/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import com.sun.jna.Platform;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.platform.PlatformUtils;
import net.pms.renderers.Renderer;
import net.pms.store.SystemFileResource;
import net.pms.store.SystemFilesHelper;
import net.pms.store.container.VirtualFolder;
import net.pms.util.ProcessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealFolder
extends VirtualFolder
implements SystemFileResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealFolder.class);
    private final File directory;

    public RealFolder(Renderer renderer, File directory) {
        this(renderer, directory, null);
    }

    public RealFolder(Renderer renderer, File directory, String name) {
        super(renderer);
        this.directory = directory;
        this.setName(name);
        this.addFile(directory);
        this.setLastModified(directory.lastModified());
        this.setSortable(true);
    }

    @Override
    public boolean isValid() {
        boolean valid;
        boolean bl = valid = this.directory.exists() && this.directory.isDirectory();
        if (valid && this.getParent() != null && this.getParent().getDefaultRenderer() != null && this.getParent().getDefaultRenderer().isUseMediaInfo()) {
            this.run();
        }
        return valid;
    }

    @Override
    public boolean isRendererAllowed() {
        return this.renderer.hasShareAccess(this.directory);
    }

    @Override
    public String getSystemName() {
        return ProcessUtil.getShortFileNameIfWideChars(this.directory.getAbsolutePath());
    }

    @Override
    public DLNAThumbnailInputStream getThumbnailInputStream() throws IOException {
        File cachedThumbnail = SystemFilesHelper.getFolderThumbnail(this.directory);
        DLNAThumbnailInputStream result = null;
        try {
            if (cachedThumbnail != null) {
                result = DLNAThumbnailInputStream.toThumbnailInputStream(new FileInputStream(cachedThumbnail));
            } else if (this.getMediaInfo() != null && this.getMediaInfo().getThumbnail() != null) {
                result = this.getMediaInfo().getThumbnailInputStream();
            }
        }
        catch (IOException e) {
            LOGGER.debug("An error occurred while getting thumbnail for \"{}\", using generic thumbnail instead: {}", (Object)this.getName(), (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result != null ? result : super.getThumbnailInputStream();
    }

    @Override
    public boolean isSubSelectable() {
        return true;
    }

    @Override
    public String write() {
        return this.getName() + ">" + this.directory.getAbsolutePath();
    }

    @Override
    public String getName() {
        if (super.getName() == null) {
            if (this.directory == null) {
                return null;
            }
            if (this.directory.getName().trim().isEmpty()) {
                if (Platform.isWindows()) {
                    this.setName(PlatformUtils.INSTANCE.getDiskLabel(this.directory));
                }
                if (super.getName() != null && super.getName().length() > 0) {
                    this.setName(this.directory.getAbsolutePath().substring(0, 1) + ":\\ [" + super.getName() + "]");
                } else {
                    this.setName(this.directory.getAbsolutePath().substring(0, 1));
                }
            } else {
                this.setName(this.directory.getName());
            }
        }
        return super.getName().replaceAll("_imdb([^_]+)_", "");
    }

    @Override
    public File getSystemFile() {
        return this.directory;
    }
}

