/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.pms.configuration.sharedcontent.SharedContentConfiguration;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTableFilesStatus;
import net.pms.platform.PlatformUtils;
import net.pms.renderers.Renderer;
import net.pms.store.MediaStatusStore;
import net.pms.store.MediaStoreIds;
import net.pms.store.StoreContainer;
import net.pms.store.StoreResource;
import net.pms.store.container.LocalizedStoreContainer;
import net.pms.store.container.MonitorEntry;
import net.pms.store.item.RealFile;
import net.pms.store.item.VirtualVideoActionLocalized;
import net.pms.util.FileUtil;
import net.pms.util.FullyPlayedAction;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaMonitor
extends LocalizedStoreContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaMonitor.class);
    private final ReentrantReadWriteLock fullyPlayedEntriesLock = new ReentrantReadWriteLock();
    private final HashMap<String, Boolean> fullyPlayedEntries = new HashMap();
    private final File[] dirs;

    public MediaMonitor(Renderer renderer, File[] dirs) {
        super(renderer, "Unused", "images/store/folder.png");
        this.dirs = new File[dirs.length];
        System.arraycopy(dirs, 0, this.dirs, 0, dirs.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanDir(File[] files, final StoreContainer res) {
        if (files != null) {
            final MediaMonitor mm = this;
            res.addChild(new VirtualVideoActionLocalized(this.renderer, "MarkAllAsPlayed", true, null){

                @Override
                public boolean enable() {
                    for (StoreResource r : res.getChildren()) {
                        if (!(r instanceof RealFile)) continue;
                        RealFile rf = (RealFile)r;
                        MediaStatusStore.setFullyPlayed(rf.getFile().getAbsolutePath(), this.renderer.getAccountUserId(), true, null);
                    }
                    mm.setDiscovered(false);
                    mm.getChildren().clear();
                    MediaStoreIds.incrementSystemUpdateId();
                    return true;
                }
            });
            HashSet<String> fullyPlayedPaths = null;
            if (this.renderer.getUmsConfiguration().isHideEmptyFolders()) {
                fullyPlayedPaths = new HashSet<String>();
                this.fullyPlayedEntriesLock.readLock().lock();
                try {
                    for (Map.Entry entry : this.fullyPlayedEntries.entrySet()) {
                        if (!Boolean.TRUE.equals(entry.getValue())) continue;
                        fullyPlayedPaths.add((String)entry.getKey());
                    }
                }
                finally {
                    this.fullyPlayedEntriesLock.readLock().unlock();
                }
            }
            for (File fileEntry : files) {
                boolean add;
                if (fileEntry.isFile()) {
                    if (MediaStatusStore.isFullyPlayed(fileEntry.getAbsolutePath(), this.renderer.getAccountUserId())) continue;
                    res.addChild(new RealFile(this.renderer, fileEntry));
                }
                if (!fileEntry.isDirectory()) continue;
                boolean bl = add = !this.renderer.getUmsConfiguration().isHideEmptyFolders();
                if (!add) {
                    add = FileUtil.isFolderRelevant(fileEntry, this.renderer.getUmsConfiguration(), fullyPlayedPaths);
                }
                if (!add) continue;
                res.addChild(new MonitorEntry(this.renderer, fileEntry, this));
            }
        }
    }

    @Override
    public void discoverChildren() {
        if (this.dirs != null) {
            for (File f : this.dirs) {
                this.scanDir(f.listFiles(), this);
            }
        }
    }

    @Override
    public boolean isRefreshNeeded() {
        return true;
    }

    public void stopped(StoreResource resource) {
        boolean logTrace;
        if (!(resource instanceof RealFile)) {
            return;
        }
        RealFile realFile = (RealFile)resource;
        String fullPathToFile = realFile.getFile().getAbsolutePath();
        boolean isMonitored = false;
        List<File> foldersMonitored = SharedContentConfiguration.getMonitoredFolders();
        if (!foldersMonitored.isEmpty()) {
            for (File folderMonitored : foldersMonitored) {
                if (!fullPathToFile.contains(folderMonitored.getAbsolutePath())) continue;
                isMonitored = true;
                break;
            }
        }
        if (!isMonitored) {
            LOGGER.trace("File {} is not within a monitored directory, so not calculating fully played status", (Object)realFile.getName());
            return;
        }
        double fileDuration = 0.0;
        if (realFile.getMediaInfo() != null && (realFile.getMediaInfo().isAudio() || realFile.getMediaInfo().isVideo())) {
            fileDuration = realFile.getMediaInfo().getDurationInSeconds();
        }
        long now = System.currentTimeMillis();
        long lastStartSystemTime = realFile.getLastStartSystemTime();
        long lastStartSystemTimeUser = realFile.getLastStartSystemTimeUser();
        double lastStartPosition = realFile.getLastStartPosition();
        int minimumPlayTime = CONFIGURATION.getMinimumWatchedPlayTimeSeconds();
        FullyPlayedAction fullyPlayedAction = CONFIGURATION.getFullyPlayedAction();
        double triggerPlayTime = fileDuration * CONFIGURATION.getResumeBackFactor();
        double elapsed = 0.0;
        if ((double)lastStartSystemTimeUser > 0.0) {
            elapsed = (double)(now - lastStartSystemTimeUser) / 1000.0;
        }
        if (lastStartPosition > 0.0) {
            elapsed += lastStartPosition;
        }
        boolean bl = logTrace = LOGGER.isTraceEnabled() && !fullyPlayedAction.equals((Object)FullyPlayedAction.NO_ACTION);
        if (logTrace) {
            LOGGER.trace("Fully Played feature logging:");
            LOGGER.trace("   duration: " + fileDuration);
            LOGGER.trace("   getLastStartPosition: " + lastStartPosition);
            LOGGER.trace("   currentTime: " + now);
            LOGGER.trace("   getLastStartSystemTime: " + lastStartSystemTime);
            LOGGER.trace("   getLastStartSystemTimeUser: " + lastStartSystemTimeUser);
            LOGGER.trace("   minimum play time: " + minimumPlayTime);
            LOGGER.trace("   triggered fully played time: " + triggerPlayTime);
            LOGGER.trace("   elapsed: " + elapsed);
        }
        int userId = this.renderer.getAccountUserId();
        if (fileDuration == 0.0 || elapsed > (double)minimumPlayTime && elapsed >= triggerPlayTime) {
            LOGGER.trace("final decision: fully played");
            StoreContainer fileParent = realFile.getParent();
            if (fileParent == null) {
                LOGGER.trace("fileParent is null for {}", (Object)fullPathToFile);
            } else if (MediaStatusStore.isFullyPlayed(fullPathToFile, userId)) {
                LOGGER.trace("{} already marked as fully played", (Object)fullPathToFile);
            } else {
                MediaStatusStore.setFullyPlayed(fullPathToFile, userId, true, elapsed);
                this.setDiscovered(false);
                this.getChildren().clear();
                File playedFile = new File(fullPathToFile);
                if (fullyPlayedAction == FullyPlayedAction.MOVE_FOLDER || fullyPlayedAction == FullyPlayedAction.MOVE_FOLDER_AND_MARK) {
                    String oldDirectory = FileUtil.appendPathSeparator(playedFile.getAbsoluteFile().getParent());
                    String newDirectory = FileUtil.appendPathSeparator(CONFIGURATION.getFullyPlayedOutputDirectory());
                    if (!StringUtils.isBlank(newDirectory) && !newDirectory.equals(oldDirectory)) {
                        String newFilename = playedFile.getName();
                        String newPathToFile = newDirectory + newFilename;
                        try {
                            MediaMonitor.fileWillMove(fullPathToFile, newPathToFile);
                            Files.move(Paths.get(playedFile.getAbsolutePath(), new String[0]), Paths.get(newPathToFile, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                            LOGGER.debug("Moved {} because it has been fully played", (Object)newFilename);
                        }
                        catch (IOException e) {
                            LOGGER.debug("Moving {} failed, trying again in 3 seconds: {}", (Object)newFilename, (Object)e.getMessage());
                            try {
                                Thread.sleep(3000L);
                                Files.move(Paths.get(playedFile.getAbsolutePath(), new String[0]), Paths.get(newPathToFile, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                                LOGGER.debug("Moved {} because it has been fully played", (Object)newFilename);
                            }
                            catch (InterruptedException e2) {
                                LOGGER.debug("Abandoning moving of {} because the thread was interrupted, probably due to program shutdown: {}", (Object)newFilename, (Object)e2.getMessage());
                                MediaMonitor.fileMoveFail(newPathToFile);
                                Thread.currentThread().interrupt();
                            }
                            catch (IOException e3) {
                                LOGGER.debug("Moving {} failed a second time: {}", (Object)newFilename, (Object)e3.getMessage());
                            }
                        }
                    } else if (StringUtils.isBlank(newDirectory)) {
                        LOGGER.warn("Failed to move \"{}\" after being fully played because the folder to move to isn't configured", (Object)playedFile.getName());
                    } else {
                        LOGGER.trace("Not moving \"{}\" after being fully played since it's already in the target folder \"{}\"", (Object)playedFile.getName(), (Object)newDirectory);
                    }
                } else if (fullyPlayedAction == FullyPlayedAction.MOVE_TRASH) {
                    try {
                        PlatformUtils.INSTANCE.moveToTrash(playedFile);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to move file \"{}\" to recycler/trash after it has been fully played: {}", (Object)playedFile.getAbsoluteFile(), (Object)e.getMessage());
                        LOGGER.trace("", e);
                    }
                }
                if (fullyPlayedAction != FullyPlayedAction.NO_ACTION) {
                    this.notifyRefresh();
                }
                LOGGER.info("{} marked as fully played", (Object)playedFile.getName());
            }
        } else {
            MediaStatusStore.setLastPlayed(fullPathToFile, userId, elapsed);
            LOGGER.trace("final decision: not fully played");
        }
    }

    private static void fileWillMove(String fullPathToFile, String fullPathToNewFile) {
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            if (connection != null) {
                MediaTableFilesStatus.createCopyOnFileMoved(connection, fullPathToFile, fullPathToNewFile);
            }
        }
        finally {
            MediaDatabase.close(connection);
        }
    }

    private static void fileMoveFail(String fullPathToNewFile) {
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            if (connection != null) {
                MediaTableFilesStatus.remove(connection, fullPathToNewFile, false);
            }
        }
        finally {
            MediaDatabase.close(connection);
        }
    }

    @Override
    public void doRefreshChildren() {
        if (this.isDiscovered()) {
            this.notifyRefresh();
        }
    }
}

