/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import net.pms.media.video.metadata.ApiSeason;
import net.pms.media.video.metadata.TvSeriesMetadata;
import net.pms.renderers.Renderer;
import net.pms.store.StoreContainer;
import net.pms.store.container.MediaLibraryFolder;
import net.pms.store.container.MediaLibraryTvSeries;
import org.apache.commons.lang3.StringUtils;

public class MediaLibraryTvSeason
extends MediaLibraryFolder {
    private final Integer tvSeasonId;
    private TvSeriesMetadata tvSeriesMetadata;
    private String seasonName = "";

    public MediaLibraryTvSeason(Renderer renderer, String i18nName, String tvSeason, String[] sql, int[] expectedOutput) {
        super(renderer, i18nName, sql, expectedOutput, tvSeason);
        this.tvSeasonId = MediaLibraryTvSeason.getInteger(tvSeason);
    }

    @Override
    public String getName() {
        return super.getName().concat(this.getSeasonName());
    }

    @Override
    public String getLocalizedDisplayName(String lang) {
        return super.getLocalizedDisplayName(lang).concat(this.getSeasonName());
    }

    private TvSeriesMetadata getTvSeriesMetadata() {
        StoreContainer storeContainer;
        if (this.tvSeriesMetadata == null && this.tvSeasonId != null && (storeContainer = this.getParent()) instanceof MediaLibraryTvSeries) {
            MediaLibraryTvSeries mediaLibraryTvSeries = (MediaLibraryTvSeries)storeContainer;
            this.tvSeriesMetadata = mediaLibraryTvSeries.getTvSeriesMetadata();
        }
        return this.tvSeriesMetadata;
    }

    private synchronized String getSeasonName() {
        if (this.seasonName.isEmpty() && this.getTvSeriesMetadata() != null && this.tvSeriesMetadata.getSeasons() != null && this.tvSeasonId != null) {
            for (ApiSeason season : this.tvSeriesMetadata.getSeasons()) {
                if (season.getSeasonNumber() != this.tvSeasonId.intValue()) continue;
                if (StringUtils.isBlank(season.getName()) || season.getName().equalsIgnoreCase("Season " + season.getSeasonNumber())) break;
                this.seasonName = ": " + season.getName();
                break;
            }
        }
        return this.seasonName;
    }

    private static Integer getInteger(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

