/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTableFiles;
import net.pms.database.MediaTableVideoMetadata;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.renderers.Renderer;
import net.pms.store.MediaStoreIds;
import net.pms.store.StoreContainer;
import net.pms.store.StoreResource;
import net.pms.store.container.DVDISOFile;
import net.pms.store.container.LocalizedStoreContainer;
import net.pms.store.container.MediaLibraryAbstract;
import net.pms.store.container.MediaLibraryFolderNamed;
import net.pms.store.container.MediaLibraryMovieFolder;
import net.pms.store.container.MediaLibraryTvSeason;
import net.pms.store.container.MediaLibraryTvSeries;
import net.pms.store.container.PlaylistFolder;
import net.pms.store.item.MediaLibraryTvEpisode;
import net.pms.store.item.RealFile;
import net.pms.store.utils.StoreResourceSorter;
import net.pms.util.UMSUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaLibraryFolder
extends MediaLibraryAbstract {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaLibraryFolder.class);
    private String[] sqls;
    private int[] expectedOutputs;
    private List<String> populatedVirtualFoldersListFromDb;
    private List<String> populatedFilesListFromDb;

    public MediaLibraryFolder(Renderer renderer, String i18nName, String sql, int expectedOutput) {
        this(renderer, i18nName, new String[]{sql}, new int[]{expectedOutput}, null);
    }

    public MediaLibraryFolder(Renderer renderer, String i18nName, String[] sql, int[] expectedOutput) {
        this(renderer, i18nName, sql, expectedOutput, null);
    }

    public MediaLibraryFolder(Renderer renderer, String i18nName, String[] sql, int[] expectedOutput, String formatString) {
        super(renderer, i18nName, null, formatString);
        this.sqls = sql;
        this.expectedOutputs = expectedOutput;
        this.setChildrenSorted(expectedOutput == null || expectedOutput.length < 1 || MediaLibraryFolder.isSortableOutputExpected(expectedOutput[0]));
    }

    @Override
    public void discoverChildren() {
        this.doRefreshChildren();
        this.setDiscovered(true);
    }

    private String transformSQL(String sql) {
        int i = 1;
        StoreContainer resource = this;
        sql = sql.replace("${0}", this.transformName(this.getName()));
        while (resource.getParent() != null) {
            resource = resource.getParent();
            sql = sql.replace("${" + i + "}", this.transformName(((StoreResource)resource).getName()));
            ++i;
        }
        return sql;
    }

    private String transformName(String name) {
        if (name.equals("###")) {
            name = "";
        }
        name = name.replace("'", "''");
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRefreshNeeded() {
        block11: {
            Connection connection = null;
            try {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection != null && this.sqls.length > 0) {
                    String sql = this.sqls[0];
                    int expectedOutput = this.expectedOutputs[0];
                    if (sql != null) {
                        sql = this.transformSQL(sql);
                        if (expectedOutput == 7 || expectedOutput == 15 || expectedOutput == 0 || expectedOutput == 5 || expectedOutput == 17 || expectedOutput == 9 || expectedOutput == 3 || expectedOutput == 11 || expectedOutput == 2) {
                            boolean bl = !UMSUtils.isListsEqual(this.populatedFilesListFromDb, MediaTableFiles.getStrings(connection, sql));
                            return bl;
                        }
                        if (MediaLibraryFolder.isTextOutputExpected(expectedOutput)) {
                            boolean bl = !UMSUtils.isListsEqual(this.populatedVirtualFoldersListFromDb, MediaTableFiles.getStrings(connection, sql));
                            return bl;
                        }
                        if (expectedOutput == 18) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    break block11;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                MediaDatabase.close(connection);
            }
        }
        return true;
    }

    private static List<String> getTVSeriesQueries(String tableName, String columnName) {
        ArrayList<String> queries = new ArrayList<String>();
        queries.add("SELECT " + columnName + " FROM " + tableName + " WHERE TVSERIESID IS NOT NULL ORDER BY " + columnName + " ASC");
        queries.add("SELECT TV_SERIES.ID, TV_SERIES.TITLE FROM TV_SERIES LEFT JOIN " + tableName + " ON TV_SERIES.ID = " + tableName + ".TVSERIESID WHERE " + columnName + " = '${0}' ORDER BY TV_SERIES.TITLE ASC");
        queries.add("SELECT * FROM FILES LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID LEFT JOIN TV_SERIES ON VIDEO_METADATA.TVSERIESID = TV_SERIES.ID WHERE FILES.FORMAT_TYPE = 4 AND VIDEO_METADATA.ISTVEPISODE AND TV_SERIES.ID = ${0} ORDER BY CAST(REGEXP_SUBSTR(CONCAT('0', VIDEO_METADATA.TVEPISODENUMBER), '\\d*') AS INTEGER)");
        return queries;
    }

    private static List<String> getTVSeriesQueries(String columnName, boolean desc) {
        ArrayList<String> queries = new ArrayList<String>();
        queries.add("SELECT " + columnName + " FROM TV_SERIES ORDER BY " + columnName + (desc ? " DESC" : " ASC"));
        queries.add("SELECT TV_SERIES.ID, TV_SERIES.TITLE FROM TV_SERIES WHERE " + columnName + " = '${0}' ORDER BY TV_SERIES.TITLE ASC");
        queries.add("SELECT * FROM FILES LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID LEFT JOIN TV_SERIES ON VIDEO_METADATA.TVSERIESID = TV_SERIES.ID WHERE FILES.FORMAT_TYPE = 4 AND VIDEO_METADATA.ISTVEPISODE AND TV_SERIES.ID = ${0} ORDER BY CAST(REGEXP_SUBSTR(CONCAT('0', VIDEO_METADATA.TVEPISODENUMBER), '\\d*') AS INTEGER)");
        return queries;
    }

    private static List<String> getTVSeriesQueriesByFirstAirDate() {
        ArrayList<String> queries = new ArrayList<String>();
        queries.add("SELECT FORMATDATETIME(TV_SERIES.FIRSTAIRDATE, 'yyyy') FROM TV_SERIES ORDER BY TV_SERIES.STARTYEAR DESC");
        queries.add("SELECT TV_SERIES.ID, TV_SERIES.TITLE FROM TV_SERIES WHERE FORMATDATETIME(TV_SERIES.FIRSTAIRDATE, 'yyyy') = '${0}' ORDER BY TV_SERIES.STARTYEAR ASC");
        queries.add("SELECT * FROM FILES LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID LEFT JOIN TV_SERIES ON VIDEO_METADATA.TVSERIESID = TV_SERIES.ID WHERE FILES.FORMAT_TYPE = 4 AND VIDEO_METADATA.ISTVEPISODE AND TV_SERIES.ID = ${0} ORDER BY CAST(REGEXP_SUBSTR(CONCAT('0', VIDEO_METADATA.TVEPISODENUMBER), '\\d*') AS INTEGER)");
        return queries;
    }

    private static String getFirstNonTVSeriesQuery(String firstSql, String tableName, String columnName, boolean desc) {
        int indexAfterFromInFirstQuery = firstSql.indexOf(" FROM FILES") + " FROM FILES".length();
        String selectSection = "SELECT DISTINCT " + columnName + " FROM FILES";
        String orderBySection = " ORDER BY " + columnName + (desc ? " DESC" : " ASC");
        StringBuilder query = new StringBuilder(firstSql);
        if (tableName != null && !firstSql.contains(" LEFT JOIN " + tableName)) {
            String joinSection = " LEFT JOIN " + tableName + " ON FILES.ID = " + tableName + ".FILEID";
            query.insert(indexAfterFromInFirstQuery, joinSection);
        }
        indexAfterFromInFirstQuery = firstSql.indexOf(" FROM FILES") + " FROM FILES".length();
        query.replace(0, indexAfterFromInFirstQuery, selectSection);
        int indexBeforeOrderByInFirstActorsQuery = query.indexOf(" ORDER BY ");
        query.replace(indexBeforeOrderByInFirstActorsQuery, query.length(), orderBySection);
        return query.toString();
    }

    private static String getSubsequentNonTVSeriesQuery(String sql, String tableName, String columnName, int i) {
        StringBuilder query = new StringBuilder(sql);
        int indexAfterFrom = sql.indexOf(" FROM FILES") + " FROM FILES".length();
        String condition = columnName + " = '${0}' AND ";
        if (!sql.contains(" LEFT JOIN " + tableName)) {
            String joinSection = " LEFT JOIN " + tableName + " ON FILES.ID = " + tableName + ".FILEID";
            query.insert(indexAfterFrom, joinSection);
        }
        int indexAfterWhere = query.indexOf(" WHERE ") + " WHERE ".length();
        String replacedCondition = condition.replace("${0}", "${" + i + "}");
        query.insert(indexAfterWhere, replacedCondition);
        return query.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public synchronized void doRefreshChildren() {
        block99: {
            filesListFromDb = null;
            virtualFoldersListFromDb = null;
            unwatchedSqls = new ArrayList<String>();
            watchedSqls = new ArrayList<String>();
            actorsSqls = new ArrayList<String>();
            countriesSqls = new ArrayList<E>();
            directorsSqls = new ArrayList<E>();
            genresSqls = new ArrayList<E>();
            ratedSqls = new ArrayList<E>();
            ratingSqls = new ArrayList<E>();
            releasedSqls = new ArrayList<E>();
            seasonsQuery = new StringBuilder();
            expectedOutput = 0;
            firstSql = null;
            if (this.sqls.length > 0) {
                connection = null;
                try {
                    connection = MediaDatabase.getConnectionIfAvailable();
                    if (connection == null) break block99;
                    firstSql = this.sqls[0];
                    expectedOutput = this.expectedOutputs[0];
                    if (firstSql == null) break block99;
                    firstSql = this.transformSQL((String)firstSql);
                    switch (expectedOutput) {
                        case 0: 
                        case 2: 
                        case 3: 
                        case 5: 
                        case 15: {
                            firstSql = firstSql.replaceAll("SELECT DISTINCT VIDEO_METADATA.TVSEASON FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID", "SELECT * FROM FILES LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID");
                            filesListFromDb = MediaTableFiles.getFiles(connection, (String)firstSql);
                            this.populatedFilesListFromDb = MediaTableFiles.getStrings(connection, (String)firstSql);
                            ** break;
lbl30:
                            // 1 sources

                            break;
                        }
                        case 17: {
                            this.populatedFilesListFromDb = new ArrayList<String>();
                            filesListFromDb = new ArrayList<File>();
                            for (File item : MediaTableFiles.getFiles(connection, (String)firstSql)) {
                                if (this.populatedFilesListFromDb.contains(item.getAbsolutePath())) continue;
                                filesListFromDb.add(item);
                                this.populatedFilesListFromDb.add(item.getAbsolutePath());
                            }
                            break;
                        }
                        case 7: {
                            filesListFromDb = MediaTableFiles.getFiles(connection, (String)firstSql);
                            this.populatedFilesListFromDb = MediaTableFiles.getStrings(connection, (String)firstSql);
                            indexAfterFromInFirstQuery = firstSql.indexOf(" FROM FILES") + " FROM FILES".length();
                            indexAtJointure = firstSql.indexOf(" LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID");
                            if (indexAtJointure > 0) {
                                indexAfterFromInFirstQuery = indexAtJointure + " LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID".length();
                            }
                            orderBySection = " ORDER BY VIDEO_METADATA.TVSEASON";
                            seasonsQuery.append((String)firstSql);
                            seasonsQuery.replace(0, indexAfterFromInFirstQuery, "SELECT DISTINCT VIDEO_METADATA.TVSEASON FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID");
                            indexBeforeOrderByInFirstQuery = seasonsQuery.indexOf(" ORDER BY ");
                            seasonsQuery.replace(indexBeforeOrderByInFirstQuery, seasonsQuery.length(), orderBySection);
                            virtualFoldersListFromDb = MediaTableFiles.getStrings(connection, seasonsQuery.toString());
                            this.populatedVirtualFoldersListFromDb = virtualFoldersListFromDb;
                            ** break;
lbl60:
                            // 1 sources

                            break;
                        }
                        case 1: 
                        case 4: 
                        case 6: 
                        case 13: 
                        case 14: 
                        case 16: {
                            virtualFoldersListFromDb = MediaTableFiles.getStrings(connection, (String)firstSql);
                            this.populatedVirtualFoldersListFromDb = virtualFoldersListFromDb;
                            ** break;
lbl65:
                            // 1 sources

                            break;
                        }
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 18: {
                            if (expectedOutput == 10 || expectedOutput == 8 || expectedOutput == 12) {
                                virtualFoldersListFromDb = MediaTableFiles.getStrings(connection, (String)firstSql);
                                this.populatedVirtualFoldersListFromDb = virtualFoldersListFromDb;
                            } else if (expectedOutput == 9 || expectedOutput == 11) {
                                filesListFromDb = MediaTableFiles.getFiles(connection, (String)firstSql);
                                this.populatedFilesListFromDb = MediaTableFiles.getStrings(connection, (String)firstSql);
                            }
                            if (!firstSql.toUpperCase().startsWith("SELECT ")) {
                                firstSql = "SELECT FILES.FILENAME, FILES.MODIFIED FROM FILES WHERE " + (String)firstSql;
                            }
                            if (this.renderer.getUmsConfiguration().isUseInfoFromExternalAPI()) {
                                if (expectedOutput == 12) {
                                    actorsSqls = MediaLibraryFolder.getTVSeriesQueries("VIDEO_METADATA_ACTORS", "VIDEO_METADATA_ACTORS.ACTOR");
                                    countriesSqls = MediaLibraryFolder.getTVSeriesQueries("VIDEO_METADATA_COUNTRIES", "VIDEO_METADATA_COUNTRIES.COUNTRY");
                                    directorsSqls = MediaLibraryFolder.getTVSeriesQueries("VIDEO_METADATA_DIRECTORS", "VIDEO_METADATA_DIRECTORS.DIRECTOR");
                                    genresSqls = MediaLibraryFolder.getTVSeriesQueries("VIDEO_METADATA_GENRES", "VIDEO_METADATA_GENRES.GENRE");
                                    ratedSqls = MediaLibraryFolder.getTVSeriesQueries("TV_SERIES.RATED", false);
                                    ratingSqls = MediaLibraryFolder.getTVSeriesQueries("CAST(FLOOR(TV_SERIES.RATING) AS INT)", true);
                                    releasedSqls = MediaLibraryFolder.getTVSeriesQueriesByFirstAirDate();
                                } else {
                                    actorsSqls.add(MediaLibraryFolder.getFirstNonTVSeriesQuery((String)firstSql, "VIDEO_METADATA_ACTORS", "VIDEO_METADATA_ACTORS.ACTOR", false));
                                    countriesSqls.add(MediaLibraryFolder.getFirstNonTVSeriesQuery((String)firstSql, "VIDEO_METADATA_COUNTRIES", "VIDEO_METADATA_COUNTRIES.COUNTRY", false));
                                    directorsSqls.add(MediaLibraryFolder.getFirstNonTVSeriesQuery((String)firstSql, "VIDEO_METADATA_DIRECTORS", "VIDEO_METADATA_DIRECTORS.DIRECTOR", false));
                                    genresSqls.add(MediaLibraryFolder.getFirstNonTVSeriesQuery((String)firstSql, "VIDEO_METADATA_GENRES", "VIDEO_METADATA_GENRES.GENRE", false));
                                    ratedSqls.add(MediaLibraryFolder.getFirstNonTVSeriesQuery((String)firstSql, "VIDEO_METADATA", "VIDEO_METADATA.RATED", false));
                                    ratingSqls.add(MediaLibraryFolder.getFirstNonTVSeriesQuery((String)firstSql, "VIDEO_METADATA", "CAST(FLOOR(VIDEO_METADATA.RATING) AS INT)", true));
                                    releasedSqls.add(MediaLibraryFolder.getFirstNonTVSeriesQuery((String)firstSql, "VIDEO_METADATA", "FORMATDATETIME(VIDEO_METADATA.RELEASEDATE, 'yyyy')", true));
                                }
                            }
                            i = 0;
                            for (Object sql : this.sqls) {
                                if (!sql.toUpperCase().startsWith("SELECT ") && !sql.toUpperCase().startsWith("WITH ")) {
                                    sql = "SELECT FILES.FILENAME, FILES.MODIFIED FROM FILES WHERE " + (String)sql;
                                }
                                indexAfterFrom = sql.indexOf(" FROM FILES") + " FROM FILES".length();
                                sqlWithJoin = new StringBuilder((String)sql);
                                if (!sql.contains(" LEFT JOIN FILES_STATUS")) {
                                    sqlWithJoin.insert(indexAfterFrom, " LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME");
                                }
                                indexAfterWhere = sqlWithJoin.indexOf(" WHERE ") + " WHERE ".length();
                                unwatchedSql = new StringBuilder(sqlWithJoin);
                                unwatchedSql.insert(indexAfterWhere, MediaLibraryFolder.getUnWatchedCondition(this.renderer.getAccountUserId()) + " AND ");
                                unwatchedSqls.add(unwatchedSql.toString());
                                watchedSql = new StringBuilder(sqlWithJoin);
                                watchedSql.insert(indexAfterWhere, MediaLibraryFolder.getWatchedCondition(this.renderer.getAccountUserId()) + " AND ");
                                watchedSqls.add(watchedSql.toString());
                                if (this.renderer.getUmsConfiguration().isUseInfoFromExternalAPI() && expectedOutput != 12) {
                                    actorsSqls.add(MediaLibraryFolder.getSubsequentNonTVSeriesQuery((String)sql, "VIDEO_METADATA_ACTORS", "VIDEO_METADATA_ACTORS.ACTOR", i));
                                    countriesSqls.add(MediaLibraryFolder.getSubsequentNonTVSeriesQuery((String)sql, "VIDEO_METADATA_COUNTRIES", "VIDEO_METADATA_COUNTRIES.COUNTRY", i));
                                    directorsSqls.add(MediaLibraryFolder.getSubsequentNonTVSeriesQuery((String)sql, "VIDEO_METADATA_DIRECTORS", "VIDEO_METADATA_DIRECTORS.DIRECTOR", i));
                                    genresSqls.add(MediaLibraryFolder.getSubsequentNonTVSeriesQuery((String)sql, "VIDEO_METADATA_GENRES", "VIDEO_METADATA_GENRES.GENRE", i));
                                    ratedSqls.add(MediaLibraryFolder.getSubsequentNonTVSeriesQuery((String)sql, "VIDEO_METADATA", "VIDEO_METADATA.RATED", i));
                                    ratingSqls.add(MediaLibraryFolder.getSubsequentNonTVSeriesQuery((String)sql, "VIDEO_METADATA", "CAST(FLOOR(VIDEO_METADATA.RATING) AS INT)", i));
                                    releasedSqls.add(MediaLibraryFolder.getSubsequentNonTVSeriesQuery((String)sql, "VIDEO_METADATA", "FORMATDATETIME(VIDEO_METADATA.RELEASEDATE, 'yyyy')", i));
                                }
                                ++i;
                            }
                            break;
                        }
                        ** default:
lbl139:
                        // 1 sources

                        break;
                    }
                }
                finally {
                    MediaDatabase.close(connection);
                }
            }
        }
        newFiles = new LinkedHashSet<File>();
        newVirtualFolders = new LinkedHashSet<String>();
        oldFiles = new ArrayList<E>();
        oldVirtualFolders = new ArrayList<E>();
        if (filesListFromDb != null) {
            this.getChildren().forEach((Consumer<StoreResource>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lnet/pms/store/StoreResource;)V)(oldFiles));
            for (File file : filesListFromDb) {
                newFiles.add(file);
            }
        }
        if (virtualFoldersListFromDb != null) {
            this.getChildren().forEach((Consumer<StoreResource>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lnet/pms/store/StoreResource;)V)(oldVirtualFolders));
            for (String f : virtualFoldersListFromDb) {
                newVirtualFolders.add(f);
            }
        }
        oldFiles.forEach((Consumer<StoreResource>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$doRefreshChildren$0(net.pms.store.StoreResource ), (Lnet/pms/store/StoreResource;)V)((MediaLibraryFolder)this));
        oldVirtualFolders.forEach((Consumer<StoreResource>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$doRefreshChildren$1(net.pms.store.StoreResource ), (Lnet/pms/store/StoreResource;)V)((MediaLibraryFolder)this));
        if (expectedOutput == 10 || expectedOutput == 8 || expectedOutput == 9 || expectedOutput == 12 || expectedOutput == 18) {
            filteredExpectedOutputs = (int[])this.expectedOutputs.clone();
            switch (filteredExpectedOutputs[0]) {
                case 9: 
                case 18: {
                    filteredExpectedOutputs[0] = 0;
                    break;
                }
                case 11: {
                    filteredExpectedOutputs[0] = 3;
                    break;
                }
                case 8: {
                    filteredExpectedOutputs[0] = 1;
                    break;
                }
                case 12: {
                    filteredExpectedOutputs[0] = 13;
                    break;
                }
                case 10: {
                    filteredExpectedOutputs[0] = 6;
                    break;
                }
            }
            if (!unwatchedSqls.isEmpty() && !watchedSqls.isEmpty()) {
                filterByProgress = new LocalizedStoreContainer(this.renderer, "FilterByProgress");
                filterByProgress.addChild(new MediaLibraryFolder(this.renderer, "Unwatched", (String[])unwatchedSqls.toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$doRefreshChildren$2(int ), (I)[Ljava/lang/String;)()), filteredExpectedOutputs));
                filterByProgress.addChild(new MediaLibraryFolder(this.renderer, "Watched", (String[])watchedSqls.toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$doRefreshChildren$3(int ), (I)[Ljava/lang/String;)()), filteredExpectedOutputs));
                this.addChild(filterByProgress);
            }
            if (!genresSqls.isEmpty()) {
                filteredExpectedOutputsWithPrependedTexts = (int[])filteredExpectedOutputs.clone();
                filteredExpectedOutputsWithPrependedTexts = ArrayUtils.insert(0, filteredExpectedOutputsWithPrependedTexts, new int[]{1});
                filteredExpectedOutputsWithPrependedTextsNoSort = (int[])filteredExpectedOutputs.clone();
                filteredExpectedOutputsWithPrependedTextsNoSort = ArrayUtils.insert(0, filteredExpectedOutputsWithPrependedTextsNoSort, new int[]{6});
                filterByInformation = new LocalizedStoreContainer(this.renderer, "FilterByInformation");
                filterByInformation.addChild(new MediaLibraryFolder(this.renderer, "Actors", (String[])actorsSqls.toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$doRefreshChildren$4(int ), (I)[Ljava/lang/String;)()), filteredExpectedOutputsWithPrependedTexts));
                filterByInformation.addChild(new MediaLibraryFolder(this.renderer, "Country", (String[])countriesSqls.toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$doRefreshChildren$5(int ), (I)[Ljava/lang/String;)()), filteredExpectedOutputsWithPrependedTexts));
                filterByInformation.addChild(new MediaLibraryFolder(this.renderer, "Director", (String[])directorsSqls.toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$doRefreshChildren$6(int ), (I)[Ljava/lang/String;)()), filteredExpectedOutputsWithPrependedTexts));
                filterByInformation.addChild(new MediaLibraryFolder(this.renderer, "Genres", (String[])genresSqls.toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$doRefreshChildren$7(int ), (I)[Ljava/lang/String;)()), filteredExpectedOutputsWithPrependedTexts));
                filterByInformation.addChild(new MediaLibraryFolder(this.renderer, "Rated", (String[])ratedSqls.toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$doRefreshChildren$8(int ), (I)[Ljava/lang/String;)()), filteredExpectedOutputsWithPrependedTexts));
                filterByInformation.addChild(new MediaLibraryFolder(this.renderer, "Rating", (String[])ratingSqls.toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$doRefreshChildren$9(int ), (I)[Ljava/lang/String;)()), filteredExpectedOutputsWithPrependedTextsNoSort));
                filterByInformation.addChild(new MediaLibraryFolder(this.renderer, "Released", (String[])releasedSqls.toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$doRefreshChildren$10(int ), (I)[Ljava/lang/String;)()), filteredExpectedOutputsWithPrependedTextsNoSort));
                MediaLibraryFolder.LOGGER.trace("filteredExpectedOutputsWithPrependedTexts: " + Arrays.toString(filteredExpectedOutputsWithPrependedTexts));
                MediaLibraryFolder.LOGGER.trace("genresSqls: " + genresSqls.toString());
                this.addChild(filterByInformation);
            }
        }
        if (expectedOutput != 7 || newVirtualFolders.size() != 1) {
            newVirtualFoldersResources = new ArrayList<StoreResource>();
            for (String virtualFolderName : newVirtualFolders) {
                if (virtualFolderName == null || !MediaLibraryFolder.isTextOutputExpected(expectedOutput)) continue;
                sqls2 = new String[this.sqls.length - 1];
                expectedOutputs2 = new int[this.expectedOutputs.length - 1];
                System.arraycopy(this.sqls, 1, sqls2, 0, sqls2.length);
                System.arraycopy(this.expectedOutputs, 1, expectedOutputs2, 0, expectedOutputs2.length);
                i18nName = null;
                if (expectedOutput == 7) {
                    expectedOutputs2 = new int[]{15};
                    episodesWithinSeasonQuery = new StringBuilder(this.sqls[0]);
                    indexAfterWhere = episodesWithinSeasonQuery.indexOf(" WHERE ") + " WHERE ".length();
                    condition = "VIDEO_METADATA.TVSEASON = '" + virtualFolderName + "' AND ";
                    episodesWithinSeasonQuery.insert(indexAfterWhere, condition);
                    sqls2 = new String[]{this.transformSQL(episodesWithinSeasonQuery.toString())};
                    if (virtualFolderName.length() != 4) {
                        if ("0".equals(virtualFolderName)) {
                            i18nName = "SeasonSpecials";
                            virtualFolderName = null;
                        } else {
                            i18nName = "SeasonX";
                        }
                    }
                }
                if ((expectedOutput == 1 || expectedOutput == 6) && (resource = this).getName() != null && "###".equals(virtualFolderName)) {
                    indexAfterWhere = resource.getSystemName();
                    condition = -1;
                    switch (indexAfterWhere.hashCode()) {
                        case 1955889470: {
                            if (!indexAfterWhere.equals("Actors")) break;
                            condition = 0;
                            break;
                        }
                        case -1672482954: {
                            if (!indexAfterWhere.equals("Country")) break;
                            condition = 1;
                            break;
                        }
                        case 310687660: {
                            if (!indexAfterWhere.equals("Director")) break;
                            condition = 2;
                            break;
                        }
                        case 2129335152: {
                            if (!indexAfterWhere.equals("Genres")) break;
                            condition = 3;
                            break;
                        }
                        case 78733156: {
                            if (!indexAfterWhere.equals("Rated")) break;
                            condition = 4;
                            break;
                        }
                        case -1854235203: {
                            if (!indexAfterWhere.equals("Rating")) break;
                            condition = 5;
                            break;
                        }
                        case -486654627: {
                            if (!indexAfterWhere.equals("Released")) break;
                            condition = 6;
                            break;
                        }
                        case 1044864670: {
                            if (!indexAfterWhere.equals("ByArtist")) break;
                            condition = 7;
                            break;
                        }
                        case 1973172280: {
                            if (!indexAfterWhere.equals("ByAlbum")) break;
                            condition = 8;
                            break;
                        }
                        case 1978516300: {
                            if (!indexAfterWhere.equals("ByGenre")) break;
                            condition = 9;
                        }
                    }
                    switch (condition) {
                        case 0: {
                            for (i = 0; i < sqls2.length; ++i) {
                                sqls2[i] = sqls2[i].replace(" WHERE VIDEO_METADATA_ACTORS.ACTOR = '${" + i + "}'", " WHERE VIDEO_METADATA_ACTORS.FILEID IS NULL");
                            }
                            i18nName = "Unknown";
                            break;
                        }
                        case 1: {
                            for (i = 0; i < sqls2.length; ++i) {
                                sqls2[i] = sqls2[i].replace(" WHERE VIDEO_METADATA_COUNTRIES.COUNTRY = '${" + i + "}'", " WHERE VIDEO_METADATA_COUNTRIES.FILEID IS NULL");
                            }
                            i18nName = "Unknown";
                            break;
                        }
                        case 2: {
                            for (i = 0; i < sqls2.length; ++i) {
                                sqls2[i] = sqls2[i].replace(" WHERE VIDEO_METADATA_DIRECTORS.DIRECTOR = '${" + i + "}'", " WHERE VIDEO_METADATA_DIRECTORS.FILEID IS NULL");
                            }
                            i18nName = "Unknown";
                            break;
                        }
                        case 3: {
                            for (i = 0; i < sqls2.length; ++i) {
                                sqls2[i] = sqls2[i].replace(" WHERE VIDEO_METADATA_GENRES.GENRE = '${" + i + "}'", " WHERE VIDEO_METADATA_GENRES.FILEID IS NULL");
                            }
                            i18nName = "Unknown";
                            break;
                        }
                        case 4: {
                            for (i = 0; i < sqls2.length; ++i) {
                                sqls2[i] = sqls2[i].replace(" WHERE VIDEO_METADATA.RATED = '${" + i + "}'", " WHERE VIDEO_METADATA.RATED IS NULL");
                                sqls2[i] = sqls2[i].replace(" WHERE TV_SERIES.RATED = '${" + i + "}'", " WHERE TV_SERIES.RATED IS NULL");
                            }
                            i18nName = "Unknown";
                            break;
                        }
                        case 5: {
                            for (i = 0; i < sqls2.length; ++i) {
                                sqls2[i] = sqls2[i].replace(" WHERE CAST(FLOOR(VIDEO_METADATA.RATING) AS INT) = '${" + i + "}'", " WHERE VIDEO_METADATA.RATING IS NULL");
                                sqls2[i] = sqls2[i].replace(" WHERE CAST(FLOOR(TV_SERIES.RATING) AS INT) = '${" + i + "}'", " WHERE TV_SERIES.RATING IS NULL");
                            }
                            i18nName = "Unknown";
                            break;
                        }
                        case 6: {
                            for (i = 0; i < sqls2.length; ++i) {
                                sqls2[i] = sqls2[i].replace(" WHERE FORMATDATETIME(VIDEO_METADATA.RELEASEDATE, 'yyyy') = '${" + i + "}'", " WHERE VIDEO_METADATA.RELEASEDATE IS NULL");
                                sqls2[i] = sqls2[i].replace(" WHERE FORMATDATETIME(TV_SERIES.FIRSTAIRDATE, 'yyyy') = '${" + i + "}'", " WHERE TV_SERIES.FIRSTAIRDATE IS NULL");
                            }
                            i18nName = "Unknown";
                            break;
                        }
                        case 7: {
                            for (i = 0; i < sqls2.length; ++i) {
                                sqls2[i] = sqls2[i].replace("COALESCE(AUDIO_METADATA.ALBUMARTIST, AUDIO_METADATA.ARTIST) = '${" + i + "}'", "COALESCE(AUDIO_METADATA.ALBUMARTIST, AUDIO_METADATA.ARTIST) = ''");
                            }
                            i18nName = "Unknown";
                            break;
                        }
                        case 8: {
                            for (i = 0; i < sqls2.length; ++i) {
                                sqls2[i] = sqls2[i].replace("AUDIO_METADATA.ALBUM = '${" + i + "}'", "AUDIO_METADATA.ALBUM = ''");
                            }
                            i18nName = "Unknown";
                            break;
                        }
                        case 9: {
                            for (i = 0; i < sqls2.length; ++i) {
                                sqls2[i] = sqls2[i].replace("AUDIO_METADATA.GENRE = '${" + i + "}'", "AUDIO_METADATA.GENRE = ''");
                            }
                            i18nName = "Unknown";
                            break;
                        }
                    }
                }
                isExpectedTVSeries = expectedOutput == 13 || expectedOutput == 14 || expectedOutput == 12;
                isExpectedTVSeason = expectedOutput == 7;
                v0 = isExpectedMovieFolder = expectedOutput == 16;
                if (isExpectedTVSeries) {
                    tvSeriesId = this.getMediaLibraryTvSeriesId(virtualFolderName);
                    if (tvSeriesId == null) continue;
                    newVirtualFoldersResources.add(new MediaLibraryTvSeries(this.renderer, tvSeriesId, sqls2, expectedOutputs2));
                    continue;
                }
                if (isExpectedTVSeason) {
                    newVirtualFoldersResources.add(new MediaLibraryTvSeason(this.renderer, i18nName, virtualFolderName, sqls2, expectedOutputs2));
                    continue;
                }
                if (isExpectedMovieFolder) {
                    filename = this.getMediaLibraryMovieFilename(virtualFolderName);
                    if (filename == null) continue;
                    newVirtualFoldersResources.add(new MediaLibraryMovieFolder(this.renderer, virtualFolderName, filename, sqls2, expectedOutputs2));
                    continue;
                }
                if (i18nName != null) {
                    newVirtualFoldersResources.add(new MediaLibraryFolder(this.renderer, i18nName, sqls2, expectedOutputs2, virtualFolderName));
                    continue;
                }
                newVirtualFoldersResources.add(new MediaLibraryFolderNamed(this.renderer, virtualFolderName, sqls2, expectedOutputs2, null));
            }
            if (expectedOutput != 6 && expectedOutput != 10 && expectedOutput != 14 && expectedOutput != 7) {
                StoreResourceSorter.sortResourcesByTitle(newVirtualFoldersResources);
            }
            for (StoreResource newResource : newVirtualFoldersResources) {
                this.addChild(newResource);
            }
        }
        if (expectedOutput == 7) {
            recommendations = new MediaLibraryFolder(this.renderer, "Recommendations", new String[]{"WITH ratedSubquery AS (SELECT TV_SERIES.RATED FROM TV_SERIES WHERE TV_SERIES.ID = " + this.getName() + " LIMIT 1), genresSubquery AS (SELECT VIDEO_METADATA_GENRES.GENRE FROM TV_SERIES LEFT JOIN VIDEO_METADATA_GENRES ON TV_SERIES.ID = VIDEO_METADATA_GENRES.TVSERIESID WHERE TV_SERIES.ID = " + this.getName() + ") SELECT DISTINCT TV_SERIES.ID, TV_SERIES.RATING, VIDEO_METADATA_GENRES.GENRE, TV_SERIES.RATED FROM ratedSubquery, genresSubquery, TV_SERIES LEFT JOIN VIDEO_METADATA_GENRES ON TV_SERIES.ID = VIDEO_METADATA_GENRES.TVSERIESID WHERE TV_SERIES.ID != " + this.getName() + " AND VIDEO_METADATA_GENRES.GENRE IN (genresSubquery.GENRE) AND TV_SERIES.RATED = ratedSubquery.RATED ORDER BY TV_SERIES.RATING DESC", "SELECT * FROM FILES LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID LEFT JOIN TV_SERIES ON VIDEO_METADATA.TVSERIESID = TV_SERIES.ID WHERE FILES.FORMAT_TYPE = 4 AND VIDEO_METADATA.ISTVEPISODE AND TV_SERIES.ID = ${0} ORDER BY VIDEO_METADATA.TVSEASON, CAST(REGEXP_SUBSTR(CONCAT('0', VIDEO_METADATA.TVEPISODENUMBER), '\\d*') AS INTEGER)"}, new int[]{14, 7});
            this.addChild(recommendations);
        } else if (expectedOutput == 9 && firstSql != null) {
            recommendations = new MediaLibraryFolder(this.renderer, "Recommendations", new String[]{firstSql, "WITH ratedSubquery AS (SELECT VIDEO_METADATA.RATED FROM VIDEO_METADATA WHERE VIDEO_METADATA.FILEID = ${0} LIMIT 1), genresSubquery AS (SELECT VIDEO_METADATA_GENRES.GENRE FROM VIDEO_METADATA_GENRES WHERE VIDEO_METADATA_GENRES.FILEID = ${0}) SELECT DISTINCT VIDEO_METADATA.FILEID, FILES.*, VIDEO_METADATA.RATING, VIDEO_METADATA_GENRES.GENRE, VIDEO_METADATA.RATED FROM ratedSubquery, genresSubquery, FILES LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID LEFT JOIN VIDEO_METADATA_GENRES ON VIDEO_METADATA.FILEID = VIDEO_METADATA_GENRES.FILEID WHERE VIDEO_METADATA.FILEID != ${0} AND VIDEO_METADATA_GENRES.GENRE IN (genresSubquery.GENRE) AND VIDEO_METADATA.RATED = ratedSubquery.RATED ORDER BY VIDEO_METADATA.RATING DESC"}, new int[]{16, 17});
            this.addChild(recommendations);
        }
        newFilesResources = new ArrayList<StoreResource>();
        for (File file : newFiles) {
            if (!this.renderer.hasShareAccess(file)) continue;
            switch (expectedOutput) {
                case 0: 
                case 5: 
                case 9: 
                case 17: {
                    newFilesResources.add(new RealFile(this.renderer, file));
                    break;
                }
                case 7: {
                    newFilesResources.add(new MediaLibraryTvEpisode(this.renderer, file, false));
                    break;
                }
                case 15: {
                    newFilesResources.add(new MediaLibraryTvEpisode(this.renderer, file, true));
                    break;
                }
                case 2: {
                    newFilesResources.add(new PlaylistFolder(this.renderer, file));
                    break;
                }
                case 3: 
                case 11: {
                    newFilesResources.add(new DVDISOFile(this.renderer, file));
                    break;
                }
            }
        }
        if (expectedOutput != 5 && expectedOutput != 17 && expectedOutput != 7) {
            StoreResourceSorter.sortResourcesByTitle(newFilesResources);
        }
        for (StoreResource newResource : newFilesResources) {
            this.addChild(newResource);
        }
        if (this.isDiscovered()) {
            MediaStoreIds.incrementUpdateId(this.getLongId());
        }
        this.sortChildrenIfNeeded();
    }

    private static boolean isTextOutputExpected(int expectedOutput) {
        return expectedOutput == 1 || expectedOutput == 6 || expectedOutput == 10 || expectedOutput == 8 || expectedOutput == 4 || expectedOutput == 12 || expectedOutput == 14 || expectedOutput == 13 || expectedOutput == 7 || expectedOutput == 16;
    }

    private static boolean isSortableOutputExpected(int expectedOutput) {
        return expectedOutput != 5 && expectedOutput != 6 && expectedOutput != 10 && expectedOutput != 14 && expectedOutput != 17 && expectedOutput != 4 && expectedOutput != 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getMediaLibraryTvSeriesId(String virtualFolderName) {
        block7: {
            try {
                Long tvSeriesId = Long.valueOf(virtualFolderName);
                if (!MediaDatabase.isAvailable()) break block7;
                Connection connection = null;
                List<String> filenames = null;
                try {
                    connection = MediaDatabase.getConnectionIfAvailable();
                    filenames = MediaTableVideoMetadata.getTvEpisodesFilesByTvSeriesId(connection, tvSeriesId);
                }
                finally {
                    MediaDatabase.close(connection);
                }
                if (filenames != null && !filenames.isEmpty()) {
                    for (String filename : filenames) {
                        File file = new File(filename);
                        if (!file.exists() || !this.renderer.hasShareAccess(file)) continue;
                        return tvSeriesId;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMediaLibraryMovieFilename(String virtualFolderName) {
        block6: {
            try {
                File file;
                Long fileId = Long.valueOf(virtualFolderName);
                if (!MediaDatabase.isAvailable()) break block6;
                Connection connection = null;
                String filename = null;
                try {
                    connection = MediaDatabase.getConnectionIfAvailable();
                    filename = MediaTableFiles.getFilenameById(connection, fileId);
                }
                finally {
                    MediaDatabase.close(connection);
                }
                if (filename != null && (file = new File(filename)).exists() && this.renderer.hasShareAccess(file)) {
                    return filename;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isTVSeries() {
        return this instanceof MediaLibraryTvSeries;
    }

    public boolean isMovieFolder() {
        return this instanceof MediaLibraryMovieFolder;
    }

    @Override
    public DLNAThumbnailInputStream getThumbnailInputStream() throws IOException {
        try {
            return super.getThumbnailInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" [id=");
        result.append(this.getId());
        result.append(", name=");
        result.append(this.getName());
        result.append(", full path=");
        result.append(this.getResourceId());
        result.append(", discovered=");
        result.append(this.isDiscovered());
        result.append(", isTVSeries=");
        result.append(this.isTVSeries());
        result.append(", isMovieFolder=");
        result.append(this.isMovieFolder());
        result.append(']');
        return result.toString();
    }

    private static /* synthetic */ String[] lambda$doRefreshChildren$10(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String[] lambda$doRefreshChildren$9(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String[] lambda$doRefreshChildren$8(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String[] lambda$doRefreshChildren$7(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String[] lambda$doRefreshChildren$6(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String[] lambda$doRefreshChildren$5(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String[] lambda$doRefreshChildren$4(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String[] lambda$doRefreshChildren$3(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String[] lambda$doRefreshChildren$2(int x$0) {
        return new String[x$0];
    }

    private /* synthetic */ void lambda$doRefreshChildren$1(StoreResource virtualFolderResource) {
        this.getChildren().remove(virtualFolderResource);
    }

    private /* synthetic */ void lambda$doRefreshChildren$0(StoreResource fileResource) {
        this.getChildren().remove(fileResource);
    }
}

