/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import net.pms.Messages;
import net.pms.renderers.Renderer;
import net.pms.store.StoreContainer;

public class LocalizedStoreContainer
extends StoreContainer {
    private final String i18nName;
    private final String[] formatStrings;

    public LocalizedStoreContainer(Renderer renderer, String i18nName) {
        this(renderer, i18nName, null, (String[])null);
    }

    public LocalizedStoreContainer(Renderer renderer, String i18nName, String thumbnailIcon) {
        this(renderer, i18nName, thumbnailIcon, (String[])null);
    }

    public LocalizedStoreContainer(Renderer renderer, String i18nName, String thumbnailIcon, String formatString) {
        this(renderer, i18nName, thumbnailIcon, new String[]{formatString});
    }

    public LocalizedStoreContainer(Renderer renderer, String i18nName, String thumbnailIcon, String[] formatStrings) {
        super(renderer, null, thumbnailIcon);
        this.i18nName = i18nName;
        this.formatStrings = formatStrings != null && formatStrings.length != 0 && formatStrings[0] != null ? formatStrings : null;
        if (i18nName != null) {
            this.setName(String.format(Messages.getString(i18nName), this.formatStrings));
        }
    }

    @Override
    public String getSystemName() {
        return this.getLocalizedName();
    }

    protected String getLocalizedName() {
        if (this.i18nName != null) {
            if (this.formatStrings != null && this.formatStrings.length > 0 && this.formatStrings[0] != null) {
                return this.i18nName + "|" + String.join((CharSequence)"|", this.formatStrings);
            }
            return this.i18nName;
        }
        return this.getName();
    }

    @Override
    public String getLocalizedDisplayName(String lang) {
        if (this.i18nName != null) {
            return "i18n@" + this.getLocalizedName();
        }
        return this.getDisplayName();
    }
}

