/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.pms.renderers.Renderer;
import net.pms.store.StoreContainer;
import net.pms.store.container.LocalizedStoreContainer;
import net.pms.store.item.RealFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xmlwise.Plist;
import xmlwise.XmlParseException;

public class IPhotoLibrary
extends LocalizedStoreContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(IPhotoLibrary.class);

    public IPhotoLibrary(Renderer renderer) {
        super(renderer, "IphotoLibrary");
    }

    public static IPhotoLibrary getiPhotoFolder(Renderer renderer) {
        IPhotoLibrary iPhotoVirtualFolder = null;
        if (Platform.isMac()) {
            File file = IPhotoLibrary.getiPhotoDbFile();
            if (file != null) {
                Map<String, Object> iPhotoLib;
                try {
                    iPhotoLib = Plist.load(file);
                }
                catch (IOException | XmlParseException e) {
                    LOGGER.error("Something went wrong with the iPhoto Library scan: ", e);
                    return null;
                }
                Map photoList = (Map)iPhotoLib.get("Master Image List");
                List listOfRolls = (List)iPhotoLib.get("List of Rolls");
                iPhotoVirtualFolder = new IPhotoLibrary(renderer);
                for (Map roll : listOfRolls) {
                    Object rollName = roll.get("RollName");
                    if (rollName == null) continue;
                    StoreContainer virtualFolder = new StoreContainer(renderer, rollName.toString(), null);
                    List rollPhotos = (List)roll.get("KeyList");
                    for (Object photo : rollPhotos) {
                        Object imagePath;
                        Map photoProperties = (Map)photoList.get(photo);
                        if (photoProperties == null || (imagePath = photoProperties.get("ImagePath")) == null) continue;
                        RealFile realFile = new RealFile(renderer, new File(imagePath.toString()));
                        virtualFolder.addChild(realFile);
                    }
                    iPhotoVirtualFolder.addChild(virtualFolder);
                }
            } else {
                LOGGER.info("iPhoto folder not found");
            }
        }
        return iPhotoVirtualFolder;
    }

    private static File getiPhotoDbFile() {
        File file = null;
        if (Platform.isMac()) {
            Process process;
            LOGGER.debug("Looking for iPhoto folder");
            try {
                process = Runtime.getRuntime().exec(new String[]{"defaults", "read", "com.apple.iApps", "iPhotoRecentDatabases"});
            }
            catch (IOException e1) {
                LOGGER.error("Something went wrong with the iPhoto folder finder: ", e1);
                return null;
            }
            try (InputStream inputStream = process.getInputStream();){
                List<String> lines = IOUtils.readLines(inputStream, StandardCharsets.UTF_8);
                LOGGER.debug("iPhotoRecentDatabases: {}", (Object)lines);
                if (lines.size() >= 2) {
                    String line = lines.get(1);
                    line = line.trim();
                    line = line.substring(1, line.length() - 1);
                    URL url = URI.create(line).toURL();
                    file = FileUtils.toFile(url);
                    LOGGER.debug("Resolved URL to file: {} -> {}", (Object)url, (Object)file.getAbsolutePath());
                } else {
                    LOGGER.info("iPhoto folder not found");
                }
            }
            catch (IOException | IllegalArgumentException e) {
                LOGGER.error("Something went wrong with the iPhoto iPhoto folder finder: ", e);
            }
        } else {
            LOGGER.info("iPhoto folder not found: Mac OS X only");
        }
        return file;
    }
}

