/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.util.ArrayList;
import net.pms.renderers.Renderer;
import net.pms.store.StoreContainer;
import net.pms.store.StoreResource;
import net.pms.store.container.FolderLimitLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderLimit
extends StoreContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FolderLimit.class);
    private final ArrayList<FolderLimitLevel> levels = new ArrayList();
    private boolean discover = false;

    public FolderLimit(Renderer renderer) {
        super(renderer, "Folder Limit", null);
        this.levels.add(new FolderLimitLevel(renderer, 0));
    }

    public void setStart(StoreResource res) {
        LOGGER.debug("setting folder lim " + res);
        if (res == null) {
            return;
        }
        if (this.discover) {
            return;
        }
        int level = -1;
        for (StoreResource tmp = res; tmp != null; tmp = tmp.getParent()) {
            if (tmp instanceof FolderLimit) {
                return;
            }
            if (!(tmp instanceof FolderLimitLevel)) continue;
            FolderLimitLevel folderLimitLevel = (FolderLimitLevel)tmp;
            level = folderLimitLevel.level();
            break;
        }
        try {
            FolderLimitLevel fll = this.levels.get(level + 1);
            fll.setStart(res);
            if (fll.level() == 0 && this.levels.size() > 1) {
                this.levels.clear();
                this.levels.add(fll);
            }
        }
        catch (IndexOutOfBoundsException e) {
            FolderLimitLevel fll = new FolderLimitLevel(this.renderer, level + 1);
            fll.setStart(res);
            this.levels.add(fll);
        }
    }

    @Override
    public void discoverChildren() {
        this.discover = true;
        for (StoreResource storeResource : this.levels) {
            this.addChild(storeResource);
        }
        this.discover = false;
    }

    @Override
    public synchronized void resolve() {
        this.setDiscovered(false);
        this.getChildren().clear();
    }
}

