/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.dlna.DLNAImageProfile;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.image.BufferedImageFilterChain;
import net.pms.image.ImageInfo;
import net.pms.media.MediaInfo;
import net.pms.media.MediaStatus;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.network.mediaserver.MediaServerRequest;
import net.pms.renderers.Renderer;
import net.pms.store.MediaStoreIds;
import net.pms.store.StoreContainer;
import net.pms.store.StoreItem;
import net.pms.store.container.ChapterFileTranscodeVirtualFolder;
import net.pms.store.container.CodeEnter;
import net.pms.store.container.FileTranscodeVirtualFolder;
import net.pms.util.FullyPlayedAction;
import net.pms.util.GenericIcons;
import net.pms.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StoreResource
implements Cloneable,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreResource.class);
    protected static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    protected static final int MAX_ARCHIVE_ENTRY_SIZE = 10000000;
    protected static final int MAX_ARCHIVE_SIZE_SEEK = 800000000;
    public static final long TRANS_SIZE = 0x7FFFFFFF7FFFFFFFL;
    public static final RenderingHints THUMBNAIL_HINTS = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    private volatile ImageInfo thumbnailImageInfo = null;
    protected final Renderer renderer;
    private boolean resolved;
    private String id;
    private StoreContainer parent;
    protected MediaInfo mediaInfo;
    private MediaStatus mediaStatus;
    private long lastModified;
    private boolean noName;
    private int nametruncate;
    private StoreResource first;
    private StoreResource second;
    private String fakeParentId;
    private long lastRefreshTime;
    protected boolean isSortable = false;
    protected HashMap<String, Object> attachments = null;

    protected StoreResource(Renderer renderer) {
        this.renderer = renderer;
    }

    public StoreContainer getParent() {
        return this.parent;
    }

    public void setParent(StoreContainer parent) {
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    public Long getLongId() {
        try {
            return Long.valueOf(this.getId());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPathId() {
        ArrayList<String> res = new ArrayList<String>();
        res.add(this.getId());
        for (StoreContainer tmp = this.getParent(); tmp != null; tmp = tmp.getParent()) {
            res.add(0, tmp.getId());
        }
        return StringUtils.join(res, '.');
    }

    public String getResourceId() {
        if (this.isFolder() && this.renderer.getUmsConfiguration().getAutoDiscover()) {
            return this.getPathId();
        }
        return this.getId();
    }

    protected void setLongId(long id) {
        this.setId(Long.toString(id));
    }

    public boolean isTranscodeFolderAvailable() {
        return true;
    }

    public boolean isLiveSubtitleFolderAvailable() {
        return true;
    }

    public abstract String getName();

    public abstract String getSystemName();

    public String getFileName() {
        return this.getSystemName();
    }

    public abstract long length();

    public abstract boolean isFolder();

    public StoreResource getPrimaryResource() {
        return this.first;
    }

    public void setPrimaryResource(StoreResource first) {
        this.first = first;
    }

    public StoreResource getSecondaryResource() {
        return this.second;
    }

    public void setSecondaryResource(StoreResource second) {
        this.second = second;
    }

    public String getFakeParentId() {
        return this.fakeParentId;
    }

    public void setFakeParentId(String fakeParentId) {
        this.fakeParentId = fakeParentId;
    }

    public String getParentId() {
        if (this.getFakeParentId() != null) {
            return this.getFakeParentId();
        }
        if (this.parent != null) {
            return this.parent.getResourceId();
        }
        return "-1";
    }

    protected void notifyRefresh() {
        this.lastRefreshTime = System.currentTimeMillis();
        MediaStoreIds.incrementUpdateId(this.getLongId());
    }

    @Override
    public void run() {
        try {
            if (this.first == null) {
                this.syncResolve();
                if (this.second != null) {
                    this.second.syncResolve();
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unhandled exception while resolving {}: {}", (Object)this.getDisplayName(), (Object)e.getMessage());
            LOGGER.debug("", e);
        }
    }

    protected void resolveOnce() {
    }

    public synchronized void syncResolve() {
        this.resolve();
    }

    public void resolve() {
        if (!this.resolved) {
            this.resolveOnce();
            this.resolved = true;
        }
    }

    public String getDisplayNameBase() {
        return this.isNoName() || this.getName() == null ? "" : StringEscapeUtils.unescapeJava(this.getName());
    }

    public String getDisplayName() {
        return this.getDisplayName(true);
    }

    public String getDisplayName(boolean withSuffix) {
        String engineName;
        StoreItem item;
        StoreResource storeResource;
        StringBuilder sb = new StringBuilder();
        if (this.parent instanceof ChapterFileTranscodeVirtualFolder && (storeResource = this) instanceof StoreItem && (item = (StoreItem)storeResource).getSplitRange() != null) {
            sb.append(">> ");
            sb.append(StringUtil.convertTimeToString(item.getSplitRange().getStartOrZero(), "%02d:%02d:%05.2f"));
        } else {
            sb.append(this.getDisplayNameBase());
        }
        if (withSuffix) {
            String displayNamesuffix = this.getDisplayNameSuffix();
            if (StringUtils.isNotBlank(displayNamesuffix)) {
                if (this.isInsideTranscodeFolder()) {
                    sb.setLength(0);
                    sb.append(displayNamesuffix);
                } else {
                    sb.append(" ").append(displayNamesuffix);
                }
            }
        } else if (this.isInsideTranscodeFolder() && !(this instanceof ChapterFileTranscodeVirtualFolder)) {
            sb.setLength(0);
        }
        storeResource = this;
        if (storeResource instanceof StoreItem && (engineName = (item = (StoreItem)storeResource).getDisplayNameEngine()) != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(engineName);
        }
        if (this.nametruncate > 0) {
            return sb.substring(0, this.nametruncate).trim();
        }
        return sb.toString();
    }

    public String getDisplayNameSuffix() {
        return null;
    }

    public String getLocalizedDisplayName(String lang) {
        return this.getDisplayName();
    }

    public void truncateDisplayName(String end) {
        this.nametruncate = this.getName().lastIndexOf(end);
    }

    public boolean isInsideTranscodeFolder() {
        return this.parent instanceof FileTranscodeVirtualFolder;
    }

    public String getThumbnailURL(DLNAImageProfile profile) {
        StringBuilder sb = MediaServerRequest.getServerThumbnailURL(this.renderer.getUUID(), StoreResource.encode(this.getResourceId()));
        if (profile != null) {
            if (DLNAImageProfile.JPEG_RES_H_V.equals(profile)) {
                sb.append("JPEG_RES").append(profile.getH()).append("x");
                sb.append(profile.getV()).append("_");
            } else {
                sb.append(profile).append("_");
            }
        }
        sb.append(StoreResource.encode(this.getName())).append(".");
        if (profile != null) {
            sb.append(profile.getDefaultExtension());
        } else {
            LOGGER.debug("Warning: Thumbnail without DLNA image profile requested, resulting URL is: \"{}\"", (Object)sb.toString());
        }
        return sb.toString();
    }

    public String getSubsURL(MediaSubtitle subs) {
        StringBuilder sb = MediaServerRequest.getServerSubtitlesURL(this.renderer.getUUID(), this.getResourceId());
        sb.append(StoreResource.encode(subs.getName()));
        return sb.toString();
    }

    public void checkThumbnail() {
    }

    protected DLNAThumbnailInputStream getGenericThumbnailInputStreamInternal(String fallback) throws IOException {
        if (this.isFolder()) {
            return GenericIcons.INSTANCE.getGenericFolderIcon();
        }
        return GenericIcons.INSTANCE.getGenericIcon(this);
    }

    public final DLNAThumbnailInputStream getGenericThumbnailInputStream(String fallback) throws IOException {
        DLNAThumbnailInputStream inputStream = this.getGenericThumbnailInputStreamInternal(fallback);
        this.thumbnailImageInfo = inputStream != null ? inputStream.getImageInfo() : null;
        return inputStream;
    }

    public ImageInfo getThumbnailImageInfo() {
        return this.thumbnailImageInfo;
    }

    public final DLNAThumbnailInputStream fetchThumbnailInputStream() throws IOException {
        DLNAThumbnailInputStream inputStream = this.getThumbnailInputStream();
        this.thumbnailImageInfo = inputStream != null ? inputStream.getImageInfo() : null;
        return inputStream;
    }

    public DLNAThumbnailInputStream getThumbnailInputStream() throws IOException {
        return this.getGenericThumbnailInputStream(null);
    }

    public BufferedImageFilterChain addFlagFilters(BufferedImageFilterChain filterChain) {
        return filterChain;
    }

    public abstract boolean isValid();

    public MediaInfo getMediaInfo() {
        return this.mediaInfo;
    }

    public void setMediaInfo(MediaInfo media) {
        this.mediaInfo = media;
    }

    public MediaStatus getMediaStatus() {
        return this.mediaStatus;
    }

    public void setMediaStatus(MediaStatus mediaStatus) {
        this.mediaStatus = mediaStatus;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    protected final void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public boolean isNoName() {
        return this.noName;
    }

    public void setNoName(boolean noName) {
        this.noName = noName;
    }

    public Renderer getDefaultRenderer() {
        return this.renderer;
    }

    protected long getLastRefreshTime() {
        return this.lastRefreshTime;
    }

    protected void setLastRefreshTime(long lastRefreshTime) {
        this.lastRefreshTime = lastRefreshTime;
    }

    public boolean isSearched() {
        return false;
    }

    public void attach(String key, Object data) {
        if (this.attachments == null) {
            this.attachments = new HashMap();
        }
        this.attachments.put(key, data);
    }

    public Object getAttachment(String key) {
        return this.attachments == null ? null : this.attachments.get(key);
    }

    public boolean isURLResolved() {
        return false;
    }

    public boolean isHideFullyPlayed() {
        return CONFIGURATION.getFullyPlayedAction() == FullyPlayedAction.HIDE_MEDIA && this.mediaInfo != null && this.mediaInfo.isVideo() && this.mediaStatus != null && this.mediaStatus.isFullyPlayed();
    }

    public boolean isSubSelectable() {
        return false;
    }

    public String write() {
        return null;
    }

    public static boolean isResourceUrl(String url) {
        return url != null && url.contains(MediaServerRequest.getMediaURL().toString());
    }

    public static String parseResourceId(String url) {
        if (StoreResource.isResourceUrl(url)) {
            return new MediaServerRequest(url).getResourceId();
        }
        return null;
    }

    public static String parseObjectId(String url) {
        if (StoreResource.isResourceUrl(url)) {
            MediaServerRequest request = new MediaServerRequest(url);
            return request.getResourceId() + "/" + request.getOptionalPath();
        }
        return null;
    }

    public boolean isRendererAllowed() {
        return true;
    }

    public StoreResource isCoded() {
        for (StoreResource tmp = this; tmp != null; tmp = tmp.getParent()) {
            if (!(tmp instanceof CodeEnter)) continue;
            return tmp;
        }
        return null;
    }

    public boolean isCodeValid(StoreResource r) {
        StoreResource res = r.isCoded();
        if (res instanceof CodeEnter) {
            CodeEnter codeEnter = (CodeEnter)res;
            return codeEnter.validCode(r);
        }
        return true;
    }

    public boolean isLogPlayEvents() {
        return true;
    }

    public boolean isAddToMediaLibrary() {
        return true;
    }

    public boolean isFullyPlayedAware() {
        return false;
    }

    public boolean isFullyPlayed() {
        return false;
    }

    public void setFullyPlayed(boolean fullyPlayed) {
    }

    public boolean isFullyPlayedMark() {
        return this.isFullyPlayedAware() && (CONFIGURATION.getFullyPlayedAction() == FullyPlayedAction.MARK || CONFIGURATION.getFullyPlayedAction() == FullyPlayedAction.MOVE_FOLDER_AND_MARK) && this.isFullyPlayed();
    }

    public boolean isSortable() {
        return this.isSortable;
    }

    public void setSortable(boolean isSortable) {
        this.isSortable = isSortable;
    }

    protected InputStream getResourceInputStream(String fileName) {
        fileName = "/resources/" + (String)fileName;
        fileName = ((String)fileName).replace("//", "/");
        ClassLoader cll = this.getClass().getClassLoader();
        InputStream is = cll.getResourceAsStream(((String)fileName).substring(1));
        while (is == null && cll.getParent() != null) {
            cll = cll.getParent();
            is = cll.getResourceAsStream(((String)fileName).substring(1));
        }
        return is;
    }

    public StoreResource clone() {
        StoreResource o = null;
        try {
            o = (StoreResource)super.clone();
            o.setId(null);
            o.resolved = false;
            if (this.mediaInfo != null) {
                o.mediaInfo = this.mediaInfo.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error(null, e);
        }
        return o;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" [id=");
        result.append(this.getId());
        result.append(", name=");
        result.append(this.getName());
        result.append(", full path=");
        result.append(this.getResourceId());
        result.append(']');
        return result.toString();
    }

    protected static String encode(String s) {
        try {
            if (s == null) {
                return "";
            }
            s = s.replace('\\', '-').replace('/', '-').replace('%', '-');
            return URLEncoder.encode(s, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Error while URL encoding \"{}\": {}", (Object)s, (Object)e.getMessage());
            LOGGER.trace("", e);
            return "";
        }
    }

    public String getGenre() {
        if (this.mediaInfo != null) {
            if (this.mediaInfo.isAudio()) {
                if (this.mediaInfo.hasAudioMetadata()) {
                    return this.mediaInfo.getAudioMetadata().getGenre();
                }
            } else if (this.mediaInfo.isVideo() && this.mediaInfo.hasVideoMetadata() && this.mediaInfo.getVideoMetadata().getGenres() != null) {
                return (String)this.mediaInfo.getVideoMetadata().getGenres().get(0);
            }
        }
        return null;
    }
}

