/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTableSubtracks;
import net.pms.dlna.DLNAThumbnail;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.encoders.Engine;
import net.pms.encoders.HlsHelper;
import net.pms.encoders.TranscodingSettings;
import net.pms.formats.Format;
import net.pms.formats.FormatFactory;
import net.pms.image.BufferedImageFilterChain;
import net.pms.image.ImagesUtil;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.io.SizeLimitInputStream;
import net.pms.media.MediaInfo;
import net.pms.media.MediaType;
import net.pms.media.audio.MediaAudio;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.media.video.MediaVideo;
import net.pms.network.HTTPResource;
import net.pms.network.mediaserver.MediaServerRequest;
import net.pms.parsers.Parser;
import net.pms.renderers.Renderer;
import net.pms.renderers.devices.MediaScannerDevice;
import net.pms.store.MediaStore;
import net.pms.store.ResumeObj;
import net.pms.store.StoreResource;
import net.pms.store.ThumbnailSource;
import net.pms.store.ThumbnailStore;
import net.pms.store.container.ChapterFileTranscodeVirtualFolder;
import net.pms.store.item.DVDISOTitle;
import net.pms.store.item.RealFile;
import net.pms.store.item.VirtualVideoAction;
import net.pms.util.ByteRange;
import net.pms.util.FileUtil;
import net.pms.util.IPushOutput;
import net.pms.util.InputFile;
import net.pms.util.Iso639;
import net.pms.util.MpegUtil;
import net.pms.util.Range;
import net.pms.util.SubtitleUtils;
import net.pms.util.TimeRange;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StoreItem
extends StoreResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreItem.class);
    private static final int STOP_PLAYING_DELAY = 4000;
    private static final double CONTAINER_OVERHEAD = 1.04;
    private TranscodingSettings transcodingSettings;
    private boolean skipTranscode = false;
    private ProcessWrapper externalProcess;
    private Format format;
    private int specificType;
    private MediaAudio mediaAudio;
    private TimeRange splitRange = new TimeRange();
    private long lastStartSystemTimeUser;
    private long lastStartSystemTime;
    private double lastStartPosition;
    private double lastTimeSeek = -1.0;
    private final Map<String, Integer> requestIdToRefcount = new HashMap<String, Integer>();
    private ResumeObj resume;
    private int resHash = 0;
    private MediaSubtitle mediaSubtitle;
    private final Object subtitlesLock = new Object();
    private boolean hasExternalSubtitles;
    private boolean hasSubtitles;
    private boolean isExternalSubtitlesParsed;

    protected StoreItem(Renderer renderer) {
        this(renderer, 8);
    }

    protected StoreItem(Renderer renderer, int specificType) {
        super(renderer);
        this.setSpecificType(specificType);
        this.setSortable(true);
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    protected void resolveFormat() {
        if (this.format == null) {
            this.format = FormatFactory.getAssociatedFormat(this.getFileName());
        }
        if (this.format != null && this.format.isUnknown()) {
            this.format.setType(this.getSpecificType());
        }
    }

    public TimeRange getSplitRange() {
        return this.splitRange;
    }

    public void setSplitRange(TimeRange splitRange) {
        this.splitRange = splitRange;
    }

    public TranscodingSettings getTranscodingSettings() {
        return this.transcodingSettings;
    }

    public void setTranscodingSettings(TranscodingSettings transcodingSettings) {
        this.transcodingSettings = transcodingSettings;
    }

    public boolean isTranscoded() {
        return this.getTranscodingSettings() != null;
    }

    public boolean isTimeSeekable() {
        return this.isTranscoded() ? this.getTranscodingSettings().getEngine().isTimeSeekable() : true;
    }

    protected String getEngineName() {
        if (this.isTranscoded()) {
            return this.getTranscodingSettings().getEngine().getName();
        }
        return Messages.getString("NoTranscoding");
    }

    public int getType() {
        if (this.getFormat() != null) {
            return this.getFormat().getType();
        }
        return 8;
    }

    protected int getSpecificType() {
        return this.specificType;
    }

    private void setSpecificType(int specificType) {
        this.specificType = specificType;
    }

    public MediaAudio getMediaAudio() {
        return this.mediaAudio;
    }

    public void setMediaAudio(MediaAudio mediaAudio) {
        this.mediaAudio = mediaAudio;
    }

    public MediaSubtitle getMediaSubtitle() {
        return this.mediaSubtitle;
    }

    public void setMediaSubtitle(MediaSubtitle mediaSubtitle) {
        this.mediaSubtitle = mediaSubtitle;
    }

    public boolean hasExternalSubtitles() {
        return this.hasExternalSubtitles(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasExternalSubtitles(boolean forceRefresh) {
        if (this.mediaInfo == null || !this.mediaInfo.isVideo()) {
            return false;
        }
        Object object = this.subtitlesLock;
        synchronized (object) {
            this.registerExternalSubtitles(forceRefresh);
            return this.hasExternalSubtitles;
        }
    }

    public boolean hasSubtitles() {
        return this.hasSubtitles(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSubtitles(boolean forceRefresh) {
        if (this.mediaInfo == null || !this.mediaInfo.isVideo()) {
            return false;
        }
        Object object = this.subtitlesLock;
        synchronized (object) {
            this.registerExternalSubtitles(forceRefresh);
            return this.hasSubtitles;
        }
    }

    public boolean hasEmbeddedSubtitles() {
        if (this.mediaInfo == null || !this.mediaInfo.isVideo()) {
            return false;
        }
        List<MediaSubtitle> subtitlesList = this.mediaInfo.getSubtitlesTracks();
        if (subtitlesList != null) {
            for (MediaSubtitle subtitles : subtitlesList) {
                if (!subtitles.isEmbedded()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCompatible() {
        return this.format == null || this.format.isUnknown() || this.format.isVideo() && this.renderer.isVideoSupported() || this.format.isAudio() && this.renderer.isAudioSupported() || this.format.isImage() && this.renderer.isImageSupported();
    }

    private boolean isSkipTranscode() {
        return this.skipTranscode;
    }

    public TranscodingSettings resolveTranscodingSettings() {
        boolean parserV2;
        if (this.renderer instanceof MediaScannerDevice) {
            return null;
        }
        if (this.renderer.getUmsConfiguration().isDisableTranscoding()) {
            LOGGER.debug("Final verdict: \"{}\" will be streamed since transcoding is disabled", (Object)this.getName());
            return null;
        }
        boolean bl = parserV2 = this.mediaInfo != null && this.renderer.isUseMediaInfo();
        if (this.mediaInfo == null) {
            this.mediaInfo = new MediaInfo();
        }
        if (this.format == null) {
            Format f = FormatFactory.getAssociatedFormat(this.getSystemName());
            this.setFormat(f != null ? f : FormatFactory.getAssociatedFormat(".mpg"));
        }
        if (this.isInsideTranscodeFolder()) {
            TranscodingSettings resolvedTranscodingSettings = this.getTranscodingSettings();
            LOGGER.trace("Selecting transcodingSettings {} based on transcode item settings", (Object)resolvedTranscodingSettings);
            return resolvedTranscodingSettings;
        }
        if (this.mediaInfo.isVideo() && !this.renderer.getUmsConfiguration().isDisableSubtitles() && this.hasSubtitles(false)) {
            MediaAudio audio;
            MediaAudio mediaAudio = audio = this.mediaAudio != null ? this.mediaAudio : this.resolveAudioStream();
            if (this.mediaSubtitle == null) {
                this.mediaSubtitle = this.resolveSubtitlesStream(audio == null ? null : audio.getLang(), false);
            }
        }
        String rendererForceExtensions = this.renderer.getTranscodedExtensions();
        String rendererSkipExtensions = this.renderer.getStreamedExtensions();
        String configurationForceExtensions = this.renderer.getUmsConfiguration().getForceTranscodeForExtensions();
        String configurationSkipExtensions = this.renderer.getUmsConfiguration().getDisableTranscodeForExtensions();
        this.skipTranscode = this.format.skip(configurationSkipExtensions, rendererSkipExtensions);
        if (this.skipTranscode) {
            LOGGER.debug("Final verdict: \"{}\" will be streamed since it is forced by configuration", (Object)this.getName());
            return null;
        }
        boolean forceTranscode = this.format.skip(configurationForceExtensions, rendererForceExtensions);
        TranscodingSettings resolvedTranscodingSettings = TranscodingSettings.getBestTranscodingSettings(this);
        boolean isIncompatible = false;
        if (resolvedTranscodingSettings != null) {
            String prependTranscodingReason = "File \"{}\" will not be streamed because ";
            if (forceTranscode) {
                LOGGER.debug(prependTranscodingReason + "transcoding is forced by configuration", (Object)this.getName());
            } else if (this instanceof DVDISOTitle) {
                forceTranscode = true;
                LOGGER.debug(prependTranscodingReason + "streaming of DVD video tracks isn't supported", (Object)this.getName());
            } else if (!this.format.isCompatible(this, this.renderer)) {
                isIncompatible = true;
                LOGGER.debug(prependTranscodingReason + "it is not supported by the renderer {}", (Object)this.getName(), (Object)this.renderer.getRendererName());
            } else if (this.renderer.getUmsConfiguration().isEncodedAudioPassthrough()) {
                if (this.mediaAudio != null && ("ac3".equals(this.mediaAudio.getAudioCodec()) || "dts".equals(this.mediaAudio.getAudioCodec()))) {
                    isIncompatible = true;
                    LOGGER.debug(prependTranscodingReason + "the audio will use the encoded audio passthrough feature", (Object)this.getName());
                } else {
                    for (MediaAudio audioTrack : this.mediaInfo.getAudioTracks()) {
                        if (audioTrack == null || !"ac3".equals(audioTrack.getAudioCodec()) && !"dts".equals(audioTrack.getAudioCodec())) continue;
                        isIncompatible = true;
                        LOGGER.debug(prependTranscodingReason + "the audio will use the encoded audio passthrough feature", (Object)this.getName());
                        break;
                    }
                }
            }
            if (!forceTranscode && !isIncompatible && this.format.isVideo() && parserV2 && this.mediaInfo.getDefaultVideoTrack() != null) {
                MediaVideo mediaVideo = this.mediaInfo.getDefaultVideoTrack();
                int maxBandwidth = this.renderer.getMaxBandwidth();
                if (this.renderer.isKeepAspectRatio() && !"16:9".equals(mediaVideo.getDisplayAspectRatio())) {
                    isIncompatible = true;
                    LOGGER.debug(prependTranscodingReason + "the renderer needs us to add borders to change the aspect ratio from {} to 16/9.", (Object)this.getName(), (Object)mediaVideo.getDisplayAspectRatio());
                } else if (!this.renderer.isResolutionCompatibleWithRenderer(mediaVideo.getWidth(), mediaVideo.getHeight())) {
                    isIncompatible = true;
                    LOGGER.debug(prependTranscodingReason + "the resolution is incompatible with the renderer.", (Object)this.getName());
                } else if (this.mediaInfo.getBitRate() > maxBandwidth) {
                    isIncompatible = true;
                    LOGGER.debug(prependTranscodingReason + "the bitrate ({} b/s) is too high ({} b/s).", this.getName(), this.mediaInfo.getBitRate(), maxBandwidth);
                } else if (mediaVideo.isH264()) {
                    double h264LevelLimit = this.renderer.getH264LevelLimit();
                    if (mediaVideo.getFormatLevel() != null) {
                        double h264Level = mediaVideo.getFormatLevelAsDouble(4.1);
                        if (h264Level > h264LevelLimit) {
                            isIncompatible = true;
                            LOGGER.debug(prependTranscodingReason + "the H.264 level ({}) is not supported by the renderer (limit: {}).", this.getName(), h264Level, h264LevelLimit);
                        }
                    } else if (h264LevelLimit < 4.2) {
                        isIncompatible = true;
                        LOGGER.debug(prependTranscodingReason + "the H.264 level is unknown.", (Object)this.getName());
                    }
                } else if (mediaVideo.is3d() && StringUtils.isNotBlank(this.renderer.getOutput3DFormat()) && !mediaVideo.get3DLayout().toString().toLowerCase(Locale.ROOT).equals(this.renderer.getOutput3DFormat())) {
                    forceTranscode = true;
                    LOGGER.debug(prependTranscodingReason + "it is 3D and is forced to transcode to the format \"{}\"", (Object)this.getName(), (Object)this.renderer.getOutput3DFormat());
                }
            }
            if (forceTranscode || isIncompatible && !this.isSkipTranscode()) {
                if (parserV2) {
                    LOGGER.debug("Final verdict: \"{}\" will be transcoded with transcodingSettings \"{}\" with mime type \"{}\"", this.getName(), resolvedTranscodingSettings.toString(), this.getMimeType());
                } else {
                    LOGGER.debug("Final verdict: \"{}\" will be transcoded with transcodingSettings \"{}\"", (Object)this.getName(), (Object)resolvedTranscodingSettings.toString());
                }
            } else {
                resolvedTranscodingSettings = null;
                LOGGER.debug("Final verdict: \"{}\" will be streamed", (Object)this.getName());
            }
        } else {
            LOGGER.debug("Final verdict: \"{}\" will be streamed because no compatible engine was found", (Object)this.getName());
        }
        return resolvedTranscodingSettings;
    }

    public String getRendererMimeType() {
        String mime = this.getMimeType();
        if (mime == null || mime.contains("/transcode")) {
            mime = HTTPResource.getDefaultMimeType(this.getType());
        }
        return mime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPlaying(String rendererId) {
        String requestId = this.getRequestId(rendererId);
        Map<String, Integer> map = this.requestIdToRefcount;
        synchronized (map) {
            Integer temp = this.requestIdToRefcount.get(requestId);
            if (temp == null) {
                temp = 0;
            }
            Integer refCount = temp;
            this.requestIdToRefcount.put(requestId, refCount + 1);
            if (refCount == 0) {
                StoreItem self = this;
                Runnable r = () -> {
                    String rendererName = "unknown renderer";
                    try {
                        this.renderer.setPlayingRes(self);
                        rendererName = this.renderer.getRendererName().replaceAll("\n", "");
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (this.isLogPlayEvents()) {
                        LOGGER.info("Started playing {} ({}) on your {}", this.getName(), this.getEngineName(), rendererName);
                        LOGGER.debug("The full filename of which is: " + this.getFileName() + " and the address of the renderer is: " + rendererId);
                    }
                    this.lastStartSystemTime = System.currentTimeMillis();
                };
                new Thread(r, "StartPlaying Event").start();
            }
        }
    }

    public void stopPlaying(String rendererId) {
        StoreItem self = this;
        String requestId = this.getRequestId(rendererId);
        Runnable defer = () -> {
            long start = this.lastStartSystemTime;
            if (this.isLogPlayEvents()) {
                LOGGER.trace("Stop playing {} on {} if no request under {} ms", this.getName(), this.renderer.getRendererName(), 4000);
            }
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("stopPlaying sleep interrupted", e);
                Thread.currentThread().interrupt();
            }
            Map<String, Integer> map = this.requestIdToRefcount;
            synchronized (map) {
                Integer refCount = this.requestIdToRefcount.get(requestId);
                assert (refCount != null);
                assert (refCount > 0);
                this.requestIdToRefcount.put(requestId, refCount - 1);
                if (start != this.lastStartSystemTime) {
                    if (this.isLogPlayEvents()) {
                        LOGGER.trace("Continue playing {} on {}", (Object)this.getName(), (Object)this.renderer.getRendererName());
                    }
                    return;
                }
                Runnable r = () -> {
                    if (refCount == 1) {
                        this.requestIdToRefcount.put(requestId, 0);
                        String rendererName = this.renderer.getRendererName();
                        if (this.renderer.getPlayingRes() == self) {
                            this.renderer.setPlayingRes(null);
                        }
                        if (this.isLogPlayEvents()) {
                            LOGGER.info("Stopped playing {} on {}", (Object)this.getName(), (Object)rendererName);
                            LOGGER.debug("The full filename of which is \"{}\" and the address of the renderer is {}", (Object)this.getFileName(), (Object)rendererId);
                        }
                        this.internalStop();
                    }
                };
                new Thread(r, "StopPlaying Event").start();
            }
        };
        new Thread(defer, "StopPlaying Event Deferrer").start();
    }

    private String getRequestId(String rendererId) {
        return String.format("%s|%x|%s", rendererId, this.hashCode(), this.getSystemName());
    }

    public long getLastStartSystemTime() {
        return this.lastStartSystemTime;
    }

    public void setLastStartSystemTime(long startTime) {
        this.lastStartSystemTime = startTime;
        double fileDuration = 0.0;
        if (this.mediaInfo != null && (this.mediaInfo.isAudio() || this.mediaInfo.isVideo())) {
            fileDuration = this.mediaInfo.getDurationInSeconds();
        }
        if (fileDuration < 2.0 || this.lastStartPosition < fileDuration - 2.0) {
            this.lastStartSystemTimeUser = startTime;
        }
    }

    public long getLastStartSystemTimeUser() {
        return this.lastStartSystemTimeUser;
    }

    public double getLastStartPosition() {
        return this.lastStartPosition;
    }

    public abstract InputStream getInputStream() throws IOException;

    public InputStream getInputStream(Range range) throws IOException {
        return this.getInputStream(range, null);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized InputStream getInputStream(Range range, HlsHelper.HlsConfiguration hlsConfiguration) throws IOException {
        StoreItem.LOGGER.trace("Asked stream chunk: " + range + " of " + this.getName() + " and engine " + this.getTranscodingSettings());
        timeseekAuto = false;
        cbrVideoBitrate = this.renderer.getCBRVideoBitrate();
        if (range instanceof ByteRange) {
            byteRange = (ByteRange)range;
            v0 = byteRange.getStartOrZero();
        } else {
            v0 = low = 0L;
        }
        if (!(range instanceof ByteRange)) ** GOTO lbl-1000
        byteRange = (ByteRange)range;
        if (range.isEndLimitAvailable()) {
            v1 = byteRange.getEnd();
        } else lbl-1000:
        // 2 sources

        {
            v1 = -1L;
        }
        high = v1;
        timeRange = range.createTimeRange();
        if (this.isTranscoded() && low > 0L && cbrVideoBitrate > 0 && low > (long)(usedBitRated = (int)((double)((cbrVideoBitrate + 256) * 1024) / 8.0 * 1.04))) {
            timeRange.setStart((double)low / (double)usedBitRated);
            low = 0L;
            if (timeRange.getStartOrZero() > this.mediaInfo.getDurationInSeconds()) {
                return null;
            }
            rewindSecs = this.renderer.getByteToTimeseekRewindSeconds();
            timeRange.rewindStart(rewindSecs);
            timeseekAuto = true;
        }
        if (low > 0L && this.mediaInfo.getBitRate() > 0) {
            this.lastStartPosition = (double)(low * 8L) / (double)this.mediaInfo.getBitRate();
            StoreItem.LOGGER.trace("Estimating seek position from byte range:");
            StoreItem.LOGGER.trace("   media.getBitrate: " + this.mediaInfo.getBitRate());
            StoreItem.LOGGER.trace("   low: " + low);
            StoreItem.LOGGER.trace("   lastStartPosition: " + this.lastStartPosition);
        } else {
            this.lastStartPosition = timeRange.getStartOrZero();
            StoreItem.LOGGER.trace("Setting lastStartPosition from time-seeking: " + this.lastStartPosition);
        }
        if (!this.isTranscoded() && !this.isResume()) {
            rewindSecs = this;
            if (rewindSecs instanceof IPushOutput) {
                iPushOutput = (IPushOutput)rewindSecs;
                out = new PipedOutputStream();
                fis = new PipedInputStream(out);
                iPushOutput.push(out);
                if (low > 0L) {
                    fis.skip(low);
                }
                this.setLastStartSystemTime(System.currentTimeMillis());
                return StoreItem.wrap(fis, high, low);
            }
            fis = this.getInputStream();
            if (fis != null) {
                if (low > 0L) {
                    fis.skip(low);
                }
                fis = StoreItem.wrap(fis, high, low);
                if (timeRange.getStartOrZero() > 0.0 && this instanceof RealFile) {
                    fis.skip(MpegUtil.getPositionForTimeInMpeg(((RealFile)this).getFile(), (int)timeRange.getStartOrZero()));
                }
            }
            this.setLastStartSystemTime(System.currentTimeMillis());
            return fis;
        }
        params = new OutputParams(this.renderer.getUmsConfiguration());
        params.setAid(this.mediaAudio);
        params.setSid(this.mediaSubtitle);
        params.setMediaRenderer(this.renderer);
        timeRange.limit(this.getSplitRange());
        params.setTimeSeek(timeRange.getStartOrZero());
        params.setTimeEnd(timeRange.getEndOrZero());
        params.setShiftScr(timeseekAuto);
        params.setHlsConfiguration(hlsConfiguration);
        fis = this;
        if (fis instanceof IPushOutput) {
            iPushOutput = (IPushOutput)fis;
            params.setStdIn(iPushOutput);
        }
        if (this.resume != null) {
            if (range instanceof TimeRange) {
                tRange = (TimeRange)range;
                this.resume.update(tRange, this);
            }
            params.setTimeSeek(this.resume.getTimeOffset() / 1000L);
            if (!this.isTranscoded()) {
                this.setTranscodingSettings(TranscodingSettings.getBestTranscodingSettings(this));
            }
        }
        if (System.currentTimeMillis() - this.lastStartSystemTime < 500L) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                StoreItem.LOGGER.error(null, e);
                Thread.currentThread().interrupt();
            }
        }
        if (this.externalProcess == null || this.externalProcess.isDestroyed() || hlsConfiguration != null) {
            StoreItem.LOGGER.debug("Starting transcode/remux of " + this.getName() + " with media info: " + this.mediaInfo);
            this.setLastStartSystemTime(System.currentTimeMillis());
            if (params.getTimeSeek() > 0.0) {
                StoreItem.LOGGER.debug("Setting last time seek (from resume) to: " + params.getTimeSeek() + " seconds");
                this.lastTimeSeek = params.getTimeSeek();
            }
            this.externalProcess = this.getTranscodingSettings().getEngine().launchTranscode(this, this.mediaInfo, params);
            if (params.getWaitBeforeStart() > 0) {
                StoreItem.LOGGER.trace("Sleeping for {} milliseconds", (Object)params.getWaitBeforeStart());
                try {
                    Thread.sleep(params.getWaitBeforeStart());
                }
                catch (InterruptedException e) {
                    StoreItem.LOGGER.error(null, e);
                    Thread.currentThread().interrupt();
                }
                StoreItem.LOGGER.trace("Finished sleeping for " + params.getWaitBeforeStart() + " milliseconds");
            }
        } else if (params.getTimeSeek() > 0.0 && this.mediaInfo != null && this.mediaInfo.isMediaParsed() && this.mediaInfo.getDurationInSeconds() > 0.0) {
            StoreItem.LOGGER.debug("Requesting time seek: " + params.getTimeSeek() + " seconds");
            if (this.lastTimeSeek == params.getTimeSeek()) {
                StoreItem.LOGGER.debug("Duplicate time seek request: " + params.getTimeSeek() + " seconds, ignoring");
            } else {
                StoreItem.LOGGER.debug("Setting last time seek to: " + params.getTimeSeek() + " seconds");
                this.lastTimeSeek = params.getTimeSeek();
                params.setMinBufferSize(1.0);
                r = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$getInputStream$3(), ()V)((StoreItem)this);
                new Thread(r, "External Process Stopper").start();
                this.setLastStartSystemTime(System.currentTimeMillis());
                newExternalProcess = this.getTranscodingSettings().getEngine().launchTranscode(this, this.mediaInfo, params);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    StoreItem.LOGGER.error(null, e);
                    Thread.currentThread().interrupt();
                }
                if (newExternalProcess == null) {
                    StoreItem.LOGGER.trace("External process instance is null... sounds not good");
                }
                this.externalProcess = newExternalProcess;
            }
        }
        if (this.externalProcess == null) {
            return null;
        }
        is = null;
        timer = 0;
        while (is == null && timer < 10) {
            is = this.externalProcess.getInputStream(low);
            ++timer;
            if (is != null) continue;
            StoreItem.LOGGER.debug("External input stream instance is null... sounds not good, waiting 500ms");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (is == null && !this.externalProcess.isDestroyed()) {
            r = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$getInputStream$4(), ()V)((StoreItem)this);
            new Thread(r, "Hanging External Process Stopper").start();
        }
        return is;
    }

    public static InputStream wrap(InputStream input, long high, long low) {
        if (input != null && high > low) {
            long bytes = high - (low < 0L ? 0L : low) + 1L;
            LOGGER.trace("Using size-limiting stream (" + bytes + " bytes)");
            return new SizeLimitInputStream(input, bytes);
        }
        return input;
    }

    public String getMimeType() {
        return this.getMimeType(this.getTranscodingSettings());
    }

    private String getMimeType(TranscodingSettings transcodingSettings) {
        if (transcodingSettings != null) {
            return transcodingSettings.getMimeType(this);
        }
        if (this.mediaInfo != null && this.mediaInfo.isMediaParsed()) {
            return this.getPreferredMimeType();
        }
        if (this.getFormat() != null) {
            return this.getFormat().mimeType();
        }
        return HTTPResource.getDefaultMimeType(this.getSpecificType());
    }

    private String getPreferredMimeType() {
        String preferred;
        if (!(this.mediaInfo == null || !this.renderer.isUseMediaInfo() || this.format != null && this.format.isImage() || (preferred = this.renderer.getFormatConfiguration().getMatchedMIMEtype(this, this.renderer)) == null || "MIMETYPE_AUTO".equals(preferred))) {
            LOGGER.trace("File \"{}\" will be sent with MIME type \"{}\"", (Object)this.getName(), (Object)preferred);
            return preferred;
        }
        return this.mediaInfo != null ? this.mediaInfo.getMimeType() : null;
    }

    public String getMediaURL() {
        return this.getMediaURL("");
    }

    public String getMediaURL(String prefix) {
        return this.getMediaURL(prefix, false);
    }

    public String getMediaURL(String prefix, boolean useSystemName) {
        return this.getMediaURL(prefix, useSystemName, true);
    }

    private String getMediaURL(String prefix, boolean useSystemName, boolean urlEncode) {
        StringBuilder sb = MediaServerRequest.getServerMediaURL(this.renderer.getUUID(), this.getResourceId());
        String uri = useSystemName ? this.getSystemName() : this.getName();
        sb.append(prefix);
        sb.append(urlEncode ? StoreItem.encode(uri) : uri);
        return sb.toString();
    }

    private void internalStop() {
        MediaStore mediaStore;
        StoreResource res = this.resumeStop();
        MediaStore mediaStore2 = mediaStore = this.renderer != null ? this.renderer.getMediaStore() : null;
        if (mediaStore != null) {
            res = res == null ? this.clone() : res.clone();
            mediaStore.stopPlaying(res);
        }
    }

    public int resumeHash() {
        return this.resHash;
    }

    public void setResumeHash(int resHash) {
        this.resHash = resHash;
    }

    public ResumeObj getResume() {
        return this.resume;
    }

    public void setResume(ResumeObj r) {
        this.resume = r;
    }

    protected boolean isResumeable() {
        if (this.format != null) {
            return this.format.isVideo();
        }
        return true;
    }

    private StoreResource resumeStop() {
        if (!CONFIGURATION.isResumeEnabled() || !this.isResumeable()) {
            return null;
        }
        this.notifyRefresh();
        if (this.resume != null) {
            this.resume.stop(this.lastStartSystemTime, (long)(this.mediaInfo.getDurationInSeconds() * 1000.0));
            if (this.resume.isDone()) {
                this.getParent().removeChild(this);
            } else if (this.getMediaInfo() != null) {
                this.mediaInfo.setThumbnailId(null);
                this.mediaInfo.setThumbnailSource(ThumbnailSource.UNKNOWN);
            }
        } else {
            for (StoreResource res : this.getParent().getChildren()) {
                StoreItem item;
                if (!(res instanceof StoreItem) || !(item = (StoreItem)res).isResume() || !item.getName().equals(this.getName())) continue;
                item.resume.stop(this.lastStartSystemTime, (long)(this.mediaInfo.getDurationInSeconds() * 1000.0));
                if (item.resume.isDone()) {
                    this.getParent().removeChild(res);
                    return null;
                }
                if (res.getMediaInfo() != null) {
                    res.mediaInfo.setThumbnailId(null);
                    res.mediaInfo.setThumbnailSource(ThumbnailSource.UNKNOWN);
                }
                return res;
            }
            ResumeObj r = ResumeObj.store(this, this.lastStartSystemTime);
            if (r != null) {
                StoreItem clone = this.clone();
                clone.resume = r;
                clone.resHash = this.resHash;
                if (clone.mediaInfo != null) {
                    clone.mediaInfo.setThumbnailId(null);
                    clone.mediaInfo.setThumbnailSource(ThumbnailSource.UNKNOWN);
                }
                clone.transcodingSettings = this.transcodingSettings;
                this.getParent().addChildInternal(clone);
                return clone;
            }
        }
        return null;
    }

    public final boolean isResume() {
        return this.resume != null && this.isResumeable();
    }

    public int minPlayTime() {
        return CONFIGURATION.getMinimumWatchedPlayTime();
    }

    public String resumeStr(String s) {
        if (this.isResume()) {
            return Messages.getString("Resume") + ": " + s;
        }
        return s;
    }

    public String resumeName() {
        return this.resumeStr(this.getDisplayName());
    }

    public String getLocalizedResumeName(String lang) {
        return this.resumeStr(this.getLocalizedDisplayName(lang));
    }

    public String getResolutionForKeepAR(int scaleWidth, int scaleHeight) {
        double videoAspectRatio = (double)scaleWidth / (double)scaleHeight;
        double rendererAspectRatio = 1.777777777777778;
        if (videoAspectRatio > rendererAspectRatio) {
            scaleHeight = (int)Math.round((double)scaleWidth / rendererAspectRatio);
        } else {
            scaleWidth = (int)Math.round((double)scaleHeight * rendererAspectRatio);
        }
        scaleWidth = Engine.convertToModX(scaleWidth, 4);
        scaleHeight = Engine.convertToModX(scaleHeight, 4);
        return scaleWidth + "x" + scaleHeight;
    }

    protected String getDisplayNameEngine() {
        if (this.isNoName() || this.isTranscoded() && !CONFIGURATION.isHideEngineNames()) {
            return "[" + this.getEngineName() + "]";
        }
        return null;
    }

    @Override
    public String getDisplayNameSuffix() {
        if (this.mediaInfo == null) {
            return null;
        }
        MediaType mediaType = this.mediaInfo.getMediaType();
        switch (mediaType) {
            case VIDEO: {
                boolean subsAreValidForStreaming;
                StringBuilder nameSuffixBuilder = new StringBuilder();
                boolean bl = subsAreValidForStreaming = this.mediaSubtitle != null && this.mediaSubtitle.isExternal() && (!this.isTranscoded() || this.renderer.streamSubsForTranscodedVideo()) && this.renderer.isExternalSubtitlesFormatSupported(this.mediaSubtitle, this);
                if (this.mediaAudio != null) {
                    Object audioLanguage = this.mediaAudio.getLang();
                    audioLanguage = audioLanguage == null || "und".equals(((String)audioLanguage).toLowerCase(Locale.ROOT)) ? "" : ((audioLanguage = Iso639.getFirstName((String)audioLanguage)) == null ? "" : "/" + (String)audioLanguage);
                    Object audioTrackTitle = "";
                    if (this.mediaAudio.getTitle() != null && !"".equals(this.mediaAudio.getTitle()) && this.renderer.isShowAudioMetadata()) {
                        audioTrackTitle = " (" + this.mediaAudio.getTitle() + ")";
                    }
                    if (nameSuffixBuilder.length() > 0) {
                        nameSuffixBuilder.append(" ");
                    }
                    nameSuffixBuilder.append("{Audio: ").append(this.mediaAudio.getAudioCodec()).append((String)audioLanguage).append((String)audioTrackTitle).append("}");
                }
                UmsConfiguration.SubtitlesInfoLevel subsInfoLevel = this.getParent() instanceof ChapterFileTranscodeVirtualFolder ? UmsConfiguration.SubtitlesInfoLevel.NONE : (this.isInsideTranscodeFolder() ? UmsConfiguration.SubtitlesInfoLevel.FULL : CONFIGURATION.getSubtitlesInfoLevel());
                if (this.mediaSubtitle != null && this.mediaSubtitle.getId() != Integer.MIN_VALUE && subsInfoLevel != UmsConfiguration.SubtitlesInfoLevel.NONE) {
                    if (nameSuffixBuilder.length() > 0) {
                        nameSuffixBuilder.append(" ");
                    }
                    nameSuffixBuilder.append("{");
                    String subtitleLanguage = this.mediaSubtitle.getLangFullName();
                    if (subsInfoLevel == UmsConfiguration.SubtitlesInfoLevel.BASIC) {
                        if ("Undetermined".equals(subtitleLanguage)) {
                            nameSuffixBuilder.append(Messages.getString("Unknown"));
                        } else {
                            nameSuffixBuilder.append(subtitleLanguage);
                        }
                        nameSuffixBuilder.append(" ").append(Messages.getString("Subtitles_lowercase"));
                    } else if (subsInfoLevel == UmsConfiguration.SubtitlesInfoLevel.FULL) {
                        if (subsAreValidForStreaming) {
                            nameSuffixBuilder.append(Messages.getString("Stream")).append(" ");
                        }
                        if (this.mediaSubtitle.isExternal()) {
                            nameSuffixBuilder.append(Messages.getString("External_abbr")).append(" ");
                        } else if (this.mediaSubtitle.isEmbedded()) {
                            nameSuffixBuilder.append(Messages.getString("Internal_abbr")).append(" ");
                        }
                        nameSuffixBuilder.append(Messages.getString("Sub"));
                        nameSuffixBuilder.append(this.mediaSubtitle.getType().getShortName()).append("/");
                        if ("Undetermined".equals(subtitleLanguage)) {
                            nameSuffixBuilder.append(Messages.getString("Unknown_abbr"));
                        } else {
                            nameSuffixBuilder.append(subtitleLanguage);
                        }
                        if (this.mediaSubtitle.getTitle() != null && StringUtils.isNotBlank(this.mediaSubtitle.getTitle()) && this.renderer.isShowSubMetadata()) {
                            nameSuffixBuilder.append(" (").append(this.mediaSubtitle.getTitle()).append(")");
                        }
                    }
                    nameSuffixBuilder.append("}");
                }
                return nameSuffixBuilder.toString();
            }
        }
        return null;
    }

    protected void checkThumbnail(InputFile inputFile) {
        if (this.mediaInfo != null && !this.mediaInfo.isThumbnailReady() && this.renderer.getUmsConfiguration().isThumbnailGenerationEnabled() && this.renderer.isThumbnails()) {
            DLNAThumbnail thumbnail;
            Double seekPosition = null;
            boolean isResume = this.isResume();
            if (isResume) {
                Double resumePosition = (double)this.resume.getTimeOffset() / 1000.0;
                seekPosition = this.mediaInfo.getDurationInSeconds() > 0.0 && resumePosition < this.mediaInfo.getDurationInSeconds() ? resumePosition : Double.valueOf(this.renderer.getUmsConfiguration().getThumbnailSeekPos());
            }
            if ((thumbnail = Parser.getThumbnail(this.mediaInfo, inputFile, this.getFormat(), this.getType(), seekPosition)) != null) {
                if (!isResume && this.mediaInfo.getFileId() != null) {
                    this.mediaInfo.setThumbnailId(ThumbnailStore.getId(thumbnail, this.mediaInfo.getFileId(), this.mediaInfo.getThumbnailSource()));
                } else {
                    this.mediaInfo.setThumbnailId(ThumbnailStore.getTempId(thumbnail));
                }
            }
        }
    }

    @Override
    protected DLNAThumbnailInputStream getGenericThumbnailInputStreamInternal(String fallback) throws IOException {
        String thumb = fallback;
        if (this.format != null && this.format.getIcon() != null) {
            thumb = this.format.getIcon();
        }
        if (thumb != null && this.isCodeValid(this)) {
            if (new File(thumb).exists()) {
                FileInputStream inputStream = new FileInputStream(thumb);
                return DLNAThumbnailInputStream.toThumbnailInputStream(inputStream);
            }
            InputStream is = this.getResourceInputStream(thumb);
            if (is != null) {
                return DLNAThumbnailInputStream.toThumbnailInputStream(is);
            }
            try {
                return DLNAThumbnailInputStream.toThumbnailInputStream(HTTPResource.downloadAndSend(thumb, true));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getGenericThumbnailInputStreamInternal(fallback);
    }

    public BufferedImageFilterChain addAudioFlagFilter(BufferedImageFilterChain filterChain) {
        String audioLanguageCode;
        String string = audioLanguageCode = this.mediaAudio != null ? this.mediaAudio.getLang() : null;
        if (StringUtils.isNotBlank(audioLanguageCode)) {
            if (filterChain == null) {
                filterChain = new BufferedImageFilterChain();
            }
            filterChain.add(new ImagesUtil.AudioFlagFilter(audioLanguageCode, THUMBNAIL_HINTS));
        }
        return filterChain;
    }

    public BufferedImageFilterChain addSubtitlesFlagFilter(BufferedImageFilterChain filterChain) {
        String subsLanguageCode;
        String string = subsLanguageCode = this.mediaSubtitle != null && this.mediaSubtitle.getId() != Integer.MIN_VALUE ? this.mediaSubtitle.getLang() : null;
        if (StringUtils.isNotBlank(subsLanguageCode)) {
            if (filterChain == null) {
                filterChain = new BufferedImageFilterChain();
            }
            filterChain.add(new ImagesUtil.SubtitlesFlagFilter(subsLanguageCode, THUMBNAIL_HINTS));
        }
        return filterChain;
    }

    @Override
    public BufferedImageFilterChain addFlagFilters(BufferedImageFilterChain filterChain) {
        if (this.isInsideTranscodeFolder() && (this.mediaAudio != null || this.mediaSubtitle != null) && (this.mediaInfo != null && this.mediaInfo.isVideo() || this.mediaInfo == null && this.format != null && this.format.isVideo())) {
            filterChain = this.addAudioFlagFilter(filterChain);
            filterChain = this.addSubtitlesFlagFilter(filterChain);
        }
        return filterChain;
    }

    @Override
    public synchronized void syncResolve() {
        this.resolve();
        if (this.mediaInfo != null && this.mediaInfo.isVideo()) {
            this.registerExternalSubtitles(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExternalSubtitles(boolean forceRefresh) {
        if (this.mediaInfo == null || !this.mediaInfo.isVideo() || this instanceof VirtualVideoAction) {
            return;
        }
        Object object = this.subtitlesLock;
        synchronized (object) {
            List<MediaSubtitle> subtitlesList;
            boolean changed;
            File file;
            if (!forceRefresh && this.isExternalSubtitlesParsed) {
                return;
            }
            File file2 = file = this instanceof RealFile ? ((RealFile)this).getFile() : new File(this.getFileName());
            if (file == null || this.mediaInfo == null || FileUtil.isUrl(this.getFileName())) {
                this.isExternalSubtitlesParsed = true;
                return;
            }
            if (!this.renderer.getUmsConfiguration().isDisableSubtitles() && this.renderer.getUmsConfiguration().isAutoloadExternalSubtitles() && (changed = SubtitleUtils.searchAndAttachExternalSubtitles(file, this.mediaInfo, forceRefresh)) && this.mediaInfo.isMediaParsed() && !this.mediaInfo.isParsing()) {
                Connection connection = null;
                try {
                    connection = MediaDatabase.getConnectionIfAvailable();
                    if (connection != null) {
                        boolean currentAutoCommit = connection.getAutoCommit();
                        if (currentAutoCommit) {
                            connection.setAutoCommit(false);
                        }
                        MediaTableSubtracks.insertOrUpdateSubtitleTracks(connection, this.mediaInfo.getFileId(), this.mediaInfo);
                        if (currentAutoCommit) {
                            connection.commit();
                            connection.setAutoCommit(true);
                        }
                    }
                }
                catch (SQLException e) {
                    LOGGER.error("Database error while trying to add parsed information for \"{}\" to the cache: {}", (Object)file, (Object)e.getMessage());
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("SQL error code: {}", (Object)e.getErrorCode());
                        if (e.getCause() instanceof SQLException && ((SQLException)e.getCause()).getErrorCode() != e.getErrorCode()) {
                            LOGGER.trace("Cause SQL error code: {}", (Object)((SQLException)e.getCause()).getErrorCode());
                        }
                        LOGGER.trace("", e);
                    }
                }
                finally {
                    MediaDatabase.close(connection);
                }
            }
            if ((subtitlesList = this.mediaInfo.getSubtitlesTracks()) != null) {
                this.hasSubtitles = !subtitlesList.isEmpty();
                for (MediaSubtitle subtitles : subtitlesList) {
                    if (!subtitles.isExternal()) continue;
                    this.hasExternalSubtitles = true;
                    break;
                }
            }
            this.isExternalSubtitlesParsed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExternalSubtitlesParsed() {
        if (this.mediaInfo == null || !this.mediaInfo.isVideo()) {
            return;
        }
        Object object = this.subtitlesLock;
        synchronized (object) {
            if (this.isExternalSubtitlesParsed) {
                return;
            }
            List<MediaSubtitle> subtitlesList = this.mediaInfo.getSubtitlesTracks();
            this.hasSubtitles = !subtitlesList.isEmpty();
            for (MediaSubtitle subtitles : subtitlesList) {
                if (!subtitles.isExternal()) continue;
                this.hasExternalSubtitles = true;
                break;
            }
            this.isExternalSubtitlesParsed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSubtitlesStatus() {
        Object object = this.subtitlesLock;
        synchronized (object) {
            this.isExternalSubtitlesParsed = false;
            this.hasExternalSubtitles = false;
            this.hasSubtitles = false;
        }
    }

    public MediaAudio resolveAudioStream() {
        if (this.mediaInfo == null || this.mediaInfo.getAudioTrackCount() == 0) {
            LOGGER.trace("Found no audio track");
            return null;
        }
        MediaAudio dtsTrack = null;
        StringTokenizer st = new StringTokenizer(this.renderer.getUmsConfiguration().getAudioLanguages(), ",");
        while (st.hasMoreTokens()) {
            String lang = st.nextToken().trim();
            LOGGER.trace("Looking for an audio track with language \"{}\" for \"{}\"", (Object)lang, (Object)this.getName());
            for (MediaAudio audio : this.mediaInfo.getAudioTracks()) {
                if (audio.matchCode(lang)) {
                    LOGGER.trace("Matched audio track: {}", (Object)audio);
                    return audio;
                }
                if (dtsTrack != null || !audio.isDTS()) continue;
                dtsTrack = audio;
            }
        }
        if (dtsTrack != null) {
            LOGGER.trace("Preferring DTS audio track since no language match was found: {}", (Object)dtsTrack);
            return dtsTrack;
        }
        MediaAudio result = this.mediaInfo.getDefaultAudioTrack();
        LOGGER.trace("Using the first available audio track: {}", (Object)result);
        return result;
    }

    public MediaSubtitle resolveSubtitlesStream(String audioLanguage, boolean forceRefresh) {
        String forcedTags;
        int anyLanguage;
        MediaSubtitle matchedSub;
        if (this.mediaInfo == null) {
            return null;
        }
        if (this.renderer.getUmsConfiguration().isDisableSubtitles()) {
            LOGGER.trace("Not resolving subtitles since subtitles are disabled");
            return null;
        }
        if (!this.hasSubtitles(forceRefresh)) {
            return null;
        }
        boolean useExternal = this.renderer.getUmsConfiguration().isAutoloadExternalSubtitles();
        boolean forceExternal = this.renderer.getUmsConfiguration().isForceExternalSubtitles();
        String audioSubLanguages = this.renderer.getUmsConfiguration().getAudioSubLanguages();
        if (forceExternal) {
            matchedSub = this.getHighestPriorityExternalSubtitles();
            if (matchedSub == null) {
                LOGGER.trace("No external subtitles candidates were found to force for \"{}\"", (Object)this.getName());
            } else {
                LOGGER.trace("Forcing external subtitles track for \"{}\": {}", (Object)this.getName(), (Object)matchedSub);
                return matchedSub;
            }
        }
        if (StringUtils.isBlank(audioLanguage) || StringUtils.isBlank(audioSubLanguages)) {
            LOGGER.trace("Searching for subtitles without considering audio language for \"{}\"", (Object)this.getName());
            ArrayList<MediaSubtitle> candidates = new ArrayList<MediaSubtitle>();
            for (MediaSubtitle subtitles : this.mediaInfo.getSubtitlesTracks()) {
                if (subtitles.isExternal()) {
                    if (!useExternal) continue;
                    candidates.add(subtitles);
                    continue;
                }
                candidates.add(subtitles);
            }
            if (!candidates.isEmpty() && (matchedSub = SubtitleUtils.findPrioritizedSubtitles(candidates, this.renderer, false)) != null) {
                LOGGER.trace("Matched {} subtitles track for \"{}\" with unknown audio language: {}", matchedSub.isExternal() ? "external" : "internal", this.getName(), matchedSub);
                return matchedSub;
            }
        } else {
            StringTokenizer st = new StringTokenizer(audioSubLanguages.toLowerCase(Locale.ROOT), ";");
            while (st.hasMoreTokens()) {
                String pair = st.nextToken();
                int commaPos = pair.indexOf(44);
                if (commaPos > -1) {
                    String[] audio = pair.substring(0, commaPos).trim();
                    String sub = pair.substring(commaPos + 1).trim();
                    LOGGER.trace("Searching for a match for audio language \"{}\" with audio \"{}\" and subtitles \"{}\" for \"{}\"", audioLanguage, audio, sub, this.getName());
                    if (!"*".equals(audio) && !"und".equals(audio) && !Iso639.isCodesMatching((String)audio, audioLanguage)) continue;
                    int n = anyLanguage = "*".equals(sub) || "und".equals(sub) ? 1 : 0;
                    if ("off".equals(sub)) {
                        LOGGER.trace("Not looking for non-forced subtitles since they are \"off\" for audio language \"{}\"", (Object)audio);
                        break;
                    }
                    ArrayList<MediaSubtitle> candidates = new ArrayList<MediaSubtitle>();
                    for (MediaSubtitle subtitles : this.mediaInfo.getSubtitlesTracks()) {
                        if (anyLanguage == 0 && !subtitles.matchCode(sub)) continue;
                        if (subtitles.isEmbedded()) {
                            candidates.add(subtitles);
                            LOGGER.trace("Adding internal subtitles candidate: {}", (Object)subtitles);
                            continue;
                        }
                        if (useExternal) {
                            candidates.add(subtitles);
                            LOGGER.trace("Adding external subtitles candidate: {}", (Object)subtitles);
                            continue;
                        }
                        LOGGER.trace("Ignoring external subtitles because auto loading of external subtitles is disabled: {}", (Object)subtitles);
                    }
                    if (candidates.isEmpty() || (matchedSub = SubtitleUtils.findPrioritizedSubtitles(candidates, this.renderer, anyLanguage == 0)) == null) continue;
                    LOGGER.trace("Matched {} subtitles track for \"{}\": {}", matchedSub.isExternal() ? "external" : "internal", this.getName(), matchedSub);
                    return matchedSub;
                }
                LOGGER.warn("Ignoring invalid audio/subtitle language configuration \"{}\"", (Object)pair);
            }
        }
        if (StringUtils.isNotBlank(forcedTags = this.renderer.getUmsConfiguration().getForcedSubtitleTags())) {
            Locale locale = PMS.getLocale();
            ArrayList<String> forcedTagsList = new ArrayList<String>();
            for (String forcedTag : forcedTags.split(",")) {
                if (!StringUtils.isNotBlank(forcedTag)) continue;
                forcedTagsList.add(forcedTag.trim().toLowerCase(locale));
            }
            ArrayList<MediaSubtitle> candidates = new ArrayList<MediaSubtitle>();
            String forcedLanguage = this.renderer.getUmsConfiguration().getForcedSubtitleLanguage();
            anyLanguage = StringUtils.isBlank(forcedLanguage) || "*".equals(forcedLanguage) || "und".equals(forcedLanguage) ? 1 : 0;
            for (MediaSubtitle subtitles : this.mediaInfo.getSubtitlesTracks()) {
                if (!useExternal && subtitles.isExternal() || anyLanguage == 0 && !Iso639.isCodesMatching(subtitles.getLang(), forcedLanguage)) continue;
                if (subtitles.isForced()) {
                    candidates.add(subtitles);
                    LOGGER.trace("Adding {} forced subtitles candidate that is flagged \"forced\": {}", (Object)(subtitles.isExternal() ? "external" : "internal"), (Object)subtitles);
                    continue;
                }
                String title = subtitles.getTitle();
                if (!StringUtils.isNotBlank(title)) continue;
                title = title.toLowerCase(locale);
                for (String forcedTag : forcedTagsList) {
                    if (!title.contains(forcedTag)) continue;
                    candidates.add(subtitles);
                    LOGGER.trace("Adding {} forced subtitles candidate that matched tag \"{}\": {}", subtitles.isExternal() ? "external" : "internal", forcedTag, subtitles);
                }
            }
            if (!candidates.isEmpty() && (matchedSub = SubtitleUtils.findPrioritizedSubtitles(candidates, this.renderer, false)) != null) {
                LOGGER.trace("Using forced {} subtitles track for \"{}\": {}", matchedSub.isExternal() ? "external" : "internal", this.getName(), matchedSub);
                return matchedSub;
            }
        }
        LOGGER.trace("Found no matching subtitle for \"{}\"", (Object)this.getName());
        return null;
    }

    private MediaSubtitle getHighestPriorityExternalSubtitles() {
        MediaSubtitle matchedSub = null;
        ArrayList<MediaSubtitle> candidates = new ArrayList<MediaSubtitle>();
        for (MediaSubtitle subtitles : this.mediaInfo.getSubtitlesTracks()) {
            if (!subtitles.isExternal()) continue;
            candidates.add(subtitles);
        }
        if (!candidates.isEmpty()) {
            matchedSub = SubtitleUtils.findPrioritizedSubtitles(candidates, this.renderer, true);
        }
        return matchedSub;
    }

    @Override
    public StoreItem clone() {
        return (StoreItem)super.clone();
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" [id=").append(this.getId());
        result.append(", name=").append(this.getName());
        result.append(", full path=");
        result.append(this.getResourceId());
        result.append(", format=").append(this.getFormat());
        if (this.getMediaAudio() != null) {
            result.append(", selected audio=[").append(this.getMediaAudio()).append("]");
        }
        if (this.getMediaSubtitle() != null) {
            result.append(", selected subtitles=[").append(this.getMediaSubtitle()).append("]");
        }
        result.append(", transcoding engine=[").append(this.getEngineName()).append("]");
        result.append(']');
        return result.toString();
    }

    private /* synthetic */ void lambda$getInputStream$4() {
        LOGGER.error("External input stream instance is null... stopping process");
        this.externalProcess.stopProcess();
    }

    private /* synthetic */ void lambda$getInputStream$3() {
        this.externalProcess.stopProcess();
    }
}

