/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store;

import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTableFailedLookups;
import net.pms.database.MediaTableFiles;
import net.pms.database.MediaTableTVSeries;
import net.pms.database.MediaTableVideoMetadata;
import net.pms.external.tmdb.TMDB;
import net.pms.formats.Format;
import net.pms.media.MediaInfo;
import net.pms.media.video.metadata.MediaVideoMetadata;
import net.pms.media.video.metadata.TvSeriesMetadata;
import net.pms.parsers.FFmpegParser;
import net.pms.parsers.Parser;
import net.pms.parsers.WebStreamParser;
import net.pms.store.MediaStatusStore;
import net.pms.util.FileNameMetadata;
import net.pms.util.FileUtil;
import net.pms.util.InputFile;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaInfoStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaInfoStore.class);
    private static final Map<String, WeakReference<MediaInfo>> STORE = new HashMap<String, WeakReference<MediaInfo>>();
    private static final Map<Long, WeakReference<TvSeriesMetadata>> TV_SERIES_STORE = new HashMap<Long, WeakReference<TvSeriesMetadata>>();
    private static final Map<String, Object> LOCKS = new HashMap<String, Object>();

    private MediaInfoStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getLock(String filename) {
        Map<String, Object> map = LOCKS;
        synchronized (map) {
            if (LOCKS.containsKey(filename)) {
                return LOCKS.get(filename);
            }
            Object lock = new Object();
            LOCKS.put(filename, lock);
            return lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MediaInfo getMediaInfoStored(String filename) {
        Map<String, WeakReference<MediaInfo>> map = STORE;
        synchronized (map) {
            if (STORE.containsKey(filename) && STORE.get(filename).get() != null) {
                return (MediaInfo)STORE.get(filename).get();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeMediaInfo(String filename, MediaInfo mediaInfo) {
        Map<String, WeakReference<MediaInfo>> map = STORE;
        synchronized (map) {
            STORE.put(filename, new WeakReference<MediaInfo>(mediaInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaInfo getMediaInfo(String filename) {
        Object lock;
        Object object = lock = MediaInfoStore.getLock(filename);
        synchronized (object) {
            MediaInfo mediaInfo = MediaInfoStore.getMediaInfoStored(filename);
            if (mediaInfo != null) {
                return mediaInfo;
            }
            Connection connection = null;
            try {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection != null) {
                    File file = new File(filename);
                    mediaInfo = MediaTableFiles.getMediaInfo(connection, filename, file.lastModified());
                    if (mediaInfo != null && mediaInfo.isMediaParsed() && mediaInfo.getMimeType() != null) {
                        MediaInfoStore.storeMediaInfo(filename, mediaInfo);
                    }
                    MediaInfo mediaInfo2 = mediaInfo;
                    return mediaInfo2;
                }
            }
            catch (IOException | SQLException e) {
                LOGGER.debug("Error while getting cached information about {}: {}", (Object)filename, (Object)e.getMessage());
                LOGGER.trace("", e);
            }
            finally {
                MediaDatabase.close(connection);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaInfo getMediaInfo(String filename, File file, Format format, int type) {
        Object lock;
        Object object = lock = MediaInfoStore.getLock(filename);
        synchronized (object) {
            MediaInfo mediaInfo = MediaInfoStore.getMediaInfoStored(filename);
            if (mediaInfo != null) {
                return mediaInfo;
            }
            LOGGER.trace("Store does not yet contain MediaInfo for {}", (Object)filename);
            Connection connection = null;
            InputFile input = new InputFile();
            input.setFile(file);
            try {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection != null) {
                    connection.setAutoCommit(false);
                    try {
                        mediaInfo = MediaTableFiles.getMediaInfo(connection, filename, file.lastModified());
                        if (mediaInfo != null) {
                            if (!mediaInfo.isMediaParsed()) {
                                Parser.parse(mediaInfo, input, format, type);
                                MediaTableFiles.insertOrUpdateData(connection, filename, file.lastModified(), type, mediaInfo);
                            }
                            if (mediaInfo.getMimeType() == null) {
                                Parser.postParse(mediaInfo, type);
                                MediaTableFiles.insertOrUpdateData(connection, filename, file.lastModified(), type, mediaInfo);
                            }
                        }
                    }
                    catch (IOException | SQLException e) {
                        LOGGER.debug("Error while getting cached information about {}, reparsing information: {}", (Object)filename, (Object)e.getMessage());
                        LOGGER.trace("", e);
                    }
                }
                if (mediaInfo == null) {
                    mediaInfo = new MediaInfo();
                    if (format != null) {
                        Parser.parse(mediaInfo, input, format, type);
                    } else {
                        FFmpegParser.parse(mediaInfo, input, format, type);
                    }
                    mediaInfo.waitMediaParsing(5);
                    if (connection != null && mediaInfo.isMediaParsed()) {
                        try {
                            MediaTableFiles.insertOrUpdateData(connection, filename, file.lastModified(), type, mediaInfo);
                        }
                        catch (SQLException e) {
                            LOGGER.error("Database error while trying to add parsed information for \"{}\" to the cache: {}", (Object)filename, (Object)e.getMessage());
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace("SQL error code: {}", (Object)e.getErrorCode());
                                if (e.getCause() instanceof SQLException && ((SQLException)e.getCause()).getErrorCode() != e.getErrorCode()) {
                                    LOGGER.trace("Cause SQL error code: {}", (Object)((SQLException)e.getCause()).getErrorCode());
                                }
                                LOGGER.trace("", e);
                            }
                        }
                    }
                }
            }
            catch (SQLException e) {
                LOGGER.error("Error in RealFile.resolve: {}", (Object)e.getMessage());
                LOGGER.trace("", e);
            }
            finally {
                try {
                    if (connection != null) {
                        connection.commit();
                        connection.setAutoCommit(true);
                    }
                }
                catch (SQLException e) {
                    LOGGER.error("Error in commit in RealFile.resolve: {}", (Object)e.getMessage());
                    LOGGER.trace("", e);
                }
                MediaDatabase.close(connection);
            }
            if (mediaInfo != null) {
                MediaInfoStore.storeMediaInfo(filename, mediaInfo);
            }
            return mediaInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaInfo getWebStreamMediaInfo(String url, int type) {
        Object lock;
        Object object = lock = MediaInfoStore.getLock(url);
        synchronized (object) {
            MediaInfo mediaInfo = MediaInfoStore.getMediaInfoStored(url);
            if (mediaInfo != null) {
                return mediaInfo;
            }
            LOGGER.trace("Store does not yet contain MediaInfo for {}", (Object)url);
            try (Connection connection = MediaDatabase.getConnectionIfAvailable();){
                mediaInfo = MediaTableFiles.getMediaInfo(connection, url, 0L);
                if (mediaInfo == null) {
                    mediaInfo = new MediaInfo();
                }
                if (!mediaInfo.isMediaParsed()) {
                    WebStreamParser.parse(mediaInfo, url, type);
                    MediaTableFiles.insertOrUpdateData(connection, url, 0L, type, mediaInfo);
                }
            }
            catch (Exception e) {
                LOGGER.error("Database error while trying to add parsed information for \"{}\" to the cache: {}", (Object)url, (Object)e.getMessage());
            }
            if (mediaInfo != null) {
                MediaInfoStore.storeMediaInfo(url, mediaInfo);
            }
            return mediaInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaVideoMetadata getMediaVideoMetadata(String filename) {
        MediaInfo mediaInfo = MediaInfoStore.getMediaInfoStored(filename);
        if (mediaInfo != null) {
            return mediaInfo.getVideoMetadata();
        }
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            if (connection != null) {
                MediaVideoMetadata mediaVideoMetadata = MediaTableVideoMetadata.getVideoMetadataByFilename(connection, filename);
                return mediaVideoMetadata;
            }
        }
        finally {
            MediaDatabase.close(connection);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TvSeriesMetadata getTvSeriesMetadataStored(Long tvSeriesId) {
        Map<Long, WeakReference<TvSeriesMetadata>> map = TV_SERIES_STORE;
        synchronized (map) {
            if (TV_SERIES_STORE.containsKey(tvSeriesId) && TV_SERIES_STORE.get(tvSeriesId).get() != null) {
                return (TvSeriesMetadata)TV_SERIES_STORE.get(tvSeriesId).get();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeTvSeriesMetadata(Long tvSeriesId, TvSeriesMetadata tvSeriesMetadata) {
        Map<Long, WeakReference<TvSeriesMetadata>> map = TV_SERIES_STORE;
        synchronized (map) {
            TV_SERIES_STORE.put(tvSeriesId, new WeakReference<TvSeriesMetadata>(tvSeriesMetadata));
        }
    }

    public static TvSeriesMetadata getTvSeriesMetadata(Long tvSeriesId) {
        TvSeriesMetadata tvSeriesMetadata = MediaInfoStore.getTvSeriesMetadataStored(tvSeriesId);
        if (tvSeriesMetadata != null || !MediaDatabase.isAvailable()) {
            return tvSeriesMetadata;
        }
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            if (connection != null) {
                tvSeriesMetadata = MediaTableTVSeries.getTvSeriesMetadata(connection, tvSeriesId);
            }
        }
        finally {
            MediaDatabase.close(connection);
        }
        if (tvSeriesMetadata != null) {
            MediaInfoStore.storeTvSeriesMetadata(tvSeriesId, tvSeriesMetadata);
        }
        return tvSeriesMetadata;
    }

    public static void updateTvSeriesMetadata(TvSeriesMetadata tvSeriesMetadata, Long tvSeriesId) {
        if (tvSeriesId == null || tvSeriesId < 0L) {
            return;
        }
        if (tvSeriesMetadata == null) {
            LOGGER.warn("Couldn't update Tv Series Metadata for \"{}\" because there is no media information", (Object)tvSeriesId);
            return;
        }
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            if (connection != null) {
                MediaTableTVSeries.updateAPIMetadata(connection, tvSeriesMetadata, tvSeriesId);
            }
        }
        finally {
            MediaDatabase.close(connection);
        }
        TvSeriesMetadata storedTvSeriesMetadata = MediaInfoStore.getTvSeriesMetadataStored(tvSeriesId);
        if (storedTvSeriesMetadata != null) {
            storedTvSeriesMetadata.update(tvSeriesMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTvEpisodesTvSeriesId(Long oldTvSeriesId, Long tvSeriesId) {
        block7: {
            if (oldTvSeriesId == null || tvSeriesId == null) {
                return;
            }
            Connection connection = null;
            try {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection == null) break block7;
                TvSeriesMetadata tvSeriesMetadata = MediaInfoStore.getTvSeriesMetadata(tvSeriesId);
                List<String> filenames = MediaTableVideoMetadata.getTvEpisodesFilesByTvSeriesId(connection, oldTvSeriesId);
                for (String filename : filenames) {
                    MediaTableFailedLookups.remove(connection, filename, false);
                    MediaInfo mediaInfo = MediaInfoStore.getMediaInfo(filename);
                    if (mediaInfo == null || !mediaInfo.hasVideoMetadata()) continue;
                    mediaInfo.getVideoMetadata().setSeriesMetadata(tvSeriesMetadata);
                    if ((tvSeriesMetadata == null || tvSeriesMetadata.getTmdbId() == null || tvSeriesMetadata.getTmdbId().equals(mediaInfo.getVideoMetadata().getTmdbTvId())) && tvSeriesId.equals(mediaInfo.getVideoMetadata().getTvSeriesId())) continue;
                    mediaInfo.getVideoMetadata().setTvSeriesId(tvSeriesId);
                    mediaInfo.getVideoMetadata().setTmdbId(null);
                    mediaInfo.getVideoMetadata().setIMDbID(null);
                    try {
                        MediaTableVideoMetadata.insertOrUpdateVideoMetadata(connection, mediaInfo.getFileId(), mediaInfo, true);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    File file = new File(filename);
                    mediaInfo.setLastExternalLookup(0L);
                    MediaTableFailedLookups.remove(connection, file.getAbsolutePath(), true);
                    TMDB.backgroundLookupAndAddMetadata(file, mediaInfo);
                }
                MediaTableTVSeries.cleanup(connection);
            }
            finally {
                MediaDatabase.close(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMetadataFromFileName(File file, MediaInfo mediaInfo) {
        block21: {
            String absolutePath = file.getAbsolutePath();
            if (absolutePath == null || Platform.isMac() && absolutePath.contains("Photos Library.photoslibrary")) {
                return;
            }
            try {
                if (!mediaInfo.isVideo() || mediaInfo.hasVideoMetadata()) break block21;
                MediaVideoMetadata videoMetadata = new MediaVideoMetadata();
                FileNameMetadata metadataFromFilename = FileUtil.getFileNameMetadata(file.getName(), absolutePath);
                String titleFromFilename = metadataFromFilename.getMovieOrShowName();
                if (StringUtils.isNotBlank(titleFromFilename) && metadataFromFilename.isTvEpisode()) {
                    TvSeriesMetadata tvSeriesMetadata = new TvSeriesMetadata();
                    tvSeriesMetadata.setTitle(titleFromFilename);
                    tvSeriesMetadata.setStartYear(metadataFromFilename.getYear());
                    videoMetadata.setTvSeason(metadataFromFilename.getTvSeasonNumber());
                    videoMetadata.setTvEpisodeNumber(metadataFromFilename.getTvEpisodeNumber());
                    if (StringUtils.isNotBlank(metadataFromFilename.getTvEpisodeName())) {
                        videoMetadata.setTitle(metadataFromFilename.getTvEpisodeName());
                    }
                    videoMetadata.setSeriesMetadata(tvSeriesMetadata);
                    videoMetadata.setIsTvEpisode(true);
                } else {
                    videoMetadata.setTitle(titleFromFilename);
                    videoMetadata.setYear(metadataFromFilename.getYear());
                }
                if (metadataFromFilename.getExtraInformation() != null) {
                    videoMetadata.setExtraInformation(metadataFromFilename.getExtraInformation());
                }
                mediaInfo.setVideoMetadata(videoMetadata);
                if (!MediaDatabase.isAvailable()) break block21;
                try (Connection connection = MediaDatabase.getConnectionIfAvailable();){
                    if (connection != null) {
                        if (videoMetadata.isTvEpisode() && videoMetadata.getTvSeriesId() == null) {
                            Integer tvSeriesYear;
                            String tvSeriesTitle = videoMetadata.getSeriesMetadata().getTitle();
                            Long tvSeriesId = MediaTableTVSeries.getIdBySimilarTitle(connection, tvSeriesTitle, tvSeriesYear = videoMetadata.getSeriesMetadata().getStartYear());
                            if (tvSeriesId == null) {
                                tvSeriesId = MediaTableTVSeries.set(connection, tvSeriesTitle, tvSeriesYear);
                            }
                            TvSeriesMetadata tvSeriesMetadata = MediaInfoStore.getTvSeriesMetadata(tvSeriesId);
                            videoMetadata.setSeriesMetadata(tvSeriesMetadata);
                            videoMetadata.setTvSeriesId(tvSeriesId);
                        }
                        MediaTableVideoMetadata.insertVideoMetadata(connection, absolutePath, file.lastModified(), mediaInfo);
                    }
                }
            }
            catch (SQLException e) {
                LOGGER.error("Could not update the database with information from the filename for \"{}\": {}", (Object)file.getAbsolutePath(), (Object)e.getMessage());
                LOGGER.trace("", e);
            }
            catch (Exception e) {
                LOGGER.debug("", e);
            }
            finally {
                TMDB.backgroundLookupAndAddMetadata(file, mediaInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeMediaEntriesInFolder(String pathToFolder) {
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            if (connection != null) {
                MediaTableFiles.removeMediaEntriesInFolder(connection, pathToFolder);
            }
        }
        finally {
            MediaDatabase.close(connection);
        }
        boolean removed = false;
        Map<String, WeakReference<MediaInfo>> map = STORE;
        synchronized (map) {
            Iterator<String> filenames = STORE.keySet().iterator();
            while (filenames.hasNext()) {
                if (!filenames.next().startsWith(pathToFolder)) continue;
                filenames.remove();
                removed = true;
            }
        }
        removed = MediaStatusStore.removeMediaEntriesInFolder(pathToFolder) || removed;
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeMediaEntry(String filename) {
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            if (connection != null) {
                MediaTableFiles.removeMediaEntry(connection, filename, true);
            }
        }
        finally {
            MediaDatabase.close(connection);
        }
        boolean removed = false;
        Map<String, WeakReference<MediaInfo>> map = STORE;
        synchronized (map) {
            if (STORE.remove(filename) != null) {
                removed = true;
            }
        }
        removed = MediaStatusStore.removeMediaEntry(filename) || removed;
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<String, WeakReference<MediaInfo>> map = STORE;
        synchronized (map) {
            STORE.clear();
        }
    }
}

