/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.pms.PMS;
import net.pms.store.SearchObj;
import net.pms.store.StoreContainer;
import net.pms.store.StoreResource;
import net.pms.store.SystemFileResource;
import net.pms.store.item.RealFile;

public class FileSearch
implements SearchObj {
    private List<StoreResource> folders;

    public FileSearch(List<StoreResource> folders) {
        this.folders = new ArrayList<StoreResource>(folders);
    }

    public void update(List<StoreResource> folders) {
        this.folders = new ArrayList<StoreResource>(folders);
    }

    @Override
    public void search(String searchString, StoreContainer searcher) {
        searchString = searchString.toLowerCase();
        for (StoreResource res : this.folders) {
            if (!(res instanceof SystemFileResource)) continue;
            SystemFileResource systemFileResource = (SystemFileResource)((Object)res);
            String name = res.getName().toLowerCase();
            if (name.contains(searchString)) {
                searcher.addChild(res.clone());
                continue;
            }
            if (!systemFileResource.getSystemFile().isDirectory()) continue;
            File f = systemFileResource.getSystemFile();
            this.searchFiles(f.listFiles(), searchString, searcher, 0);
        }
    }

    private void searchFiles(File[] files, String str, StoreContainer searcher, int cnt) {
        if (files == null) {
            return;
        }
        for (File f : files) {
            String name = f.getName().toLowerCase();
            if (name.contains(str)) {
                searcher.addChild(new RealFile(searcher.getDefaultRenderer(), f));
                continue;
            }
            if (!f.isDirectory()) continue;
            if (cnt >= PMS.getConfiguration().getSearchDepth()) {
                return;
            }
            this.searchFiles(f.listFiles(), str, searcher, cnt + 1);
        }
    }
}

