/*
 * Decompiled with CFR 0.152.
 */
package net.pms.service.process;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import net.pms.service.process.ProcessState;
import net.pms.util.ProcessUtil;

@NotThreadSafe
public class ProcessInfo {
    protected final Process process;
    protected final String processName;
    protected final long pid;
    protected long terminateTimeoutMS;
    protected ProcessState state = ProcessState.RUNNING;

    public ProcessInfo(@Nonnull Process process, @Nonnull String processName, long terminateTimeoutMS) {
        if (process == null) {
            throw new IllegalArgumentException("process cannot be null");
        }
        if (processName == null) {
            throw new IllegalArgumentException("processName cannot be null");
        }
        this.process = process;
        this.processName = processName;
        this.pid = ProcessUtil.getProcessId(process);
        if (this.pid == 0L) {
            throw new IllegalStateException("Unable to retrieve process id");
        }
        this.terminateTimeoutMS = terminateTimeoutMS;
    }

    public Process getProcess() {
        return this.process;
    }

    public String getName() {
        return this.processName;
    }

    public long getPID() {
        return this.pid;
    }

    public long getTerminateTimeoutMS() {
        return this.terminateTimeoutMS;
    }

    public void setTerminateTimeoutMS(long terminateTimeoutMS) {
        this.terminateTimeoutMS = terminateTimeoutMS;
    }

    public ProcessState getState() {
        return this.state;
    }

    public void setState(ProcessState state) {
        this.state = state;
    }

    public String toString() {
        return "ProcessInfo [Name=" + this.processName + ", PID=" + this.pid + ", State=" + this.state + "]";
    }
}

