/*
 * Decompiled with CFR 0.152.
 */
package net.pms.service.process;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.pms.service.process.ProcessInfo;
import net.pms.service.process.ProcessManager;
import net.pms.service.process.ProcessState;
import net.pms.service.process.ProcessTicket;
import net.pms.util.ProcessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcessTerminator
extends Thread {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractProcessTerminator.class);
    protected final TreeMap<Long, ProcessInfo> processes = new TreeMap();
    protected final ProcessManager owner;

    protected AbstractProcessTerminator(@Nonnull ProcessManager owner) {
        super("Process Terminator");
        if (owner == null) {
            throw new IllegalArgumentException("owner cannot be null");
        }
        this.owner = owner;
        this.setDaemon(true);
    }

    protected void gobbleStream(InputStream is) {
        if (is == null) {
            return;
        }
        byte[] gobbler = new byte[1024];
        try {
            while (is.read(gobbler) != -1) {
            }
        }
        catch (IOException e) {
            LOGGER.error("Gobbling of {} failed with: {}", (Object)is.getClass(), (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    protected abstract void stopPlatformProcess(@Nullable ProcessInfo var1) throws InterruptedException;

    protected void stopProcess(@Nullable ProcessInfo processInfo) throws InterruptedException {
        if (processInfo == null) {
            return;
        }
        if (ProcessUtil.isProcessIsAlive(processInfo.getProcess())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Trying to terminate process \"{}\" ({}) since its allowed run time has expired", (Object)processInfo.getName(), (Object)processInfo.getPID());
            }
            this.stopPlatformProcess(processInfo);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Successfully terminated process \"{}\" ({})", (Object)processInfo.getName(), (Object)processInfo.getPID());
            }
            this.destroyProcess(processInfo.process);
        }
    }

    protected static void closeSilently(AutoCloseable autoCloseable) {
        if (autoCloseable != null) {
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void destroyProcess(@Nullable Process process) {
        if (process == null) {
            return;
        }
        AbstractProcessTerminator.closeSilently(process.getInputStream());
        AbstractProcessTerminator.closeSilently(process.getErrorStream());
        AbstractProcessTerminator.closeSilently(process.getOutputStream());
        process.destroy();
    }

    protected Long getSchedule(long delayMS) {
        Long schedule = System.nanoTime() + delayMS * 1000000L;
        while (this.processes.get(schedule) != null) {
            Long l = schedule;
            schedule = schedule + 1L;
        }
        return schedule;
    }

    @Override
    public void run() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ProcessTerminator is starting");
        }
        try {
            this.work(false);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            this.owner.clearWorker(this);
            LOGGER.debug("Shutting down ProcessTerminator");
            try {
                this.work(true);
            }
            catch (InterruptedException e1) {
                LOGGER.debug("ProcessTerminator interrupted while shutting down, terminating without terminating managed processes");
            }
            catch (Throwable e1) {
                LOGGER.error("Unexpected error in ProcessTerminator while shutting down, terminating without terminating managed processes", (Object)e.getClass().getSimpleName());
            }
        }
        catch (Throwable e) {
            this.owner.clearWorker(this);
            LOGGER.error("Unexpected error in ProcessTerminator, shutting down managed processes: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
            try {
                this.work(true);
            }
            catch (InterruptedException e1) {
                LOGGER.debug("ProcessTerminator interrupted while shutting down, terminating without terminating managed processes");
            }
            catch (Throwable e1) {
                LOGGER.error("Unexpected error in ProcessTerminator while trying to shut down from a previous {}, terminating without terminating managed processes", (Object)e.getClass().getSimpleName());
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ProcessTerminator has stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void work(boolean shutdown) throws InterruptedException {
        if (shutdown) {
            ArrayList<ProcessInfo> reschedule = new ArrayList<ProcessInfo>();
            Iterator<Map.Entry<Long, ProcessInfo>> iterator = this.processes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, ProcessInfo> entry = iterator.next();
                if (entry.getValue().getState() != ProcessState.RUNNING) continue;
                reschedule.add((ProcessInfo)entry.getValue());
                iterator.remove();
            }
            int delay = 0;
            for (ProcessInfo processInfo : reschedule) {
                if (processInfo.getTerminateTimeoutMS() > 500L) {
                    processInfo.setTerminateTimeoutMS(500L);
                }
                this.processes.put(this.getSchedule(delay++), processInfo);
            }
            if (LOGGER.isTraceEnabled() && !reschedule.isEmpty()) {
                LOGGER.trace("ProcessTerminator rescheduled {} process{} for immediate shutdown", (Object)reschedule.size(), (Object)(reschedule.size() > 1 ? "es" : ""));
            }
        }
        while (true) {
            if (!shutdown) {
                ProcessTicket currentTicket;
                block17: do {
                    LinkedList<ProcessTicket> delay = this.owner.incoming;
                    synchronized (delay) {
                        currentTicket = this.owner.incoming.poll();
                    }
                    if (currentTicket == null || currentTicket.getAction() == null) continue;
                    switch (currentTicket.getAction()) {
                        case ADD: {
                            this.processes.put(this.getSchedule(currentTicket.getTimeoutMS()), new ProcessInfo(currentTicket.getProcess(), currentTicket.getName(), currentTicket.getTerminateTimeoutMS()));
                            if (!LOGGER.isTraceEnabled()) continue block17;
                            LOGGER.trace("ProcessTerminator scheduled shutdown of process \"{}\" in {} milliseconds", (Object)currentTicket.getName(), (Object)currentTicket.getTimeoutMS());
                            break;
                        }
                        case REMOVE: {
                            Map.Entry<Long, ProcessInfo> entry;
                            ProcessInfo remove = null;
                            Iterator<Map.Entry<Long, ProcessInfo>> iterator = this.processes.entrySet().iterator();
                            while (iterator.hasNext()) {
                                entry = iterator.next();
                                if (entry.getValue().getProcess() != currentTicket.getProcess()) continue;
                                remove = entry.getValue();
                                iterator.remove();
                            }
                            if (!LOGGER.isDebugEnabled()) continue block17;
                            if (remove == null) {
                                LOGGER.debug("Couldn't find {} process to remove from process management", (Object)currentTicket.getName());
                                break;
                            }
                            if (!LOGGER.isTraceEnabled()) continue block17;
                            LOGGER.trace("ProcessTerminator unscheduled process \"{}\" ({})", (Object)remove.getName(), (Object)remove.getPID());
                            break;
                        }
                        case SHUTDOWN: {
                            Map.Entry<Long, ProcessInfo> entry;
                            ProcessInfo reschedule = null;
                            Iterator<Map.Entry<Long, ProcessInfo>> iterator = this.processes.entrySet().iterator();
                            while (iterator.hasNext()) {
                                entry = iterator.next();
                                if (entry.getValue().getProcess() != currentTicket.getProcess()) continue;
                                reschedule = entry.getValue();
                                iterator.remove();
                            }
                            if (reschedule != null) {
                                if (currentTicket.getTerminateTimeoutMS() > 0L) {
                                    reschedule.setTerminateTimeoutMS(Math.max(100L, currentTicket.getTerminateTimeoutMS()));
                                }
                                this.processes.put(this.getSchedule(0L), reschedule);
                                if (!LOGGER.isTraceEnabled()) continue block17;
                                LOGGER.trace("ProcessTerminator rescheduled process \"{}\" ({}) for immediate shutdown", (Object)reschedule.getName(), (Object)reschedule.getPID());
                                break;
                            }
                            if (!LOGGER.isDebugEnabled()) continue block17;
                            LOGGER.debug("ProcessTerminator: No matching {} process found to reschedule for immediate shutdown");
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)"Unimplemented ProcessTicketAction");
                        }
                    }
                } while (currentTicket != null);
            }
            while (!this.processes.isEmpty() && this.processes.firstKey() <= System.nanoTime()) {
                ProcessInfo processInfo = this.processes.remove(this.processes.firstKey());
                this.stopProcess(processInfo);
            }
            if (this.processes.isEmpty()) {
                if (shutdown) break;
                LinkedList<ProcessTicket> processInfo = this.owner.incoming;
                synchronized (processInfo) {
                    if (this.owner.incoming.isEmpty()) {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("ProcessTerminator is waiting for new tickets");
                        }
                        this.owner.incoming.wait();
                    }
                }
            }
            long waitTime = this.processes.firstKey() - System.nanoTime();
            if (waitTime <= 0L) continue;
            LinkedList<ProcessTicket> linkedList = this.owner.incoming;
            synchronized (linkedList) {
                if (this.owner.incoming.isEmpty()) {
                    if (LOGGER.isTraceEnabled()) {
                        if (waitTime < 1000000L) {
                            LOGGER.trace("ProcessTerminator is waiting {} nanoseconds", (Object)waitTime);
                        } else {
                            long waitTimeMS = waitTime / 1000000L;
                            LOGGER.trace("ProcessTerminator is waiting {} millisecond{}", (Object)waitTimeMS, (Object)(waitTimeMS == 1L ? "" : "s"));
                        }
                    }
                    this.owner.incoming.wait(waitTime / 1000000L, (int)(waitTime % 1000000L));
                }
            }
        }
    }
}

