/*
 * Decompiled with CFR 0.152.
 */
package net.pms.service;

import net.pms.formats.Format;
import net.pms.service.Services;
import net.pms.store.StoreItem;

public class StartStopListenerDelegate {
    private final String rendererId;
    private StoreItem item;
    private boolean started = false;
    private boolean stopped = false;

    public StartStopListenerDelegate(String rendererId, StoreItem item) {
        this.rendererId = rendererId;
        this.item = item;
    }

    public StartStopListenerDelegate(String rendererId) {
        this.rendererId = rendererId;
    }

    public synchronized void start(StoreItem item) {
        assert (this.item == null);
        this.item = item;
        this.start();
    }

    public synchronized void start() {
        assert (this.item != null);
        Format format = this.item.getFormat();
        if (!this.started && format != null && (format.isVideo() || format.isAudio())) {
            this.item.startPlaying(this.rendererId);
            this.started = true;
            Services.sleepManager().startPlaying();
        } else {
            Services.postponeSleep();
        }
    }

    public synchronized void stop() {
        if (this.started && !this.stopped) {
            this.item.stopPlaying(this.rendererId);
            this.stopped = true;
            Services.sleepManager().stopPlaying();
        }
    }
}

