/*
 * Decompiled with CFR 0.152.
 */
package net.pms.renderers.devices.players;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import net.pms.renderers.devices.WebGuiRenderer;
import net.pms.renderers.devices.players.LogicalPlayer;
import net.pms.renderers.devices.players.PlaylistItem;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebGuiPlayer
extends LogicalPlayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebGuiPlayer.class);
    private static final Gson GSON = new Gson();

    public WebGuiPlayer(WebGuiRenderer renderer) {
        super(renderer);
        LOGGER.debug("Created web gui player for " + renderer.getRendererName());
    }

    @Override
    public void setURI(String uri, String metadata) {
        StoreResource r;
        PlaylistItem item = this.resolveURI(uri, metadata);
        if (item != null && (r = this.renderer.getMediaStore().getValidResource(item.getUri(), item.getName())) != null) {
            ((WebGuiRenderer)this.renderer).sendMessage("setPlayId", r.getId());
            return;
        }
        LOGGER.debug("Bad uri " + uri);
    }

    @Override
    public void pause() {
        ((WebGuiRenderer)this.renderer).sendMessage("pause");
    }

    @Override
    public void play() {
        ((WebGuiRenderer)this.renderer).sendMessage("play");
    }

    @Override
    public void stop() {
        ((WebGuiRenderer)this.renderer).sendMessage("stop");
    }

    @Override
    public void mute() {
        ((WebGuiRenderer)this.renderer).sendMessage("mute");
    }

    @Override
    public void setVolume(int volume) {
        ((WebGuiRenderer)this.renderer).sendMessage("setvolume", "" + volume);
    }

    @Override
    public int getControls() {
        return this.renderer.getUmsConfiguration().isWebPlayerControllable() ? 3 : 0;
    }

    @Override
    public void start() {
        StoreItem d = this.renderer.getPlayingRes();
        this.state.setName(d.getDisplayName());
        if (d.getMediaInfo() != null) {
            this.state.setDuration(StringUtil.shortTime(d.getMediaInfo().getDurationString(), 4));
        }
    }

    public void setDataFromJson(String jsonData) {
        Map data = GSON.fromJson(jsonData, HashMap.class);
        String s = (String)data.get("playback");
        if (s != null) {
            this.state.setPlayback(switch (s) {
                case "STOPPED" -> 0;
                case "PLAYING" -> 1;
                case "PAUSED" -> 2;
                default -> -1;
            });
        }
        if ((s = (String)data.get("mute")) != null) {
            this.state.setMuted(!"0".equals(data.get("mute")));
        }
        if ((s = (String)data.get("volume")) != null) {
            try {
                this.state.setVolume(StringUtil.hasValue(s) ? Integer.parseInt(s) : 0);
            }
            catch (NumberFormatException e) {
                LOGGER.debug("Unexpected volume value \"{}\"", data.get("volume"));
            }
        }
        if (this.state.isStopped()) {
            this.state.setPosition("");
        } else {
            s = (String)data.get("position");
            if (s != null) {
                try {
                    long seconds = Integer.parseInt(s);
                    this.state.setPosition(seconds * 1000L);
                }
                catch (NumberFormatException e) {
                    LOGGER.debug("Unexpected position value \"{}\"", data.get("position"));
                }
            }
        }
        this.alert();
        if (this.renderer.getPlayingRes() != null && (this.state.isPlaying() || this.state.isPaused())) {
            this.renderer.getPlayingRes().setLastStartSystemTime(System.currentTimeMillis());
        }
    }
}

