/*
 * Decompiled with CFR 0.152.
 */
package net.pms.renderers.devices.players;

import java.io.File;
import java.util.List;
import net.pms.dlna.DidlHelper;
import net.pms.network.mediaserver.MediaServer;
import net.pms.renderers.Renderer;
import net.pms.renderers.devices.players.MinimalPlayer;
import net.pms.renderers.devices.players.Playlist;
import net.pms.renderers.devices.players.PlaylistItem;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.store.container.RealFolder;
import net.pms.store.item.VirtualVideoAction;
import net.pms.util.UMSUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class LogicalPlayer
extends MinimalPlayer {
    protected Playlist playlist = new Playlist(this);
    protected boolean autoContinue;
    protected boolean addAllSiblings;
    protected boolean forceStop;
    protected int lastPlayback = 0;
    protected int maxVol;

    protected LogicalPlayer(Renderer renderer) {
        super(renderer);
        this.maxVol = renderer.getMaxVolume();
        this.autoContinue = renderer.getUmsConfiguration().isAutoContinue();
        this.addAllSiblings = renderer.getUmsConfiguration().isAutoAddAll();
        this.forceStop = false;
        this.alert();
        LogicalPlayer.initAutoPlay(this);
    }

    @Override
    public abstract void setURI(String var1, String var2);

    public PlaylistItem resolveURI(String uri, String metadata) {
        if (uri != null) {
            PlaylistItem item = this.playlist.get(uri);
            if (metadata != null && metadata.startsWith("<DIDL")) {
                return new PlaylistItem(uri, null, metadata);
            }
            if (item != null) {
                return item;
            }
            StoreResource resource = this.renderer.getMediaStore().getValidResource(uri, metadata);
            if (resource instanceof StoreItem) {
                StoreItem storeItem = (StoreItem)resource;
                return new PlaylistItem(storeItem.getMediaURL("", true), resource.getDisplayName(), DidlHelper.getDidlString(resource));
            }
        }
        return null;
    }

    @Override
    public void pressPlay(String uri, String metadata) {
        this.forceStop = false;
        if (this.state.isUnknown()) {
            this.state.setPlayback(0);
        }
        if (this.state.isPlaying()) {
            this.pause();
        } else {
            if (this.state.isStopped()) {
                PlaylistItem item = this.playlist.resolve(uri);
                if (item != null) {
                    uri = item.getUri();
                    metadata = item.getMetadata();
                    this.state.setName(item.getName());
                }
                if (uri != null && !uri.equals(this.state.getUri())) {
                    this.setURI(uri, metadata);
                }
            }
            this.play();
        }
    }

    @Override
    public void pressStop() {
        this.forceStop = true;
        this.stop();
    }

    @Override
    public void next() {
        this.step(1);
    }

    @Override
    public void prev() {
        this.step(-1);
    }

    public void step(int n) {
        if (!this.state.isStopped()) {
            this.stop();
        }
        this.state.setPlayback(0);
        this.playlist.step(n);
        this.pressPlay(null, null);
    }

    @Override
    public void alert() {
        boolean stopping = this.state.isStopped() && this.lastPlayback != -1 && this.lastPlayback != 0;
        this.lastPlayback = this.state.getPlayback();
        super.alert();
        if (stopping && this.autoContinue && !this.forceStop) {
            this.next();
        }
    }

    @Override
    public int getControls() {
        return this.renderer.getControls();
    }

    @Override
    public Playlist getPlaylist() {
        return this.playlist;
    }

    @Override
    public void add(int index, String uri, String name, String metadata, boolean select) {
        if (!StringUtils.isBlank(uri)) {
            StoreResource d;
            if (this.addAllSiblings && StoreResource.isResourceUrl(uri) && (d = this.renderer.getMediaStore().getResource(StoreResource.parseResourceId(uri))) != null && d.getParent() != null) {
                List<StoreResource> list = d.getParent().getChildren();
                this.addAll(index, list, list.indexOf(d));
                return;
            }
            this.playlist.add(index, uri, name, metadata, select);
        }
    }

    public void addAll(int index, List<StoreResource> list, int selIndex) {
        for (int i = 0; i < list.size(); ++i) {
            StoreResource r = list.get(i);
            if (!(r instanceof StoreItem)) continue;
            StoreItem item = (StoreItem)r;
            if (r instanceof VirtualVideoAction || item.isFolder()) continue;
            this.playlist.add(index, item.getMediaURL("", true), r.getDisplayName(), DidlHelper.getDidlString(r), i == selIndex);
        }
    }

    @Override
    public void remove(String uri) {
        if (!StringUtils.isBlank(uri)) {
            this.playlist.remove(uri);
        }
    }

    public void clear() {
        this.playlist.removeAllElements();
    }

    private static void initAutoPlay(LogicalPlayer player) {
        String[] strs;
        String auto = player.renderer.getUmsConfiguration().getAutoPlay();
        if (StringUtils.isEmpty(auto)) {
            return;
        }
        for (String s : strs = auto.split(" ")) {
            String[] tmp = s.split(":", 2);
            if (tmp.length != 2 || !player.renderer.getConfName().equalsIgnoreCase(tmp[0])) continue;
            String folder = tmp[1];
            Runnable r = () -> {
                while (!MediaServer.isStarted()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                RealFolder f = new RealFolder(player.getRenderer(), new File(folder));
                f.discoverChildren();
                player.addAll(-1, f.getChildren(), -1);
                UMSUtils.sleep(1000);
                player.pressPlay(null, null);
            };
            new Thread(r).start();
        }
    }
}

