/*
 * Decompiled with CFR 0.152.
 */
package net.pms.renderers.devices.players;

import java.io.IOException;
import net.pms.renderers.Renderer;
import net.pms.renderers.devices.players.LogicalPlayer;
import net.pms.renderers.devices.players.PlaylistItem;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.litvak.chromecast.api.v2.ChromeCast;
import su.litvak.chromecast.api.v2.Media;
import su.litvak.chromecast.api.v2.MediaStatus;
import su.litvak.chromecast.api.v2.Status;

public class ChromecastPlayer
extends LogicalPlayer {
    private static final String MEDIA_PLAYER = "CC1AD845";
    private static final Logger LOGGER = LoggerFactory.getLogger(ChromecastPlayer.class);
    private final ChromeCast api;

    public ChromecastPlayer(Renderer renderer, ChromeCast api) {
        super(renderer);
        this.api = api;
    }

    @Override
    public void setURI(String uri, String metadata) {
        PlaylistItem playlistItem = this.resolveURI(uri, metadata);
        if (playlistItem != null) {
            StoreItem libraryItem;
            StoreItem item;
            StoreResource r = this.renderer.getMediaStore().getValidResource(playlistItem.getUri(), playlistItem.getName());
            StoreItem storeItem = item = r instanceof StoreItem ? (libraryItem = (StoreItem)r) : null;
            if (item == null) {
                LOGGER.debug("Bad media in cc seturi: " + uri);
                return;
            }
            try {
                this.api.launchApp(MEDIA_PLAYER);
                this.api.load("", null, playlistItem.getUri(), item.getMimeType());
            }
            catch (IOException e) {
                LOGGER.debug("Bad chromecast load: " + e);
            }
        }
    }

    @Override
    public void play() {
        try {
            this.api.play();
        }
        catch (IOException e) {
            LOGGER.debug("Bad chromecast play " + e);
        }
    }

    @Override
    public void pause() {
        try {
            this.api.pause();
        }
        catch (IOException e) {
            LOGGER.debug("Bad chromecast pause " + e);
        }
    }

    @Override
    public void stop() {
        try {
            this.api.stopApp();
        }
        catch (IOException e) {
            LOGGER.debug("Bad chromecast stop " + e);
        }
    }

    @Override
    public void forward() {
        try {
            this.api.seek(60.0);
        }
        catch (IOException e) {
            LOGGER.debug("Bad chromecast fwd " + e);
        }
    }

    @Override
    public void rewind() {
        try {
            this.api.seek(-60.0);
        }
        catch (IOException e) {
            LOGGER.debug("Bad chromecast rwd " + e);
        }
    }

    @Override
    public void setVolume(int volume) {
        try {
            this.api.setVolume(volume);
        }
        catch (IOException e) {
            LOGGER.debug("Bad chromecast volume " + e);
        }
    }

    @Override
    public int getControls() {
        return 3;
    }

    private int translateState(MediaStatus.PlayerState s) {
        return switch (s) {
            case MediaStatus.PlayerState.IDLE -> 0;
            case MediaStatus.PlayerState.PLAYING, MediaStatus.PlayerState.BUFFERING -> 1;
            case MediaStatus.PlayerState.PAUSED -> 2;
            default -> -1;
        };
    }

    public void startPoll() {
        Runnable r = () -> {
            while (true) {
                try {
                    while (true) {
                        MediaStatus status;
                        Thread.sleep(1000L);
                        Status s1 = this.api.getStatus();
                        if (s1 == null || !s1.isAppRunning(MEDIA_PLAYER) || (status = this.api.getMediaStatus()) == null) continue;
                        this.state.setPlayback(this.translateState(status.playerState));
                        Media m = status.media;
                        if (m != null) {
                            if (m.url != null) {
                                this.state.setUri(status.media.url);
                            }
                            if (m.duration != null) {
                                this.state.setDuration(status.media.duration);
                            }
                        }
                        this.state.setPosition(status.currentTime);
                        if (status.volume != null) {
                            this.state.setVolume(status.volume.level.intValue());
                            this.state.setMuted(status.volume.muted);
                        }
                        this.alert();
                    }
                }
                catch (IOException e) {
                    LOGGER.debug("Bad chromecast mediastate " + e);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        };
        new Thread(r).start();
    }
}

