/*
 * Decompiled with CFR 0.152.
 */
package net.pms.renderers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import net.pms.PMS;
import net.pms.configuration.RendererConfiguration;
import net.pms.configuration.RendererConfigurations;
import net.pms.configuration.UmsConfiguration;
import net.pms.dlna.protocolinfo.DeviceProtocolInfo;
import net.pms.network.mediaserver.MediaServer;
import net.pms.network.mediaserver.jupnp.controlpoint.UmsSubscriptionCallback;
import net.pms.renderers.ConnectedRenderers;
import net.pms.renderers.Renderer;
import net.pms.util.XmlUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.jupnp.controlpoint.ActionCallback;
import org.jupnp.model.action.ActionArgumentValue;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.header.DeviceTypeHeader;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceDetails;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.Icon;
import org.jupnp.model.meta.ManufacturerDetails;
import org.jupnp.model.meta.ModelDetails;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.meta.Service;
import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.ServiceId;
import org.jupnp.model.types.UDADeviceType;
import org.jupnp.model.types.UDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JUPnPDeviceHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JUPnPDeviceHelper.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final DeviceType[] MEDIA_RENDERER_TYPES = new DeviceType[]{new UDADeviceType("MediaRenderer", 1), new UDADeviceType("Basic", 1)};
    public static final int ACTIVE = 0;
    public static final int CONTROLS = 1;
    public static final int RENEW = 2;
    public static final int AVT = 1;
    public static final int RC = 2;
    public static final int ANY = 255;
    private static final boolean DEBUG = true;
    public static final String NORMAL = "NORMAL";
    public static final String REPEAT_ONE = "REPEAT_ONE";
    public static final String REPEAT_ALL = "REPEAT_ALL";
    public static final String RANDOM = "RANDOM";
    public static final String REL_BYTE = "X_DLNA_REL_BYTE";
    public static final String REL_TIME = "REL_TIME";
    public static final String TRACK_NR = "TRACK_NR";
    private static final String AV_TRANSPORT_SERVICE = "AVTransport";
    private static final String RENDERING_CONTROL_SERVICE = "RenderingControl";
    public static final String MASTER = "Master";
    public static final String LF = "LF";
    public static final String RF = "RF";
    protected static ArrayList<RemoteDevice> ignoredDevices = new ArrayList();
    private static DocumentBuilder db;

    private JUPnPDeviceHelper() {
    }

    public static void searchMediaRendererDevices() {
        if (MediaServer.upnpService != null) {
            for (DeviceType deviceType : MEDIA_RENDERER_TYPES) {
                LOGGER.trace("Sending UPnP search for devices of type: {}", (Object)deviceType);
                MediaServer.upnpService.getControlPoint().search(new DeviceTypeHeader(deviceType));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remoteDeviceAdded(RemoteDevice device) {
        ConnectedRenderers.RENDERER_LOCK.lock();
        try {
            if (JUPnPDeviceHelper.isBlocked(JUPnPDeviceHelper.getUUID(device)) || !JUPnPDeviceHelper.addRenderer(device)) {
                LOGGER.trace("Ignoring remote device: {} {}", (Object)device.getType().getType(), (Object)device);
                JUPnPDeviceHelper.addIgnoredDeviceToList(device);
            }
            if (device.hasEmbeddedDevices()) {
                for (RemoteDevice embedded : device.getEmbeddedDevices()) {
                    if (!JUPnPDeviceHelper.isBlocked(JUPnPDeviceHelper.getUUID(embedded)) && JUPnPDeviceHelper.addRenderer(embedded)) continue;
                    LOGGER.trace("Ignoring embedded device: {} {}", (Object)embedded.getType(), (Object)embedded.toString());
                    JUPnPDeviceHelper.addIgnoredDeviceToList(embedded);
                }
            }
        }
        finally {
            ConnectedRenderers.RENDERER_LOCK.unlock();
        }
    }

    public static void remoteDeviceUpdated(RemoteDevice d) {
        JUPnPDeviceHelper.rendererUpdated(d);
    }

    public static void remoteDeviceRemoved(RemoteDevice d) {
        String uuid = JUPnPDeviceHelper.getUUID(d);
        if (ConnectedRenderers.hasUuidRenderer(uuid)) {
            ConnectedRenderers.markUpnpRenderer(uuid, 0, false);
            LOGGER.debug("Renderer {} is now offline.", (Object)JUPnPDeviceHelper.getFriendlyName(d));
        }
    }

    public static void markRenderer(String uuid, int property, Object value) {
        ConnectedRenderers.markUpnpRenderer(uuid, property, value);
    }

    public static boolean isUpnpDevice(String uuid) {
        return JUPnPDeviceHelper.getDevice(uuid) != null;
    }

    public static boolean isActive(String uuid) {
        if (ConnectedRenderers.hasUuidRenderer(uuid)) {
            return ConnectedRenderers.getUuidRenderer(uuid).isActive();
        }
        return false;
    }

    public static boolean isUpnpControllable(String uuid) {
        if (ConnectedRenderers.hasUuidRenderer(uuid)) {
            return ConnectedRenderers.getUuidRenderer(uuid).isControllable();
        }
        return false;
    }

    public static String getFriendlyName(String uuid) {
        return JUPnPDeviceHelper.getFriendlyName(JUPnPDeviceHelper.getDevice(uuid));
    }

    public static boolean activate(String uuid) {
        if (!ConnectedRenderers.hasUuidRenderer(uuid)) {
            LOGGER.debug("Activating upnp service for {}", (Object)uuid);
            return JUPnPDeviceHelper.addRenderer(uuid);
        }
        return true;
    }

    public static boolean isNonRenderer(InetAddress socket) {
        Device d = JUPnPDeviceHelper.getRendererDevice(socket);
        if (d != null && !JUPnPDeviceHelper.isMediaRenderer(d)) {
            LOGGER.debug("Device at {} is {}: {}", socket, d.getType(), d.toString());
            return true;
        }
        return false;
    }

    public static ActionArgumentValue[] getPositionInfo(Renderer renderer) {
        Device dev = JUPnPDeviceHelper.getDevice(renderer.getUUID());
        if (dev == null) {
            return null;
        }
        ActionInvocation invocation = JUPnPDeviceHelper.send(dev, renderer, AV_TRANSPORT_SERVICE, "GetPositionInfo", new String[0]);
        return invocation == null ? null : invocation.getOutput();
    }

    public static InetAddress getInetAddress(String uuid) {
        Device device = JUPnPDeviceHelper.getDevice(uuid);
        if (device != null) {
            return JUPnPDeviceHelper.getInetAddress(device);
        }
        return null;
    }

    private static InetAddress getInetAddress(Device device) {
        try {
            URL url = JUPnPDeviceHelper.getURL(device);
            if (url != null && url.getHost() != null) {
                return InetAddress.getByName(url.getHost());
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    private static boolean addRenderer(String uuid) {
        Device device = JUPnPDeviceHelper.getDevice(uuid);
        return device != null && JUPnPDeviceHelper.addRenderer(device);
    }

    private static synchronized boolean addRenderer(Device<?, RemoteDevice, ?> device) {
        String uuid;
        if (device != null && JUPnPDeviceHelper.isMediaRenderer(device) && (uuid = JUPnPDeviceHelper.getUUID(device)) != null) {
            ConnectedRenderers.addUuidAssociation(JUPnPDeviceHelper.getInetAddress(device), uuid);
            Renderer renderer = JUPnPDeviceHelper.rendererFound(device, uuid);
            if (renderer != null) {
                LOGGER.debug("Adding device: {} {}", (Object)device.getType(), (Object)device.toString());
                JUPnPDeviceHelper.subscribeAll(device, renderer);
                JUPnPDeviceHelper.getProtocolInfo(device);
                renderer.setActive(true);
                renderer.getPlayer();
                return true;
            }
        }
        return false;
    }

    private static Renderer rendererFound(Device device, String uuid) {
        try {
            boolean distinct;
            RendererConfiguration ref;
            InetAddress socket = JUPnPDeviceHelper.getInetAddress(device);
            Renderer renderer = ConnectedRenderers.getRendererBySocketAddress(socket);
            RendererConfiguration rendererConfiguration = ref = CONFIGURATION.isRendererForceDefault() ? null : RendererConfigurations.getRendererConfigurationByUPNPDetails(JUPnPDeviceHelper.getDeviceDetailsString(device));
            if (renderer != null && !renderer.isUpnpAllowed()) {
                LOGGER.debug("Upnp service is {} for \"{}\"", (Object)renderer.getUpnpModeString(), (Object)renderer);
                return null;
            }
            if (renderer != null && ref != null) {
                LOGGER.debug("Upnp service found device \"{}\" with upnp details matching conf \"{}\"", (Object)renderer, (Object)ref);
            }
            boolean bl = distinct = renderer != null && StringUtils.isNotBlank(renderer.getUUID()) && !uuid.equals(renderer.getUUID());
            if (!(distinct || renderer == null || !renderer.matchUPNPDetails(JUPnPDeviceHelper.getDeviceDetailsString(device)) && renderer.isLoaded())) {
                if (ref != null && !ref.getUpnpDetailsString().equals(renderer.getUpnpDetailsString()) && ref.getLoadingPriority() >= renderer.getLoadingPriority()) {
                    LOGGER.debug("Switching to preferred renderer: " + ref);
                    renderer.inherit(ref);
                }
                renderer.setUUID(uuid);
                ConnectedRenderers.addUuidRenderer(uuid, renderer);
                Map<String, String> details = JUPnPDeviceHelper.getDeviceDetails(device);
                renderer.setDetails(details);
                renderer.updateRendererGui();
                LOGGER.debug("Found upnp service for \"{}\" with dlna details: {}", (Object)renderer, (Object)details);
            } else {
                renderer = ConnectedRenderers.getOrCreateUuidRenderer(uuid);
                if (ref != null) {
                    renderer.inherit(ref);
                } else {
                    renderer.inheritDefault();
                    LOGGER.debug("Marking upnp renderer \"{}\" at {} as unrecognized", (Object)renderer, (Object)socket);
                }
                if (renderer.associateIP(socket)) {
                    Map<String, String> details = JUPnPDeviceHelper.getDeviceDetails(device);
                    renderer.setDetails(details);
                    PMS.get().setRendererFound(renderer);
                    LOGGER.debug("New renderer found: \"{}\" with dlna details: {}", (Object)renderer, (Object)details);
                }
            }
            return renderer;
        }
        catch (ConfigurationException e) {
            LOGGER.debug("Error initializing device " + JUPnPDeviceHelper.getFriendlyName(device) + ": " + e);
            return null;
        }
    }

    private static boolean isBlocked(String uuid) {
        int mode = RendererConfigurations.getDeviceUpnpMode(uuid);
        if (mode != 1) {
            LOGGER.debug("Upnp service is {} for {}", (Object)Renderer.getUpnpModeString(mode), (Object)uuid);
            return true;
        }
        return false;
    }

    private static void subscribeAll(Device d, Renderer renderer) {
        String name = JUPnPDeviceHelper.getFriendlyName(d);
        int ctrl = 0;
        for (Service s : d.getServices()) {
            String sid = s.getServiceId().getId();
            LOGGER.debug("Subscribing to " + sid + " service on " + name);
            if (sid.contains(AV_TRANSPORT_SERVICE)) {
                ctrl |= 1;
            } else if (sid.contains(RENDERING_CONTROL_SERVICE)) {
                ctrl |= 2;
            }
            MediaServer.upnpService.getControlPoint().execute(new UmsSubscriptionCallback(s));
        }
        renderer.setRenew(false);
        renderer.setControls(ctrl);
    }

    private static void rendererUpdated(Device d) {
        String uuid = JUPnPDeviceHelper.getUUID(d);
        if (ConnectedRenderers.hasUuidRenderer(uuid)) {
            Renderer renderer = ConnectedRenderers.getUuidRenderer(uuid);
            if (renderer.needsRenewal()) {
                LOGGER.debug("Renewing subscriptions to ", (Object)JUPnPDeviceHelper.getFriendlyName(d));
                JUPnPDeviceHelper.subscribeAll(d, renderer);
            }
            renderer.setActive(true);
        }
    }

    private static Device getRendererDevice(InetAddress socket) {
        if (MediaServer.upnpService != null) {
            for (DeviceType r : MEDIA_RENDERER_TYPES) {
                Device device = JUPnPDeviceHelper.getDevice(socket, MediaServer.upnpService.getRegistry().getDevices(r));
                if (device == null) continue;
                return device;
            }
        }
        return null;
    }

    public static Device getDevice(String uuid) {
        return uuid != null && MediaServer.upnpService != null ? MediaServer.upnpService.getRegistry().getDevice(UDN.valueOf(uuid), false) : null;
    }

    public static Device getDevice(InetAddress socket) {
        if (MediaServer.upnpService != null) {
            return JUPnPDeviceHelper.getDevice(socket, MediaServer.upnpService.getRegistry().getDevices());
        }
        return null;
    }

    private static Device getDevice(InetAddress socket, Collection<Device> devices) {
        for (Device device : devices) {
            try {
                InetAddress[] addresses;
                URL url = JUPnPDeviceHelper.getURL(device);
                if (url == null || url.getHost() == null) continue;
                for (InetAddress address : addresses = InetAddress.getAllByName(url.getHost())) {
                    if (!address.equals(socket)) continue;
                    return device;
                }
            }
            catch (UnknownHostException unknownHostException) {
            }
        }
        return null;
    }

    private static URL getURL(Device device) {
        if (device instanceof RemoteDevice) {
            RemoteDevice remoteDevice = (RemoteDevice)device;
            return ((RemoteDeviceIdentity)remoteDevice.getIdentity()).getDescriptorURL();
        }
        if (device != null && device.getDetails() != null) {
            return device.getDetails().getBaseURL();
        }
        return null;
    }

    public static List<String> getServiceNames(String uuid) {
        if (JUPnPDeviceHelper.isUpnpDevice(uuid)) {
            return JUPnPDeviceHelper.getServiceNames(JUPnPDeviceHelper.getDevice(uuid));
        }
        return null;
    }

    private static List<String> getServiceNames(Device d) {
        ArrayList<String> services = new ArrayList<String>();
        for (Service s : d.getServices()) {
            services.add(s.getServiceId().getId());
        }
        return services;
    }

    public static Map<String, String> getDeviceDetails(String uuid) {
        if (JUPnPDeviceHelper.isUpnpDevice(uuid)) {
            return JUPnPDeviceHelper.getDeviceDetails(JUPnPDeviceHelper.getDevice(uuid));
        }
        return null;
    }

    private static Map<String, String> getDeviceDetails(Device d) {
        if (d == null) {
            return null;
        }
        DeviceDetails dev = d.getDetails();
        ManufacturerDetails man = dev.getManufacturerDetails();
        ModelDetails model = dev.getModelDetails();
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
        details.put("friendlyName", dev.getFriendlyName());
        details.put("address", JUPnPDeviceHelper.getURL(d).getHost());
        details.put("udn", JUPnPDeviceHelper.getUUID(d));
        Object detail = man.getManufacturer();
        if (detail != null) {
            details.put("manufacturer", (String)detail);
        }
        if ((detail = model.getModelName()) != null) {
            details.put("modelName", (String)detail);
        }
        if ((detail = model.getModelNumber()) != null) {
            details.put("modelNumber", (String)detail);
        }
        if ((detail = model.getModelDescription()) != null) {
            details.put("modelDescription", (String)detail);
        }
        if ((detail = man.getManufacturerURI()) != null) {
            details.put("manufacturerURL", detail.toString());
        }
        if ((detail = model.getModelURI()) != null) {
            details.put("modelURL", detail.toString());
        }
        return details;
    }

    private static String getDeviceDetailsString(Device d) {
        return StringUtils.join(JUPnPDeviceHelper.getDeviceDetails(d).values(), " ");
    }

    public static String getDeviceIcon(String uuid, int maxHeight) {
        if (JUPnPDeviceHelper.isUpnpDevice(uuid)) {
            return JUPnPDeviceHelper.getDeviceIcon(JUPnPDeviceHelper.getDevice(uuid), maxHeight);
        }
        return null;
    }

    private static String getDeviceIcon(Device d, int maxHeight) {
        URL base = JUPnPDeviceHelper.getURL(d);
        Icon icon = null;
        String url = null;
        int maxH = maxHeight == 0 ? 99999 : maxHeight;
        int height = 0;
        if (d != null) {
            for (Icon i : d.getIcons()) {
                int h = i.getHeight();
                if (h >= maxH || h <= height) continue;
                icon = i;
                height = h;
            }
        }
        try {
            url = icon != null ? base.toURI().resolve(icon.getUri()).toURL().toString() : null;
        }
        catch (MalformedURLException | URISyntaxException exception) {
            // empty catch block
        }
        LOGGER.debug("Device icon: " + url);
        return url;
    }

    private static boolean isMediaRenderer(Device d) {
        String t = d.getType().getType();
        for (DeviceType r : MEDIA_RENDERER_TYPES) {
            if (!r.getType().equals(t)) continue;
            return true;
        }
        return false;
    }

    private static String getFriendlyName(Device d) {
        return d != null ? d.getDetails().getFriendlyName() : null;
    }

    public static String getUUID(InetAddress socket) {
        Device d = JUPnPDeviceHelper.getRendererDevice(socket);
        if (d != null) {
            return JUPnPDeviceHelper.getUUID(d);
        }
        return null;
    }

    private static String getUUID(Device d) {
        return ((DeviceIdentity)d.getIdentity()).getUdn().getIdentifierString();
    }

    private static void addIgnoredDeviceToList(RemoteDevice device) {
        if (!ignoredDevices.contains(device)) {
            ignoredDevices.add(device);
        }
    }

    private static void getProtocolInfo(Device<?, RemoteDevice, ?> device) {
        Object connectionManager = device.findService(ServiceId.valueOf("ConnectionManager"));
        if (connectionManager != null) {
            Action action = ((Service)connectionManager).getAction("GetProtocolInfo");
            final String name = JUPnPDeviceHelper.getFriendlyName(device);
            if (action != null) {
                final String uuid = JUPnPDeviceHelper.getUUID(device);
                ActionInvocation actionInvocation = new ActionInvocation(action);
                new ActionCallback(actionInvocation, MediaServer.upnpService.getControlPoint()){

                    @Override
                    public void success(ActionInvocation invocation) {
                        Map outputs = invocation.getOutputMap();
                        ActionArgumentValue sink = outputs.get("Sink");
                        if (sink != null && ConnectedRenderers.hasUuidRenderer(uuid)) {
                            ConnectedRenderers.getUuidRenderer((String)uuid).deviceProtocolInfo.add(DeviceProtocolInfo.GET_PROTOCOLINFO_SINK, sink.toString());
                        }
                        if (LOGGER.isTraceEnabled()) {
                            StringBuilder sb = new StringBuilder();
                            for (Map.Entry entry : outputs.entrySet()) {
                                String value;
                                if (entry.getValue() == null || !StringUtils.isNotBlank(value = entry.getValue().toString())) continue;
                                sb.append("\n").append(entry.getKey()).append(":\n  ");
                                sb.append(value.replace(",", "\n  "));
                            }
                            if (sb.length() > 0) {
                                LOGGER.trace("Received GetProtocolInfo from \"{}\": {}", (Object)name, (Object)sb.toString());
                            } else {
                                LOGGER.trace("Received empty reply to GetProtocolInfo from \"{}\"", (Object)name);
                            }
                        }
                    }

                    @Override
                    public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                        LOGGER.debug("GetProtocolInfo from \"{}\" failed with status code {}: {} ({})", name, operation != null ? operation.getStatusCode() : invocation.getFailure().getErrorCode(), operation != null ? operation.getStatusMessage() : invocation.getFailure().getMessage(), defaultMsg);
                    }
                }.run();
            }
        }
    }

    private static ActionInvocation send(Device dev, String service, String action, String ... args) {
        return JUPnPDeviceHelper.send(dev, null, service, action, args);
    }

    private static ActionInvocation send(final Device dev, final Renderer renderer, String service, final String action, String ... args) {
        Object svc = dev.findService(ServiceId.valueOf("urn:upnp-org:serviceId:" + service));
        final String uuid = JUPnPDeviceHelper.getUUID(dev);
        if (svc != null) {
            boolean isNotGetPositionInfoRequest;
            Action x = ((Service)svc).getAction(action);
            String name = JUPnPDeviceHelper.getFriendlyName(dev);
            boolean bl = isNotGetPositionInfoRequest = !action.equals("GetPositionInfo");
            if (x != null) {
                ActionInvocation a = new ActionInvocation(x);
                a.setInput("InstanceID", "0");
                for (int i = 0; i < args.length; i += 2) {
                    a.setInput(args[i], args[i + 1]);
                }
                if (isNotGetPositionInfoRequest) {
                    LOGGER.debug("Sending upnp {}.{} {} to {}", service, action, args, name);
                }
                new ActionCallback(a, MediaServer.upnpService.getControlPoint()){

                    @Override
                    public void success(ActionInvocation invocation) {
                        ConnectedRenderers.markUpnpRenderer(uuid, 0, true);
                    }

                    @Override
                    public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                        if (isNotGetPositionInfoRequest) {
                            LOGGER.error("Failed to send action \"{}\" to {}: {}", action, dev.getDetails().getFriendlyName(), defaultMsg);
                            if (LOGGER.isTraceEnabled() && invocation != null && invocation.getFailure() != null) {
                                LOGGER.trace("", invocation.getFailure());
                            }
                            ConnectedRenderers.markUpnpRenderer(uuid, 0, false);
                        } else if (renderer != null && renderer.isGetPositionInfoImplemented) {
                            if (invocation.getFailure().getErrorCode() == 501) {
                                renderer.isGetPositionInfoImplemented = false;
                                LOGGER.info("The renderer {} returns that the GetPositionInfo is not implemented. The UMS disabled this feature.", (Object)renderer);
                            } else {
                                ++renderer.countGetPositionRequests;
                                if (renderer.countGetPositionRequests > 2) {
                                    renderer.isGetPositionInfoImplemented = false;
                                    LOGGER.info("The GetPositionInfo seems to be not properly implemented in the {}. The UMS disabled this feature.", (Object)renderer);
                                }
                            }
                        }
                    }
                }.run();
                if (isNotGetPositionInfoRequest) {
                    for (ActionArgumentValue arg : a.getOutput()) {
                        LOGGER.debug("Received from {}: {}={}", name, arg.getArgument().getName(), arg.toString());
                    }
                }
                return a;
            }
        } else {
            LOGGER.warn("Couldn't find UPnP service {} for device {} when trying perform action {}", service, dev.getDetails().getFriendlyName(), action);
        }
        return null;
    }

    public static void play(Device dev) {
        JUPnPDeviceHelper.send(dev, AV_TRANSPORT_SERVICE, "Play", "Speed", "1");
    }

    public static void pause(Device dev) {
        JUPnPDeviceHelper.send(dev, AV_TRANSPORT_SERVICE, "Pause", new String[0]);
    }

    public static void next(Device dev) {
        JUPnPDeviceHelper.send(dev, AV_TRANSPORT_SERVICE, "Next", new String[0]);
    }

    public static void previous(Device dev) {
        JUPnPDeviceHelper.send(dev, AV_TRANSPORT_SERVICE, "Previous", new String[0]);
    }

    public static void seek(Device dev, String mode, String target) {
        JUPnPDeviceHelper.send(dev, AV_TRANSPORT_SERVICE, "Seek", "Unit", mode, "Target", target);
    }

    public static void stop(Device dev) {
        JUPnPDeviceHelper.send(dev, AV_TRANSPORT_SERVICE, "Stop", new String[0]);
    }

    public static String getCurrentTransportState(Device dev) {
        ActionInvocation invocation = JUPnPDeviceHelper.send(dev, AV_TRANSPORT_SERVICE, "GetTransportInfo", new String[0]);
        if (invocation == null) {
            return null;
        }
        ActionArgumentValue argumentValue = invocation.getOutput("CurrentTransportState");
        return argumentValue == null ? null : argumentValue.toString();
    }

    public static String getCurrentTransportActions(Device dev) {
        ActionInvocation invocation = JUPnPDeviceHelper.send(dev, AV_TRANSPORT_SERVICE, "GetCurrentTransportActions", new String[0]);
        if (invocation == null) {
            return null;
        }
        ActionArgumentValue argumentValue = invocation.getOutput("CurrentTransportActions");
        return argumentValue == null ? null : argumentValue.toString();
    }

    public static String getDeviceCapabilities(Device dev) {
        ActionInvocation invocation = JUPnPDeviceHelper.send(dev, AV_TRANSPORT_SERVICE, "GetDeviceCapabilities", new String[0]);
        if (invocation == null) {
            return null;
        }
        ActionArgumentValue argumentValue = invocation.getOutput("DeviceCapabilities");
        return argumentValue == null ? null : argumentValue.toString();
    }

    public static String getMediaInfo(Device dev) {
        ActionInvocation invocation = JUPnPDeviceHelper.send(dev, AV_TRANSPORT_SERVICE, "GetMediaInfo", new String[0]);
        if (invocation == null) {
            return null;
        }
        ActionArgumentValue argumentValue = invocation.getOutput("MediaInfo");
        return argumentValue == null ? null : argumentValue.toString();
    }

    public static String getTransportInfo(Device dev) {
        ActionInvocation invocation = JUPnPDeviceHelper.send(dev, AV_TRANSPORT_SERVICE, "GetTransportInfo", new String[0]);
        if (invocation == null) {
            return null;
        }
        ActionArgumentValue argumentValue = invocation.getOutput("TransportInfo");
        return argumentValue == null ? null : argumentValue.toString();
    }

    public static String getTransportSettings(Device dev) {
        ActionInvocation invocation = JUPnPDeviceHelper.send(dev, AV_TRANSPORT_SERVICE, "GetTransportSettings", new String[0]);
        if (invocation == null) {
            return null;
        }
        ActionArgumentValue argumentValue = invocation.getOutput("TransportSettings");
        return argumentValue == null ? null : argumentValue.toString();
    }

    public static void setAVTransportURI(Device dev, String uri, String metaData) {
        JUPnPDeviceHelper.send(dev, AV_TRANSPORT_SERVICE, "SetAVTransportURI", "CurrentURI", uri, "CurrentURIMetaData", metaData != null ? JUPnPDeviceHelper.unEncodeXML(metaData) : null);
    }

    public static void setPlayMode(Device dev, String mode) {
        JUPnPDeviceHelper.send(dev, AV_TRANSPORT_SERVICE, "SetPlayMode", "NewPlayMode", mode);
    }

    public static String xDlnaGetBytePositionInfo(Device dev, String trackSize) {
        ActionInvocation invocation = JUPnPDeviceHelper.send(dev, AV_TRANSPORT_SERVICE, "X_DLNA_GetBytePositionInfo", "TrackSize", trackSize);
        if (invocation == null) {
            return null;
        }
        ActionArgumentValue argumentValue = invocation.getOutput("BytePositionInfo");
        return argumentValue == null ? null : argumentValue.toString();
    }

    public static String getMute(Device dev) {
        return JUPnPDeviceHelper.getMute(dev, MASTER);
    }

    public static String getMute(Device dev, String channel) {
        ActionInvocation invocation = JUPnPDeviceHelper.send(dev, RENDERING_CONTROL_SERVICE, "GetMute", "Channel", channel);
        if (invocation == null) {
            return null;
        }
        ActionArgumentValue argumentValue = invocation.getOutput("Mute");
        return argumentValue == null ? null : argumentValue.toString();
    }

    public static String getVolume(Device dev) {
        return JUPnPDeviceHelper.getVolume(dev, MASTER);
    }

    public static String getVolume(Device dev, String channel) {
        ActionInvocation invocation = JUPnPDeviceHelper.send(dev, RENDERING_CONTROL_SERVICE, "GetVolume", "Channel", channel);
        if (invocation == null) {
            return null;
        }
        ActionArgumentValue argumentValue = invocation.getOutput("Volume");
        return argumentValue == null ? null : argumentValue.toString();
    }

    public static void setMute(Device dev, boolean on) {
        JUPnPDeviceHelper.setMute(dev, on, MASTER);
    }

    public static void setMute(Device dev, boolean on, String channel) {
        JUPnPDeviceHelper.send(dev, RENDERING_CONTROL_SERVICE, "SetMute", "DesiredMute", on ? "1" : "0", "Channel", channel);
    }

    public static void setVolume(Device dev, int volume) {
        JUPnPDeviceHelper.setVolume(dev, volume, MASTER);
    }

    public static void setVolume(Device dev, int volume, String channel) {
        JUPnPDeviceHelper.send(dev, RENDERING_CONTROL_SERVICE, "SetVolume", "DesiredVolume", String.valueOf(volume), "Channel", channel);
    }

    public static boolean isNotIgnoredDevice(String uuid) {
        if (ignoredDevices != null) {
            UDN udn = UDN.valueOf(uuid);
            for (RemoteDevice rd : ignoredDevices) {
                if (rd.findDevice(udn) == null) continue;
                return false;
            }
        }
        return true;
    }

    public static synchronized void xml2d(String uuid, String xml, Renderer item) {
        if (StringUtils.isBlank(xml)) {
            return;
        }
        try {
            if (db == null) {
                try {
                    db = XmlUtils.xxeDisabledDocumentBuilderFactory().newDocumentBuilder();
                }
                catch (ParserConfigurationException ex) {
                    LOGGER.debug("Error creating xml2d parser " + ex);
                    return;
                }
            }
            Document doc = db.parse(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
            NodeList ids = doc.getElementsByTagName("InstanceID");
            int idsLength = ids.getLength();
            for (int i = 0; i < idsLength; ++i) {
                NodeList c = ids.item(i).getChildNodes();
                String id = ((Element)ids.item(i)).getAttribute("val");
                if (item == null) {
                    item = ConnectedRenderers.getUuidRenderer(uuid);
                }
                item.data.put("InstanceID", id);
                for (int n = 0; n < c.getLength(); ++n) {
                    if (c.item(n).getNodeType() != 1) continue;
                    Element e = (Element)c.item(n);
                    String name = e.getTagName();
                    String val = e.getAttribute("val");
                    LOGGER.debug(name + ": " + val);
                    item.data.put(name, val);
                }
                item.alert();
            }
        }
        catch (IOException | SAXException e) {
            LOGGER.debug("Error parsing xml: " + e);
        }
    }

    private static String unEncodeXML(String s) {
        return s.replace("&amp;", "&").replace("&lt;", "<").replace("&gt;", ">");
    }
}

