/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.windows;

import com.sun.jna.Native;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Shell32Util;
import com.sun.jna.platform.win32.VerRsrc;
import com.sun.jna.platform.win32.VersionUtil;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.LongByReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.io.IPipeProcess;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapperImpl;
import net.pms.platform.PlatformProgramPaths;
import net.pms.platform.PlatformUtils;
import net.pms.platform.windows.CSIDL;
import net.pms.platform.windows.GUID;
import net.pms.platform.windows.Kernel32;
import net.pms.platform.windows.KnownFolders;
import net.pms.platform.windows.NTStatus;
import net.pms.platform.windows.WindowsPipeProcess;
import net.pms.platform.windows.WindowsProcessTerminator;
import net.pms.platform.windows.WindowsSleepWorker;
import net.pms.service.process.AbstractProcessTerminator;
import net.pms.service.process.ProcessManager;
import net.pms.service.sleep.AbstractSleepWorker;
import net.pms.service.sleep.PreventSleepMode;
import net.pms.service.sleep.SleepManager;
import net.pms.util.FilePermissions;
import net.pms.util.FileUtil;
import net.pms.util.ProcessUtil;
import net.pms.util.Version;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsUtils
extends PlatformUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsUtils.class);
    private final boolean kerio;
    protected final Path psPing;
    protected final String avsPluginsFolder;
    protected final String kLiteFiltersDir;

    @Override
    public File getAvsPluginsDir() {
        if (this.avsPluginsFolder == null) {
            return null;
        }
        File pluginsDir = new File(this.avsPluginsFolder);
        if (!pluginsDir.exists()) {
            pluginsDir = null;
        }
        return pluginsDir;
    }

    @Override
    public File getKLiteFiltersDir() {
        if (this.kLiteFiltersDir == null) {
            return null;
        }
        File filtersDir = new File(this.kLiteFiltersDir + "\\Filters");
        if (!filtersDir.exists()) {
            filtersDir = null;
        }
        return filtersDir;
    }

    @Override
    public String getShortPathNameW(String longPathName) {
        boolean unicodeChars;
        if (longPathName == null) {
            return null;
        }
        try {
            byte[] b1 = longPathName.getBytes(StandardCharsets.UTF_8);
            byte[] b2 = longPathName.getBytes("cp1252");
            unicodeChars = b1.length != b2.length;
        }
        catch (UnsupportedEncodingException e) {
            return longPathName;
        }
        if (unicodeChars) {
            try {
                WString pathname = new WString(longPathName);
                char[] test = new char[2 + pathname.length() * 2];
                int r = Kernel32.INSTANCE.GetShortPathNameW(pathname, test, test.length);
                if (r > 0) {
                    String result = Native.toString(test);
                    LOGGER.trace("Using short path name of \"{}\": \"{}\"", (Object)pathname, (Object)result);
                    return result;
                }
                return longPathName;
            }
            catch (Exception e) {
                return longPathName;
            }
        }
        return longPathName;
    }

    private static String getWindowsDirectory() {
        char[] test = new char[514];
        int r = Kernel32.INSTANCE.GetWindowsDirectoryW(test, 256);
        if (r > 0) {
            return Native.toString(test);
        }
        return null;
    }

    @Override
    public String getDiskLabel(File f) {
        try {
            int nFileSystemNameSize;
            CharBuffer lpFileSystemNameBufferChar;
            LongByReference lpFileSystemFlags;
            LongByReference lpMaximumComponentLength;
            LongByReference lpVolumeSerialNumber;
            String driveName = f.getCanonicalPath().substring(0, 2) + "\\";
            char[] lpRootPathNameChars = new char[4];
            for (int i = 0; i < 3; ++i) {
                lpRootPathNameChars[i] = driveName.charAt(i);
            }
            lpRootPathNameChars[3] = '\u0000';
            int nVolumeNameSize = 256;
            CharBuffer lpVolumeNameBufferChar = CharBuffer.allocate(nVolumeNameSize);
            boolean result2 = Kernel32.INSTANCE.GetVolumeInformationW(lpRootPathNameChars, lpVolumeNameBufferChar, nVolumeNameSize, lpVolumeSerialNumber = new LongByReference(), lpMaximumComponentLength = new LongByReference(), lpFileSystemFlags = new LongByReference(), lpFileSystemNameBufferChar = CharBuffer.allocate(nFileSystemNameSize = 256), nFileSystemNameSize);
            if (!result2) {
                return null;
            }
            return WindowsUtils.charString2String(lpVolumeNameBufferChar);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static int getACP() {
        return Kernel32.INSTANCE.GetACP();
    }

    public static int getOEMCP() {
        return Kernel32.INSTANCE.GetOEMCP();
    }

    public static Charset getOEMCharset() {
        return WindowsUtils.getCharset(Kernel32.INSTANCE.GetOEMCP());
    }

    public static int getConsoleOutputCP() {
        return Kernel32.INSTANCE.GetConsoleOutputCP();
    }

    public static Charset getConsoleOutputCharset() {
        return WindowsUtils.getCharset(Kernel32.INSTANCE.GetOEMCP());
    }

    private static Charset getCharset(int codepage) {
        String[] aliases;
        Charset result = null;
        for (String alias : aliases = new String[]{"cp" + codepage, "MS" + codepage}) {
            try {
                result = Charset.forName(alias);
                break;
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                result = null;
            }
        }
        return result;
    }

    private static String charString2String(CharBuffer buf) {
        int i;
        char[] chars = buf.array();
        for (i = 0; i < chars.length && chars[i] != '\u0000'; ++i) {
        }
        return new String(chars, 0, i);
    }

    public WindowsUtils() {
        this.setVLCRegistryInfo();
        this.avsPluginsFolder = WindowsUtils.getAviSynthPluginsFolder();
        this.aviSynth = this.avsPluginsFolder != null;
        this.kLiteFiltersDir = WindowsUtils.getKLiteFiltersFolder();
        this.kerio = WindowsUtils.isKerioInstalled();
        this.psPing = WindowsUtils.findPsPing();
    }

    @Override
    public boolean isKerioFirewall() {
        return this.kerio;
    }

    @Override
    public String[] getPingCommand(String hostAddress, int count, int packetSize) {
        if (this.psPing != null) {
            return new String[]{this.psPing.toString(), "-w", "0", "-i", "0", "-n", Integer.toString(count), "-l", Integer.toString(packetSize), hostAddress};
        }
        return new String[]{"ping", "-n", Integer.toString(count), "-l", Integer.toString(packetSize), hostAddress};
    }

    @Override
    public String parsePingLine(String line) {
        if (this.psPing != null) {
            int msPos = line.indexOf("ms");
            if (msPos == -1) {
                return null;
            }
            return line.substring(line.lastIndexOf(58, msPos) + 1, msPos).trim();
        }
        return super.parsePingLine(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAdmin() {
        Object object = IS_ADMIN_LOCK;
        synchronized (object) {
            if (isAdmin != null) {
                return isAdmin;
            }
            if (OS_VERSION.isGreaterThanOrEqualTo("5.1.0")) {
                try {
                    String[] command = new String[]{"reg", "query", "\"HKU\\S-1-5-19\""};
                    Process p = Runtime.getRuntime().exec(command);
                    p.waitFor();
                    int exitValue = p.exitValue();
                    if (0 == exitValue) {
                        isAdmin = true;
                        return true;
                    }
                    isAdmin = false;
                }
                catch (IOException e) {
                    isAdmin = false;
                    LOGGER.error("An error prevented UMS from checking Windows permissions: {}", (Object)e.getMessage());
                }
                catch (InterruptedException e) {
                    isAdmin = false;
                    Thread.currentThread().interrupt();
                }
            } else {
                isAdmin = true;
            }
            return isAdmin;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Path> getDefaultFolders() {
        Object object = DEFAULT_FOLDERS_LOCK;
        synchronized (object) {
            if (defaultFolders == null) {
                ArrayList<Path> result = new ArrayList<Path>();
                if (OS_VERSION.isGreaterThanOrEqualTo("6.0.0")) {
                    List<GUID> knownFolders = UmsConfiguration.isUserProfile() ? List.of(KnownFolders.FOLDERID_MUSIC, KnownFolders.FOLDERID_PICTURES, KnownFolders.FOLDERID_VIDEOS) : List.of(KnownFolders.FOLDERID_PUBLIC_MUSIC, KnownFolders.FOLDERID_PUBLIC_PICTURES, KnownFolders.FOLDERID_PUBLIC_VIDEOS);
                    for (GUID guid : knownFolders) {
                        Path folder = WindowsUtils.getWindowsKnownFolder(guid);
                        if (folder == null) continue;
                        result.add(folder);
                    }
                } else {
                    CSIDL[] csidls;
                    for (CSIDL csidl : csidls = new CSIDL[]{CSIDL.CSIDL_MYMUSIC, CSIDL.CSIDL_MYPICTURES, CSIDL.CSIDL_MYVIDEO}) {
                        Path folder = CSIDL.getWindowsFolder(csidl);
                        if (folder == null) continue;
                        result.add(folder);
                    }
                }
                defaultFolders = Collections.unmodifiableList(result);
            }
            return defaultFolders;
        }
    }

    @Override
    public Version getFileVersionInfo(String filePath) {
        try {
            VerRsrc.VS_FIXEDFILEINFO version = VersionUtil.getFileVersionInfo(filePath);
            Version fileVersion = new Version(version.getFileVersionMajor() + "." + version.getFileVersionMinor() + "." + version.getFileVersionRevision() + "." + version.getFileVersionBuild());
            if (fileVersion.isGreaterThan(new Version("0.0.0.0"))) {
                return fileVersion;
            }
            return new Version(version.getProductVersionMajor() + "." + version.getProductVersionMinor() + "." + version.getProductVersionRevision() + "." + version.getProductVersionBuild());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getiTunesFile() throws IOException {
        Process process = Runtime.getRuntime().exec(new String[]{"reg", "query", "\"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\"", "/v", "\"My Music\""});
        Object location = null;
        try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = in.readLine()) != null) {
                String lookFor = "REG_SZ";
                if (!line.contains("REG_SZ")) continue;
                location = line.substring(line.indexOf("REG_SZ") + "REG_SZ".length()).trim();
            }
        }
        if (location != null) {
            location = location + "\\iTunes\\iTunes Music Library.xml";
            return location;
        }
        LOGGER.info("Could not find the My Music folder");
        return null;
    }

    @Override
    public String getDefaultFontPath() {
        File fontsDir;
        File winDirFile;
        String font = null;
        String winDir = WindowsUtils.getWindowsDirectory();
        if (winDir != null && (winDirFile = new File(winDir)).exists() && (fontsDir = new File(winDirFile, "Fonts")).exists()) {
            File arialDir = new File(fontsDir, "Arial.ttf");
            if (arialDir.exists()) {
                font = arialDir.getAbsolutePath();
            } else {
                arialDir = new File(fontsDir, "arial.ttf");
                if (arialDir.exists()) {
                    font = arialDir.getAbsolutePath();
                }
            }
        }
        if (font == null) {
            font = WindowsUtils.getAbsolutePath("C:\\Windows\\Fonts", "Arial.ttf");
        }
        if (font == null) {
            font = WindowsUtils.getAbsolutePath("C:\\WINNT\\Fonts", "Arial.ttf");
        }
        if (font == null) {
            font = WindowsUtils.getAbsolutePath("D:\\Windows\\Fonts", "Arial.ttf");
        }
        if (font == null) {
            font = WindowsUtils.getAbsolutePath(".\\bin\\mplayer\\", "subfont.ttf");
        }
        return font;
    }

    @Override
    public boolean isPreventSleepSupported() {
        return true;
    }

    @Override
    public AbstractSleepWorker getSleepWorker(SleepManager owner, PreventSleepMode mode) {
        return new WindowsSleepWorker(owner, mode);
    }

    @Override
    public AbstractProcessTerminator getProcessTerminator(ProcessManager processManager) {
        return new WindowsProcessTerminator(processManager);
    }

    @Override
    public IPipeProcess getPipeProcess(String pipeName, OutputParams params, String ... extras) {
        return new WindowsPipeProcess(pipeName, params, extras);
    }

    @Override
    public void appendErrorString(StringBuilder sb, int exitCode) {
        NTStatus ntStatus = null;
        if (exitCode > 10) {
            ntStatus = NTStatus.typeOf(exitCode);
        }
        if (ntStatus != null) {
            sb.append("Process exited with error ").append((Object)ntStatus).append("\n");
        } else {
            sb.append("Process exited with code ").append(exitCode).append(":\n");
        }
    }

    private void setVLCRegistryInfo() {
        String key = "SOFTWARE\\VideoLAN\\VLC";
        try {
            if (!Advapi32Util.registryKeyExists(WinReg.HKEY_LOCAL_MACHINE, key) && !Advapi32Util.registryKeyExists(WinReg.HKEY_LOCAL_MACHINE, key = "SOFTWARE\\Wow6432Node\\VideoLAN\\VLC")) {
                return;
            }
            this.vlcPath = Paths.get(Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, key, ""), new String[0]);
            this.vlcVersion = new Version(Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, key, "Version"));
        }
        catch (Win32Exception e) {
            LOGGER.debug("Could not get VLC information from Windows registry: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    @Override
    public String[] getShutdownCommand() {
        return new String[]{"shutdown.exe", "-s", "-t", "0"};
    }

    @Override
    public String getJvmExecutableName() {
        return System.console() == null ? "javaw.exe" : "java.exe";
    }

    private static String getAviSynthPluginsFolder() {
        String key = "SOFTWARE\\AviSynth";
        try {
            if (!Advapi32Util.registryKeyExists(WinReg.HKEY_LOCAL_MACHINE, key) && !Advapi32Util.registryKeyExists(WinReg.HKEY_LOCAL_MACHINE, key = "SOFTWARE\\Wow6432Node\\AviSynth")) {
                return null;
            }
            return Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, key, "plugindir2_5");
        }
        catch (Win32Exception e) {
            LOGGER.debug("Could not get AviSynth information from Windows registry: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
            return null;
        }
    }

    private static String getKLiteFiltersFolder() {
        String key = "SOFTWARE\\Wow6432Node\\KLCodecPack";
        try {
            if (!Advapi32Util.registryKeyExists(WinReg.HKEY_LOCAL_MACHINE, key) && !Advapi32Util.registryKeyExists(WinReg.HKEY_LOCAL_MACHINE, key = "SOFTWARE\\KLCodecPack")) {
                return null;
            }
            return Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, key, "installdir");
        }
        catch (Win32Exception e) {
            LOGGER.debug("Could not get K-Lite Codec Pack information from Windows registry: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
            return null;
        }
    }

    private static boolean isKerioInstalled() {
        try {
            String key = "SOFTWARE\\Kerio";
            if (!Advapi32Util.registryKeyExists(WinReg.HKEY_LOCAL_MACHINE, key)) {
                key = "SOFTWARE\\Wow6432Node\\Kerio";
                return Advapi32Util.registryKeyExists(WinReg.HKEY_LOCAL_MACHINE, key);
            }
            return true;
        }
        catch (Win32Exception e) {
            LOGGER.debug("Could not get Kerio information from Windows registry: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
            return false;
        }
    }

    private static Path findPsPing() {
        Path tmpPsPing = FileUtil.findExecutableInOSPath(Paths.get("psping64.exe", new String[0]));
        if (tmpPsPing == null) {
            tmpPsPing = FileUtil.findExecutableInOSPath(Paths.get("psping.exe", new String[0]));
        }
        return tmpPsPing;
    }

    @Nullable
    private static Path getWindowsKnownFolder(GUID guid) {
        try {
            String folderPath = Shell32Util.getKnownFolderPath(guid);
            if (StringUtils.isNotBlank(folderPath)) {
                Path folder = Paths.get(folderPath, new String[0]);
                try {
                    FilePermissions permissions = new FilePermissions(folder, new LinkOption[0]);
                    if (permissions.isBrowsable()) {
                        return folder;
                    }
                    LOGGER.warn("Insufficient permissions to read default folder \"{}\"", (Object)guid);
                }
                catch (FileNotFoundException e) {
                    LOGGER.debug("Default folder \"{}\" not found", (Object)folder);
                }
            }
        }
        catch (Win32Exception e) {
            LOGGER.debug("Default folder \"{}\" not found: {}", (Object)guid, (Object)e.getMessage());
        }
        catch (InvalidPathException e) {
            LOGGER.error("Unexpected error while resolving default Windows folder with GUID {}: {}", (Object)guid, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    public static boolean isUmsServiceInstalled() {
        String[] commands = new String[]{"sc", "query", "\"Universal Media Server\""};
        int[] expectedExitCodes = new int[]{0, 1060};
        String response = ProcessUtil.run(expectedExitCodes, commands);
        return response.contains("TYPE");
    }

    public static boolean installWin32Service() {
        Path wrapper = PlatformProgramPaths.resolve("service/wrapper.exe");
        if (wrapper == null || !Files.exists(wrapper, new LinkOption[0])) {
            return false;
        }
        String[] cmdArray = new String[]{wrapper.toFile().getAbsolutePath(), "-i", "wrapper.conf"};
        ProcessWrapperImpl pwinstall = new ProcessWrapperImpl(cmdArray, true, new OutputParams(PMS.getConfiguration()));
        pwinstall.runInSameThread();
        return pwinstall.isSuccess();
    }

    public static boolean uninstallWin32Service() {
        Path wrapper = PlatformProgramPaths.resolve("service/wrapper.exe");
        if (wrapper == null || !Files.exists(wrapper, new LinkOption[0])) {
            return false;
        }
        String[] cmdArray = new String[]{wrapper.toFile().getAbsolutePath(), "-r", "wrapper.conf"};
        OutputParams output = new OutputParams(PMS.getConfiguration());
        output.setNoExitCheck(true);
        ProcessWrapperImpl pwuninstall = new ProcessWrapperImpl(cmdArray, true, output);
        pwuninstall.runInSameThread();
        return true;
    }

    public static boolean isVersionThatSleepsImmediately() {
        return StringUtils.equals(System.getProperty("os.name"), "Windows 11");
    }
}

