/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.windows;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsRegistry.class);

    public static String readRegistry(String location, String key) {
        try {
            String parsed;
            String[] query = new String[]{"reg", "query", "\"" + location + "\"", "/v", "\"" + key + "\""};
            Process process = Runtime.getRuntime().exec(query);
            StreamReader reader = new StreamReader(process.getInputStream(), System.getProperty("file.encoding"));
            reader.start();
            process.waitFor();
            reader.join();
            if (reader.getResult().length() > 6 && (parsed = reader.getResult().substring(reader.getResult().indexOf("REG_SZ") + 6).trim()).length() > 1) {
                return parsed;
            }
        }
        catch (IOException query) {
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    private WindowsRegistry() {
    }

    static class StreamReader
    extends Thread {
        private final InputStream inputStream;
        private final String charsetName;
        private final StringBuilder result = new StringBuilder();

        public StreamReader(InputStream is, String charsetName) {
            this.inputStream = is;
            this.charsetName = charsetName;
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.inputStream, this.charsetName));
                while ((line = br.readLine()) != null) {
                    this.result.append(line);
                }
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error(null, e);
            }
            catch (IOException e1) {
                LOGGER.error(null, e1);
            }
        }

        public String getResult() {
            return this.result.toString();
        }
    }
}

