/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.windows;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.pms.io.BufferedOutputFile;
import net.pms.io.IPipeProcess;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.platform.windows.WindowsNamedPipe;

public class WindowsPipeProcess
implements IPipeProcess {
    private WindowsNamedPipe mk;

    public WindowsPipeProcess(String pipeName, OutputParams params, String ... extras) {
        boolean forcereconnect = false;
        boolean in = true;
        if (extras != null && extras.length > 0 && extras[0].equals("out")) {
            in = false;
        }
        if (extras != null) {
            for (String extra : extras) {
                if (!extra.equals("reconnect")) continue;
                forcereconnect = true;
            }
        }
        this.mk = new WindowsNamedPipe(pipeName, forcereconnect, in, params);
    }

    public WindowsPipeProcess(String pipeName, String ... extras) {
        this(pipeName, (OutputParams)null, extras);
    }

    @Override
    public String getInputPipe() {
        return this.mk.getPipeName();
    }

    @Override
    public String getOutputPipe() {
        return this.mk.getPipeName();
    }

    @Override
    public ProcessWrapper getPipeProcess() {
        return this.mk;
    }

    @Override
    public void deleteLater() {
    }

    @Override
    public BufferedOutputFile getDirectBuffer() {
        return this.mk.getDirectBuffer();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.mk.getReadable();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.mk.getWritable();
    }
}

