/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.windows;

import com.sun.jna.platform.win32.Shell32Util;
import com.sun.jna.platform.win32.Win32Exception;
import java.io.FileNotFoundException;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import net.pms.platform.windows.WindowsUtils;
import net.pms.util.FilePermissions;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CSIDL {
    CSIDL_COMMON_MUSIC(53),
    CSIDL_COMMON_PICTURES(54),
    CSIDL_COMMON_VIDEO(55),
    CSIDL_DESKTOP(0),
    CSIDL_MYMUSIC(13),
    CSIDL_MYPICTURES(39),
    CSIDL_MYVIDEO(14);

    private static final Logger LOGGER;
    private final int value;

    private CSIDL(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    @Nullable
    public static Path getWindowsFolder(@Nullable CSIDL csidl) {
        if (csidl == null) {
            return null;
        }
        try {
            String folderPath = Shell32Util.getFolderPath(csidl.getValue());
            if (StringUtils.isNotBlank(folderPath)) {
                Path folder = Paths.get(folderPath, new String[0]);
                try {
                    FilePermissions permissions = new FilePermissions(folder, new LinkOption[0]);
                    if (permissions.isBrowsable()) {
                        return folder;
                    }
                    LOGGER.warn("Insufficient permissions to read default folder \"{}\"", (Object)csidl);
                }
                catch (FileNotFoundException e) {
                    LOGGER.debug("Default folder \"{}\" not found", (Object)folder);
                }
            }
        }
        catch (Win32Exception e) {
            LOGGER.debug("Default folder \"{}\" not found: {}", (Object)csidl, (Object)e.getMessage());
        }
        catch (InvalidPathException e) {
            LOGGER.error("Unexpected error while resolving default Windows folder with id {}: {}", (Object)csidl, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    static {
        LOGGER = LoggerFactory.getLogger(WindowsUtils.class);
    }
}

