/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.mac.corefoundation;

import com.sun.jna.DefaultTypeMapper;
import com.sun.jna.FromNativeContext;
import com.sun.jna.Function;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.ptr.ShortByReference;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.pms.platform.jna.JnaIntEnum;
import net.pms.platform.jna.JnaIntEnumConverter;
import net.pms.platform.jna.JnaLongEnum;
import net.pms.platform.jna.JnaLongEnumConverter;
import net.pms.platform.jna.StringByReference;
import net.pms.platform.mac.corefoundation.CFTypeArrayRef;
import net.pms.platform.mac.corefoundation.TerminatedStringEncodingArray;
import net.pms.platform.mac.kernreturn.KernReturnT;
import net.pms.platform.mac.kernreturn.KernReturnTConverter;

@SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"})
public interface CoreFoundation
extends Library {
    public static final Map<String, Object> options = Collections.unmodifiableMap(new HashMap<String, Object>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("type-mapper", new DefaultTypeMapper(){
                {
                    this.addTypeConverter(JnaIntEnum.class, new JnaIntEnumConverter());
                    this.addTypeConverter(JnaLongEnum.class, new JnaLongEnumConverter());
                    this.addTypeConverter(KernReturnT.class, new KernReturnTConverter());
                }
            });
        }
    });
    public static final CoreFoundation INSTANCE = Native.load("CoreFoundation", CoreFoundation.class, options);
    public static final CFAllocatorRef ALLOCATOR = INSTANCE.CFAllocatorGetDefault();
    public static final NativeLibrary NATIVE_LIBRARY_INSTANCE = NativeLibrary.getInstance("CoreFoundation");
    public static final Pointer kCFTypeArrayCallBacks = NATIVE_LIBRARY_INSTANCE.getGlobalVariableAddress("kCFTypeArrayCallBacks");
    public static final CFAllocatorRef kCFAllocatorDefault = new CFAllocatorRef();

    public long CFNullGetTypeID();

    public long CFAllocatorGetTypeID();

    public long CFGetTypeID(CFTypeRef var1);

    public CFStringRef CFCopyTypeIDDescription(long var1);

    public CFTypeRef CFRetain(CFTypeRef var1);

    public void CFRelease(CFTypeRef var1);

    public NativeLong CFGetRetainCount(CFTypeRef var1);

    public boolean CFEqual(CFTypeRef var1, CFTypeRef var2);

    public long CFHash(CFTypeRef var1);

    public CFStringRef CFCopyDescription(CFTypeRef var1);

    public long CFNumberGetTypeID();

    public CFNumberRef CFNumberCreate(CFAllocatorRef var1, CFNumberType var2, PointerType var3);

    public CFNumberType CFNumberGetType(CFNumberRef var1);

    public long CFNumberGetByteSize(CFNumberRef var1);

    public boolean CFNumberIsFloatType(CFNumberRef var1);

    public boolean CFNumberGetValue(CFNumberRef var1, CFNumberType var2, ByReference var3);

    public boolean CFNumberGetValue(CFNumberRef var1, CFNumberType var2, Pointer var3);

    public long CFBooleanGetTypeID();

    public boolean CFBooleanGetValue(CFBooleanRef var1);

    public long CFArrayGetTypeID();

    public CFArrayRef CFArrayCreate(CFAllocatorRef var1, CFTypeArrayRef var2, long var3, Pointer var5);

    public CFArrayRef CFArrayCreateCopy(CFAllocatorRef var1, CFArrayRef var2);

    public CFMutableArrayRef CFArrayCreateMutable(CFAllocatorRef var1, long var2, Pointer var4);

    public CFMutableArrayRef CFArrayCreateMutableCopy(CFAllocatorRef var1, long var2, CFArrayRef var4);

    public long CFArrayGetCount(CFArrayRef var1);

    public CFTypeRef CFArrayGetValueAtIndex(CFArrayRef var1, long var2);

    public void CFArrayAppendValue(CFMutableArrayRef var1, CFTypeRef var2);

    public void CFArrayInsertValueAtIndex(CFMutableArrayRef var1, long var2, CFTypeRef var4);

    public void CFArraySetValueAtIndex(CFMutableArrayRef var1, long var2, CFTypeRef var4);

    public void CFArrayRemoveValueAtIndex(CFMutableArrayRef var1, long var2);

    public void CFArrayRemoveAllValues(CFMutableArrayRef var1);

    public void CFArrayExchangeValuesAtIndices(CFMutableArrayRef var1, long var2, long var4);

    public long CFStringGetTypeID();

    public CFStringRef CFStringCreateWithCString(CFAllocatorRef var1, String var2, int var3);

    public CFStringRef CFStringCreateWithBytes(CFAllocatorRef var1, byte[] var2, long var3, int var5, boolean var6);

    public CFStringRef CFStringCreateWithCharacters(CFAllocatorRef var1, char[] var2, long var3);

    public CFStringRef CFStringCreateCopy(CFAllocatorRef var1, CFStringRef var2);

    public CFMutableStringRef CFStringCreateMutable(CFAllocatorRef var1, long var2);

    public CFMutableStringRef CFStringCreateMutableCopy(CFAllocatorRef var1, long var2, CFStringRef var4);

    public long CFStringGetLength(CFStringRef var1);

    public char CFStringGetCharacterAtIndex(CFStringRef var1, long var2);

    public boolean CFStringGetCString(CFStringRef var1, StringByReference var2, long var3, int var5);

    public StringByReference CFStringGetCStringPtr(CFStringRef var1, int var2);

    public int CFStringGetSmallestEncoding(CFStringRef var1);

    public int CFStringGetFastestEncoding(CFStringRef var1);

    public int CFStringGetSystemEncoding();

    public long CFStringGetMaximumSizeForEncoding(long var1, int var3);

    public boolean CFStringGetFileSystemRepresentation(CFStringRef var1, StringByReference var2, long var3);

    public long CFStringGetMaximumSizeOfFileSystemRepresentation(CFStringRef var1);

    public CFStringRef CFStringCreateWithFileSystemRepresentation(CFAllocatorRef var1, StringByReference var2);

    public CFComparisonResult CFStringCompare(CFStringRef var1, CFStringRef var2, long var3);

    public boolean CFStringIsEncodingAvailable(int var1);

    public TerminatedStringEncodingArray CFStringGetListOfAvailableEncodings();

    public CFStringRef CFStringGetNameOfEncoding(int var1);

    public NativeLong CFStringConvertEncodingToNSStringEncoding(int var1);

    public int CFStringConvertNSStringEncodingToEncoding(NativeLong var1);

    public int CFStringConvertEncodingToWindowsCodepage(int var1);

    public int CFStringConvertWindowsCodepageToEncoding(int var1);

    public int CFStringConvertIANACharSetNameToEncoding(CFStringRef var1);

    public CFStringRef CFStringConvertEncodingToIANACharSetName(int var1);

    public int CFStringGetMostCompatibleMacStringEncoding(int var1);

    public long CFDictionaryGetTypeID();

    public CFDictionaryRef CFDictionaryCreateCopy(CFAllocatorRef var1, CFDictionaryRef var2);

    public CFMutableDictionaryRef CFDictionaryCreateMutable(CFAllocatorRef var1, long var2, Pointer var4, Pointer var5);

    public CFMutableDictionaryRef CFDictionaryCreateMutableCopy(CFAllocatorRef var1, long var2, CFDictionaryRef var4);

    public long CFDictionaryGetCount(CFDictionaryRef var1);

    public long CFDictionaryGetCountOfKey(CFDictionaryRef var1, CFTypeRef var2);

    public long CFDictionaryGetCountOfValue(CFDictionaryRef var1, CFTypeRef var2);

    public boolean CFDictionaryContainsKey(CFDictionaryRef var1, CFTypeRef var2);

    public boolean CFDictionaryContainsValue(CFDictionaryRef var1, CFTypeRef var2);

    public CFTypeRef CFDictionaryGetValue(CFDictionaryRef var1, CFTypeRef var2);

    public boolean CFDictionaryGetValueIfPresent(CFDictionaryRef var1, CFTypeRef var2, PointerByReference var3);

    public void CFDictionaryGetKeysAndValues(CFDictionaryRef var1, CFTypeArrayRef var2, CFTypeArrayRef var3);

    public void CFDictionaryAddValue(CFMutableDictionaryRef var1, CFTypeRef var2, CFTypeRef var3);

    public void CFDictionarySetValue(CFMutableDictionaryRef var1, CFTypeRef var2, CFTypeRef var3);

    public void CFDictionaryReplaceValue(CFMutableDictionaryRef var1, CFTypeRef var2, CFTypeRef var3);

    public void CFDictionaryRemoveValue(CFMutableDictionaryRef var1, CFTypeRef var2);

    public void CFDictionaryRemoveAllValues(CFMutableDictionaryRef var1);

    public CFAllocatorRef CFAllocatorGetDefault();

    public long CFDataGetTypeID();

    public CFDataRef CFDataCreate(CFAllocatorRef var1, byte[] var2, long var3);

    public CFDataRef CFDataCreateCopy(CFAllocatorRef var1, CFDataRef var2);

    public CFMutableDataRef CFDataCreateMutable(CFAllocatorRef var1, long var2);

    public CFMutableDataRef CFDataCreateMutableCopy(CFAllocatorRef var1, long var2, CFDataRef var4);

    public long CFDataGetLength(CFTypeRef var1);

    public PointerByReference CFDataGetBytePtr(CFDataRef var1);

    public PointerByReference CFDataGetMutableBytePtr(CFMutableDataRef var1);

    public void CFDataSetLength(CFMutableDataRef var1, long var2);

    public void CFDataIncreaseLength(CFMutableDataRef var1, long var2);

    public void CFDataAppendBytes(CFMutableDataRef var1, byte[] var2, long var3);

    public static class CFAllocatorRef
    extends CFTypeRef {
        public CFAllocatorRef() {
        }

        public CFAllocatorRef(Pointer p) {
            super(p);
        }
    }

    public static enum CFComparisonResult implements JnaLongEnum<CFComparisonResult>
    {
        kCFCompareLessThan(-1),
        kCFCompareEqualTo(0),
        kCFCompareGreaterThan(1);

        private final int value;

        private CFComparisonResult(int value) {
            this.value = value;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public CFComparisonResult typeForValue(long value) {
            return CFComparisonResult.typeOf(value);
        }

        public static CFComparisonResult typeOf(long value) {
            if (value > 0L) {
                return kCFCompareGreaterThan;
            }
            if (value < 0L) {
                return kCFCompareLessThan;
            }
            return kCFCompareEqualTo;
        }
    }

    public static enum CFDataSearchFlags implements JnaLongEnum<CFDataSearchFlags>
    {
        kCFDataSearchBackwards(1L),
        kCFDataSearchAnchored(2L);

        private final long value;

        private CFDataSearchFlags(long value) {
            this.value = value;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public CFDataSearchFlags typeForValue(long value) {
            return CFDataSearchFlags.typeOf(value);
        }

        public static CFDataSearchFlags typeOf(long value) {
            for (CFDataSearchFlags entry : CFDataSearchFlags.values()) {
                if (value != entry.getValue()) continue;
                return entry;
            }
            return null;
        }
    }

    public static enum CFStringNormalizationForm implements JnaLongEnum<CFStringNormalizationForm>
    {
        kCFStringNormalizationFormD(0L),
        kCFStringNormalizationFormKD(1L),
        kCFStringNormalizationFormC(2L),
        kCFStringNormalizationFormKC(3L);

        private final long value;

        private CFStringNormalizationForm(long value) {
            this.value = value;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public CFStringNormalizationForm typeForValue(long value) {
            return CFStringNormalizationForm.typeOf(value);
        }

        public static CFStringNormalizationForm typeOf(long value) {
            for (CFStringNormalizationForm entry : CFStringNormalizationForm.values()) {
                if (value != entry.getValue()) continue;
                return entry;
            }
            return null;
        }
    }

    public static enum CFStringCompareFlags implements JnaLongEnum<CFStringCompareFlags>
    {
        kCFCompareCaseInsensitive(1L),
        kCFCompareBackwards(4L),
        kCFCompareAnchored(8L),
        kCFCompareNonliteral(16L),
        kCFCompareLocalized(32L),
        kCFCompareNumerically(64L),
        kCFCompareDiacriticInsensitive(128L),
        kCFCompareWidthInsensitive(256L),
        kCFCompareForcedOrdering(512L);

        private final long value;

        private CFStringCompareFlags(long value) {
            this.value = value;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public CFStringCompareFlags typeForValue(long value) {
            return CFStringCompareFlags.typeOf(value);
        }

        public static CFStringCompareFlags typeOf(long value) {
            for (CFStringCompareFlags entry : CFStringCompareFlags.values()) {
                if (value != entry.getValue()) continue;
                return entry;
            }
            return null;
        }
    }

    public static enum CFStringBuiltInEncodings implements JnaIntEnum<CFStringBuiltInEncodings>
    {
        kCFStringEncodingMacRoman(0),
        kCFStringEncodingWindowsLatin1(1280),
        kCFStringEncodingISOLatin1(513),
        kCFStringEncodingNextStepLatin(2817),
        kCFStringEncodingASCII(1536),
        kCFStringEncodingUnicode(256),
        kCFStringEncodingUTF8(0x8000100),
        kCFStringEncodingNonLossyASCII(3071),
        kCFStringEncodingUTF16(256),
        kCFStringEncodingUTF16BE(0x10000100),
        kCFStringEncodingUTF16LE(0x14000100),
        kCFStringEncodingUTF32(0xC000100),
        kCFStringEncodingUTF32BE(0x18000100),
        kCFStringEncodingUTF32LE(0x1C000100),
        kCFStringEncodingInvalidId(-1);

        private final int value;

        private CFStringBuiltInEncodings(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public CFStringBuiltInEncodings typeForValue(int value) {
            return CFStringBuiltInEncodings.typeOf(value);
        }

        public static CFStringBuiltInEncodings typeOf(int value) {
            for (CFStringBuiltInEncodings entry : CFStringBuiltInEncodings.values()) {
                if (value != entry.getValue()) continue;
                return entry;
            }
            return null;
        }
    }

    public static enum CFNumberType implements JnaLongEnum<CFNumberType>
    {
        kCFNumberSInt8Type(1),
        kCFNumberSInt16Type(2),
        kCFNumberSInt32Type(3),
        kCFNumberSInt64Type(4),
        kCFNumberFloat32Type(5),
        kCFNumberFloat64Type(6),
        kCFNumberCharType(7),
        kCFNumberShortType(8),
        kCFNumberIntType(9),
        kCFNumberLongType(10),
        kCFNumberLongLongType(11),
        kCFNumberFloatType(12),
        kCFNumberDoubleType(13),
        kCFNumberCFIndexType(14),
        kCFNumberNSIntegerType(15),
        kCFNumberCGFloatType(16),
        kCFNumberMaxType(16);

        private final long value;

        private CFNumberType(int value) {
            this.value = value;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public CFNumberType typeForValue(long value) {
            return CFNumberType.typeOf(value);
        }

        public static CFNumberType typeOf(long value) {
            for (CFNumberType entry : CFNumberType.values()) {
                if (value != entry.getValue()) continue;
                return entry;
            }
            return null;
        }
    }

    public static class CFMutableDataRefByReference
    extends CFTypeRefByReference {
        @Override
        protected CFMutableDataRef newInstance() {
            return new CFMutableDataRef(this.getPointer().getPointer(0L));
        }

        public CFMutableDataRef getCFMutableDataRef() {
            return (CFMutableDataRef)this.getCFTypeRef();
        }
    }

    public static class CFMutableDataRef
    extends CFDataRef {
        public CFMutableDataRef() {
        }

        public CFMutableDataRef(Pointer p) {
            super(p);
        }
    }

    public static class CFDataRefByReference
    extends CFTypeRefByReference {
        @Override
        protected CFDataRef newInstance() {
            return new CFDataRef(this.getPointer().getPointer(0L));
        }

        public CFDataRef getCFDataRef() {
            return (CFDataRef)this.getCFTypeRef();
        }
    }

    public static class CFDataRef
    extends CFTypeRef {
        public CFDataRef() {
        }

        public CFDataRef(Pointer p) {
            super(p);
        }
    }

    public static class CFMutableDictionaryRefByReference
    extends CFTypeRefByReference {
        @Override
        protected CFMutableDictionaryRef newInstance() {
            return new CFMutableDictionaryRef(this.getPointer().getPointer(0L));
        }

        public CFMutableDictionaryRef getCFMutableDictionaryRef() {
            return (CFMutableDictionaryRef)this.getCFTypeRef();
        }
    }

    public static class CFMutableDictionaryRef
    extends CFDictionaryRef {
        public CFMutableDictionaryRef() {
        }

        public CFMutableDictionaryRef(Pointer p) {
            super(p);
        }
    }

    public static class CFDictionaryRefByReference
    extends CFTypeRefByReference {
        @Override
        protected CFDictionaryRef newInstance() {
            return new CFDictionaryRef(this.getPointer().getPointer(0L));
        }

        public CFDictionaryRef getCFDictionaryRef() {
            return (CFDictionaryRef)this.getCFTypeRef();
        }
    }

    public static class CFDictionaryRef
    extends CFTypeRef {
        public CFDictionaryRef() {
        }

        public CFDictionaryRef(Pointer p) {
            super(p);
        }
    }

    public static class CFMutableStringRefByReference
    extends CFTypeRefByReference {
        @Override
        protected CFMutableStringRef newInstance() {
            return new CFMutableStringRef(this.getPointer().getPointer(0L));
        }

        public CFMutableStringRef getCFMutableStringRef() {
            return (CFMutableStringRef)this.getCFTypeRef();
        }
    }

    public static class CFMutableStringRef
    extends CFStringRef {
        public CFMutableStringRef() {
        }

        public CFMutableStringRef(Pointer p) {
            super(p);
        }

        public CFMutableStringRef(CFTypeRef cfMutableString) {
            super(cfMutableString == null ? null : cfMutableString.getPointer());
        }
    }

    public static class CFStringRefByReference
    extends CFTypeRefByReference {
        @Override
        protected CFStringRef newInstance() {
            return new CFStringRef(this.getPointer().getPointer(0L));
        }

        public CFStringRef getCFStringRef() {
            return (CFStringRef)this.getCFTypeRef();
        }
    }

    public static class CFStringRef
    extends CFTypeRef {
        public CFStringRef() {
        }

        public CFStringRef(Pointer p) {
            super(p);
        }

        public CFStringRef(CFTypeRef cfString) {
            super(cfString == null ? null : cfString.getPointer());
        }

        public static CFStringRef toCFStringRef(String string) {
            if (string == null) {
                return null;
            }
            char[] chars = string.toCharArray();
            int length = chars.length;
            return INSTANCE.CFStringCreateWithCharacters(null, chars, length);
        }

        public CFComparisonResult compareTo(CFStringRef other) {
            return this.compareTo(other, null);
        }

        public CFComparisonResult compareTo(CFStringRef other, CFStringCompareFlags ... compareOptions) {
            if (other == null) {
                return CFComparisonResult.kCFCompareLessThan;
            }
            if (other.getPointer() == Pointer.NULL) {
                return this.getPointer() == Pointer.NULL ? CFComparisonResult.kCFCompareEqualTo : CFComparisonResult.kCFCompareLessThan;
            }
            if (this.getPointer() == null) {
                return CFComparisonResult.kCFCompareLessThan;
            }
            long flags = 0L;
            if (compareOptions != null) {
                for (CFStringCompareFlags flag : compareOptions) {
                    if (flag == null) continue;
                    flags |= flag.getValue();
                }
            }
            return INSTANCE.CFStringCompare(this, other, flags);
        }

        @Override
        public String toString() {
            if (this.getPointer() == null) {
                return "null";
            }
            long maxSize = Math.max(INSTANCE.CFStringGetMaximumSizeForEncoding(INSTANCE.CFStringGetLength(this), CFStringBuiltInEncodings.kCFStringEncodingUTF8.getValue()), 1L);
            StringByReference buffer = new StringByReference(maxSize);
            INSTANCE.CFStringGetCString(this, buffer, maxSize, CFStringBuiltInEncodings.kCFStringEncodingUTF8.getValue());
            return buffer.getValue(StandardCharsets.UTF_8);
        }
    }

    public static class CFMutableArrayRefByReference
    extends CFTypeRefByReference {
        @Override
        protected CFMutableArrayRef newInstance() {
            return new CFMutableArrayRef(this.getPointer().getPointer(0L));
        }

        public CFMutableArrayRef getCFMutableArrayRef() {
            return (CFMutableArrayRef)this.getCFTypeRef();
        }
    }

    public static class CFMutableArrayRef
    extends CFArrayRef {
        public CFMutableArrayRef() {
        }

        public CFMutableArrayRef(Pointer p) {
            super(p);
        }
    }

    public static class CFArrayRefByReference
    extends CFTypeRefByReference {
        @Override
        protected CFArrayRef newInstance() {
            return new CFArrayRef(this.getPointer().getPointer(0L));
        }

        public CFArrayRef getCFArrayRef() {
            return (CFArrayRef)this.getCFTypeRef();
        }
    }

    public static class CFArrayRef
    extends CFTypeRef {
        public CFArrayRef() {
        }

        public CFArrayRef(Pointer p) {
            super(p);
        }

        public CFArrayRef(CFTypeRef cfArray) {
            super(cfArray == null ? null : cfArray.getPointer());
        }
    }

    public static class CFBooleanRefByReference
    extends CFTypeRefByReference {
        @Override
        protected CFBooleanRef newInstance() {
            return new CFBooleanRef(this.getPointer().getPointer(0L));
        }

        public CFBooleanRef getCFBooleanRef() {
            return (CFBooleanRef)this.getCFTypeRef();
        }
    }

    public static class CFBooleanRef
    extends CFTypeRef {
        public CFBooleanRef() {
        }

        public CFBooleanRef(Pointer p) {
            super(p);
        }
    }

    public static class CFNumberRefByReference
    extends CFTypeRefByReference {
        @Override
        protected CFNumberRef newInstance() {
            return new CFNumberRef(this.getPointer().getPointer(0L));
        }

        public CFNumberRef getCFNumberRef() {
            return (CFNumberRef)this.getCFTypeRef();
        }
    }

    public static class CFNumberRef
    extends CFTypeRef {
        public CFNumberRef() {
        }

        public CFNumberRef(Pointer p) {
            super(p);
        }

        public CFNumberRef(CFTypeRef cfNumber) {
            super(cfNumber == null ? null : cfNumber.getPointer());
        }

        public static CFNumberRef toCFNumberRef(byte value) {
            return INSTANCE.CFNumberCreate(ALLOCATOR, CFNumberType.kCFNumberSInt8Type, new ByteByReference(value));
        }

        public static CFNumberRef toCFNumberRef(short value) {
            return INSTANCE.CFNumberCreate(ALLOCATOR, CFNumberType.kCFNumberSInt16Type, new ShortByReference(value));
        }

        public static CFNumberRef toCFNumberRef(int value) {
            return INSTANCE.CFNumberCreate(ALLOCATOR, CFNumberType.kCFNumberSInt32Type, new IntByReference(value));
        }

        public static CFNumberRef toCFNumberRef(long value) {
            return INSTANCE.CFNumberCreate(ALLOCATOR, CFNumberType.kCFNumberSInt64Type, new LongByReference(value));
        }

        public static CFNumberRef toCFNumberRef(char value) {
            return INSTANCE.CFNumberCreate(ALLOCATOR, CFNumberType.kCFNumberCharType, new ShortByReference((short)value));
        }

        public static CFNumberRef toCFNumberRef(float value) {
            return INSTANCE.CFNumberCreate(ALLOCATOR, CFNumberType.kCFNumberFloat32Type, new FloatByReference(value));
        }

        public static CFNumberRef toCFNumberRef(double value) {
            return INSTANCE.CFNumberCreate(ALLOCATOR, CFNumberType.kCFNumberFloat64Type, new DoubleByReference(value));
        }

        public Number getValue() {
            if (this.getPointer() == null) {
                return null;
            }
            CFNumberType numberType = INSTANCE.CFNumberGetType(this);
            Memory value = new Memory(8L);
            INSTANCE.CFNumberGetValue(this, numberType, value);
            switch (numberType) {
                case kCFNumberCFIndexType: 
                case kCFNumberSInt32Type: {
                    return value.getInt(0L);
                }
                case kCFNumberCGFloatType: 
                case kCFNumberMaxType: {
                    if (NativeLong.SIZE == 8) {
                        return value.getDouble(0L);
                    }
                    return Float.valueOf(value.getFloat(0L));
                }
                case kCFNumberCharType: {
                    return (int)value.getChar(0L);
                }
                case kCFNumberDoubleType: 
                case kCFNumberFloat64Type: {
                    return value.getDouble(0L);
                }
                case kCFNumberFloatType: 
                case kCFNumberFloat32Type: {
                    return Float.valueOf(value.getFloat(0L));
                }
                case kCFNumberLongLongType: 
                case kCFNumberSInt64Type: {
                    return value.getLong(0L);
                }
                case kCFNumberIntType: 
                case kCFNumberLongType: 
                case kCFNumberNSIntegerType: {
                    return value.getNativeLong(0L);
                }
                case kCFNumberSInt16Type: 
                case kCFNumberShortType: {
                    return value.getShort(0L);
                }
                case kCFNumberSInt8Type: {
                    return value.getByte(0L);
                }
            }
            throw new IllegalStateException("Unimplemented value " + numberType);
        }

        @Override
        public String toString() {
            if (this.getPointer() == null) {
                return "null";
            }
            return this.getValue().toString();
        }

        public static CFNumberRef toCFNumberRef(CFTypeRef cfType) {
            return new CFNumberRef(cfType == null ? null : cfType.getPointer());
        }
    }

    public static class CFTypeRefByReference
    extends PointerByReference {
        protected CFTypeRef instance;

        public CFTypeRef getCFTypeRef() {
            if (this.getPointer() == null || this.getPointer().getPointer(0L) == null) {
                this.instance = null;
                return null;
            }
            if (this.instance != null && this.getPointer().getPointer(0L).equals(this.instance.getPointer())) {
                return this.instance;
            }
            this.instance = this.newInstance();
            return this.instance;
        }

        @Override
        public String toString() {
            CFTypeRef tmpInstance = this.getCFTypeRef();
            if (tmpInstance == null) {
                return "null";
            }
            return tmpInstance.toString();
        }

        protected CFTypeRef newInstance() {
            return new CFTypeRef(this.getPointer().getPointer(0L));
        }
    }

    public static class CFTypeRef
    extends PointerType {
        public CFTypeRef() {
            super(new Memory(Native.LONG_SIZE));
        }

        public CFTypeRef(Pointer p) {
            super(p);
        }

        @Override
        public Object fromNative(Object nativeValue, FromNativeContext context) {
            if (nativeValue == null) {
                return null;
            }
            try {
                return this.getClass().getConstructor(Pointer.class).newInstance((Pointer)nativeValue);
            }
            catch (IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException("Can't instantiate " + this.getClass(), e);
            }
            catch (IllegalAccessException | SecurityException e) {
                throw new IllegalArgumentException("Not allowed to instantiate " + this.getClass(), e);
            }
        }

        @Override
        public String toString() {
            if (this.getPointer() == null) {
                return "null";
            }
            if (this.getPointer() instanceof Function || this.getPointer() instanceof Memory) {
                return "Java initialized, not a real CF type";
            }
            CFStringRef description = INSTANCE.CFCopyDescription(this);
            try {
                String string = description.toString();
                return string;
            }
            finally {
                INSTANCE.CFRelease(description);
            }
        }
    }
}

