/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.mac;

import com.sun.jna.DefaultTypeMapper;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.pms.platform.jna.JnaLongEnum;
import net.pms.platform.jna.JnaLongEnumConverter;
import net.pms.platform.mac.corefoundation.CoreFoundation;

public class NSFoundation {
    private NSFoundation() {
    }

    @Nonnull
    public static String nsUserName() {
        CoreFoundation.CFStringRef cfStringRef = new CoreFoundation.CFStringRef(NSFoundationIF.INSTANCE.CFBridgingRetain(NSFoundationIF.INSTANCE.NSUserName()));
        try {
            String string = cfStringRef.toString();
            return string;
        }
        finally {
            CoreFoundation.INSTANCE.CFRelease(cfStringRef);
        }
    }

    @Nonnull
    public static String nsFullUserName() {
        CoreFoundation.CFStringRef cfStringRef = new CoreFoundation.CFStringRef(NSFoundationIF.INSTANCE.CFBridgingRetain(NSFoundationIF.INSTANCE.NSFullUserName()));
        try {
            String string = cfStringRef.toString();
            return string;
        }
        finally {
            CoreFoundation.INSTANCE.CFRelease(cfStringRef);
        }
    }

    @Nonnull
    public static Path nsHomeDirectory() {
        CoreFoundation.CFStringRef cfStringRef = new CoreFoundation.CFStringRef(NSFoundationIF.INSTANCE.CFBridgingRetain(NSFoundationIF.INSTANCE.NSHomeDirectory()));
        try {
            Path path = Paths.get(cfStringRef.toString(), new String[0]);
            return path;
        }
        finally {
            CoreFoundation.INSTANCE.CFRelease(cfStringRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Path nsHomeDirectoryForUser(@Nullable String userName) {
        Pointer nsUserName = userName == null ? Pointer.NULL : NSFoundationIF.INSTANCE.CFBridgingRelease(CoreFoundation.CFStringRef.toCFStringRef(userName));
        Pointer nsString = NSFoundationIF.INSTANCE.NSHomeDirectoryForUser(nsUserName);
        if (nsString == null) {
            return null;
        }
        CoreFoundation.CFStringRef cfStringRef = new CoreFoundation.CFStringRef(NSFoundationIF.INSTANCE.CFBridgingRetain(nsString));
        try {
            Path path = Paths.get(cfStringRef.toString(), new String[0]);
            return path;
        }
        finally {
            CoreFoundation.INSTANCE.CFRelease(cfStringRef);
        }
    }

    @Nonnull
    public static Path nsTemporaryDirectory() {
        CoreFoundation.CFStringRef cfStringRef = new CoreFoundation.CFStringRef(NSFoundationIF.INSTANCE.CFBridgingRetain(NSFoundationIF.INSTANCE.NSTemporaryDirectory()));
        try {
            Path path = Paths.get(cfStringRef.toString(), new String[0]);
            return path;
        }
        finally {
            CoreFoundation.INSTANCE.CFRelease(cfStringRef);
        }
    }

    @Nonnull
    public static Path nsOpenStepRootDirectory() {
        CoreFoundation.CFStringRef cfStringRef = new CoreFoundation.CFStringRef(NSFoundationIF.INSTANCE.CFBridgingRetain(NSFoundationIF.INSTANCE.NSOpenStepRootDirectory()));
        try {
            Path path = Paths.get(cfStringRef.toString(), new String[0]);
            return path;
        }
        finally {
            CoreFoundation.INSTANCE.CFRelease(cfStringRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static List<Path> nsSearchPathForDirectoriesInDomains(NSSearchPathDirectory directory, long domainMask, boolean expandTilde) {
        ArrayList<Path> result = new ArrayList<Path>();
        CoreFoundation.CFArrayRef cfArrayRef = new CoreFoundation.CFArrayRef(NSFoundationIF.INSTANCE.CFBridgingRetain(NSFoundationIF.INSTANCE.NSSearchPathForDirectoriesInDomains(directory, domainMask, expandTilde)));
        try {
            long count = CoreFoundation.INSTANCE.CFArrayGetCount(cfArrayRef);
            int i = 0;
            while ((long)i < count) {
                CoreFoundation.CFTypeRef nsPathString = CoreFoundation.INSTANCE.CFArrayGetValueAtIndex(cfArrayRef, i);
                if (nsPathString != null) {
                    CoreFoundation.CFStringRef cfStringRef = new CoreFoundation.CFStringRef(NSFoundationIF.INSTANCE.CFBridgingRetain(nsPathString.getPointer()));
                    result.add(Paths.get(cfStringRef.toString(), new String[0]));
                    CoreFoundation.INSTANCE.CFRelease(cfStringRef);
                }
                ++i;
            }
            ArrayList<Path> arrayList = result;
            return arrayList;
        }
        finally {
            CoreFoundation.INSTANCE.CFRelease(cfArrayRef);
        }
    }

    protected static interface NSFoundationIF
    extends Library {
        public static final Map<String, Object> OPTIONS = Collections.unmodifiableMap(new HashMap<String, Object>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("type-mapper", new DefaultTypeMapper(){
                    {
                        this.addTypeConverter(JnaLongEnum.class, new JnaLongEnumConverter());
                    }
                });
            }
        });
        public static final NSFoundationIF INSTANCE = Native.load("/System/Library/Frameworks/Foundation.framework/Resources/BridgeSupport/Foundation.dylib", NSFoundationIF.class, OPTIONS);

        @Nullable
        public CoreFoundation.CFTypeRef CFBridgingRetain(@Nullable Pointer var1);

        @Nullable
        public Pointer CFBridgingRelease(@Nullable CoreFoundation.CFTypeRef var1);

        public Pointer NSUserName();

        public Pointer NSFullUserName();

        public Pointer NSHomeDirectory();

        @Nullable
        public Pointer NSHomeDirectoryForUser(@Nullable Pointer var1);

        public Pointer NSTemporaryDirectory();

        public Pointer NSOpenStepRootDirectory();

        public Pointer NSSearchPathForDirectoriesInDomains(NSSearchPathDirectory var1, long var2, boolean var4);
    }

    public static enum NSSearchPathDirectory implements JnaLongEnum<NSSearchPathDirectory>
    {
        NSApplicationDirectory(1L),
        NSDemoApplicationDirectory(2L),
        NSDeveloperApplicationDirectory(3L),
        NSAdminApplicationDirectory(4L),
        NSLibraryDirectory(5L),
        NSDeveloperDirectory(6L),
        NSUserDirectory(7L),
        NSDocumentationDirectory(8L),
        NSDocumentDirectory(9L),
        NSCoreServiceDirectory(10L),
        NSAutosavedInformationDirectory(11L),
        NSDesktopDirectory(12L),
        NSCachesDirectory(13L),
        NSApplicationSupportDirectory(14L),
        NSDownloadsDirectory(15L),
        NSInputMethodsDirectory(16L),
        NSMoviesDirectory(17L),
        NSMusicDirectory(18L),
        NSPicturesDirectory(19L),
        NSPrinterDescriptionDirectory(20L),
        NSSharedPublicDirectory(21L),
        NSPreferencePanesDirectory(22L),
        NSApplicationScriptsDirectory(23L),
        NSItemReplacementDirectory(99L),
        NSAllApplicationsDirectory(100L),
        NSAllLibrariesDirectory(101L),
        NSTrashDirectory(102L);

        private final long value;

        private NSSearchPathDirectory(long value) {
            this.value = value;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        public static NSSearchPathDirectory typeOf(long value) {
            for (NSSearchPathDirectory entry : NSSearchPathDirectory.values()) {
                if (value != entry.getValue()) continue;
                return entry;
            }
            return null;
        }

        @Override
        public NSSearchPathDirectory typeForValue(long value) {
            return NSSearchPathDirectory.typeOf(value);
        }
    }

    public static class NSSearchPathDomainMask {
        public static final long NSUserDomainMask = 1L;
        public static final long NSLocalDomainMask = 2L;
        public static final long NSNetworkDomainMask = 4L;
        public static final long NSSystemDomainMask = 8L;
        public static final long NSAllDomainsMask = 65535L;

        private NSSearchPathDomainMask() {
        }
    }
}

