/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.mac;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.platform.PlatformUtils;
import net.pms.platform.mac.MacSleepWorker;
import net.pms.platform.mac.NSFoundation;
import net.pms.service.sleep.AbstractSleepWorker;
import net.pms.service.sleep.PreventSleepMode;
import net.pms.service.sleep.SleepManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacUtils
extends PlatformUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacUtils.class);

    @Override
    public boolean isNetworkInterfaceLoopback(NetworkInterface ni) throws SocketException {
        return false;
    }

    @Override
    public byte[] getHardwareAddress(NetworkInterface ni) throws SocketException {
        byte[] aHardwareAddress = null;
        try {
            List<String> lines;
            Process process = Runtime.getRuntime().exec(new String[]{"ifconfig", ni.getName(), "ether"});
            try (InputStream inputStream = process.getInputStream();){
                lines = IOUtils.readLines(inputStream, StandardCharsets.UTF_8);
            }
            String aMacStr = null;
            Pattern aMacPattern = Pattern.compile("\\s*ether\\s*([a-d0-9]{2}:[a-d0-9]{2}:[a-d0-9]{2}:[a-d0-9]{2}:[a-d0-9]{2}:[a-d0-9]{2})");
            if (lines != null) {
                for (String line : lines) {
                    Matcher aMacMatcher = aMacPattern.matcher(line);
                    if (!aMacMatcher.find()) continue;
                    aMacStr = aMacMatcher.group(1);
                    break;
                }
            }
            if (aMacStr != null) {
                String[] aComps = aMacStr.split(":");
                aHardwareAddress = new byte[aComps.length];
                for (int i = 0; i < aComps.length; ++i) {
                    String aComp = aComps[i];
                    aHardwareAddress[i] = (byte)Short.valueOf(aComp, 16).shortValue();
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to execute ifconfig", e);
        }
        return aHardwareAddress;
    }

    @Override
    public String[] getPingCommand(String hostAddress, int count, int packetSize) {
        if (packetSize > 8000) {
            int divisor = MacUtils.getPingPacketDivisor(packetSize);
            packetSize /= divisor;
            count *= divisor;
        }
        return new String[]{"ping", "-c", Integer.toString(count), "-i", "0.1", "-s", Integer.toString(packetSize), hostAddress};
    }

    @Override
    public String parsePingLine(String line) {
        int msPos = line.indexOf("ms");
        String timeString = null;
        if (msPos > -1) {
            timeString = line.lastIndexOf(60, msPos) > -1 ? "0.5" : line.substring(line.lastIndexOf(61, msPos) + 1, msPos).trim();
        }
        return timeString != null && timeString.contains("/") ? null : timeString;
    }

    @Override
    public int getPingPacketFragments(int packetSize) {
        if (packetSize > 8000) {
            packetSize /= MacUtils.getPingPacketDivisor(packetSize);
        }
        return (packetSize + 8) / 1500 + 1;
    }

    @Override
    public boolean isTsMuxeRCompatible() {
        return System.getProperty("os.version") == null || !System.getProperty("os.version").contains("10.4.");
    }

    @Override
    public String getiTunesFile() throws IOException, URISyntaxException {
        Process process = Runtime.getRuntime().exec(new String[]{"defaults", "read", "com.apple.iApps", "iTunesRecentDatabases"});
        try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line1 = in.readLine();
            String line2 = in.readLine();
            if (line1 != null && line2 != null) {
                String line = line2.trim();
                line = line.substring(1, line.length() - 1);
                URI tURI = new URI(line);
                String string = URLDecoder.decode(tURI.toURL().getFile(), "UTF8");
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Path> getDefaultFolders() {
        Object object = DEFAULT_FOLDERS_LOCK;
        synchronized (object) {
            if (defaultFolders == null) {
                ArrayList<Path> result = new ArrayList<Path>();
                result.addAll(NSFoundation.nsSearchPathForDirectoriesInDomains(NSFoundation.NSSearchPathDirectory.NSMoviesDirectory, 65535L, true));
                result.addAll(NSFoundation.nsSearchPathForDirectoriesInDomains(NSFoundation.NSSearchPathDirectory.NSMusicDirectory, 65535L, true));
                result.addAll(NSFoundation.nsSearchPathForDirectoriesInDomains(NSFoundation.NSSearchPathDirectory.NSPicturesDirectory, 65535L, true));
                defaultFolders = Collections.unmodifiableList(result);
            }
            return defaultFolders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAdmin() {
        Object object = IS_ADMIN_LOCK;
        synchronized (object) {
            if (isAdmin != null) {
                return isAdmin;
            }
            try {
                String exitLine;
                int exitValue;
                LOGGER.trace("isAdmin: Executing \"id -Gn\"");
                Process p = Runtime.getRuntime().exec(new String[]{"id", "-Gn"});
                InputStream is = p.getInputStream();
                InputStreamReader isr = new InputStreamReader(is, StandardCharsets.US_ASCII);
                try (BufferedReader br = new BufferedReader(isr);){
                    p.waitFor();
                    exitValue = p.exitValue();
                    exitLine = br.readLine();
                }
                if (exitValue != 0 || exitLine == null || exitLine.isEmpty()) {
                    LOGGER.error("Could not determine admin privileges, \"id -Gn\" ended with exit code: {}", (Object)exitValue);
                    isAdmin = false;
                    return false;
                }
                LOGGER.trace("isAdmin: \"id -Gn\" returned {}", (Object)exitLine);
                if (exitLine.matches(".*\\badmin\\b.*")) {
                    LOGGER.trace("isAdmin: UMS has admin privileges");
                    isAdmin = true;
                    return true;
                }
                LOGGER.trace("isAdmin: UMS does not have admin privileges");
                isAdmin = false;
                return false;
            }
            catch (IOException e) {
                LOGGER.error("An error prevented UMS from checking macOS permissions: {}", (Object)e.getMessage());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            isAdmin = false;
            return false;
        }
    }

    @Override
    public String getDefaultFontPath() {
        return MacUtils.getAbsolutePath("/System/Library/Frameworks/JavaVM.framework/Versions/1.5.0/Home/lib/fonts/", "LucidaSansRegular.ttf");
    }

    @Override
    public boolean isPreventSleepSupported() {
        return MacUtils.isMacOsVersionEqualOrGreater("10.5.0");
    }

    @Override
    public AbstractSleepWorker getSleepWorker(SleepManager owner, PreventSleepMode mode) {
        return new MacSleepWorker(owner, mode);
    }

    @Override
    public String getTrayIcon() {
        if (MacUtils.isDarkMode()) {
            return "icon-darkmode";
        }
        return "icon-bw";
    }

    @Override
    public List<String> getRestartCommand(boolean hasOptions) {
        String macAppPath;
        Pattern pattern;
        Matcher matcher;
        String libraryPath = ManagementFactory.getRuntimeMXBean().getLibraryPath();
        if (StringUtils.isNotBlank(libraryPath) && (matcher = (pattern = Pattern.compile("(.+?\\.app)/Contents/MacOS")).matcher(libraryPath)).find() && StringUtils.isNotBlank(macAppPath = matcher.group(1))) {
            ArrayList<String> restart = new ArrayList<String>();
            restart.add("open");
            restart.add("-n");
            restart.add("-a");
            restart.add(macAppPath);
            if (hasOptions) {
                restart.add("--args");
            }
            return restart;
        }
        return MacUtils.getUMSCommand();
    }

    @Override
    public String[] getShutdownCommand() {
        return new String[]{"shutdown", "-h", "now"};
    }

    private static boolean isDarkMode() {
        try {
            Process proc = Runtime.getRuntime().exec(new String[]{"defaults", "read", "-g", "AppleInterfaceStyle"});
            proc.waitFor(100L, TimeUnit.MILLISECONDS);
            return proc.exitValue() == 0;
        }
        catch (IOException | IllegalThreadStateException ex) {
            LOGGER.warn("Could not determine whether 'dark mode' is being used. Falling back to default (light) mode.");
            LOGGER.debug("" + ex);
            return false;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private static int getPingPacketDivisor(int packetSize) {
        return (int)Math.ceil((double)packetSize / 8000.0);
    }

    public static boolean isMacOsVersionEqualOrGreater(String version) {
        return OS_VERSION.isGreaterThanOrEqualTo(version);
    }
}

