/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.linux;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import net.pms.util.FileUtil;

public class UnixMountPoint {
    private final String device;
    private final String folder;

    public UnixMountPoint(String device, String folder) {
        this.device = device;
        this.folder = folder;
    }

    public String getDevice() {
        return this.device;
    }

    public String getFolder() {
        return this.folder;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UnixMountPoint)) {
            return false;
        }
        return this.device.equals(((UnixMountPoint)obj).device) && this.folder.equals(((UnixMountPoint)obj).folder);
    }

    public int hashCode() {
        return this.device.hashCode() + this.folder.hashCode();
    }

    public String toString() {
        return String.format("Device: \"%s\", folder: \"%s\"", this.device, this.folder);
    }

    public static UnixMountPoint getMountPoint(Path path) throws FileUtil.InvalidFileSystemException {
        FileStore store;
        try {
            store = Files.getFileStore(path);
        }
        catch (IOException e) {
            throw new FileUtil.InvalidFileSystemException(String.format("Could not get Unix mount point for file \"%s\": %s", path.toAbsolutePath(), e.getMessage()), e);
        }
        try {
            Field entryField = store.getClass().getSuperclass().getDeclaredField("entry");
            Field nameField = entryField.getType().getDeclaredField("name");
            Field dirField = entryField.getType().getDeclaredField("dir");
            entryField.setAccessible(true);
            nameField.setAccessible(true);
            dirField.setAccessible(true);
            String device = new String((byte[])nameField.get(entryField.get(store)), StandardCharsets.UTF_8);
            String folder = new String((byte[])dirField.get(entryField.get(store)), StandardCharsets.UTF_8);
            return new UnixMountPoint(device, folder);
        }
        catch (NoSuchFieldException e) {
            throw new FileUtil.InvalidFileSystemException(String.format("File \"%s\" is not on a Unix file system", path.isAbsolute()), e);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new FileUtil.InvalidFileSystemException(String.format("An error occurred while trying to find mount point for file \"%s\": %s", path.toAbsolutePath(), e.getMessage()), e);
        }
    }

    public static UnixMountPoint getMountPoint(File file) throws FileUtil.InvalidFileSystemException {
        return UnixMountPoint.getMountPoint(file.toPath());
    }
}

