/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.linux;

import com.sun.jna.Platform;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.io.BufferedOutputFile;
import net.pms.io.IPipeProcess;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.platform.windows.WindowsNamedPipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxPipeProcess
implements IPipeProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinuxPipeProcess.class);
    private UmsConfiguration configuration;
    private String linuxPipeName;
    private WindowsNamedPipe mk;

    public LinuxPipeProcess(String pipeName, OutputParams params, String ... extras) {
        this.configuration = PMS.getConfiguration(params);
        this.linuxPipeName = LinuxPipeProcess.getPipeName(pipeName);
    }

    public LinuxPipeProcess(String pipeName, String ... extras) {
        this(pipeName, (OutputParams)null, extras);
    }

    @Override
    public String getInputPipe() {
        return this.linuxPipeName;
    }

    @Override
    public String getOutputPipe() {
        return this.linuxPipeName;
    }

    @Override
    public ProcessWrapper getPipeProcess() {
        OutputParams mkfifoVidParams = new OutputParams(this.configuration);
        mkfifoVidParams.setMaxBufferSize(0.1);
        mkfifoVidParams.setLog(true);
        String[] cmdArray = Platform.isMac() || Platform.isFreeBSD() || Platform.isSolaris() ? new String[]{"mkfifo", "-m", "777", this.linuxPipeName} : new String[]{"mkfifo", "--mode=777", this.linuxPipeName};
        return new ProcessWrapperImpl(cmdArray, mkfifoVidParams);
    }

    @Override
    public void deleteLater() {
        File f = new File(this.linuxPipeName);
        f.deleteOnExit();
    }

    @Override
    public BufferedOutputFile getDirectBuffer() {
        if (!Platform.isWindows()) {
            return null;
        }
        return this.mk.getDirectBuffer();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        LOGGER.trace("Opening file {} for reading...", (Object)this.linuxPipeName);
        RandomAccessFile raf = new RandomAccessFile(this.linuxPipeName, "r");
        return new FileInputStream(raf.getFD());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        LOGGER.trace("Opening file {} for writing...", (Object)this.linuxPipeName);
        RandomAccessFile raf = new RandomAccessFile(this.linuxPipeName, "rw");
        return new FileOutputStream(raf.getFD());
    }

    private static String getPipeName(String pipeName) {
        try {
            return PMS.getConfiguration().getTempFolder() + "/" + pipeName;
        }
        catch (IOException e) {
            LOGGER.error("Pipe may not be in temporary directory: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
            return pipeName;
        }
    }
}

