/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.jna;

import com.sun.jna.FromNativeContext;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;

public class WStringByReference
extends PointerType {
    public WStringByReference() {
    }

    public WStringByReference(long dataSize) {
        super(dataSize < 1L ? Pointer.NULL : new Memory(dataSize + (long)Native.WCHAR_SIZE));
    }

    public WStringByReference(String value) {
        if (value != null) {
            this.setValue(value);
        }
    }

    public void setValue(String value) {
        if (value == null) {
            this.setPointer(Pointer.NULL);
            return;
        }
        int length = WStringByReference.getNumberOfBytes(value);
        if ((long)length > this.getAllocatedSize()) {
            this.setPointer(new Memory(length + Native.WCHAR_SIZE));
        }
        this.getPointer().setWideString(0L, value);
    }

    public String getValue() {
        return this.getPointer() == null ? null : this.getPointer().getWideString(0L);
    }

    public long getAllocatedSize() {
        if (this.getPointer() instanceof Memory) {
            return Math.max(((Memory)this.getPointer()).size() - (long)Native.WCHAR_SIZE, 0L);
        }
        return -1L;
    }

    @Override
    public Object fromNative(Object nativeValue, FromNativeContext context) {
        if (nativeValue == null) {
            return null;
        }
        this.setPointer((Pointer)nativeValue);
        return this;
    }

    @Override
    public String toString() {
        if (this.getPointer() == null) {
            return "null";
        }
        return this.getValue();
    }

    public static int getNumberOfBytes(String string) {
        int codepoint;
        if (string == null) {
            return 0;
        }
        if (Native.WCHAR_SIZE == 4) {
            return string.codePointCount(0, string.length()) * Native.WCHAR_SIZE;
        }
        int length = string.length();
        int byteLength = 0;
        for (int offset = 0; offset < length; offset += Character.charCount(codepoint)) {
            codepoint = string.codePointAt(offset);
            byteLength += Character.charCount(codepoint) * Native.WCHAR_SIZE;
        }
        return byteLength;
    }
}

