/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.jna;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import net.pms.platform.jna.FixedArrayByReference;

public class FixedCharArrayByReference
extends FixedArrayByReference<Byte> {
    public FixedCharArrayByReference(long fixedSize) {
        super(fixedSize);
    }

    public String getString() {
        return this.getString(Charset.defaultCharset());
    }

    public String getString(Charset charset) {
        if (this.size > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Array to big, please read it \"manually\" using getPointer.getX");
        }
        if (this.getPointer() == null) {
            return null;
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        decoder.replaceWith("?");
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.getPointer().getByteArray(0L, (int)this.size));
        CharBuffer charBuffer = CharBuffer.allocate(100);
        StringBuilder sb = new StringBuilder(100);
        CoderResult coderResult = null;
        while (coderResult == null || !coderResult.isUnderflow()) {
            coderResult = decoder.decode(byteBuffer, charBuffer, true);
            if (!coderResult.isOverflow() || !this.drainCharBuffer(charBuffer, sb)) continue;
            return sb.toString();
        }
        if (this.drainCharBuffer(charBuffer, sb)) {
            return sb.toString();
        }
        coderResult = null;
        while (coderResult == null || !coderResult.isUnderflow()) {
            coderResult = decoder.flush(charBuffer);
            if (!coderResult.isOverflow() || !this.drainCharBuffer(charBuffer, sb)) continue;
            return sb.toString();
        }
        if (this.drainCharBuffer(charBuffer, sb)) {
            return sb.toString();
        }
        return sb.toString();
    }

    protected boolean drainCharBuffer(CharBuffer charBuffer, StringBuilder stringBuilder) {
        if (charBuffer == null || stringBuilder == null) {
            throw new IllegalArgumentException("Neither argument can be null");
        }
        charBuffer.flip();
        while (charBuffer.hasRemaining()) {
            char c = charBuffer.get();
            if (c == '\u0000') {
                return true;
            }
            stringBuilder.append(c);
        }
        charBuffer.compact();
        return false;
    }

    public void setString(String content) {
        this.setString(content, Charset.defaultCharset());
    }

    public void setString(String content, Charset charset) {
        if (content == null) {
            this.setPointer(Pointer.NULL);
            return;
        }
        if (this.size > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Array to big, please write it \"manually\" using getPointer.getX");
        }
        byte[] sourceBytes = content.getBytes(charset);
        byte[] bytes = new byte[(int)this.size];
        System.arraycopy(sourceBytes, 0, bytes, 0, Math.min((int)this.size, sourceBytes.length));
        if ((long)sourceBytes.length < this.size) {
            bytes[sourceBytes.length] = 0;
        }
        for (int i = 0; i < bytes.length; ++i) {
            this.getPointer().setByte(i, bytes[i]);
        }
    }

    public byte[] getByteArray() {
        if (this.size > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Array to big, please read it \"manually\" using getPointer.setX");
        }
        return this.getPointer() == null ? null : this.getPointer().getByteArray(0L, (int)this.size);
    }

    public void setByteArray(byte[] array) {
        if (array == null) {
            throw new NullPointerException("array cannot be null");
        }
        if ((long)array.length != this.size) {
            throw new IllegalArgumentException("array size must be " + this.size);
        }
        if (this.size < 1L) {
            this.setPointer(Pointer.NULL);
            return;
        }
        if (this.getPointer() == null) {
            this.setPointer(new Memory((long)this.getElementSize() * this.size));
        }
        this.getPointer().write(0L, array, 0, (int)this.size);
    }

    @Override
    public int getElementSize() {
        return 1;
    }

    protected Byte[] getElements() {
        Byte[] result = new Byte[(int)this.size];
        int i = 0;
        while ((long)i < this.size) {
            result[i] = this.getPointer().getByte(i * this.getElementSize());
            ++i;
        }
        return result;
    }

    protected void setElements(Byte[] array) {
        int i = 0;
        while ((long)i < this.size) {
            this.getPointer().setByte(i * this.getElementSize(), array[i]);
            ++i;
        }
    }

    @Override
    public String toString() {
        if (this.getPointer() == null) {
            return "null";
        }
        if (this.size > Integer.MAX_VALUE) {
            return super.toString();
        }
        return this.getString();
    }
}

