/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform;

import com.sun.jna.Platform;
import com.sun.jna.platform.FileUtils;
import com.vdurmont.semver4j.Semver;
import dev.dirs.UserDirectories;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import net.pms.PMS;
import net.pms.io.IPipeProcess;
import net.pms.io.OutputParams;
import net.pms.platform.IPlatformUtils;
import net.pms.platform.linux.LinuxPipeProcess;
import net.pms.platform.linux.LinuxUtils;
import net.pms.platform.mac.MacUtils;
import net.pms.platform.posix.POSIXProcessTerminator;
import net.pms.platform.solaris.SolarisUtils;
import net.pms.platform.windows.WindowsUtils;
import net.pms.service.process.AbstractProcessTerminator;
import net.pms.service.process.ProcessManager;
import net.pms.service.sleep.AbstractSleepWorker;
import net.pms.service.sleep.PreventSleepMode;
import net.pms.service.sleep.SleepManager;
import net.pms.util.StringUtil;
import net.pms.util.Version;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformUtils
implements IPlatformUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformUtils.class);
    public static final IPlatformUtils INSTANCE = PlatformUtils.createInstance();
    protected static final Object IS_ADMIN_LOCK = new Object();
    protected static final Object DEFAULT_FOLDERS_LOCK = new Object();
    protected static final Semver OS_VERSION = PlatformUtils.createOSVersion();
    @GuardedBy(value="IS_ADMIN_LOCK")
    protected static Boolean isAdmin = null;
    @GuardedBy(value="DEFAULT_FOLDERS_LOCK")
    protected static List<Path> defaultFolders = null;
    protected Path vlcPath;
    protected Version vlcVersion;
    protected boolean aviSynth;
    protected boolean aviSynthPlus;

    protected PlatformUtils() {
    }

    @Override
    public File getAvsPluginsDir() {
        return null;
    }

    @Override
    public File getKLiteFiltersDir() {
        return null;
    }

    @Override
    public String getShortPathNameW(String longPathName) {
        return longPathName;
    }

    @Override
    public String getDiskLabel(File f) {
        return null;
    }

    @Override
    public boolean isKerioFirewall() {
        return false;
    }

    @Override
    public Path getVlcPath() {
        return this.vlcPath;
    }

    @Override
    public Version getVlcVersion() {
        return this.vlcVersion;
    }

    @Override
    public boolean isAviSynthAvailable() {
        return this.aviSynth;
    }

    @Override
    public boolean isAviSynthPlusAvailable() {
        return this.aviSynthPlus;
    }

    @Override
    public boolean isTsMuxeRCompatible() {
        return true;
    }

    @Override
    public String getiTunesFile() throws IOException, URISyntaxException {
        return null;
    }

    @Override
    public Charset getDefaultCharset() {
        return Charset.defaultCharset();
    }

    @Override
    public boolean browseURI(String url) {
        try {
            URI uri = new URI(url);
            if (Platform.isLinux() && Runtime.getRuntime().exec(new String[]{"which", "xdg-open"}).getInputStream().read() != -1) {
                Runtime.getRuntime().exec(new String[]{"xdg-open", uri.toString()});
                return true;
            }
            if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(uri);
                return true;
            }
            if (Platform.isMac()) {
                Runtime.getRuntime().exec(new String[]{"open", uri.toString()});
                return true;
            }
            LOGGER.error("Action BROWSE isn't supported on this platform");
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.trace("Unable to open the given URI: " + url + ".");
        }
        return false;
    }

    @Override
    public boolean isNetworkInterfaceLoopback(NetworkInterface ni) throws SocketException {
        return ni.isLoopback();
    }

    @Override
    public byte[] getHardwareAddress(NetworkInterface ni) throws SocketException {
        return ni.getHardwareAddress();
    }

    @Override
    public String[] getPingCommand(String hostAddress, int count, int packetSize) {
        return new String[]{"ping", "-c", Integer.toString(count), "-s", Integer.toString(packetSize), hostAddress};
    }

    @Override
    public String parsePingLine(String line) {
        int msPos = line.indexOf("ms");
        String timeString = null;
        if (msPos > -1) {
            timeString = line.lastIndexOf(60, msPos) > -1 ? "0.5" : line.substring(line.lastIndexOf(61, msPos) + 1, msPos).trim();
        }
        return timeString;
    }

    @Override
    public int getPingPacketFragments(int packetSize) {
        return (packetSize + 8) / 1500 + 1;
    }

    @Override
    public String getTrayIcon() {
        return "icon";
    }

    @Override
    public void moveToTrash(File file) throws IOException {
        FileUtils.getInstance().moveToTrash(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Path> getDefaultFolders() {
        Object object = DEFAULT_FOLDERS_LOCK;
        synchronized (object) {
            if (defaultFolders == null) {
                ArrayList<Path> result = new ArrayList<Path>();
                UserDirectories userDirs = UserDirectories.get();
                if (userDirs.videoDir != null) {
                    result.add(Paths.get(userDirs.videoDir, new String[0]));
                    if (userDirs.audioDir != null) {
                        result.add(Paths.get(userDirs.audioDir, new String[0]));
                    }
                    if (userDirs.pictureDir != null) {
                        result.add(Paths.get(userDirs.pictureDir, new String[0]));
                    }
                    if (userDirs.publicDir != null) {
                        result.add(Paths.get(userDirs.publicDir, new String[0]));
                    }
                } else {
                    result.add(Paths.get(userDirs.homeDir, new String[0]));
                }
                defaultFolders = Collections.unmodifiableList(result);
            }
            return defaultFolders;
        }
    }

    @Override
    public Version getFileVersionInfo(String filePath) {
        return null;
    }

    @Override
    public boolean isAdmin() {
        return false;
    }

    @Override
    public String getDefaultFontPath() {
        return null;
    }

    @Override
    public boolean isPreventSleepSupported() {
        return false;
    }

    @Override
    public AbstractSleepWorker getSleepWorker(SleepManager owner, PreventSleepMode mode) {
        throw new IllegalStateException("Missing SleepWorker implementation for current platform");
    }

    @Override
    public AbstractProcessTerminator getProcessTerminator(ProcessManager processManager) {
        return new POSIXProcessTerminator(processManager);
    }

    @Override
    public IPipeProcess getPipeProcess(String pipeName, String ... extras) {
        return this.getPipeProcess(pipeName, (OutputParams)null, extras);
    }

    @Override
    public IPipeProcess getPipeProcess(String pipeName, OutputParams params, String ... extras) {
        return new LinuxPipeProcess(pipeName, params, extras);
    }

    @Override
    public void appendErrorString(StringBuilder sb, int exitCode) {
        sb.append("Process exited with code ").append(exitCode).append(":\n");
    }

    @Override
    public List<String> getRestartCommand(boolean hasOptions) {
        return PlatformUtils.getUMSCommand();
    }

    @Override
    public String[] getShutdownCommand() {
        return null;
    }

    @Override
    public String getJvmExecutableName() {
        return "java";
    }

    @Override
    public void destroyProcess(Process p) {
        p.destroy();
    }

    private static PlatformUtils createInstance() {
        if (Platform.isWindows()) {
            return new WindowsUtils();
        }
        if (Platform.isMac()) {
            return new MacUtils();
        }
        if (Platform.isLinux()) {
            return new LinuxUtils();
        }
        if (Platform.isSolaris()) {
            return new SolarisUtils();
        }
        return new PlatformUtils();
    }

    private static Semver createOSVersion() {
        if (!Platform.isMac() && !Platform.isWindows()) {
            return null;
        }
        Object ver = System.getProperty("os.version");
        int dotCount = StringUtils.countMatches((CharSequence)ver, ".");
        if (dotCount == 1) {
            ver = (String)ver + ".0";
        }
        return new Semver((String)ver);
    }

    protected static String getAbsolutePath(String path, String name) {
        File f = new File(path, name);
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        return null;
    }

    public static Semver getOSVersion() {
        return OS_VERSION;
    }

    public static int getOSBitness() {
        return Platform.is64Bit() ? 64 : 32;
    }

    public static boolean is64Bit() {
        return Platform.is64Bit();
    }

    public static boolean isWindows() {
        return Platform.isWindows();
    }

    public static boolean isMac() {
        return Platform.isMac();
    }

    protected static List<String> getUMSCommand() {
        String jvmExecutableName;
        ArrayList<String> restart = new ArrayList<String>();
        File jvmPath = new File(System.getProperty("java.home"));
        File jvmExecutable = new File(jvmPath, jvmExecutableName = INSTANCE.getJvmExecutableName());
        if (!jvmExecutable.exists() || jvmExecutable.isDirectory()) {
            jvmPath = new File(jvmPath, "bin");
            jvmExecutable = new File(jvmPath, jvmExecutableName);
        }
        if (!jvmExecutable.exists() || jvmExecutable.isDirectory()) {
            LOGGER.error("Can\u00b4t find Java executable \"{}\", falling back to pathless execution using \"{}\"", (Object)jvmExecutable.getAbsolutePath(), (Object)jvmExecutableName);
            restart.add(jvmExecutableName);
        } else {
            restart.add(StringUtil.quoteArg(jvmExecutable.getAbsolutePath()));
        }
        for (String jvmArg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            restart.add(StringUtil.quoteArg(jvmArg));
        }
        restart.add("-cp");
        restart.add(ManagementFactory.getRuntimeMXBean().getClassPath());
        restart.add(PMS.class.getName());
        return restart;
    }
}

