/*
 * Decompiled with CFR 0.152.
 */
package net.pms.parsers.mediainfo;

import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import net.pms.parsers.mediainfo.InfoKind;
import net.pms.parsers.mediainfo.MediaInfoLibrary;
import net.pms.parsers.mediainfo.StreamKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaInfoHelper
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaInfoHelper.class);
    private Pointer handle;

    public MediaInfoHelper(boolean log) {
        try {
            if (log) {
                LOGGER.info("Loading MediaInfo library");
            }
            this.handle = MediaInfoLibrary.INSTANCE.New();
            if (log) {
                LOGGER.info("Loaded {}", (Object)MediaInfoHelper.optionStatic("Info_Version"));
            }
            if (!Platform.isWindows()) {
                if (log) {
                    LOGGER.debug("Setting MediaInfo library characterset to UTF-8");
                }
                this.setUTF8();
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error loading MediaInfo library: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
            if (!Platform.isWindows() && !Platform.isMac()) {
                LOGGER.info("Make sure you have libmediainfo and libzen installed");
            }
            LOGGER.info("The server will now use the less accurate FFmpeg parsing method");
        }
    }

    public boolean isValid() {
        return this.handle != null;
    }

    public void dispose() {
        if (this.handle == null) {
            throw new IllegalStateException();
        }
        MediaInfoLibrary.INSTANCE.Delete(this.handle);
        this.handle = null;
    }

    @Override
    public void close() throws Exception {
        if (this.handle != null) {
            this.dispose();
        }
    }

    public int openFile(String fileName) {
        return MediaInfoLibrary.INSTANCE.Open(this.handle, new WString(fileName));
    }

    public void closeFile() {
        MediaInfoLibrary.INSTANCE.Close(this.handle);
    }

    public String inform() {
        return MediaInfoLibrary.INSTANCE.Inform(this.handle).toString();
    }

    public String get(StreamKind streamType, int streamNumber, String parameter) {
        return this.get(streamType, streamNumber, parameter, InfoKind.TEXT, InfoKind.NAME);
    }

    public String get(StreamKind streamType, int streamNumber, String parameter, InfoKind infoType) {
        return this.get(streamType, streamNumber, parameter, infoType, InfoKind.NAME);
    }

    public String get(StreamKind streamType, int streamNumber, String parameter, InfoKind infoType, InfoKind searchType) {
        return MediaInfoLibrary.INSTANCE.Get(this.handle, streamType.getValue(), streamNumber, new WString(parameter), infoType.getValue(), searchType.getValue()).toString();
    }

    public String get(StreamKind streamType, int streamNumber, int parameterIndex) {
        return this.get(streamType, streamNumber, parameterIndex, InfoKind.TEXT);
    }

    public String get(StreamKind streamType, int streamNumber, int parameterIndex, InfoKind infoType) {
        return MediaInfoLibrary.INSTANCE.GetI(this.handle, streamType.getValue(), streamNumber, parameterIndex, infoType.getValue()).toString();
    }

    public Long getLong(StreamKind streamType, int streamNumber, String parameter) {
        String result = this.get(streamType, streamNumber, parameter);
        if (result != null && !"".equals(result)) {
            try {
                return Long.valueOf(result);
            }
            catch (NumberFormatException e) {
                StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
                if (stackTraceElements.length > 1) {
                    LOGGER.debug("Could not parse \"{}\" as Long for \"{}.{}\"", result, stackTraceElements[2].getClassName(), stackTraceElements[2].getMethodName());
                }
                LOGGER.debug("Could not parse \"{}\" as Long", (Object)result);
            }
        }
        return null;
    }

    public Double getDouble(StreamKind streamType, int streamNumber, String parameter) {
        String result = this.get(streamType, streamNumber, parameter);
        if (result != null && !"".equals(result)) {
            try {
                return Double.valueOf(result);
            }
            catch (NumberFormatException e) {
                StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
                if (stackTraceElements.length > 1) {
                    LOGGER.debug("Could not parse \"{}\" as Double for \"{}.{}\"", result, stackTraceElements[2].getClassName(), stackTraceElements[2].getMethodName());
                }
                LOGGER.debug("Could not parse \"{}\" as Double", (Object)result);
            }
        }
        return null;
    }

    public int countGet(StreamKind streamType) {
        return MediaInfoLibrary.INSTANCE.Count_Get(this.handle, streamType.getValue(), -1);
    }

    public int countGet(StreamKind streamType, int streamNumber) {
        return MediaInfoLibrary.INSTANCE.Count_Get(this.handle, streamType.getValue(), streamNumber);
    }

    public String option(String option) {
        return MediaInfoLibrary.INSTANCE.Option(this.handle, new WString(option), new WString("")).toString();
    }

    public String option(String option, String value) {
        return MediaInfoLibrary.INSTANCE.Option(this.handle, new WString(option), new WString(value)).toString();
    }

    public final void setUTF8() {
        MediaInfoLibrary.INSTANCE.Option(this.handle, new WString("setlocale_LC_CTYPE"), new WString("UTF-8"));
    }

    public static String optionStatic(String option) {
        return MediaInfoLibrary.INSTANCE.Option(MediaInfoLibrary.INSTANCE.New(), new WString(option), new WString("")).toString();
    }

    public static String optionStatic(String option, String value) {
        return MediaInfoLibrary.INSTANCE.Option(MediaInfoLibrary.INSTANCE.New(), new WString(option), new WString(value)).toString();
    }
}

