/*
 * Decompiled with CFR 0.152.
 */
package net.pms.parsers;

import java.net.http.HttpHeaders;
import net.pms.database.MediaTableFiles;
import net.pms.dlna.DLNAThumbnail;
import net.pms.external.JavaHttpClient;
import net.pms.formats.Format;
import net.pms.formats.FormatFactory;
import net.pms.media.MediaInfo;
import net.pms.media.audio.metadata.MediaAudioMetadata;
import net.pms.parsers.FFmpegParser;
import net.pms.store.ThumbnailSource;
import net.pms.store.ThumbnailStore;
import net.pms.util.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebStreamParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebStreamParser.class.getName());

    private WebStreamParser() {
    }

    public static void parse(MediaInfo mediaInfo, String url, int type) {
        mediaInfo.waitMediaParsing(5);
        if (mediaInfo.isMediaParsed()) {
            return;
        }
        mediaInfo.setParsing(true);
        mediaInfo.resetParser();
        HttpHeaders headHeaders = JavaHttpClient.getHeaders(url);
        String contentType = headHeaders.firstValue("content-type").orElse(null);
        if (contentType != null) {
            mediaInfo.setMimeType(contentType);
        }
        if (type == 1) {
            HttpHeaders getHeaders = JavaHttpClient.getHeadersFromInputStreamRequest(url);
            WebStreamParser.addAudioIcyInfos(mediaInfo, url, headHeaders);
            WebStreamParser.addAudioIcyInfos(mediaInfo, url, getHeaders);
        }
        mediaInfo.setParsing(false);
        FFmpegParser.parseUrl(mediaInfo, url);
        mediaInfo.setMediaParser("WEBSTREAM");
    }

    public static int getWebStreamType(String url, int defaultType) {
        int type = WebStreamParser.getTypeFromUrl(url, defaultType);
        if (type == 0 || type == 8) {
            LOGGER.debug("Analyzing internet resource type from content-type HEADER : {}", (Object)url);
            HttpHeaders headHeaders = JavaHttpClient.getHeaders(url);
            type = WebStreamParser.getTypeFromHttpHeaders(headHeaders, 0);
            if (type == 0) {
                HttpHeaders getHeaders = JavaHttpClient.getHeadersFromInputStreamRequest(url);
                type = WebStreamParser.getTypeFromHttpHeaders(getHeaders, 0);
            }
            if (type == 0) {
                LOGGER.debug("Couldn't determine stream content type from content-type HEADER for {}", (Object)url);
            } else {
                LOGGER.debug("Stream content type set to {} for {}", (Object)Format.getStringType(type), (Object)url);
            }
        }
        if (type == 0 || type == 8) {
            type = defaultType;
            LOGGER.debug("Stream content type set to default {} for {}", (Object)Format.getStringType(type), (Object)url);
        }
        return type;
    }

    private static void addAudioIcyInfos(MediaInfo mediaInfo, String url, HttpHeaders headers) {
        Long fileId;
        DLNAThumbnail thumbnail;
        String logo;
        String genre;
        Integer sampleRate;
        Integer bitrate;
        if (headers == null) {
            LOGGER.trace("web audio stream without header info.");
            return;
        }
        if (!mediaInfo.hasAudioMetadata()) {
            mediaInfo.setAudioMetadata(new MediaAudioMetadata());
        }
        if ((bitrate = WebStreamParser.parseIntValue(headers.firstValue("icy-br").orElse(null))) != null) {
            mediaInfo.setBitRate(bitrate);
            if (mediaInfo.hasAudio()) {
                mediaInfo.getDefaultAudioTrack().setBitRate(bitrate);
            }
        }
        if ((sampleRate = WebStreamParser.parseIntValue(headers.firstValue("icy-sr").orElse(null))) != null && mediaInfo.hasAudio()) {
            mediaInfo.getDefaultAudioTrack().setSampleRate(sampleRate);
        }
        if ((genre = (String)headers.firstValue("icy-genre").orElse(null)) != null) {
            if (!mediaInfo.hasAudioMetadata()) {
                mediaInfo.setAudioMetadata(new MediaAudioMetadata());
            }
            mediaInfo.getAudioMetadata().setGenre(genre);
        }
        if (StringUtils.isNotBlank(logo = (String)headers.firstValue("icy-logo").orElse(null)) && !ThumbnailSource.WEBSTREAM.equals((Object)mediaInfo.getThumbnailSource()) && !ThumbnailSource.RADIOBROWSER.equals((Object)mediaInfo.getThumbnailSource()) && (thumbnail = JavaHttpClient.getThumbnail(logo)) != null && (fileId = MediaTableFiles.getFileId(url)) != null) {
            Long thumbnailId = ThumbnailStore.getId(thumbnail, fileId, ThumbnailSource.WEBSTREAM);
            mediaInfo.setThumbnailId(thumbnailId);
            mediaInfo.setThumbnailSource(ThumbnailSource.WEBSTREAM);
        }
    }

    private static Integer parseIntValue(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static int getTypeFromUrl(String url, int defaultType) {
        int type = 0;
        Object ext = FileUtil.getUrlExtension(url);
        if (ext != null) {
            ext = "." + (String)ext;
            LOGGER.debug("Analyzing internet resource type from file extension of given URL.");
            Format f = FormatFactory.getAssociatedFormat((String)ext);
            if (f != null) {
                type = f.getType();
                if (type == 16 && !url.endsWith((String)ext)) {
                    type = defaultType;
                }
                LOGGER.debug("Stream content type set to {} for {}", (Object)Format.getStringType(type), (Object)url);
            } else {
                LOGGER.debug("Couldn't determine stream content type from file extension for {}", (Object)url);
            }
        }
        return type;
    }

    private static int getTypeFromHttpHeaders(HttpHeaders headers, int currentType) {
        String contentType = headers.firstValue("content-type").orElse("");
        if (contentType.isEmpty()) {
            LOGGER.trace("web server has no content type set ...");
            return currentType;
        }
        if (contentType.startsWith("audio")) {
            return 1;
        }
        if (contentType.startsWith("video")) {
            return 4;
        }
        if (contentType.startsWith("image")) {
            return 2;
        }
        LOGGER.trace("web server has no content type set ...");
        return currentType;
    }
}

