/*
 * Decompiled with CFR 0.152.
 */
package net.pms.parsers;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.dlna.DLNAThumbnail;
import net.pms.external.JavaHttpClient;
import net.pms.formats.AudioAsVideo;
import net.pms.formats.Format;
import net.pms.image.ExifInfo;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.image.ImagesUtil;
import net.pms.media.MediaInfo;
import net.pms.network.HTTPResource;
import net.pms.parsers.DCRawParser;
import net.pms.parsers.FFmpegParser;
import net.pms.parsers.JaudiotaggerParser;
import net.pms.parsers.MPlayerParser;
import net.pms.parsers.MediaInfoParser;
import net.pms.parsers.RealAudioParser;
import net.pms.store.ThumbnailSource;
import net.pms.util.InputFile;
import net.pms.util.UnknownFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static final Logger LOGGER = LoggerFactory.getLogger(Parser.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    public static final String MANUAL_PARSER = "NO_PARSER";

    protected Parser() {
    }

    public static void parse(MediaInfo media, InputFile file, Format ext, int type) {
        media.waitMediaParsing(5);
        if (media.isMediaParsed()) {
            return;
        }
        media.resetParser();
        if (file.getFile() != null) {
            if (ext.getIdentifier() == Format.Identifier.RA && RealAudioParser.parse(media, file, type)) {
                return;
            }
            if (ext.getIdentifier() == Format.Identifier.RAW && DCRawParser.parse(media, file, type)) {
                return;
            }
            if (MediaInfoParser.isValid() && ext.getIdentifier() != Format.Identifier.ADPCM && ext.getIdentifier() != Format.Identifier.DFF && ext.getIdentifier() != Format.Identifier.DSF && ext.getIdentifier() != Format.Identifier.PNM) {
                MediaInfoParser.parse(media, file.getFile(), type);
            } else if (type == 1 || ext instanceof AudioAsVideo) {
                JaudiotaggerParser.parse(media, file.getFile(), ext);
            } else {
                FFmpegParser.parse(media, file, ext, type);
            }
        } else {
            FFmpegParser.parse(media, file, ext, type);
        }
    }

    public static void postParse(MediaInfo mediaInfo, int type) {
        String container = mediaInfo.getContainer();
        String codecA = mediaInfo.getDefaultAudioTrack() != null ? mediaInfo.getDefaultAudioTrack().getCodec() : null;
        String codecV = mediaInfo.getDefaultVideoTrack() != null ? mediaInfo.getDefaultVideoTrack().getCodec() : null;
        String mimeType = null;
        if (container != null) {
            switch (container) {
                case "avi": {
                    String string = "video/avi";
                    break;
                }
                case "asf": {
                    String string = "video/x-ms-asf";
                    break;
                }
                case "flv": {
                    String string = "video/x-flv";
                    break;
                }
                case "m4v": {
                    String string = "video/x-m4v";
                    break;
                }
                case "mp4": {
                    String string = "video/mp4";
                    break;
                }
                case "mpegps": {
                    String string = "video/mpeg";
                    break;
                }
                case "mpegts": {
                    String string = "video/vnd.dlna.mpeg-tts";
                    break;
                }
                case "hls": {
                    String string = "application/x-mpegURL";
                    break;
                }
                case "wmv": {
                    String string = "video/x-ms-wmv";
                    break;
                }
                case "mov": {
                    String string = "video/quicktime";
                    break;
                }
                case "adpcm": {
                    String string = "audio/x-adpcm";
                    break;
                }
                case "adts": {
                    String string = "audio/vnd.dlna.adts";
                    break;
                }
                case "m4a": {
                    String string = "audio/mp4";
                    break;
                }
                case "ac3": {
                    String string = "audio/vnd.dolby.dd-raw";
                    break;
                }
                case "au": {
                    String string = "audio/basic";
                    break;
                }
                case "dff": {
                    String string = "audio/x-dff";
                    break;
                }
                case "dsf": {
                    String string = "audio/x-dsf";
                    break;
                }
                case "eac3": {
                    String string = "audio/eac3";
                    break;
                }
                case "mpa": {
                    String string = "audio/mpeg";
                    break;
                }
                case "mp2": {
                    String string = "audio/mpeg";
                    break;
                }
                case "aiff": {
                    String string = "audio/aiff";
                    break;
                }
                case "atrac": {
                    String string = "audio/x-sony-oma";
                    break;
                }
                case "mka": {
                    String string = "audio/x-matroska";
                    break;
                }
                case "mlp": {
                    String string = "audio/vnd.dolby.mlp";
                    break;
                }
                case "ape": {
                    String string = "audio/x-ape";
                    break;
                }
                case "mpc": {
                    String string = "audio/x-musepack";
                    break;
                }
                case "ogg": {
                    String string = "video/ogg";
                    break;
                }
                case "oga": {
                    String string = "audio/ogg";
                    break;
                }
                case "ra": {
                    String string = "audio/vnd.rn-realaudio";
                    break;
                }
                case "rm": {
                    String string = "application/vnd.rn-realmedia";
                    break;
                }
                case "shn": {
                    String string = "audio/x-shn";
                    break;
                }
                case "3ga": {
                    String string = "audio/3gpp";
                    break;
                }
                case "truehd": {
                    String string = "audio/vnd.dolby.mlp";
                    break;
                }
                case "tta": {
                    String string = "audio/x-tta";
                    break;
                }
                case "wavpack": {
                    String string = "audio/x-wavpack";
                    break;
                }
                case "weba": {
                    String string = "audio/webm";
                    break;
                }
                case "webp": {
                    String string = "image/webp";
                    break;
                }
                case "wma": 
                case "wma10": {
                    String string = "audio/x-ms-wma";
                    break;
                }
                case "bmp": {
                    String string = "image/bmp";
                    break;
                }
                case "gif": {
                    String string = "image/gif";
                    break;
                }
                case "jpeg": {
                    String string = "image/jpeg";
                    break;
                }
                case "png": {
                    String string = "image/png";
                    break;
                }
                case "tiff": {
                    String string = "image/tiff";
                    break;
                }
                default: {
                    String string = mimeType = mimeType;
                }
            }
        }
        if (mimeType == null) {
            if (codecV != null && !codecV.equals("und")) {
                if ("matroska".equals(container) || "mkv".equals(container)) {
                    mimeType = "video/x-matroska";
                } else if ("ogg".equals(container)) {
                    mimeType = "video/ogg";
                } else if ("3gp".equals(container)) {
                    mimeType = "video/3gpp";
                } else if ("3g2".equals(container)) {
                    mimeType = "video/3gpp2";
                } else if ("webm".equals(container)) {
                    mimeType = "video/webm";
                } else if (container != null && container.startsWith("flash")) {
                    mimeType = "video/x-flv";
                } else if (codecV.startsWith("h264") || codecV.equals("h263") || codecV.equals("mpeg4") || codecV.equals("mp4")) {
                    mimeType = "video/mp4";
                } else if (codecV.contains("mpeg") || codecV.contains("mpg")) {
                    mimeType = "video/mpeg";
                }
            } else if ((codecV == null || codecV.equals("und")) && codecA != null) {
                if ("ogg".equals(container) || "oga".equals(container)) {
                    mimeType = "audio/ogg";
                } else if ("3gp".equals(container)) {
                    mimeType = "audio/3gpp";
                } else if ("3g2".equals(container)) {
                    mimeType = "audio/3gpp2";
                } else if ("adts".equals(container)) {
                    mimeType = "audio/vnd.dlna.adts";
                } else if ("matroska".equals(container) || "mkv".equals(container)) {
                    mimeType = "audio/x-matroska";
                } else if ("webm".equals(container)) {
                    mimeType = "audio/webm";
                } else if (codecA.contains("mp3")) {
                    mimeType = "audio/mpeg";
                } else if (codecA.equals("mpa")) {
                    mimeType = "audio/mpeg";
                } else if (codecA.equals("mp2")) {
                    mimeType = "audio/mpeg";
                } else if (codecA.contains("flac")) {
                    mimeType = "audio/x-flac";
                } else if (codecA.contains("vorbis")) {
                    mimeType = "audio/ogg";
                } else if (codecA.contains("asf") || codecA.startsWith("wm")) {
                    mimeType = "audio/x-ms-wma";
                } else if (codecA.contains("pcm") || codecA.contains("wav") || codecA.contains("dts")) {
                    mimeType = "audio/wav";
                } else if (codecA.equals("truehd")) {
                    mimeType = "audio/vnd.dolby.mlp";
                } else if (codecA.equals("dts")) {
                    mimeType = "audio/vnd.dts";
                } else if (codecA.equals("dtshd")) {
                    mimeType = "audio/vnd.dts.hd";
                } else if (codecA.equals("eac3")) {
                    mimeType = "audio/eac3";
                } else if (codecA.equals("adpcm")) {
                    mimeType = "audio/x-adpcm";
                } else if (codecA.equals("dff")) {
                    mimeType = "audio/x-dff";
                } else if (codecA.equals("dsf")) {
                    mimeType = "audio/x-dsf";
                }
            }
            if (mimeType == null) {
                mimeType = HTTPResource.getDefaultMimeType(type);
            }
        }
        mediaInfo.setMimeType(mimeType);
    }

    public static DLNAThumbnail getThumbnail(MediaInfo media, InputFile inputFile, Format ext, int type, Double seekPosition) {
        if (inputFile != null) {
            File file = inputFile.getFile();
            if (type == 1 || ext instanceof AudioAsVideo) {
                return JaudiotaggerParser.getThumbnail(media, file);
            }
            if (type == 2 && file != null) {
                try {
                    DLNAThumbnail thumb;
                    ExifInfo exifInfo;
                    ImageInfo imageInfo = media.getImageInfo();
                    if (!(imageInfo instanceof ExifInfo && (exifInfo = (ExifInfo)imageInfo).hasExifThumbnail() && !exifInfo.isImageIOSupported() || (thumb = DLNAThumbnail.toThumbnail(Files.newInputStream(file.toPath(), new OpenOption[0]), 320, 320, ImagesUtil.ScaleType.MAX, ImageFormat.SOURCE, false)) == null)) {
                        media.setThumbnailSource(ThumbnailSource.EMBEDDED);
                        return thumb;
                    }
                }
                catch (EOFException e) {
                    LOGGER.debug("Error generating thumbnail for \"{}\": Unexpected end of file, probably corrupt file or read error.", (Object)file.getName());
                }
                catch (UnknownFormatException e) {
                    LOGGER.debug("Could not generate thumbnail for \"{}\" because the format is unknown: {}", (Object)file.getName(), (Object)e.getMessage());
                }
                catch (IOException e) {
                    LOGGER.debug("Error generating thumbnail for \"{}\": {}", (Object)file.getName(), (Object)e.getMessage());
                    LOGGER.trace("", e);
                }
            } else if (type == 4) {
                DLNAThumbnail thumb;
                if (seekPosition == null && media.hasVideoMetadata() && media.getVideoMetadata().getPoster() != null && (thumb = JavaHttpClient.getThumbnail(media.getVideoMetadata().getPoster())) != null) {
                    media.setThumbnailSource(ThumbnailSource.TMDB_LOC);
                    return thumb;
                }
                if (CONFIGURATION.isUseMplayerForVideoThumbs() && (thumb = MPlayerParser.getThumbnail(media, inputFile, seekPosition)) != null) {
                    return thumb;
                }
                thumb = FFmpegParser.getThumbnail(media, inputFile, seekPosition);
                if (thumb != null) {
                    return thumb;
                }
            }
        }
        return null;
    }
}

