/*
 * Decompiled with CFR 0.152.
 */
package net.pms.parsers;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.pms.dlna.DLNAThumbnail;
import net.pms.formats.v2.SubtitleType;
import net.pms.image.ImageFormat;
import net.pms.image.ImagesUtil;
import net.pms.media.MediaInfo;
import net.pms.media.audio.MediaAudio;
import net.pms.media.audio.metadata.MediaAudioMetadata;
import net.pms.media.chapter.MediaChapter;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.media.video.MediaVideo;
import net.pms.parsers.JaudiotaggerParser;
import net.pms.parsers.MetadataExtractorParser;
import net.pms.parsers.Parser;
import net.pms.parsers.mediainfo.InfoKind;
import net.pms.parsers.mediainfo.MediaInfoHelper;
import net.pms.parsers.mediainfo.MediaInfoParseLogger;
import net.pms.parsers.mediainfo.StreamAudio;
import net.pms.parsers.mediainfo.StreamContainer;
import net.pms.parsers.mediainfo.StreamImage;
import net.pms.parsers.mediainfo.StreamKind;
import net.pms.parsers.mediainfo.StreamMenu;
import net.pms.parsers.mediainfo.StreamSubtitle;
import net.pms.parsers.mediainfo.StreamVideo;
import net.pms.store.ThumbnailSource;
import net.pms.store.ThumbnailStore;
import net.pms.util.FileUtil;
import net.pms.util.Iso639;
import net.pms.util.UnknownFormatException;
import net.pms.util.Version;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaInfoParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaInfoParser.class);
    private static final String YEAR_REGEX = ".*([\\d]{4}).*";
    private static final Pattern YEAR_PATTERN = Pattern.compile(".*([\\d]{4}).*");
    private static final Version VERSION;
    private static final boolean IS_VALID;
    public static final String PARSER_NAME;
    private static boolean blocked;

    private MediaInfoParser() {
    }

    public static boolean isValid() {
        return IS_VALID && !blocked;
    }

    protected static void block() {
        blocked = true;
    }

    protected static void unblock() {
        blocked = false;
    }

    @Nullable
    public static Version getVersion() {
        return VERSION;
    }

    private static MediaInfoHelper getMediaInfoHelper(boolean log) {
        MediaInfoHelper mediaInfoHelper = new MediaInfoHelper(log);
        if (mediaInfoHelper.isValid()) {
            mediaInfoHelper.option("Internet", "No");
            mediaInfoHelper.option("Complete", "1");
            mediaInfoHelper.option("Language", "en");
            mediaInfoHelper.option("File_TestContinuousFileNames", "0");
            mediaInfoHelper.option("ReadByHuman", "0");
            mediaInfoHelper.option("Cover_Data", "base64");
            mediaInfoHelper.option("File_HighestFormat", "0");
        }
        return mediaInfoHelper;
    }

    public static void parse(MediaInfo media, File file, int type) {
        boolean fileOpened;
        media.waitMediaParsing(5);
        media.setParsing(true);
        if (file == null || media.isMediaParsed()) {
            media.setParsing(false);
            return;
        }
        MediaInfoHelper mediaInfoHelper = MediaInfoParser.getMediaInfoHelper(false);
        if (!mediaInfoHelper.isValid()) {
            media.setParsing(false);
            return;
        }
        MediaInfoParseLogger parseLogger = LOGGER.isTraceEnabled() ? new MediaInfoParseLogger(mediaInfoHelper) : null;
        boolean bl = fileOpened = mediaInfoHelper.openFile(file.getAbsolutePath()) > 0;
        if (fileOpened) {
            Long subTrackCount;
            Long imageCount;
            Long audioTracks;
            Long longValue;
            MediaSubtitle currentSubTrack;
            Long videoTrackCount;
            String value;
            MediaAudio currentAudioTrack = new MediaAudio();
            MediaVideo currentVideoTrack = new MediaVideo();
            media.resetParser();
            media.setSize(file.length());
            MediaInfoParser.setFormat(StreamKind.GENERAL, media, currentVideoTrack, currentAudioTrack, StreamContainer.getFormat(mediaInfoHelper, 0), file);
            MediaInfoParser.setFormat(StreamKind.GENERAL, media, currentVideoTrack, currentAudioTrack, StreamContainer.getCodecID(mediaInfoHelper, 0).trim(), file);
            Double doubleValue = StreamContainer.getDuration(mediaInfoHelper, 0);
            if (doubleValue != null) {
                media.setDuration(doubleValue / 1000.0);
            }
            media.setBitRate(MediaInfoParser.getIntValue(StreamContainer.getOverallBitRate(mediaInfoHelper, 0), 0));
            media.setTitle(StreamContainer.getTitle(mediaInfoHelper, 0));
            if (parseLogger != null) {
                parseLogger.logGeneralColumns(file);
            }
            if (!(value = StreamContainer.getCoverData(mediaInfoHelper, 0)).isEmpty()) {
                String[] thumbs = value.split(" / ");
                try {
                    thumbs[0] = thumbs[0].trim();
                    DLNAThumbnail thumbnail = DLNAThumbnail.toThumbnail(Base64.getDecoder().decode(thumbs[0]), 640, 480, ImagesUtil.ScaleType.MAX, ImageFormat.SOURCE, false);
                    if (thumbnail != null) {
                        Long thumbId = ThumbnailStore.getId(thumbnail);
                        media.setThumbnailId(thumbId);
                        media.setThumbnailSource(ThumbnailSource.EMBEDDED);
                    }
                }
                catch (EOFException e) {
                    LOGGER.debug("Error reading \"{}\" thumbnail from MediaInfo: Unexpected end of stream, probably corrupt or read error.", (Object)file.getName());
                }
                catch (UnknownFormatException e) {
                    LOGGER.debug("Could not read \"{}\" thumbnail from MediaInfo: {}", (Object)file.getName(), (Object)e.getMessage());
                }
                catch (IOException e) {
                    LOGGER.error("Error reading \"{}\" thumbnail from MediaInfo: {}", (Object)file.getName(), (Object)e.getMessage());
                    LOGGER.trace("", e);
                }
            }
            if (mediaInfoHelper.countGet(StreamKind.MENU, 0) > 0) {
                Long chaptersPosBeginLong = StreamMenu.getChaptersPosBegin(mediaInfoHelper, 0);
                Long chaptersPosEndLong = StreamMenu.getChaptersPosEnd(mediaInfoHelper, 0);
                if (chaptersPosBeginLong != null && chaptersPosEndLong != null) {
                    int chaptersPosBegin = chaptersPosBeginLong.intValue();
                    int chaptersPosEnd = chaptersPosEndLong.intValue();
                    ArrayList<MediaChapter> chapters = new ArrayList<MediaChapter>();
                    for (int i = chaptersPosBegin; i <= chaptersPosEnd; ++i) {
                        LocalTime lt;
                        String chapterName = mediaInfoHelper.get(StreamKind.MENU, 0, i, InfoKind.NAME);
                        String chapterTitle = mediaInfoHelper.get(StreamKind.MENU, 0, i, InfoKind.TEXT);
                        if (chapterName.isEmpty()) continue;
                        MediaChapter chapter = new MediaChapter();
                        try {
                            lt = LocalTime.parse(chapterName, DateTimeFormatter.ofPattern("HH:mm:ss.SSS"));
                        }
                        catch (DateTimeParseException e) {
                            LOGGER.debug("Skip chapter as time cannot be parsed: {}", (Object)chapterName);
                            continue;
                        }
                        chapter.setId(i - chaptersPosBegin);
                        chapter.setStart((double)lt.toNanoOfDay() / 1.0E9);
                        if (!chapters.isEmpty()) {
                            ((MediaChapter)chapters.get(chapters.size() - 1)).setEnd(chapter.getStart());
                        }
                        if (!chapterTitle.isEmpty()) {
                            String lang = "und";
                            chapter.setLang(lang);
                            if (chapterTitle.startsWith(":")) {
                                chapterTitle = chapterTitle.substring(1);
                            } else if (chapterTitle.length() > 2 && ':' == chapterTitle.charAt(2) && (chapterTitle.length() < 15 || ':' != chapterTitle.charAt(5) || ':' == chapterTitle.charAt(8))) {
                                lang = chapterTitle.substring(0, 2);
                                chapterTitle = chapterTitle.substring(3);
                            }
                            if (!MediaChapter.isTitleDefault(chapterTitle)) {
                                chapter.setLang(lang);
                                chapter.setTitle(chapterTitle);
                            }
                        }
                        chapters.add(chapter);
                    }
                    if (!chapters.isEmpty()) {
                        ((MediaChapter)chapters.get(chapters.size() - 1)).setEnd(media.getDurationInSeconds());
                    }
                    media.setChapters(chapters);
                }
            }
            if ((videoTrackCount = StreamVideo.getStreamCount(mediaInfoHelper, 0)) != null && videoTrackCount > 0L) {
                int i = 0;
                while ((long)i < videoTrackCount) {
                    if (StreamVideo.getTitle(mediaInfoHelper, i).startsWith("Subtitle")) {
                        currentSubTrack = new MediaSubtitle();
                        currentSubTrack.setType(SubtitleType.valueOfMediaInfoValue(StreamVideo.getFormat(mediaInfoHelper, i)));
                        currentSubTrack.setType(SubtitleType.valueOfMediaInfoValue(StreamVideo.getCodecID(mediaInfoHelper, i), currentSubTrack.getType()));
                        currentSubTrack.setId(media.getSubtitlesTracks().size());
                        longValue = StreamVideo.getStreamOrder(mediaInfoHelper, i);
                        if (longValue != null) {
                            currentSubTrack.setStreamOrder(longValue.intValue());
                        }
                        currentSubTrack.setDefault("Yes".equals(StreamVideo.getDefault(mediaInfoHelper, i)));
                        currentSubTrack.setForced("Yes".equals(StreamVideo.getForced(mediaInfoHelper, i)));
                        MediaInfoParser.addSubtitlesTrack(currentSubTrack, media);
                    } else {
                        currentVideoTrack = new MediaVideo();
                        currentVideoTrack.setId(i);
                        MediaInfoParser.setFormat(StreamKind.VIDEO, media, currentVideoTrack, currentAudioTrack, StreamVideo.getFormat(mediaInfoHelper, i), file);
                        MediaInfoParser.setFormat(StreamKind.VIDEO, media, currentVideoTrack, currentAudioTrack, StreamVideo.getFormatVersion(mediaInfoHelper, i), file);
                        MediaInfoParser.setFormat(StreamKind.VIDEO, media, currentVideoTrack, currentAudioTrack, StreamVideo.getCodecID(mediaInfoHelper, i), file);
                        longValue = StreamVideo.getStreamOrder(mediaInfoHelper, i);
                        if (longValue != null) {
                            currentVideoTrack.setStreamOrder(longValue.intValue());
                        }
                        currentVideoTrack.setDefault("Yes".equals(StreamVideo.getDefault(mediaInfoHelper, i)));
                        currentVideoTrack.setForced("Yes".equals(StreamVideo.getForced(mediaInfoHelper, i)));
                        currentVideoTrack.setWidth(StreamVideo.getWidth(mediaInfoHelper, i).intValue());
                        currentVideoTrack.setHeight(StreamVideo.getHeight(mediaInfoHelper, i).intValue());
                        doubleValue = StreamVideo.getDuration(mediaInfoHelper, i);
                        doubleValue = doubleValue == null ? media.getDuration() : Double.valueOf(doubleValue / 1000.0);
                        currentVideoTrack.setDuration(doubleValue);
                        currentVideoTrack.setBitRate(MediaInfoParser.getIntValue(StreamVideo.getBitRate(mediaInfoHelper, i), 0));
                        value = StreamVideo.getFormatProfile(mediaInfoHelper, i);
                        if (!value.isEmpty()) {
                            String[] profile = MediaInfoParser.getFormatProfile(value);
                            if (profile[0] != null) {
                                currentVideoTrack.setFormatProfile(profile[0]);
                            }
                            if (profile[1] != null) {
                                currentVideoTrack.setFormatLevel(profile[1]);
                            }
                            if (profile[2] != null) {
                                currentVideoTrack.setFormatTier(profile[2]);
                            }
                        }
                        currentVideoTrack.setMatrixCoefficients(StreamVideo.getmatrixcoefficients(mediaInfoHelper, i));
                        currentVideoTrack.setMultiViewLayout(StreamVideo.getMultiViewLayout(mediaInfoHelper, i));
                        currentVideoTrack.setPixelAspectRatio(StreamVideo.getPixelAspectRatio(mediaInfoHelper, i));
                        currentVideoTrack.setScanType(StreamVideo.getScanType(mediaInfoHelper, i));
                        currentVideoTrack.setScanOrder(StreamVideo.getScanOrder(mediaInfoHelper, i));
                        currentVideoTrack.setDisplayAspectRatio(StreamVideo.getDisplayAspectRatioString(mediaInfoHelper, i));
                        currentVideoTrack.setOriginalDisplayAspectRatio(StreamVideo.getDisplayAspectRatioOriginalString(mediaInfoHelper, i));
                        currentVideoTrack.setFrameRate(StreamVideo.getFrameRate(mediaInfoHelper, i));
                        currentVideoTrack.setFrameRateModeOriginal(StreamVideo.getFrameRateModeOriginal(mediaInfoHelper, i));
                        currentVideoTrack.setFrameRateMode(MediaInfoParser.getFrameRateModeValue(StreamVideo.getFrameRateMode(mediaInfoHelper, i)));
                        currentVideoTrack.setFrameRateModeRaw(StreamVideo.getFrameRateMode(mediaInfoHelper, i));
                        currentVideoTrack.setReferenceFrameCount(MediaInfoParser.getByteValue(StreamVideo.getFormatSettingsRefFrames(mediaInfoHelper, i), (byte)-1));
                        currentVideoTrack.setTitle(StreamVideo.getTitle(mediaInfoHelper, i));
                        value = StreamVideo.getFormatSettingsQPel(mediaInfoHelper, i);
                        if (!value.isEmpty()) {
                            currentVideoTrack.putExtra("qpel", value);
                        }
                        if (!(value = StreamVideo.getFormatSettingsGMCString(mediaInfoHelper, i)).isEmpty()) {
                            currentVideoTrack.putExtra("gmc", value);
                        }
                        if (!(value = StreamVideo.getFormatSettingsGOP(mediaInfoHelper, i)).isEmpty()) {
                            currentVideoTrack.putExtra("gop", value);
                        }
                        currentVideoTrack.setMuxingMode(StreamVideo.getMuxingMode(mediaInfoHelper, i));
                        currentVideoTrack.setEncrypted("encrypted".equals(StreamVideo.getEncryption(mediaInfoHelper, i)));
                        longValue = StreamVideo.getBitDepth(mediaInfoHelper, i);
                        if (longValue != null) {
                            currentVideoTrack.setBitDepth(longValue.intValue());
                        }
                        if (!(value = StreamVideo.getHDRFormat(mediaInfoHelper, i)).isEmpty()) {
                            currentVideoTrack.setHDRFormat(value);
                        }
                        if (!(value = StreamVideo.getHDRFormatCompatibility(mediaInfoHelper, i)).isEmpty()) {
                            currentVideoTrack.setHDRFormatCompatibility(value);
                        }
                        if (StringUtils.isNotBlank(value = StreamVideo.getLanguageString3(mediaInfoHelper, i))) {
                            currentVideoTrack.setLang(Iso639.getISO639_2Code(value));
                        }
                        if (StringUtils.isNotBlank(value = StreamVideo.getID(mediaInfoHelper, i))) {
                            currentVideoTrack.setOptionalId(MediaInfoParser.getSpecificID(value));
                        }
                        MediaInfoParser.addVideoTrack(currentVideoTrack, media);
                        if (parseLogger != null) {
                            parseLogger.logVideoTrackColumns(i);
                        }
                    }
                    ++i;
                }
            }
            if ((audioTracks = StreamAudio.getStreamCount(mediaInfoHelper, 0)) != null && audioTracks > 0L) {
                int i = 0;
                while ((long)i < audioTracks) {
                    currentAudioTrack = new MediaAudio();
                    currentAudioTrack.setId(i);
                    longValue = StreamAudio.getStreamOrder(mediaInfoHelper, i);
                    if (longValue != null) {
                        currentAudioTrack.setStreamOrder(longValue.intValue());
                    }
                    currentAudioTrack.setDefault("Yes".equals(StreamAudio.getDefault(mediaInfoHelper, i)));
                    currentAudioTrack.setForced("Yes".equals(StreamAudio.getForced(mediaInfoHelper, i)));
                    MediaInfoParser.setFormat(StreamKind.AUDIO, media, currentVideoTrack, currentAudioTrack, StreamAudio.getFormat(mediaInfoHelper, i), file);
                    MediaInfoParser.setFormat(StreamKind.AUDIO, media, currentVideoTrack, currentAudioTrack, StreamAudio.getFormatVersion(mediaInfoHelper, i), file);
                    MediaInfoParser.setFormat(StreamKind.AUDIO, media, currentVideoTrack, currentAudioTrack, StreamAudio.getFormatProfile(mediaInfoHelper, i), file);
                    MediaInfoParser.setFormat(StreamKind.AUDIO, media, currentVideoTrack, currentAudioTrack, StreamAudio.getCodecID(mediaInfoHelper, i), file);
                    value = StreamAudio.getCodecIDDescription(mediaInfoHelper, i);
                    if (StringUtils.isNotBlank(value) && value.startsWith("Windows Media Audio 10")) {
                        currentAudioTrack.setCodec("wma10");
                    }
                    String languageCode = null;
                    value = StreamAudio.getLanguageString3(mediaInfoHelper, i);
                    if (StringUtils.isNotBlank(value)) {
                        languageCode = Iso639.getISO639_2Code(value);
                        currentAudioTrack.setLang(languageCode);
                    }
                    value = StreamAudio.getTitle(mediaInfoHelper, i).trim();
                    currentAudioTrack.setTitle(value);
                    if (languageCode == null && StringUtils.isNotBlank(value)) {
                        languageCode = Iso639.getISO639_2Code(value, true);
                        currentAudioTrack.setLang(languageCode);
                    }
                    currentAudioTrack.setNumberOfChannels(MediaInfoParser.getIntValue(StreamAudio.getChannels(mediaInfoHelper, i), 2));
                    currentAudioTrack.setSampleRate(MediaInfoParser.getIntValue(StreamAudio.getSamplingRate(mediaInfoHelper, i), 48000));
                    currentAudioTrack.setBitRate(MediaInfoParser.getIntValue(StreamAudio.getBitRate(mediaInfoHelper, i), 0));
                    currentAudioTrack.setVideoDelay(MediaInfoParser.getIntValue(StreamAudio.getVideoDelay(mediaInfoHelper, i), 0));
                    currentAudioTrack.setBitDepth(MediaInfoParser.getIntValue(StreamAudio.getBitDepth(mediaInfoHelper, i), 16));
                    value = StreamAudio.getID(mediaInfoHelper, i);
                    if (StringUtils.isNotBlank(value)) {
                        currentAudioTrack.setOptionalId(MediaInfoParser.getSpecificID(value));
                    }
                    MediaInfoParser.addAudioTrack(currentAudioTrack, media);
                    if (parseLogger != null) {
                        parseLogger.logAudioTrackColumns(i);
                    }
                    ++i;
                }
            }
            if ((imageCount = StreamImage.getStreamCount(mediaInfoHelper, 0)) != null) {
                media.setImageCount(imageCount.intValue());
            }
            if (media.getImageCount() > 0 || type == 2) {
                boolean parseByMediainfo = false;
                try {
                    MetadataExtractorParser.parse(file, media);
                }
                catch (IOException e) {
                    if (media.getImageCount() > 0) {
                        LOGGER.debug("Error parsing image ({}), switching to MediaInfo: {}", (Object)file.getAbsolutePath(), (Object)e.getMessage());
                        LOGGER.trace("", e);
                        parseByMediainfo = true;
                    }
                    LOGGER.warn("Image parsing for \"{}\" failed both with MediaInfo and internally: {}", (Object)file.getAbsolutePath(), (Object)e.getMessage());
                    LOGGER.trace("", e);
                    media.setImageCount(1);
                }
                if (parseByMediainfo) {
                    MediaInfoParser.setFormat(StreamKind.IMAGE, media, currentVideoTrack, currentAudioTrack, StreamImage.getFormat(mediaInfoHelper, 0), file);
                }
                if (parseLogger != null) {
                    parseLogger.logImageColumns(0);
                }
            }
            if ((subTrackCount = StreamSubtitle.getStreamCount(mediaInfoHelper, 0)) != null && subTrackCount > 0L) {
                int i = 0;
                while ((long)i < subTrackCount) {
                    currentSubTrack = new MediaSubtitle();
                    currentSubTrack.setType(SubtitleType.valueOfMediaInfoValue(StreamSubtitle.getCodecID(mediaInfoHelper, i), SubtitleType.valueOfMediaInfoValue(StreamSubtitle.getFormat(mediaInfoHelper, i))));
                    currentSubTrack.setId(media.getSubtitlesTracks().size());
                    String languageCode = null;
                    value = StreamSubtitle.getLanguageString3(mediaInfoHelper, i);
                    if (StringUtils.isNotBlank(value)) {
                        languageCode = Iso639.getISO639_2Code(value);
                        currentSubTrack.setLang(languageCode);
                    }
                    value = StreamSubtitle.getTitle(mediaInfoHelper, i).trim();
                    currentSubTrack.setTitle(value);
                    if (languageCode == null && StringUtils.isNotBlank(value)) {
                        languageCode = Iso639.getISO639_2Code(value, true);
                        currentSubTrack.setLang(languageCode);
                    }
                    if (StringUtils.isNotBlank(value = StreamSubtitle.getID(mediaInfoHelper, i))) {
                        currentSubTrack.setOptionalId(MediaInfoParser.getSpecificID(value));
                    }
                    currentSubTrack.setDefault("Yes".equals(StreamSubtitle.getDefault(mediaInfoHelper, i)));
                    currentSubTrack.setForced("Yes".equals(StreamSubtitle.getForced(mediaInfoHelper, i)));
                    MediaInfoParser.addSubtitlesTrack(currentSubTrack, media);
                    if (parseLogger != null) {
                        parseLogger.logSubtitleTrackColumns(i, false);
                    }
                    ++i;
                }
            }
            if (media.isAudioOrVideoContainer() && media.isAudio()) {
                media.setContainer(media.getAudioVariantFormatConfigurationString());
            }
            if ("wmv".equals(media.getContainer())) {
                for (MediaAudio audioTrack : media.getAudioTracks()) {
                    if (audioTrack.getCodec() == null || audioTrack.getCodec().equals("wma") || audioTrack.getCodec().equals("wmapro") || audioTrack.getCodec().equals("wmalossless") || audioTrack.getCodec().equals("wmavoice") || audioTrack.getCodec().equals("wma10") || audioTrack.getCodec().equals("mp3")) continue;
                    media.setContainer("asf");
                    break;
                }
            }
            if ("wmv".equals(media.getContainer())) {
                for (MediaVideo videoTrack : media.getVideoTracks()) {
                    if (videoTrack.getCodec() == null || videoTrack.getCodec().equals("wmv") || videoTrack.getCodec().equals("vc1")) continue;
                    media.setContainer("asf");
                    break;
                }
            }
            if (media.hasVideoTrack() && !media.getDefaultVideoTrack().is3d()) {
                MediaInfoParser.parseFilenameForMultiViewLayout(file, media);
            }
            if (media.isAudio()) {
                media.setAudioMetadata(MediaInfoParser.parseFileForAudioMetadata(mediaInfoHelper, file, media));
            }
            Parser.postParse(media, type);
            if (parseLogger != null) {
                LOGGER.trace("{}", (Object)parseLogger);
            }
            mediaInfoHelper.closeFile();
            if (media.getContainer() == null) {
                media.setContainer("und");
            }
            if (!media.isImage() || !media.isMediaParsed()) {
                media.setMediaParser(PARSER_NAME);
            }
        }
        try {
            mediaInfoHelper.close();
        }
        catch (Exception ex) {
            LOGGER.warn("MediaInfoHelper on close: ", ex);
        }
        media.setParsing(false);
    }

    public static void addVideoTrack(MediaVideo currentVideoTrack, MediaInfo media) {
        if (StringUtils.isBlank(currentVideoTrack.getLang())) {
            currentVideoTrack.setLang("und");
        }
        if (StringUtils.isBlank(currentVideoTrack.getCodec())) {
            currentVideoTrack.setCodec("und");
        }
        media.addVideoTrack(currentVideoTrack);
    }

    public static void addAudioTrack(MediaAudio currentAudioTrack, MediaInfo media) {
        if (StringUtils.isBlank(currentAudioTrack.getLang())) {
            currentAudioTrack.setLang("und");
        }
        if (StringUtils.isBlank(currentAudioTrack.getCodec())) {
            currentAudioTrack.setCodec("und");
        }
        media.addAudioTrack(currentAudioTrack);
    }

    public static void addSubtitlesTrack(MediaSubtitle currentSubTrack, MediaInfo media) {
        if (currentSubTrack.getType() == SubtitleType.UNSUPPORTED) {
            return;
        }
        if (StringUtils.isBlank(currentSubTrack.getLang())) {
            currentSubTrack.setLang("und");
        }
        media.addSubtitlesTrack(currentSubTrack);
    }

    protected static void setFormat(StreamKind streamType, MediaInfo media, MediaVideo video, MediaAudio audio, String value, File file) {
        String ext;
        if (StringUtils.isBlank(value) || streamType == null) {
            return;
        }
        value = value.toLowerCase(Locale.ROOT);
        String format = null;
        if (StringUtils.isBlank(value)) {
            return;
        }
        if (value.startsWith("3g2")) {
            format = "3g2";
        } else if (value.startsWith("3gp")) {
            format = "3gp";
        } else if (value.startsWith("matroska")) {
            format = "mkv";
        } else if (value.equals("avi") || value.equals("opendml")) {
            format = "avi";
        } else if (value.startsWith("cinepa")) {
            format = "cvid";
        } else if (value.startsWith("flash")) {
            format = "flv";
        } else if (value.equals("webm")) {
            format = "webm";
        } else if (value.equals("qt") || value.equals("quicktime")) {
            format = "mov";
        } else if (value.contains("isom") || streamType != StreamKind.AUDIO && value.startsWith("mp4") && !value.startsWith("mp4a") || value.equals("20") || value.equals("isml") || value.startsWith("m4a") && !value.startsWith("m4ae") || value.startsWith("m4v") || value.equals("mpeg-4 visual")) {
            format = "mp4";
        } else if (value.contains("mpeg-ps")) {
            format = "mpegps";
        } else if (value.contains("mpeg-ts") || value.equals("bdav")) {
            format = "mpegts";
        } else if (value.equals("caf")) {
            format = "caf";
        } else if (value.contains("aiff")) {
            format = "aiff";
        } else if (value.startsWith("atmos") || value.equals("131")) {
            format = "atmos";
        } else if (value.contains("ogg")) {
            format = "ogg";
        } else if (value.contains("opus")) {
            format = "opus";
        } else if (value.contains("realmedia") || value.startsWith("rv")) {
            format = "rm";
        } else if (value.startsWith("theora")) {
            format = "theora";
        } else if (value.startsWith("windows media") || value.equals("wmv1") || value.equals("wmv2")) {
            format = "wmv";
        } else if (streamType == StreamKind.VIDEO && (value.contains("mjpg") || value.contains("mjpeg") || value.equals("mjpa") || value.equals("mjpb") || value.equals("jpeg") || value.equals("jpeg2000"))) {
            format = "mjpeg";
        } else if (value.equals("h261")) {
            format = "h261";
        } else if (value.equals("h263") || value.equals("s263") || value.equals("u263")) {
            format = "h263";
        } else if (streamType == StreamKind.VIDEO && (value.startsWith("avc") || value.startsWith("h264"))) {
            format = "h264";
        } else if (value.startsWith("hevc")) {
            format = "h265";
        } else if (value.startsWith("sorenson")) {
            format = "sor";
        } else if (value.startsWith("vp6")) {
            format = "vp6";
        } else if (value.startsWith("vp7")) {
            format = "vp7";
        } else if (value.startsWith("vp8")) {
            format = "vp8";
        } else if (value.startsWith("vp9")) {
            format = "vp9";
        } else if (value.startsWith("div") || value.startsWith("xvid") || value.equals("dx50") || value.equals("dvx1")) {
            format = "divx";
        } else if (value.startsWith("indeo")) {
            format = "indeo";
        } else if (streamType == StreamKind.VIDEO && value.equals("yuv")) {
            format = "yuv";
        } else if (streamType == StreamKind.VIDEO && (value.equals("rgb") || value.equals("rgba"))) {
            format = "rgb";
        } else if (streamType == StreamKind.VIDEO && value.equals("rle")) {
            format = "rle";
        } else if (value.equals("mac3")) {
            format = "mace3";
        } else if (value.equals("mac6")) {
            format = "mace6";
        } else if (streamType == StreamKind.VIDEO && value.startsWith("tga")) {
            format = "tga";
        } else if (value.equals("ffv1")) {
            format = "ffv1";
        } else if (value.equals("celp")) {
            format = "celp";
        } else if (value.equals("qcelp")) {
            format = "qcelp";
        } else if (value.matches("(?i)(dv)|(cdv.?)|(dc25)|(dcap)|(dvc.?)|(dvs.?)|(dvrs)|(dv25)|(dv50)|(dvan)|(dvh.?)|(dvis)|(dvl.?)|(dvnm)|(dvp.?)|(mdvf)|(pdvc)|(r411)|(r420)|(sdcc)|(sl25)|(sl50)|(sldv)") && !value.contains("dvhe") && !value.contains("dvh1")) {
            format = "dv";
        } else if (value.contains("mpeg video")) {
            format = "mpeg2";
        } else if (value.startsWith("version 1")) {
            if (video.getCodec() != null && video.getCodec().equals("mpeg2") && audio.getCodec() == null) {
                format = "mpeg1";
            }
        } else if (value.equals("vc-1") || value.equals("wvc1") || value.equals("wmv3") || value.equals("wmvp") || value.equals("wmva")) {
            format = "vc1";
        } else if (value.equals("au") || value.equals("ulaw/au audio file")) {
            format = "au";
        } else if (value.equals("av01") || value.contains("av1")) {
            format = "av1";
        } else if (value.equals("layer 3")) {
            if (audio.getCodec() != null && audio.getCodec().equals("mpa")) {
                format = "mp3";
                if (media.getContainer() != null && media.getContainer().equals("mpa")) {
                    media.setContainer("mp3");
                }
            }
        } else if (value.equals("layer 2") && audio.getCodec() != null && media.getContainer() != null && audio.getCodec().equals("mpa") && media.getContainer().equals("mpa")) {
            format = "mp2";
            media.setContainer("mp2");
        } else if (value.equals("ma") || value.equals("ma / core") || value.equals("x / ma / core") || value.equals("imax / x / ma / core") || value.equals("134")) {
            if (audio.getCodec() != null && audio.getCodec().equals("dts")) {
                format = "dtshd";
            }
        } else if (value.equals("vorbis") || value.equals("a_vorbis")) {
            format = "vorbis";
        } else if (value.equals("adts")) {
            format = "adts";
        } else if (value.startsWith("amr")) {
            format = "amr";
        } else if (value.equals("dolby e")) {
            format = "dolbye";
        } else if (value.equals("ac-3") || value.equals("a_ac3") || value.equals("2000")) {
            format = "ac3";
        } else if (value.equals("ac-4")) {
            format = "ac4";
        } else if (value.startsWith("cook")) {
            format = "cook";
        } else if (value.startsWith("qdesign")) {
            format = "qdmc";
        } else if (value.equals("realaudio lossless")) {
            format = "ralf";
        } else if (value.contains("e-ac-3")) {
            format = "eac3";
        } else if (value.contains("truehd")) {
            format = "truehd";
        } else if (value.equals("tta")) {
            format = "tta";
        } else if (value.equals("55") || value.equals("a_mpeg/l3")) {
            format = "mp3";
        } else if (value.equals("lc") || value.equals("aac lc") || value.equals("mp4a-40-2") || value.equals("00001000-0000-FF00-8000-00AA00389B71") || value.equals("aac") && "avi".equals(media.getContainer())) {
            format = "aac-lc";
        } else if (value.equals("aac lc sbr")) {
            format = "he-aac";
        } else if (value.equals("ltp")) {
            format = "aac-ltp";
        } else if (value.contains("he-aac")) {
            format = "he-aac";
        } else if (value.equals("main")) {
            format = "aac-main";
        } else if (value.equals("ssr")) {
            format = "aac-ssr";
        } else if (value.startsWith("a_aac")) {
            format = switch (value) {
                case "a_aac/mpeg2/main" -> "aac-main";
                case "a_aac/mpeg2/lc", "a_aac-2" -> "aac-lc";
                case "a_aac/mpeg2/lc/sbr" -> "he-aac";
                case "a_aac/mpeg2/ssr" -> "aac-ssr";
                case "a_aac/mpeg4/main" -> "aac-main";
                case "a_aac/mpeg4/lc" -> "aac-lc";
                case "a_aac/mpeg4/lc/sbr" -> "he-aac";
                case "a_aac/mpeg4/lc/sbr/ps" -> "he-aac";
                case "a_aac/mpeg4/ssr" -> "aac-ssr";
                case "a_aac/mpeg4/ltp" -> "aac-ltp";
                default -> "aac-main";
            };
        } else if (value.equals("er bsac") || value.equals("mp4a-40-22")) {
            format = "erbsac";
        } else if (value.startsWith("adpcm")) {
            format = "adpcm";
        } else if (value.equals("pcm") || value.equals("1") && (audio.getCodec() == null || !audio.getCodec().equals("dts"))) {
            format = "lpcm";
        } else if (value.equals("alac")) {
            format = "alac";
        } else if (value.equals("als")) {
            format = "als";
        } else if (value.equals("wave")) {
            format = "wav";
        } else if (value.equals("shorten")) {
            format = "shn";
        } else if (value.equals("sls") || value.equals("SLS non-core")) {
            format = "sls";
        } else if (value.equals("acelp")) {
            format = "acelp";
        } else if (value.equals("g.729") || value.equals("g.729a")) {
            format = "g729";
        } else if (value.equals("vselp")) {
            format = "ra14.4";
        } else if (value.equals("g.728")) {
            format = "ra28.8";
        } else if (value.equals("a_real/sipr") || value.equals("kevin")) {
            format = "sipro";
        } else if ((value.equals("dts") || value.equals("a_dts") || value.equals("8")) && (audio.getCodec() == null || !audio.getCodec().equals("dtshd"))) {
            format = "dts";
        } else if (value.equals("mpeg audio")) {
            format = "mpa";
        } else if (value.equals("wma")) {
            format = "wma";
            if (video.getCodec() == null) {
                media.setContainer(format);
            }
        } else if (streamType == StreamKind.AUDIO && media.getContainer() != null && (media.getContainer().equals("wma") || media.getContainer().equals("wmv"))) {
            if (value.equals("160") || value.equals("161")) {
                format = "wma";
            } else if (value.equals("162")) {
                format = "wmapro";
            } else if (value.equals("163")) {
                format = "wmalossless";
            } else if (value.equalsIgnoreCase("A")) {
                format = "wmavoice";
            } else if (value.equals("wma10")) {
                format = "wma10";
            }
        } else if (value.equals("flac") || "19d".equals(value)) {
            format = "flac";
        } else if (value.equals("monkey's audio")) {
            format = "ape";
        } else if (value.contains("musepack")) {
            format = "mpc";
        } else if (value.contains("wavpack")) {
            format = "wavpack";
        } else if (value.contains("mlp")) {
            format = "mlp";
        } else if (value.equals("openmg")) {
            format = "atrac";
        } else if (value.startsWith("atrac") || value.endsWith("-a119-fffa01e4ce62") || value.endsWith("-88fc-61654f8c836c")) {
            format = "atrac";
            if (streamType == StreamKind.AUDIO && !"atrac".equals(media.getContainer())) {
                media.setContainer("atrac");
            }
        } else if (value.equals("nellymoser")) {
            format = "nellymoser";
        } else if (value.equals("jpeg")) {
            format = "jpg";
        } else if (value.equals("png")) {
            format = "png";
        } else if (value.equals("gif")) {
            format = "gif";
        } else if (value.equals("bitmap")) {
            format = "bmp";
        } else if (value.equals("tiff")) {
            format = "tiff";
        }
        if (format != null) {
            switch (streamType) {
                case GENERAL: {
                    media.setContainer(format);
                    break;
                }
                case VIDEO: {
                    video.setCodec(format);
                    break;
                }
                case AUDIO: {
                    audio.setCodec(format);
                    break;
                }
            }
        } else if (streamType == StreamKind.GENERAL && media.getContainer() == null && file.getAbsolutePath() != null && (ext = FileUtil.getExtension(file.getAbsolutePath())) != null) {
            media.setContainer(ext.toLowerCase(Locale.ROOT));
        }
    }

    public static int getPixelValue(String value) {
        if (StringUtils.isBlank(value)) {
            return 0;
        }
        if (value.contains("pixel")) {
            value = value.substring(0, value.indexOf("pixel"));
        }
        if ((value = value.trim()).contains("/")) {
            value = value.substring(0, value.indexOf(47)).trim();
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Could not parse pixels \"{}\": {}", (Object)value, (Object)e.getMessage());
            LOGGER.trace("", e);
            return 0;
        }
    }

    public static byte getReferenceFrameCount(String value) {
        if (StringUtils.isBlank(value)) {
            return -1;
        }
        try {
            return Byte.parseByte(StringUtils.substringBefore(value, " "));
        }
        catch (NumberFormatException ex) {
            LOGGER.warn("Could not parse ReferenceFrameCount value {}.", (Object)value);
            LOGGER.warn("Exception: ", ex);
            return -1;
        }
    }

    public static String[] getFormatProfile(String value) {
        String profileMore;
        String[] result = new String[3];
        String profile = StringUtils.substringBefore(value, "@");
        if (StringUtils.isNotBlank(profile)) {
            result[0] = StringUtils.lowerCase(profile);
        }
        if (StringUtils.isNotBlank(profileMore = StringUtils.substringAfter(value, "@"))) {
            int separatorPos;
            if (profileMore.length() > 1 && profileMore.charAt(0) == 'L' && profileMore.charAt(1) >= '0' && profileMore.charAt(1) <= '9') {
                profileMore = profileMore.substring(1);
            }
            if ((separatorPos = profileMore.indexOf(64)) != -1) {
                result[1] = StringUtils.lowerCase(profileMore.substring(0, separatorPos));
                result[2] = StringUtils.lowerCase(profileMore.substring(separatorPos + 1));
            } else {
                result[1] = StringUtils.lowerCase(profileMore);
            }
        }
        return result;
    }

    public static int getVideoBitrate(String value) {
        if (StringUtils.isBlank(value)) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            LOGGER.trace("Could not parse video bitrate \"{}\": ", (Object)value, (Object)e.getMessage());
            return 0;
        }
    }

    public static Long getSpecificID(String value) {
        int end = value.lastIndexOf("(0x");
        if (end > -1) {
            int start = value.lastIndexOf(45) + 1;
            value = value.substring(start > end ? 0 : start, end);
        } else if (value.lastIndexOf(45) > -1) {
            value = value.substring(value.lastIndexOf(45) + 1);
        }
        value = value.trim();
        return Long.valueOf(value);
    }

    public static String getFrameRateModeValue(String value) {
        if (value.indexOf(47) > -1) {
            value = value.substring(0, value.indexOf(47));
        }
        value = value.trim();
        return value;
    }

    @Nullable
    public static Double parseDuration(String value) {
        if (StringUtils.isBlank(value)) {
            return null;
        }
        String[] parts = value.split("\\s*/\\s*");
        int separator = (value = parts[parts.length - 1]).indexOf(".");
        if (separator > 0) {
            value = value.substring(0, separator);
        }
        try {
            double longValue = Long.parseLong(value);
            return longValue / 1000.0;
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Could not parse duration from \"{}\"", (Object)value);
            return null;
        }
    }

    private static Double getDoubleValue(String value) {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException ex) {
            LOGGER.warn("NumberFormatException during parsing double from value {}", (Object)value);
            return null;
        }
    }

    private static int getIntValue(Double value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value.intValue();
    }

    private static int getIntValue(Long value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value.intValue();
    }

    private static byte getByteValue(Long value, byte defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value.byteValue();
    }

    private static void parseFilenameForMultiViewLayout(File file, MediaInfo media) {
        String upperCaseFileName = file.getName().toUpperCase();
        if (upperCaseFileName.startsWith("3DSBS")) {
            LOGGER.debug("3D format SBS detected for " + file.getName());
            media.getDefaultVideoTrack().setMultiViewLayout(file.getName().substring(2, 7));
        } else if (upperCaseFileName.startsWith("3DOU")) {
            LOGGER.debug("3D format OU detected for " + file.getName());
            media.getDefaultVideoTrack().setMultiViewLayout(file.getName().substring(2, 6));
        } else if (upperCaseFileName.startsWith("3DA")) {
            LOGGER.debug("3D format Anaglyph detected for " + file.getName());
            media.getDefaultVideoTrack().setMultiViewLayout(file.getName().substring(2, 6));
        } else if (upperCaseFileName.matches(".*[\\s\\.](H-|H|HALF-|HALF.)SBS[\\s\\.].*")) {
            LOGGER.debug("3D format HSBS detected for " + file.getName());
            media.getDefaultVideoTrack().setMultiViewLayout("half side by side (left eye first)");
        } else if (upperCaseFileName.matches(".*[\\s\\.](H-|H|HALF-|HALF.)(OU|TB)[\\s\\.].*")) {
            LOGGER.debug("3D format HOU detected for " + file.getName());
            media.getDefaultVideoTrack().setMultiViewLayout("half top-bottom (left eye first)");
        } else if (upperCaseFileName.matches(".*[\\s\\.]SBS[\\s\\.].*")) {
            if (media.getWidth() > 1920) {
                LOGGER.debug("3D format SBS detected for " + file.getName());
                media.getDefaultVideoTrack().setMultiViewLayout("side by side (left eye first)");
            } else {
                LOGGER.debug("3D format HSBS detected based on width for " + file.getName());
                media.getDefaultVideoTrack().setMultiViewLayout("half side by side (left eye first)");
            }
        } else if (upperCaseFileName.matches(".*[\\s\\.](OU|TB)[\\s\\.].*")) {
            if (media.getHeight() > 1080) {
                LOGGER.debug("3D format OU detected for " + file.getName());
                media.getDefaultVideoTrack().setMultiViewLayout("top-bottom (left eye first)");
            } else {
                LOGGER.debug("3D format HOU detected based on height for " + file.getName());
                media.getDefaultVideoTrack().setMultiViewLayout("half top-bottom (left eye first)");
            }
        }
    }

    private static MediaAudioMetadata parseFileForAudioMetadata(MediaInfoHelper mediaInfoHelper, File file, MediaInfo media) {
        String recordedDate;
        Matcher matcher;
        String value;
        MediaAudioMetadata audioMetadata = new MediaAudioMetadata();
        audioMetadata.setSongname(StreamContainer.getTrack(mediaInfoHelper, 0));
        audioMetadata.setAlbum(StreamContainer.getAlbum(mediaInfoHelper, 0));
        String albumArtists = mediaInfoHelper.get(StreamKind.GENERAL, 0, "ALBUM_ARTISTS");
        if (StringUtils.isAllBlank(albumArtists)) {
            albumArtists = StreamContainer.getAlbumPerformer(mediaInfoHelper, 0);
        }
        audioMetadata.setAlbumArtist(albumArtists);
        String artists = mediaInfoHelper.get(StreamKind.GENERAL, 0, "ARTISTS");
        if (StringUtils.isAllBlank(artists)) {
            artists = StreamContainer.getPerformer(mediaInfoHelper, 0);
        }
        audioMetadata.setArtist(artists);
        audioMetadata.setGenre(StreamContainer.getGenre(mediaInfoHelper, 0));
        audioMetadata.setComposer(StreamContainer.getComposer(mediaInfoHelper, 0));
        audioMetadata.setConductor(StreamContainer.getConductor(mediaInfoHelper, 0));
        Long longValue = StreamContainer.getTrackPosition(mediaInfoHelper, 0);
        if (longValue != null) {
            audioMetadata.setTrack(longValue.intValue());
        }
        if (!(value = StreamContainer.getPart(mediaInfoHelper, 0)).isEmpty()) {
            try {
                audioMetadata.setDisc(Integer.parseInt(value));
            }
            catch (NumberFormatException nfe) {
                LOGGER.debug("Could not parse disc \"" + value + "\"");
            }
        }
        if ((matcher = YEAR_PATTERN.matcher(recordedDate = StreamContainer.getRecordedDate(mediaInfoHelper, 0))).matches()) {
            try {
                audioMetadata.setYear(Integer.parseInt(matcher.group(1)));
            }
            catch (NumberFormatException nfe) {
                LOGGER.debug("Could not parse year from recorded date \"" + recordedDate + "\"");
            }
        }
        if (!media.hasVideoTrack()) {
            JaudiotaggerParser.parse(file, audioMetadata);
        }
        return audioMetadata;
    }

    static {
        MediaInfoHelper mediaInfoHelper = MediaInfoParser.getMediaInfoHelper(true);
        IS_VALID = mediaInfoHelper.isValid();
        if (IS_VALID) {
            Matcher matcher = Pattern.compile("MediaInfoLib - v(\\S+)", 2).matcher(mediaInfoHelper.option("Info_Version"));
            VERSION = matcher.find() && StringUtils.isNotBlank(matcher.group(1)) ? new Version(matcher.group(1)) : null;
            PARSER_NAME = "MI_" + VERSION;
        } else {
            VERSION = null;
            PARSER_NAME = null;
        }
        try {
            mediaInfoHelper.close();
        }
        catch (Exception ex) {
            LOGGER.warn("MediaInfoHelper error on close: ", ex);
        }
    }
}

