/*
 * Decompiled with CFR 0.152.
 */
package net.pms.parsers;

import com.drew.imaging.FileType;
import com.drew.imaging.FileTypeDetector;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Metadata;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.DCRaw;
import net.pms.encoders.EngineFactory;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapperImpl;
import net.pms.media.MediaInfo;
import net.pms.parsers.JaudiotaggerParser;
import net.pms.parsers.MetadataExtractorParser;
import net.pms.parsers.Parser;
import net.pms.util.InputFile;
import net.pms.util.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCRawParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(JaudiotaggerParser.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final String PARSER_NAME = "DCRAW";

    private DCRawParser() {
    }

    public static boolean parse(MediaInfo media, InputFile file, int type) {
        ImageInfo imageInfo;
        ImageFormat format;
        Metadata metadata;
        Dimension dimension;
        boolean trace = LOGGER.isTraceEnabled();
        if (!DCRawParser.isValid()) {
            return false;
        }
        if (trace) {
            LOGGER.trace("Parsing RAW image \"{}\" with DCRaw", (Object)file.getFile().getName());
        }
        if ((dimension = DCRawParser.parseDimension(file.getFile())) == null) {
            return false;
        }
        media.setContainer("raw");
        FileType fileType = null;
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(file.getFile().toPath(), new OpenOption[0]));){
            fileType = FileTypeDetector.detectFileType(inputStream);
            metadata = MetadataExtractorParser.getMetadata((InputStream)inputStream, fileType);
        }
        catch (IOException e) {
            metadata = new Metadata();
            LOGGER.debug("Error reading \"{}\": {}", (Object)file.getFile().getAbsolutePath(), (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        catch (ImageProcessingException e) {
            metadata = new Metadata();
            LOGGER.debug("Error parsing {} metadata for \"{}\": {}", fileType != null ? fileType.toString().toUpperCase(Locale.ROOT) : "null", file.getFile().getAbsolutePath(), e.getMessage());
            LOGGER.trace("", e);
        }
        if (fileType == FileType.Arw && !MetadataExtractorParser.isARW(metadata)) {
            fileType = FileType.Tiff;
        }
        if (!((format = MetadataExtractorParser.toImageFormat(fileType)) != null && format != ImageFormat.TIFF || (format = MetadataExtractorParser.toImageFormat(metadata)) != null && format != ImageFormat.TIFF)) {
            format = ImageFormat.RAW;
        }
        try {
            imageInfo = ImageInfo.create((int)dimension.getWidth(), (int)dimension.getHeight(), metadata, format, file.getSize(), true, false);
            if (trace) {
                LOGGER.trace("Parsing of RAW image \"{}\" completed: {}", (Object)file.getFile().getName(), (Object)imageInfo);
            }
        }
        catch (ParseException e) {
            LOGGER.warn("Unable to parse \"{}\": {}", (Object)file.getFile().getAbsolutePath(), (Object)e.getMessage());
            LOGGER.trace("", e);
            return false;
        }
        media.setImageInfo(imageInfo);
        media.setSize(file.getSize());
        media.setImageCount(1);
        Parser.postParse(media, type);
        media.setMediaParser(PARSER_NAME);
        return true;
    }

    private static Dimension parseDimension(File file) {
        if (file == null) {
            throw new NullPointerException("file cannot be null");
        }
        OutputParams params = new OutputParams(CONFIGURATION);
        params.setLog(true);
        String[] cmdArray = new String[]{EngineFactory.getEngineExecutable(DCRaw.ID), "-i", "-v", file.getAbsolutePath()};
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params, true, false);
        pw.runInSameThread();
        List<String> list = pw.getOtherResults();
        Pattern pattern = Pattern.compile("^Output size:\\s*(\\d+)\\s*x\\s*(\\d+)");
        for (String s : list) {
            Matcher matcher = pattern.matcher(s);
            if (!matcher.find()) continue;
            Dimension result = new Dimension(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(1)));
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Parsed resolution {} x {} for image \"{}\" from DCRaw output", matcher.group(1), matcher.group(2), file.getPath());
            }
            return result;
        }
        return null;
    }

    public static boolean isValid() {
        return EngineFactory.isEngineActive(DCRaw.ID);
    }
}

