/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webplayerserver.servlets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.Connection;
import net.pms.database.UserDatabase;
import net.pms.iam.Account;
import net.pms.iam.AccountService;
import net.pms.iam.AuthService;
import net.pms.iam.UsernamePassword;
import net.pms.network.webguiserver.GuiHttpServlet;
import net.pms.network.webguiserver.servlets.AccountApiServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="AuthApiServlet", urlPatterns={"/v1/api/auth"}, displayName="Auth Api Servlet")
public class PlayerAuthApiServlet
extends GuiHttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlayerAuthApiServlet.class);

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String path;
            switch (path = req.getPathInfo()) {
                case "/session": {
                    JsonObject jObject = new JsonObject();
                    jObject.add("authenticate", new JsonPrimitive(AuthService.isPlayerEnabled()));
                    jObject.add("player", new JsonPrimitive(true));
                    Account account = AuthService.getPlayerAccountLoggedIn(req);
                    if (account != null && account.havePermission(0x2000000)) {
                        jObject.add("account", AccountApiServlet.accountToJsonObject(account));
                    }
                    PlayerAuthApiServlet.respond(req, resp, jObject.toString(), 200, "application/json");
                    break;
                }
                default: {
                    LOGGER.trace("AuthApiServlet request not available : {}", (Object)path);
                    PlayerAuthApiServlet.respondNotFound(req, resp);
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("RuntimeException in AuthApiServlet: {}", (Object)e.getMessage());
            PlayerAuthApiServlet.respond(req, resp, null, 500, "application/json");
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String path;
            switch (path = req.getPathInfo()) {
                case "/login": {
                    String loginDetails = PlayerAuthApiServlet.getBodyAsString(req);
                    UsernamePassword data = GSON.fromJson(loginDetails, UsernamePassword.class);
                    Connection connection = UserDatabase.getConnectionIfAvailable();
                    if (connection != null) {
                        Account account = AccountService.getAccountByUsername(connection, data.getUsername());
                        if (account != null) {
                            LOGGER.info("Got user from db: {}", (Object)account.getUsername());
                            AccountService.checkUserUnlock(connection, account.getUser());
                            if (AccountService.isUserLocked(account.getUser())) {
                                PlayerAuthApiServlet.respond(req, resp, "{\"retrycount\": \"0\", \"lockeduntil\": \"" + (account.getUser().getLoginFailedTime() + 30000L) + "\"}", 401, "application/json");
                            } else if (AccountService.validatePassword(data.getPassword(), account.getUser().getPassword())) {
                                if (account.havePermission(0x2000000)) {
                                    AccountService.setUserLogged(connection, account.getUser());
                                    String token = AuthService.signJwt(account.getUser().getId(), req.getRemoteAddr());
                                    JsonObject jObject = new JsonObject();
                                    jObject.add("token", new JsonPrimitive(token));
                                    JsonElement jElement = GSON.toJsonTree(account);
                                    JsonObject jAccount = jElement.getAsJsonObject();
                                    jAccount.getAsJsonObject("user").remove("password");
                                    jObject.add("account", jAccount);
                                    PlayerAuthApiServlet.respond(req, resp, jObject.toString(), 200, "application/json");
                                } else {
                                    PlayerAuthApiServlet.respondUnauthorized(req, resp);
                                }
                            } else {
                                AccountService.setUserLoginFailed(connection, account.getUser());
                                PlayerAuthApiServlet.respond(req, resp, "{\"retrycount\": \"" + (3 - account.getUser().getLoginFailedCount()) + "\", \"lockeduntil\": \"0\"}", 401, "application/json");
                            }
                        } else {
                            PlayerAuthApiServlet.respondUnauthorized(req, resp);
                        }
                        UserDatabase.close(connection);
                        break;
                    }
                    LOGGER.error("User database not available");
                    PlayerAuthApiServlet.respondInternalServerError(req, resp);
                    break;
                }
                case "/refresh": {
                    Account account = AuthService.getPlayerAccountLoggedIn(req);
                    if (account != null && account.havePermission(0x2000000)) {
                        String token = AuthService.signJwt(account.getUser().getId(), req.getRemoteAddr());
                        PlayerAuthApiServlet.respond(req, resp, "{\"token\": \"" + token + "\"}", 200, "application/json");
                        break;
                    }
                    PlayerAuthApiServlet.respondUnauthorized(req, resp);
                    break;
                }
                default: {
                    LOGGER.trace("AccountApiServlet request not available : {}", (Object)path);
                    PlayerAuthApiServlet.respondNotFound(req, resp);
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("RuntimeException in AccountApiServlet: {}", (Object)e.getMessage());
            PlayerAuthApiServlet.respondInternalServerError(req, resp);
        }
    }
}

