/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webguiserver.servlets;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Locale;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.network.webguiserver.GuiHttpServlet;
import net.pms.util.Languages;
import net.pms.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="I18nApiServlet", urlPatterns={"/v1/api/i18n"}, displayName="I18n Api Servlet")
public class I18nApiServlet
extends GuiHttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(I18nApiServlet.class);
    private static final String LANGUAGE_MEMBER_NAME = "language";
    private static final String VERSION_MEMBER_NAME = "version";

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String path;
            switch (path = req.getPathInfo()) {
                case "/": {
                    String language = req.getParameter(LANGUAGE_MEMBER_NAME);
                    String version = req.getParameter(VERSION_MEMBER_NAME);
                    if (language != null) {
                        Locale locale = Languages.toLocale(language);
                        if (locale == null) {
                            locale = PMS.getLocale();
                        }
                        JsonObject i18n = new JsonObject();
                        i18n.add("i18n", Messages.getStringsAsJsonObject(locale));
                        i18n.add("languages", Languages.getLanguagesAsJsonArray(locale));
                        i18n.add("isRtl", new JsonPrimitive(Languages.getLanguageIsRtl(locale)));
                        resp.setHeader("Cache-Control", "public, max-age=604800");
                        I18nApiServlet.respond(req, resp, i18n.toString(), 200, "application/json");
                        break;
                    }
                    I18nApiServlet.respondBadRequest(req, resp);
                    break;
                }
                default: {
                    LOGGER.trace("I18nApiServlet request not available : {}", (Object)path);
                    I18nApiServlet.respondNotFound(req, resp);
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.trace("", e);
            I18nApiServlet.respondInternalServerError(req, resp);
        }
        catch (IOException e) {
            LOGGER.error("Unexpected error in I18nApiServlet.doGet(): {}", (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String path;
            switch (path = req.getPathInfo()) {
                case "/": {
                    JsonObject version = new JsonObject();
                    version.addProperty(VERSION_MEMBER_NAME, PropertiesUtil.getProjectProperties().get("git.commit.id"));
                    I18nApiServlet.respond(req, resp, version.toString(), 200, "application/json");
                    break;
                }
                default: {
                    LOGGER.trace("I18nApiServlet request not available : {}", (Object)path);
                    I18nApiServlet.respondNotFound(req, resp);
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.trace("", e);
            I18nApiServlet.respondInternalServerError(req, resp);
        }
        catch (IOException e) {
            LOGGER.error("Unexpected error in I18nApiServlet.doPost(): {}", (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }
}

