/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webguiserver.servlets;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import net.pms.iam.Account;
import net.pms.iam.AuthService;
import net.pms.network.mediaserver.MediaServer;
import net.pms.network.webguiserver.EventSourceClient;
import net.pms.network.webguiserver.EventSourceServer;
import net.pms.network.webguiserver.GuiHttpServlet;

@WebServlet(name="EventSourceServlet", urlPatterns={"/v1/api/sse"}, displayName="Sse Api Servlet")
public class EventSourceServlet
extends GuiHttpServlet {
    private int heartBeatPeriod = 10;

    @Override
    public void init() throws ServletException {
        String heartBeatPeriodParam = this.getServletConfig().getInitParameter("heartBeatPeriod");
        if (heartBeatPeriodParam != null) {
            this.heartBeatPeriod = Integer.parseInt(heartBeatPeriodParam);
        }
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (EventSourceServlet.hasHeaderValue(request, "Accept", "text/event-stream")) {
            Account account = AuthService.getAccountLoggedIn(request);
            if (account != null && account.getUser().getId() > 0) {
                String sseType = null;
                URI referer = EventSourceServlet.getRequestReferer(request);
                if (referer != null) {
                    sseType = referer.getPath();
                }
                response.setHeader("Server", MediaServer.getServerName());
                response.setHeader("Connection", "close");
                response.setHeader("Cache-Control", "no-transform");
                response.setHeader("Charset", "UTF-8");
                response.setContentType("text/event-stream");
                response.setStatus(200);
                response.flushBuffer();
                AsyncContext async = request.startAsync();
                async.setTimeout(0L);
                EventSourceClient client = new EventSourceClient(async, this.heartBeatPeriod);
                EventSourceServer.addServerSentEventsFor(account.getUser().getId(), client, sseType);
            } else {
                EventSourceServlet.respondForbidden(request, response);
            }
        } else {
            EventSourceServlet.respondBadRequest(request, response);
        }
    }
}

