/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webguiserver.servlets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.Connection;
import net.pms.database.UserDatabase;
import net.pms.iam.Account;
import net.pms.iam.AccountService;
import net.pms.iam.AuthService;
import net.pms.iam.UsernamePassword;
import net.pms.network.webguiserver.GuiHttpServlet;
import net.pms.network.webguiserver.servlets.AccountApiServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="AuthApiServlet", urlPatterns={"/v1/api/auth"}, displayName="Auth Api Servlet")
public class AuthApiServlet
extends GuiHttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthApiServlet.class);

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String path;
            switch (path = req.getPathInfo()) {
                case "/session": {
                    JsonObject jObject = new JsonObject();
                    Account account = AuthService.getAccountLoggedIn(req);
                    jObject.add("authenticate", new JsonPrimitive(AuthService.isEnabled()));
                    jObject.add("player", new JsonPrimitive(false));
                    if (account != null) {
                        jObject.add("noAdminFound", new JsonPrimitive(false));
                        jObject.add("account", AccountApiServlet.accountToJsonObject(account));
                    }
                    if (!jObject.has("noAdminFound")) {
                        Connection connection = UserDatabase.getConnectionIfAvailable();
                        if (connection != null) {
                            jObject.add("noAdminFound", new JsonPrimitive(AccountService.hasNoAdmin(connection)));
                            UserDatabase.close(connection);
                        } else {
                            LOGGER.error("User database not available");
                            AuthApiServlet.respondInternalServerError(req, resp, "User database not available");
                            return;
                        }
                    }
                    AuthApiServlet.respond(req, resp, jObject.toString(), 200, "application/json");
                    break;
                }
                case "/disable": {
                    Connection connection = UserDatabase.getConnectionIfAvailable();
                    if (connection == null) {
                        LOGGER.error("User database not available");
                        AuthApiServlet.respondInternalServerError(req, resp, "User database not available");
                        break;
                    }
                    if (!AccountService.hasNoAdmin(connection)) {
                        LOGGER.error("An admin user is already in database");
                        AuthApiServlet.respondForbidden(req, resp);
                        break;
                    }
                    AuthService.setEnabled(false);
                    AuthApiServlet.respond(req, resp, "", 200, "application/json");
                    break;
                }
                default: {
                    LOGGER.trace("AuthApiServlet request not available : {}", (Object)path);
                    AuthApiServlet.respondNotFound(req, resp);
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("RuntimeException in AuthApiServlet: {}", (Object)e.getMessage());
            AuthApiServlet.respond(req, resp, null, 500, "application/json");
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String path;
            switch (path = req.getPathInfo()) {
                case "/login": {
                    String loginDetails = AuthApiServlet.getBodyAsString(req);
                    UsernamePassword data = GSON.fromJson(loginDetails, UsernamePassword.class);
                    Connection connection = UserDatabase.getConnectionIfAvailable();
                    if (connection != null) {
                        Account account = AccountService.getAccountByUsername(connection, data.getUsername());
                        if (account != null) {
                            LOGGER.info("Got user from db: {}", (Object)account.getUsername());
                            AccountService.checkUserUnlock(connection, account.getUser());
                            if (AccountService.isUserLocked(account.getUser())) {
                                AuthApiServlet.respond(req, resp, "{\"retrycount\": \"0\", \"lockeduntil\": \"" + (account.getUser().getLoginFailedTime() + 30000L) + "\"}", 401, "application/json");
                            } else if (AccountService.validatePassword(data.getPassword(), account.getUser().getPassword())) {
                                AccountService.setUserLogged(connection, account.getUser());
                                String token = AuthService.signJwt(account.getUser().getId(), req.getRemoteAddr());
                                JsonObject jObject = new JsonObject();
                                jObject.add("token", new JsonPrimitive(token));
                                JsonElement jElement = GSON.toJsonTree(account);
                                JsonObject jAccount = jElement.getAsJsonObject();
                                jAccount.getAsJsonObject("user").remove("password");
                                jObject.add("account", jAccount);
                                AuthApiServlet.respond(req, resp, jObject.toString(), 200, "application/json");
                            } else {
                                AccountService.setUserLoginFailed(connection, account.getUser());
                                AuthApiServlet.respond(req, resp, "{\"retrycount\": \"" + (3 - account.getUser().getLoginFailedCount()) + "\", \"lockeduntil\": \"0\"}", 401, "application/json");
                            }
                        } else {
                            AuthApiServlet.respondUnauthorized(req, resp);
                        }
                        UserDatabase.close(connection);
                        break;
                    }
                    LOGGER.error("User database not available");
                    AuthApiServlet.respondInternalServerError(req, resp);
                    break;
                }
                case "/refresh": {
                    Account account = AuthService.getAccountLoggedIn(req);
                    if (account != null) {
                        String token = AuthService.signJwt(account.getUser().getId(), req.getRemoteAddr());
                        AuthApiServlet.respond(req, resp, "{\"token\": \"" + token + "\"}", 200, "application/json");
                        break;
                    }
                    AuthApiServlet.respondUnauthorized(req, resp);
                    break;
                }
                case "/create": {
                    String loginDetails = AuthApiServlet.getBodyAsString(req);
                    UsernamePassword data = GSON.fromJson(loginDetails, UsernamePassword.class);
                    Connection connection = UserDatabase.getConnectionIfAvailable();
                    if (connection != null) {
                        if (AccountService.hasNoAdmin(connection)) {
                            AccountService.createUser(connection, data.getUsername(), data.getPassword(), 1);
                            Account account = AccountService.getAccountByUsername(connection, data.getUsername());
                            if (account != null && AccountService.validatePassword(data.getPassword(), account.getUser().getPassword())) {
                                AccountService.setUserLogged(connection, account.getUser());
                                JsonObject jObject = new JsonObject();
                                jObject.add("noAdminFound", new JsonPrimitive(false));
                                String token = AuthService.signJwt(account.getUser().getId(), req.getRemoteAddr());
                                jObject.add("token", new JsonPrimitive(token));
                                jObject.add("account", AccountApiServlet.accountToJsonObject(account));
                                AuthApiServlet.respond(req, resp, jObject.toString(), 200, "application/json");
                            } else {
                                LOGGER.error("Error in admin user creation");
                                AuthApiServlet.respondInternalServerError(req, resp);
                            }
                        } else {
                            LOGGER.error("An admin user is already in database");
                            AuthApiServlet.respondForbidden(req, resp);
                        }
                        UserDatabase.close(connection);
                        break;
                    }
                    LOGGER.error("User database not available");
                    AuthApiServlet.respondInternalServerError(req, resp, "User database not available");
                    break;
                }
                default: {
                    LOGGER.trace("AccountApiServlet request not available : {}", (Object)path);
                    AuthApiServlet.respondNotFound(req, resp);
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("RuntimeException in AccountApiServlet: {}", (Object)e.getMessage());
            AuthApiServlet.respondInternalServerError(req, resp);
        }
    }
}

