/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webguiserver;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.pms.iam.Account;
import net.pms.iam.AccountService;
import net.pms.network.webguiserver.EventSourceClient;
import net.pms.network.webguiserver.servlets.SettingsApiServlet;
import org.apache.commons.lang3.StringUtils;

public class EventSourceServer {
    private static final Map<Integer, ArrayList<EventSourceClient>> SSE_INSTANCES = new HashMap<Integer, ArrayList<EventSourceClient>>();
    private static final List<EventSourceClient> SSE_ABOUT_INSTANCES = new ArrayList<EventSourceClient>();
    private static final List<EventSourceClient> SSE_HOME_INSTANCES = new ArrayList<EventSourceClient>();
    private static final List<EventSourceClient> SSE_LOGS_INSTANCES = new ArrayList<EventSourceClient>();
    private static final List<EventSourceClient> SSE_SETTINGS_INSTANCES = new ArrayList<EventSourceClient>();
    private static final List<EventSourceClient> SSE_SHARED_INSTANCES = new ArrayList<EventSourceClient>();

    private EventSourceServer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addServerSentEventsFor(int id, EventSourceClient sse, String sseType) {
        if (id > 0) {
            Map<Integer, ArrayList<EventSourceClient>> map = SSE_INSTANCES;
            synchronized (map) {
                if (!SSE_INSTANCES.containsKey(id)) {
                    SSE_INSTANCES.put(id, new ArrayList());
                }
                SSE_INSTANCES.get(id).add(sse);
                if (sseType != null) {
                    switch (sseType) {
                        case "/": {
                            List<EventSourceClient> list = SSE_HOME_INSTANCES;
                            synchronized (list) {
                                SSE_HOME_INSTANCES.add(sse);
                                break;
                            }
                        }
                        case "/logs": {
                            List<EventSourceClient> list = SSE_LOGS_INSTANCES;
                            synchronized (list) {
                                SSE_LOGS_INSTANCES.add(sse);
                                break;
                            }
                        }
                        case "/settings": {
                            List<EventSourceClient> list = SSE_SETTINGS_INSTANCES;
                            synchronized (list) {
                                SSE_SETTINGS_INSTANCES.add(sse);
                                break;
                            }
                        }
                        case "/shared": {
                            List<EventSourceClient> list = SSE_SHARED_INSTANCES;
                            synchronized (list) {
                                SSE_SHARED_INSTANCES.add(sse);
                                break;
                            }
                        }
                        case "/about": {
                            List<EventSourceClient> list = SSE_ABOUT_INSTANCES;
                            synchronized (list) {
                                SSE_ABOUT_INSTANCES.add(sse);
                                break;
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasServerSentEvents() {
        Map<Integer, ArrayList<EventSourceClient>> map = SSE_INSTANCES;
        synchronized (map) {
            return !SSE_INSTANCES.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasHomeServerSentEvents() {
        List<EventSourceClient> list = SSE_HOME_INSTANCES;
        synchronized (list) {
            return !SSE_HOME_INSTANCES.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasAboutServerSentEvents() {
        List<EventSourceClient> list = SSE_ABOUT_INSTANCES;
        synchronized (list) {
            return !SSE_ABOUT_INSTANCES.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasLogsServerSentEvents() {
        List<EventSourceClient> list = SSE_LOGS_INSTANCES;
        synchronized (list) {
            return !SSE_LOGS_INSTANCES.isEmpty();
        }
    }

    public static void broadcastMessage(String message) {
        EventSourceServer.broadcastMessage(message, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void broadcastSettingsMessage(String message) {
        List<EventSourceClient> list = SSE_SETTINGS_INSTANCES;
        synchronized (list) {
            Iterator<EventSourceClient> sseIterator = SSE_SETTINGS_INSTANCES.iterator();
            while (sseIterator.hasNext()) {
                EventSourceClient sse = sseIterator.next();
                if (sse.isClosed()) {
                    sseIterator.remove();
                    continue;
                }
                sse.sendMessage(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void broadcastSharedMessage(String message) {
        List<EventSourceClient> list = SSE_SHARED_INSTANCES;
        synchronized (list) {
            Iterator<EventSourceClient> sseIterator = SSE_SHARED_INSTANCES.iterator();
            while (sseIterator.hasNext()) {
                EventSourceClient sse = sseIterator.next();
                if (sse.isClosed()) {
                    sseIterator.remove();
                    continue;
                }
                sse.sendMessage(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void broadcastAboutMessage(String message) {
        List<EventSourceClient> list = SSE_ABOUT_INSTANCES;
        synchronized (list) {
            Iterator<EventSourceClient> sseIterator = SSE_ABOUT_INSTANCES.iterator();
            while (sseIterator.hasNext()) {
                EventSourceClient sse = sseIterator.next();
                if (sse.isClosed()) {
                    sseIterator.remove();
                    continue;
                }
                sse.sendMessage(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void broadcastHomeMessage(String message) {
        List<EventSourceClient> list = SSE_HOME_INSTANCES;
        synchronized (list) {
            Iterator<EventSourceClient> sseIterator = SSE_HOME_INSTANCES.iterator();
            while (sseIterator.hasNext()) {
                EventSourceClient sse = sseIterator.next();
                if (sse.isClosed()) {
                    sseIterator.remove();
                    continue;
                }
                sse.sendMessage(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void broadcastLogsMessage(String message) {
        List<EventSourceClient> list = SSE_LOGS_INSTANCES;
        synchronized (list) {
            Iterator<EventSourceClient> sseIterator = SSE_LOGS_INSTANCES.iterator();
            while (sseIterator.hasNext()) {
                EventSourceClient sse = sseIterator.next();
                if (sse.isClosed()) {
                    sseIterator.remove();
                    continue;
                }
                sse.sendMessage(message, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void broadcastMessage(String message, boolean log) {
        Map<Integer, ArrayList<EventSourceClient>> map = SSE_INSTANCES;
        synchronized (map) {
            Iterator<Map.Entry<Integer, ArrayList<EventSourceClient>>> ssesIterator = SSE_INSTANCES.entrySet().iterator();
            while (ssesIterator.hasNext()) {
                Map.Entry<Integer, ArrayList<EventSourceClient>> entry = ssesIterator.next();
                Iterator<EventSourceClient> sseIterator = entry.getValue().iterator();
                while (sseIterator.hasNext()) {
                    EventSourceClient sse = sseIterator.next();
                    if (sse.isClosed()) {
                        sseIterator.remove();
                        continue;
                    }
                    sse.sendMessage(message, log);
                }
                if (!entry.getValue().isEmpty()) continue;
                ssesIterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void broadcastMessageWithPermission(String message, int permission) {
        Map<Integer, ArrayList<EventSourceClient>> map = SSE_INSTANCES;
        synchronized (map) {
            Iterator<Map.Entry<Integer, ArrayList<EventSourceClient>>> ssesIterator = SSE_INSTANCES.entrySet().iterator();
            while (ssesIterator.hasNext()) {
                Map.Entry<Integer, ArrayList<EventSourceClient>> entry = ssesIterator.next();
                Account account = AccountService.getAccountByUserId(entry.getKey());
                if (account.havePermission(permission)) {
                    Iterator<EventSourceClient> sseIterator = entry.getValue().iterator();
                    while (sseIterator.hasNext()) {
                        EventSourceClient sse = sseIterator.next();
                        if (sse.isClosed()) {
                            sseIterator.remove();
                            continue;
                        }
                        sse.sendMessage(message);
                    }
                }
                if (!entry.getValue().isEmpty()) continue;
                ssesIterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void broadcastMessage(String message, int id) {
        Map<Integer, ArrayList<EventSourceClient>> map = SSE_INSTANCES;
        synchronized (map) {
            if (SSE_INSTANCES.containsKey(id)) {
                Iterator<EventSourceClient> sseIterator = SSE_INSTANCES.get(id).iterator();
                while (sseIterator.hasNext()) {
                    EventSourceClient sse = sseIterator.next();
                    if (sse.isClosed()) {
                        sseIterator.remove();
                        continue;
                    }
                    sse.sendMessage(message);
                }
                if (SSE_INSTANCES.get(id).isEmpty()) {
                    SSE_INSTANCES.remove(id);
                }
            }
        }
    }

    public static void notify(String id, String message, String title, String color, boolean autoClose) {
        if (EventSourceServer.hasServerSentEvents()) {
            JsonObject datas = new JsonObject();
            datas.addProperty("action", "notify");
            if (!StringUtils.isEmpty(id) && !StringUtils.isBlank(id)) {
                datas.addProperty("id", id);
            }
            if (!StringUtils.isEmpty(message)) {
                datas.addProperty("message", message);
            }
            if (!StringUtils.isEmpty(title)) {
                datas.addProperty("title", title);
            }
            if (!StringUtils.isEmpty(color)) {
                datas.addProperty("color", color);
            }
            datas.addProperty("autoClose", autoClose);
            EventSourceServer.broadcastMessage(datas.toString());
        }
    }

    public static void setRefreshSessions(List<Integer> ids) {
        if (EventSourceServer.hasServerSentEvents()) {
            for (int id : ids) {
                EventSourceServer.setRefreshSession(id);
            }
        }
    }

    public static void setRefreshSession(int id) {
        EventSourceServer.broadcastMessage("{\"action\":\"refresh_session\"}", id);
    }

    public static void setUpdateAccounts() {
        EventSourceServer.broadcastMessage("{\"action\":\"update_accounts\"}");
    }

    public static void setReloadable(boolean value) {
        EventSourceServer.broadcastMessage("{\"action\":\"set_reloadable\",\"value\":" + (value ? "true" : "false") + "}");
    }

    public static void setConfigurationChanged(String key) {
        if (EventSourceServer.hasServerSentEvents() && SettingsApiServlet.haveKey(key)) {
            EventSourceServer.broadcastMessageWithPermission(SettingsApiServlet.getConfigurationUpdate(key), 1024);
        }
    }

    public static void setMemoryUsage(int maxMemory, int usedMemory, int dbCacheMemory, int bufferMemory) {
        if (EventSourceServer.hasAboutServerSentEvents()) {
            String json = "{\"action\":\"update_memory\",\"max\":" + maxMemory + ",\"used\":" + usedMemory + ",\"dbcache\":" + dbCacheMemory + ",\"buffer\":" + bufferMemory + "}";
            EventSourceServer.broadcastAboutMessage(json);
        }
    }

    public static void appendLog(String msg) {
        if (EventSourceServer.hasLogsServerSentEvents()) {
            JsonObject result = new JsonObject();
            result.addProperty("action", "log_line");
            result.addProperty("value", msg);
            EventSourceServer.broadcastLogsMessage(result.toString());
        }
    }

    public static void setMediaScanStatus(boolean running) {
        EventSourceServer.broadcastSettingsMessage("{\"action\":\"set_media_scan_status\",\"running\":" + (running ? "true" : "false") + "}");
    }

    public static void setStatusLine(String line) {
        JsonObject result = new JsonObject();
        result.addProperty("action", "set_status_line");
        result.addProperty("value", line);
        EventSourceServer.broadcastMessage(result.toString());
    }
}

