/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webguiserver;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.pms.network.webguiserver.IEventSourceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSourceClient
implements IEventSourceClient,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventSourceClient.class);
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] EVENT_FIELD = "event: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DATA_FIELD = "data: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] COMMENT_FIELD = ": ".getBytes(StandardCharsets.UTF_8);
    public static final int DEFAULT_HEART_BEAT_PERIOD = 10;
    private final int heartBeatPeriod;
    private final ScheduledExecutorService scheduler;
    private final AsyncContext async;
    private final ServletOutputStream output;
    private Future<?> heartBeat;
    private boolean closed;

    public EventSourceClient(AsyncContext async) throws IOException {
        this(async, 10, null);
    }

    public EventSourceClient(AsyncContext async, int heartBeatPeriod) throws IOException {
        this(async, heartBeatPeriod, null);
    }

    public EventSourceClient(AsyncContext async, Runnable callback) throws IOException {
        this(async, 10, callback);
    }

    public EventSourceClient(AsyncContext async, int heartBeatPeriod, final Runnable callback) throws IOException {
        this.heartBeatPeriod = heartBeatPeriod;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.async = async;
        this.output = async.getResponse().getOutputStream();
        if (callback != null) {
            async.addListener(new AsyncListener(){

                @Override
                public void onComplete(AsyncEvent event) throws IOException {
                    new Thread(callback).start();
                }

                @Override
                public void onTimeout(AsyncEvent event) throws IOException {
                    new Thread(callback).start();
                }

                @Override
                public void onError(AsyncEvent event) throws IOException {
                    new Thread(callback).start();
                }

                @Override
                public void onStartAsync(AsyncEvent event) throws IOException {
                }
            });
        }
        this.scheduleHeartBeat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void event(String name, String data) throws IOException {
        EventSourceClient eventSourceClient = this;
        synchronized (eventSourceClient) {
            this.output.write(EVENT_FIELD);
            this.output.write(name.getBytes(StandardCharsets.UTF_8));
            this.output.write(CRLF);
            this.data(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void data(String data) throws IOException {
        EventSourceClient eventSourceClient = this;
        synchronized (eventSourceClient) {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(data));
            while ((line = reader.readLine()) != null) {
                this.output.write(DATA_FIELD);
                this.output.write(line.getBytes(StandardCharsets.UTF_8));
                this.output.write(CRLF);
            }
            this.output.write(CRLF);
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void comment(String comment) throws IOException {
        EventSourceClient eventSourceClient = this;
        synchronized (eventSourceClient) {
            this.output.write(COMMENT_FIELD);
            this.output.write(comment.getBytes(StandardCharsets.UTF_8));
            this.output.write(CRLF);
            this.output.write(CRLF);
            this.flush();
        }
    }

    @Override
    public boolean sendMessage(String message) {
        return this.sendMessage(message, true);
    }

    public boolean sendMessage(String message, boolean log) {
        if (log) {
            LOGGER.trace("ServerSentEvents send message: {}", (Object)message);
        }
        try {
            this.event("message", message);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean sendComment(String comment, boolean log) {
        if (log) {
            LOGGER.trace("ServerSentEvents send comment: {}", (Object)comment);
        }
        try {
            this.comment(comment);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected void flush() throws IOException {
        this.async.getResponse().flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        EventSourceClient eventSourceClient = this;
        synchronized (eventSourceClient) {
            this.closed = true;
            if (this.heartBeat != null) {
                this.heartBeat.cancel(false);
            }
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        this.async.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleHeartBeat() {
        EventSourceClient eventSourceClient = this;
        synchronized (eventSourceClient) {
            if (!this.closed) {
                this.heartBeat = this.scheduler.schedule(this, (long)this.heartBeatPeriod, TimeUnit.SECONDS);
            }
        }
    }

    @Override
    public boolean isOpened() {
        return !this.closed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void run() {
        try {
            this.event("ping", String.valueOf(System.currentTimeMillis()));
            this.scheduleHeartBeat();
        }
        catch (IOException e) {
            this.close();
        }
    }
}

