/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.servlets;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import net.pms.dlna.DLNAImageInputStream;
import net.pms.dlna.DLNAImageProfile;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.dlna.protocolinfo.PanasonicDmpProfiles;
import net.pms.encoders.HlsHelper;
import net.pms.encoders.ImageEngine;
import net.pms.formats.v2.SubtitleType;
import net.pms.image.BufferedImageFilterChain;
import net.pms.image.ImagesUtil;
import net.pms.io.OutputParams;
import net.pms.media.MediaType;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.network.mediaserver.MediaServer;
import net.pms.network.mediaserver.MediaServerRequest;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.DlnaHelper;
import net.pms.network.mediaserver.servlets.MediaServerHttpServlet;
import net.pms.network.mediaserver.servlets.StartStopListener;
import net.pms.renderers.ConnectedRenderers;
import net.pms.renderers.Renderer;
import net.pms.service.Services;
import net.pms.store.MediaStoreIds;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.util.ByteRange;
import net.pms.util.FullyPlayed;
import net.pms.util.Range;
import net.pms.util.StringUtil;
import net.pms.util.SubtitleUtils;
import net.pms.util.TimeRange;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="MEDIA HTTP SERVER", urlPatterns={"/ums"}, displayName="Media Server Servlet")
public class MediaServerServlet
extends MediaServerHttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaServerServlet.class);
    private static final SimpleDateFormat SDF = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);
    private static final String GET = "GET";
    private static final String HEAD = "HEAD";
    private static final int BUFFER_SIZE = 8192;
    private static final String HTTP_HEADER_RANGE_PREFIX = "bytes=";

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doGetHead(req, resp);
    }

    protected void doGetHead(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Renderer renderer = null;
        try {
            String method;
            String uri = req.getRequestURI();
            MediaServerRequest mediaServerRequest = new MediaServerRequest(uri);
            if (mediaServerRequest.isBadRequest()) {
                if (LOGGER.isTraceEnabled()) {
                    MediaServerServlet.logHttpServletRequest(req, "");
                }
                MediaServerServlet.respondBadRequest(req, resp);
                return;
            }
            renderer = ConnectedRenderers.getUuidRenderer(mediaServerRequest.getUuid());
            if (renderer == null && (renderer = ConnectedRenderers.getRendererBySocketAddress(MediaServerServlet.getInetAddress(req))) != null && !mediaServerRequest.getUuid().equals(renderer.getId()) && LOGGER.isTraceEnabled()) {
                LOGGER.trace("Recognized media renderer \"{}\" is not matching UUID \"{}\"", (Object)renderer.getRendererName(), (Object)mediaServerRequest.getUuid());
            }
            if (renderer == null) {
                if (LOGGER.isTraceEnabled()) {
                    MediaServerServlet.logHttpServletRequest(req, "");
                }
                MediaServerServlet.respondForbidden(req, resp);
                return;
            }
            if (!renderer.isAllowed()) {
                if (LOGGER.isTraceEnabled()) {
                    MediaServerServlet.logHttpServletRequest(req, "", MediaServerServlet.getRendererName(req, renderer));
                    LOGGER.trace("Recognized media renderer \"{}\" is not allowed", (Object)renderer.getRendererName());
                }
                MediaServerServlet.respondUnauthorized(req, resp);
                return;
            }
            if (req.getHeader("X-PANASONIC-DMP-Profile") != null) {
                PanasonicDmpProfiles.parsePanasonicDmpProfiles(req.getHeader("X-PANASONIC-DMP-Profile"), renderer);
            }
            if (LOGGER.isTraceEnabled()) {
                MediaServerServlet.logHttpServletRequest(req, null, MediaServerServlet.getRendererName(req, renderer));
            }
            if (GET.equals(method = req.getMethod().toUpperCase()) || HEAD.equals(method)) {
                StoreResource resource = renderer.getMediaStore().getResource(mediaServerRequest.getResourceId());
                if (resource == null) {
                    MediaServerServlet.respondNotFound(req, resp);
                    return;
                }
                switch (mediaServerRequest.getRequestType()) {
                    case MEDIA: {
                        MediaServerServlet.sendMediaResponse(req, resp, renderer, resource, mediaServerRequest.getOptionalPath());
                        break;
                    }
                    case THUMBNAIL: {
                        MediaServerServlet.sendThumbnailResponse(req, resp, renderer, resource, mediaServerRequest.getOptionalPath());
                        break;
                    }
                    case SUBTITLES: {
                        MediaServerServlet.sendSubtitlesResponse(req, resp, renderer, resource);
                        break;
                    }
                    default: {
                        MediaServerServlet.respondBadRequest(req, resp);
                        break;
                    }
                }
            } else {
                MediaServerServlet.respondNotAllowed(req, resp);
            }
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message != null) {
                if (message.equals("Connection reset by peer")) {
                    LOGGER.trace("Http request from {}: {}", (Object)MediaServerServlet.getRendererName(req, renderer), (Object)message);
                }
            }
            LOGGER.error("Http request error:", e);
        }
    }

    private static void sendResponse(HttpServletRequest req, HttpServletResponse resp, Renderer renderer, int code, String message, String contentType) throws IOException {
        resp.setHeader("Server", MediaServer.getServerName());
        resp.setContentType(contentType);
        if (StringUtils.isEmpty(message)) {
            resp.setContentLength(0);
            resp.setStatus(204);
            if (LOGGER.isTraceEnabled()) {
                MediaServerServlet.logHttpServletResponse(req, resp, null, false, MediaServerServlet.getRendererName(req, renderer));
            }
            return;
        }
        byte[] bytes = message.getBytes(StandardCharsets.UTF_8);
        resp.setContentLength(bytes.length);
        resp.setStatus(code);
        if (!HEAD.equalsIgnoreCase(req.getMethod())) {
            try (ServletOutputStream os = resp.getOutputStream();){
                os.write(bytes);
            }
            catch (Exception e) {
                LOGGER.debug("Error sending response: " + e);
            }
        }
        if (LOGGER.isTraceEnabled()) {
            MediaServerServlet.logHttpServletResponse(req, resp, message, false, MediaServerServlet.getRendererName(req, renderer));
        }
    }

    private static void sendResponse(HttpServletRequest req, HttpServletResponse resp, Renderer renderer, int code, InputStream inputStream) throws IOException {
        MediaServerServlet.sendResponse(req, resp, renderer, code, inputStream, -2L, true, null);
    }

    private static void sendResponse(HttpServletRequest req, HttpServletResponse resp, Renderer renderer, int code, InputStream inputStream, long cLoverride, boolean writeStream, StartStopListener startStopListener) throws IOException {
        resp.setHeader("Server", MediaServer.getServerName());
        AsyncContext async = req.startAsync();
        if (inputStream == null) {
            resp.setContentLength(0);
            resp.setStatus(204);
            if (LOGGER.isTraceEnabled()) {
                MediaServerServlet.logHttpServletResponse(req, resp, null, false, MediaServerServlet.getRendererName(req, renderer));
            }
            async.complete();
            return;
        }
        long contentLength = 0L;
        if (cLoverride > -2L) {
            if (cLoverride == 0L) {
                contentLength = -1L;
            } else if (cLoverride > -1L && cLoverride != 0x7FFFFFFF7FFFFFFFL) {
                contentLength = cLoverride;
            } else if (cLoverride == -1L) {
                contentLength = 0L;
            }
        } else {
            contentLength = inputStream.available();
            LOGGER.trace("Available Content-Length: {}", (Object)contentLength);
        }
        if (contentLength > 0L) {
            resp.setContentLengthLong(contentLength);
        }
        resp.setStatus(code);
        if (LOGGER.isTraceEnabled()) {
            MediaServerServlet.logHttpServletResponse(req, resp, null, true, MediaServerServlet.getRendererName(req, renderer));
        }
        if (writeStream && !HEAD.equalsIgnoreCase(req.getMethod())) {
            BufferedOutputStream os = new BufferedOutputStream(resp.getOutputStream(), 8192);
            MediaServerServlet.copyStreamAsync(inputStream, os, async, startStopListener);
        } else {
            if (HEAD.equalsIgnoreCase(req.getMethod()) && contentLength < 1L) {
                resp.flushBuffer();
            }
            try {
                inputStream.close();
            }
            catch (IOException ioe) {
                LOGGER.error("Caught exception", ioe);
            }
            async.complete();
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void sendMediaResponse(HttpServletRequest req, HttpServletResponse resp, Renderer renderer, StoreResource resource, String filename) throws IOException {
        if (resource instanceof StoreItem) {
            item = (StoreItem)resource;
            timeseekrange = MediaServerServlet.getTimeSeekRange(req.getHeader("timeseekrange.dlna.org"));
            range = MediaServerServlet.getRange(req.getHeader("Range"), item.length());
            status = range.getStart() != 0L || range.getEnd() != 0L ? 206 : 200;
            startStopListener = null;
            inputStream = null;
            cLoverride = -2L;
            if (req.getHeader("transfermode.dlna.org") != null) {
                resp.setHeader("TransferMode.DLNA.ORG", req.getHeader("transfermode.dlna.org"));
            }
            contentFeatures = req.getHeader("getcontentfeatures.dlna.org");
            samsungMediaInfo = req.getHeader("getmediainfo.sec");
            if (filename.endsWith("/chapters.vtt")) {
                MediaServerServlet.respond(req, resp, HlsHelper.getChaptersWebVtt(item), 200, "text/vtt");
                return;
            }
            if (filename.endsWith("/chapters.json")) {
                MediaServerServlet.respond(req, resp, HlsHelper.getChaptersHls(item), 200, "text/vtt");
                return;
            }
            if (filename.startsWith("hls/")) {
                if (filename.endsWith(".m3u8")) {
                    rendition = filename.replace("hls/", "").replace(".m3u8", "");
                    if (HlsHelper.getByKey(rendition) != null) {
                        baseUrl = MediaServerRequest.getMediaURL(renderer.getUUID()).toString();
                        MediaServerServlet.respond(req, resp, HlsHelper.getHLSm3u8ForRendition(item, renderer, baseUrl, rendition), 200, "application/x-mpegURL");
                    } else {
                        MediaServerServlet.respondNotFound(req, resp);
                    }
                } else {
                    inputStream = HlsHelper.getInputStream("/" + filename, item);
                    if (inputStream != null) {
                        if (filename.endsWith(".ts")) {
                            resp.setContentType("video/MP2T");
                            startStopListener = new StartStopListener(req.getRemoteHost(), item);
                            MediaServerServlet.LOGGER.trace("Sending inputstream for " + filename);
                            MediaServerServlet.sendResponse(req, resp, renderer, 200, inputStream, 0x7FFFFFFF7FFFFFFFL, true, startStopListener);
                        } else if (filename.endsWith(".vtt")) {
                            resp.setContentType("text/vtt");
                            MediaServerServlet.LOGGER.trace("Sending inputstream for " + filename);
                            MediaServerServlet.sendResponse(req, resp, renderer, 200, inputStream, 0x7FFFFFFF7FFFFFFFL, true, null);
                        }
                    } else {
                        MediaServerServlet.LOGGER.error("No inputstream for " + filename);
                        MediaServerServlet.sendResponse(req, resp, renderer, 404, null);
                    }
                }
                return;
            }
            if (filename.endsWith("_transcoded_to.m3u8")) {
                if (contentFeatures != null) {
                    resp.setHeader("ContentFeatures.DLNA.ORG", "DLNA.ORG_OP=10;DLNA.ORG_CI=01;DLNA.ORG_FLAGS=01700000000000000000000000000000");
                    if (item.getMediaInfo() != null && item.getMediaInfo().getDurationInSeconds() > 0.0) {
                        durationStr = String.format(Locale.ENGLISH, "%.3f", new Object[]{item.getMediaInfo().getDurationInSeconds()});
                        resp.setHeader("TimeSeekRange.dlna.org", "npt=0-" + durationStr + "/" + durationStr);
                        resp.setHeader("X-AvailableSeekRange", "npt=0-" + durationStr);
                    }
                }
                if (samsungMediaInfo != null && item.getMediaInfo() != null && item.getMediaInfo().getDurationInSeconds() > 0.0) {
                    resp.setHeader("MediaInfo.sec", "SEC_Duration=" + (long)(item.getMediaInfo().getDurationInSeconds() * 1000.0));
                }
                baseUrl = MediaServerRequest.getMediaURL(renderer.getUUID()).toString();
                MediaServerServlet.sendResponse(req, resp, renderer, 200, HlsHelper.getHLSm3u8(item, renderer, baseUrl), "application/x-mpegURL");
                return;
            }
            if (item.getMediaInfo() != null && item.getMediaInfo().getMediaType() == MediaType.IMAGE && item.isCodeValid(item)) {
                sleepManager = Services.sleepManager();
                if (sleepManager != null) {
                    sleepManager.postponeSleep();
                }
                updateId = MediaStoreIds.getObjectUpdateIdAsString(resource.getLongId());
                etag = req.getHeader("If-None-Match");
                if (etag != null && etag.equals(updateId)) {
                    MediaServerServlet.respondNotModified(req, resp);
                    return;
                }
                if (updateId != null) {
                    resp.setHeader("etag", updateId);
                }
                if ((imageProfile = ImagesUtil.parseImageRequest(filename, null)) == null) {
                    if (item.getMediaInfo().getImageInfo() != null && item.getMediaInfo().getImageInfo().getFormat() != null) {
                        switch (1.$SwitchMap$net$pms$image$ImageFormat[item.getMediaInfo().getImageInfo().getFormat().ordinal()]) {
                            case 1: {
                                v0 = DLNAImageProfile.GIF_LRG;
                                break;
                            }
                            case 2: {
                                v0 = DLNAImageProfile.PNG_LRG;
                                break;
                            }
                            default: {
                                v0 = DLNAImageProfile.JPEG_LRG;
                            }
                        }
                        imageProfile = v0;
                    } else {
                        imageProfile = DLNAImageProfile.JPEG_LRG;
                    }
                }
                resp.setContentType(imageProfile.getMimeType().toString());
                resp.setHeader("Accept-Ranges", "bytes");
                if (MediaServerServlet.isHttp10(req)) {
                    resp.setHeader("Expires", MediaServerServlet.getFutureDate() + " GMT");
                } else {
                    resp.setHeader("Cache-Control", "max-age=86400");
                }
                try {
                    imageInputStream = item.isTranscoded() != false && item.getTranscodingSettings().getEngine() instanceof ImageEngine != false ? ((transcodeProcess = item.getTranscodingSettings().getEngine().launchTranscode(item, item.getMediaInfo(), new OutputParams(MediaServerServlet.CONFIGURATION))) != null ? transcodeProcess.getInputStream(0L) : null) : item.getInputStream();
                    if (imageInputStream == null) {
                        MediaServerServlet.LOGGER.warn("Input stream returned for \"{}\" was null, no image will be sent to renderer", (Object)filename);
                    }
                    inputStream = DLNAImageInputStream.toImageInputStream(imageInputStream, imageProfile, false);
                    if (contentFeatures != null) {
                        resp.setHeader("ContentFeatures.DLNA.ORG", DlnaHelper.getDlnaImageContentFeatures(item, imageProfile, false));
                    }
                    if (inputStream == null || range.getStart() <= 0L && range.getEnd() <= 0L) ** GOTO lbl196
                    if (range.getStart() > 0L) {
                        inputStream.skip(range.getStart());
                    }
                    inputStream = StoreItem.wrap(inputStream, range.getEnd(), range.getStart());
                }
                catch (IOException ie) {
                    MediaServerServlet.respondUnsupportedMediaType(req, resp);
                    MediaServerServlet.LOGGER.debug("Could not send image \"{}\": {}", (Object)item.getName(), (Object)(ie.getMessage() != null ? ie.getMessage() : ie.getClass().getSimpleName()));
                    MediaServerServlet.LOGGER.trace("", ie);
                    return;
                }
            } else if (item.isCodeValid(item)) {
                splitRange = item.getSplitRange();
                if (timeseekrange.getStart() == null && splitRange.getStart() != null) {
                    timeseekrange.setStart(splitRange.getStart());
                }
                if (timeseekrange.getEnd() == null && splitRange.getEnd() != null) {
                    timeseekrange.setEnd(splitRange.getEnd());
                }
                totalsize = item.length();
                ignoreTranscodeByteRangeRequests = renderer.ignoreTranscodeByteRangeRequests();
                if (!ignoreTranscodeByteRangeRequests || totalsize != 0x7FFFFFFF7FFFFFFFL || ignoreTranscodeByteRangeRequests && range.getStart() == 0L && totalsize == 0x7FFFFFFF7FFFFFFFL) {
                    if (item.isTranscoded() && renderer.isTranscodeSeekByTimeExclusive() && (timeseekrange.getStart() != null && timeseekrange.getStart() > 0.0 || timeseekrange.getEnd() != null && timeseekrange.getEnd() > 0.0)) {
                        range.setStart(0L);
                        range.setEnd(0L);
                    }
                    inputStream = item.getInputStream(Range.create(range.getStart(), range.getEnd(), timeseekrange.getStart(), timeseekrange.getEnd()));
                    if (item.isResume()) {
                        timeseekrange.setStart((double)item.getResume().getTimeOffset() / 1000.0);
                    }
                }
                userAgentString = req.getHeader("User-Agent");
                isVideoThumbnailRequest = renderer.isLG() != false && userAgentString != null && userAgentString.contains("Lavf/") != false;
                format = item.getFormat();
                if (!isVideoThumbnailRequest && format != null && format.isVideo()) {
                    v1 = mediaType = item.getMediaInfo() == null ? null : item.getMediaInfo().getMediaType();
                    if (mediaType == MediaType.VIDEO) {
                        if (item.getMediaInfo() != null && item.getMediaSubtitle() != null && item.getMediaSubtitle().isExternal() && !MediaServerServlet.CONFIGURATION.isDisableSubtitles() && renderer.isExternalSubtitlesFormatSupported(item.getMediaSubtitle(), item)) {
                            subtitleHttpHeader = renderer.getSubtitleHttpHeader();
                            if (StringUtils.isNotBlank(subtitleHttpHeader) && (!item.isTranscoded() || renderer.streamSubsForTranscodedVideo())) {
                                sub = item.getMediaSubtitle();
                                subtitleUrl = item.getSubsURL(sub);
                                resp.setHeader(subtitleHttpHeader, subtitleUrl);
                            } else {
                                MediaServerServlet.LOGGER.trace("Did not send subtitle headers because mediaRenderer.getSubtitleHttpHeader() returned {}", subtitleHttpHeader == null ? "null" : "\"" + subtitleHttpHeader + "\"");
                            }
                        } else {
                            reasons = new ArrayList<String>();
                            if (item.getMediaInfo() == null) {
                                reasons.add("item.getMedia() is null");
                            }
                            if (MediaServerServlet.CONFIGURATION.isDisableSubtitles()) {
                                reasons.add("configuration.isDisabledSubtitles() is true");
                            }
                            if (item.getMediaSubtitle() == null) {
                                reasons.add("item.getMediaSubtitle() is null");
                            } else if (!item.getMediaSubtitle().isExternal()) {
                                reasons.add("the subtitles are internal/embedded");
                            } else if (!renderer.isExternalSubtitlesFormatSupported(item.getMediaSubtitle(), item)) {
                                reasons.add("the external subtitles format isn't supported by the renderer");
                            }
                            MediaServerServlet.LOGGER.trace("Did not send subtitle headers because {}", (Object)StringUtil.createReadableCombinedString(reasons));
                        }
                    }
                }
                name = item.getDisplayName();
                if (item.isNoName()) {
                    name = item.getName() + " " + item.getDisplayName();
                }
                if (inputStream == null) {
                    if (!ignoreTranscodeByteRangeRequests) {
                        MediaServerServlet.LOGGER.error("There is no inputstream to return for " + (String)name);
                    }
                } else {
                    if (!isVideoThumbnailRequest && "GET".equals(req.getMethod().toUpperCase())) {
                        startStopListener = new StartStopListener(req.getRemoteHost(), item);
                    }
                    if ((rendererMimeType = item.getMimeType()) != null && !"".equals(rendererMimeType)) {
                        resp.setContentType(rendererMimeType);
                    }
                    if ((chunked = renderer.isChunkedTransfer()) && totalsize == 0x7FFFFFFF7FFFFFFFL) {
                        totalsize = -1L;
                    }
                    remaining = totalsize - range.getStart();
                    requested = range.getEnd() - range.getStart();
                    if (requested != 0L) {
                        v2 = bytes = remaining > -1L ? remaining : (long)inputStream.available();
                        if (requested > 0L && bytes > requested) {
                            bytes = requested + 1L;
                        }
                        range.setEnd(range.getStart() + bytes - (long)(bytes > 0L ? 1 : 0));
                        MediaServerServlet.LOGGER.trace((chunked != false ? "Using chunked response. " : "") + "Sending " + bytes + " bytes.");
                        resp.setHeader("Content-Range", "bytes " + range.getStart() + "-" + (Serializable)(range.getEnd() > -1L ? range.getEnd() : "*") + "/" + (Serializable)(totalsize > -1L ? Long.valueOf(totalsize) : "*"));
                        cLoverride = chunked && requested < 0L && totalsize < 0L ? -1L : bytes;
                    } else {
                        cLoverride = remaining;
                    }
                    range.setEnd(range.getStart() + cLoverride - (long)(cLoverride > 0L ? 1 : 0));
                    if (contentFeatures != null) {
                        resp.setHeader("ContentFeatures.DLNA.ORG", DlnaHelper.getDlnaContentFeatures(item));
                    }
                    if (samsungMediaInfo != null && item.getMediaInfo() != null && item.getMediaInfo().getDurationInSeconds() > 0.0) {
                        resp.setHeader("MediaInfo.sec", "SEC_Duration=" + (long)(item.getMediaInfo().getDurationInSeconds() * 1000.0));
                    }
                    if (!item.isTranscoded() || renderer.isTranscodeSeekByByte()) {
                        resp.setHeader("Accept-Ranges", "bytes");
                    }
                    if ("GET".equals(req.getMethod().toUpperCase())) {
                        resp.setHeader("Connection", "keep-alive");
                    }
                }
            }
lbl196:
            // 9 sources

            if (timeseekrange.isStartOffsetAvailable() && item.getMediaInfo() != null) {
                timeseekValue = StringUtil.formatDLNADuration(timeseekrange.getStartOrZero());
                timetotalValue = item.getMediaInfo().getDurationString();
                timeEndValue = timeseekrange.isEndLimitAvailable() != false ? StringUtil.formatDLNADuration(timeseekrange.getEnd()) : timetotalValue;
                resp.setHeader("TimeSeekRange.dlna.org", "npt=" + timeseekValue + "-" + timeEndValue + "/" + timetotalValue);
                resp.setHeader("X-Seek-Range", "npt=" + timeseekValue + "-" + timeEndValue + "/" + timetotalValue);
            }
            MediaServerServlet.sendResponse(req, resp, renderer, status, inputStream, cLoverride, range.getStart() != 99999475712L, startStopListener);
        } else {
            MediaServerServlet.respondBadRequest(req, resp);
        }
    }

    private static ByteRange getRange(String rangeStr, long streamLength) {
        List<ByteRange> ranges = MediaServerServlet.parseRanges(rangeStr, streamLength);
        if (ranges.isEmpty()) {
            return new ByteRange(0L, 0L);
        }
        return ranges.get(0);
    }

    private static List<ByteRange> parseRanges(String rangesStr, long streamLength) {
        ArrayList<ByteRange> ranges = new ArrayList<ByteRange>();
        if (rangesStr == null || StringUtils.isEmpty(rangesStr)) {
            return ranges;
        }
        long streamEnd = streamLength - 1L;
        if (!(rangesStr = rangesStr.toLowerCase().trim()).startsWith(HTTP_HEADER_RANGE_PREFIX)) {
            LOGGER.warn("Range '{}' does not start with '{}'", (Object)rangesStr, (Object)HTTP_HEADER_RANGE_PREFIX);
            return ranges;
        }
        for (String rangeStr : rangesStr.split(",")) {
            try {
                rangeStr = rangeStr.trim();
                if (rangeStr.startsWith(HTTP_HEADER_RANGE_PREFIX)) {
                    rangeStr = rangeStr.substring(HTTP_HEADER_RANGE_PREFIX.length());
                }
                long start = -1L;
                long end = -1L;
                int dash = rangeStr.indexOf(45);
                if (dash < 0 || rangeStr.indexOf("-", dash + 1) >= 0) {
                    LOGGER.warn("Range header '{}' is not well formed on '{}'", (Object)rangesStr, (Object)rangeStr);
                    break;
                }
                if (dash > 0) {
                    start = Long.parseLong(rangeStr.substring(0, dash).trim());
                }
                if (dash < rangeStr.length() - 1) {
                    end = Long.parseLong(rangeStr.substring(dash + 1).trim());
                }
                if (start == -1L) {
                    if (end == 0L) continue;
                    if (end == -1L) {
                        LOGGER.warn("Range header '{}' is not well formed on '{}'", (Object)rangesStr, (Object)rangeStr);
                        break;
                    }
                    start = Math.max(0L, streamEnd - end + 1L);
                    end = streamEnd;
                } else {
                    if (start > streamEnd) continue;
                    if (end == -1L || end > streamEnd) {
                        end = streamEnd;
                    }
                }
                if (end < start) {
                    LOGGER.warn("Range header '{}' is not well formed on '{}'", (Object)rangesStr, (Object)rangeStr);
                    break;
                }
                ranges.add(new ByteRange(start, end));
            }
            catch (NumberFormatException x) {
                LOGGER.warn("Range header '{}' is not well formed on '{}'", (Object)rangesStr, (Object)rangeStr);
            }
        }
        return ranges;
    }

    private static TimeRange getTimeSeekRange(String timeSeekRangeStr) {
        TimeRange timeSeekRange = new TimeRange();
        if (timeSeekRangeStr != null && timeSeekRangeStr.startsWith("npt=")) {
            String[] params = timeSeekRangeStr.substring(4).split("[-/]");
            if (params.length > 1 && params[1].length() != 0) {
                timeSeekRange.setEnd(StringUtil.convertStringToTime(params[1]));
            }
            if (params.length > 0 && params[0].length() != 0) {
                timeSeekRange.setStart(StringUtil.convertStringToTime(params[0]));
            }
        }
        return timeSeekRange;
    }

    private static void sendThumbnailResponse(HttpServletRequest req, HttpServletResponse resp, Renderer renderer, StoreResource resource, String filename) throws IOException {
        ByteRange range;
        DLNAThumbnailInputStream thumbInputStream;
        String updateId = MediaStoreIds.getObjectUpdateIdAsString(resource.getLongId());
        String etag = req.getHeader("If-None-Match");
        if (etag != null && etag.equals(updateId)) {
            MediaServerServlet.respondNotModified(req, resp);
            return;
        }
        if (updateId != null) {
            resp.setHeader("etag", updateId);
        }
        if (req.getHeader("transfermode.dlna.org") != null) {
            resp.setHeader("TransferMode.DLNA.ORG", req.getHeader("transfermode.dlna.org"));
        }
        String contentFeatures = req.getHeader("getcontentfeatures.dlna.org");
        DLNAImageProfile imageProfile = ImagesUtil.parseImageRequest(filename, DLNAImageProfile.JPEG_TN);
        resp.setContentType(imageProfile.getMimeType().toString());
        resp.setHeader("Accept-Ranges", "bytes");
        if (MediaServerServlet.isHttp10(req)) {
            resp.setHeader("Expires", MediaServerServlet.getFutureDate() + " GMT");
        } else {
            resp.setHeader("Cache-Control", "max-age=86400");
        }
        if (!CONFIGURATION.isShowCodeThumbs() && !resource.isCodeValid(resource)) {
            thumbInputStream = resource.getGenericThumbnailInputStream(null);
        } else {
            resource.checkThumbnail();
            thumbInputStream = resource.fetchThumbnailInputStream();
        }
        BufferedImageFilterChain filterChain = null;
        if (renderer.isThumbnails() && resource.isFullyPlayedMark()) {
            filterChain = new BufferedImageFilterChain(FullyPlayed.getOverlayFilter());
        }
        filterChain = resource.addFlagFilters(filterChain);
        InputStream inputStream = thumbInputStream.transcode(imageProfile, renderer.isThumbnailPadding(), filterChain);
        if (contentFeatures != null) {
            resp.setHeader("ContentFeatures.DLNA.ORG", DlnaHelper.getDlnaImageContentFeatures(resource, imageProfile, true));
        }
        int status = 200;
        if (inputStream != null && ((range = MediaServerServlet.getRange(req.getHeader("Range"), ((InputStream)inputStream).available())).getStart() > 0L || range.getEnd() > 0L)) {
            if (range.getStart() > 0L) {
                ((InputStream)inputStream).skip(range.getStart());
            }
            inputStream = StoreItem.wrap(inputStream, range.getEnd(), range.getStart());
            status = 206;
        }
        MediaServerServlet.sendResponse(req, resp, renderer, status, inputStream);
    }

    private static void sendSubtitlesResponse(HttpServletRequest req, HttpServletResponse resp, Renderer renderer, StoreResource resource) throws IOException {
        StoreItem item;
        TimeRange timeseekrange = MediaServerServlet.getTimeSeekRange(req.getHeader("timeseekrange.dlna.org"));
        int status = 200;
        InputStream inputStream = null;
        if (req.getHeader("transfermode.dlna.org") != null) {
            resp.setHeader("TransferMode.DLNA.ORG", req.getHeader("transfermode.dlna.org"));
        }
        if (resource instanceof StoreItem && (item = (StoreItem)resource).isCodeValid(item) && item.getMediaInfo() != null) {
            resp.setContentType("text/plain");
            String updateId = MediaStoreIds.getObjectUpdateIdAsString(resource.getLongId());
            String etag = req.getHeader("If-None-Match");
            if (etag != null && etag.equals(updateId)) {
                MediaServerServlet.respondNotModified(req, resp);
                return;
            }
            if (updateId != null) {
                resp.setHeader("etag", updateId);
            }
            if (MediaServerServlet.isHttp10(req)) {
                resp.setHeader("Expires", MediaServerServlet.getFutureDate() + " GMT");
            } else {
                resp.setHeader("Cache-Control", "max-age=86400");
            }
            MediaSubtitle sub = item.getMediaSubtitle();
            if (sub != null) {
                if (sub.isExternal()) {
                    if (sub.getExternalFile() == null) {
                        LOGGER.error("External subtitles file \"{}\" is unavailable", (Object)sub.getName());
                    } else {
                        try {
                            inputStream = sub.getType() == SubtitleType.SUBRIP && renderer.isRemoveTagsFromSRTsubs() ? SubtitleUtils.removeSubRipTags(sub.getExternalFile()) : new FileInputStream(sub.getExternalFile());
                            LOGGER.trace("Loading external subtitles file: {}", (Object)sub.getName());
                            ByteRange range = MediaServerServlet.getRange(req.getHeader("Range"), inputStream.available());
                            if (range.getStart() != 0L || range.getEnd() != 0L) {
                                status = 206;
                            }
                        }
                        catch (IOException ioe) {
                            LOGGER.debug("Couldn't load external subtitles file: {}\nCause: {}", (Object)sub.getName(), (Object)ioe.getMessage());
                            LOGGER.trace("", ioe);
                        }
                    }
                } else {
                    LOGGER.trace("Not sending subtitles because they are embedded: {}", (Object)sub);
                }
            } else {
                LOGGER.trace("Not sending external subtitles because dlna.getMediaSubtitle() returned null");
            }
            if (timeseekrange.isStartOffsetAvailable()) {
                String timeseekValue = StringUtil.formatDLNADuration(timeseekrange.getStartOrZero());
                String timetotalValue = item.getMediaInfo().getDurationString();
                String timeEndValue = timeseekrange.isEndLimitAvailable() ? StringUtil.formatDLNADuration(timeseekrange.getEnd()) : timetotalValue;
                resp.setHeader("TimeSeekRange.dlna.org", "npt=" + timeseekValue + "-" + timeEndValue + "/" + timetotalValue);
                resp.setHeader("X-Seek-Range", "npt=" + timeseekValue + "-" + timeEndValue + "/" + timetotalValue);
            }
            MediaServerServlet.sendResponse(req, resp, renderer, status, inputStream);
        } else {
            MediaServerServlet.respondBadRequest(req, resp);
        }
    }

    private static String getFutureDate() {
        SDF.setTimeZone(TimeZone.getTimeZone("GMT"));
        return SDF.format(new Date(10000000000L + System.currentTimeMillis()));
    }

    private static String getRendererName(HttpServletRequest req, Renderer renderer) {
        Object rendererName = renderer != null ? (StringUtils.isNotBlank(renderer.getRendererName()) ? (StringUtils.isBlank(renderer.getConfName()) || renderer.getRendererName().equals(renderer.getConfName()) ? renderer.getRendererName() : renderer.getRendererName() + " [" + renderer.getConfName() + "]") : (StringUtils.isNotBlank(renderer.getConfName()) ? renderer.getConfName() : "Unnamed")) : "Unknown";
        if (req != null) {
            rendererName = (String)rendererName + " (" + req.getRemoteHost() + ":" + req.getRemotePort() + ")";
        }
        return rendererName;
    }
}

