/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.transport.impl;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import net.pms.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpMessage;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class StreamsLoggerHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamsLoggerHelper.class);
    private static final String HTTPSERVER_REQUEST_BEGIN = "================================== HTTPSERVER REQUEST BEGIN =====================================";
    private static final String HTTPSERVER_REQUEST_END = "================================== HTTPSERVER REQUEST END =======================================";
    private static final String HTTPSERVER_RESPONSE_BEGIN = "================================== HTTPSERVER RESPONSE BEGIN ====================================";
    private static final String HTTPSERVER_RESPONSE_END = "================================== HTTPSERVER RESPONSE END ======================================";
    private static final String HTTPCLIENT_REQUEST_BEGIN = "==================================== HTTPCLIENT REQUEST BEGIN ====================================";
    private static final String HTTPCLIENT_REQUEST_END = "==================================== HTTPCLIENT REQUEST END ======================================";
    private static final String HTTPCLIENT_RESPONSE_BEGIN = "==================================== HTTPCLIENT RESPONSE BEGIN ===================================";
    private static final String HTTPCLIENT_RESPONSE_END = "==================================== HTTPCLIENT RESPONSE END =====================================";

    private StreamsLoggerHelper() {
    }

    public static void logStreamServerRequestMessage(StreamRequestMessage requestMessage) {
        String formattedRequest = StreamsLoggerHelper.getFormattedRequest(requestMessage);
        String formattedHeaders = StreamsLoggerHelper.getFormattedHeaders(requestMessage);
        String formattedBody = StreamsLoggerHelper.getFormattedBody(requestMessage);
        LOGGER.trace("Received a request from {}:\n{}\n{}{}{}{}", requestMessage.getConnection().getRemoteAddress().getHostAddress(), HTTPSERVER_REQUEST_BEGIN, formattedRequest, formattedHeaders, formattedBody, HTTPSERVER_REQUEST_END);
    }

    public static void logStreamServerResponseMessage(StreamResponseMessage responseMessage, StreamRequestMessage requestMessage) {
        String formattedResponse = StreamsLoggerHelper.getFormattedResponse(responseMessage);
        String formattedHeaders = StreamsLoggerHelper.getFormattedHeaders(responseMessage);
        String formattedBody = StreamsLoggerHelper.getFormattedBody(responseMessage);
        LOGGER.trace("Send a response to {}:\n{}\n{}{}{}{}", requestMessage.getConnection().getRemoteAddress().getHostAddress(), HTTPSERVER_RESPONSE_BEGIN, formattedResponse, formattedHeaders, formattedBody, HTTPSERVER_RESPONSE_END);
    }

    public static void logStreamClientRequestMessage(StreamRequestMessage requestMessage) {
        String formattedRequest = StreamsLoggerHelper.getFormattedRequest(requestMessage);
        String formattedHeaders = StreamsLoggerHelper.getFormattedHeaders(requestMessage);
        String formattedBody = StreamsLoggerHelper.getFormattedBody(requestMessage);
        LOGGER.trace("Send a request to {}:\n{}\n{}{}{}{}", requestMessage.getUri().getHost(), HTTPCLIENT_REQUEST_BEGIN, formattedRequest, formattedHeaders, formattedBody, HTTPCLIENT_REQUEST_END);
    }

    public static void logStreamClientResponseMessage(StreamResponseMessage responseMessage, StreamRequestMessage requestMessage) {
        String formattedResponse = StreamsLoggerHelper.getFormattedResponse(responseMessage);
        String formattedHeaders = StreamsLoggerHelper.getFormattedHeaders(responseMessage);
        String formattedBody = StreamsLoggerHelper.getFormattedBody(responseMessage);
        LOGGER.trace("Received a response from {}:\n{}\n{}{}{}{}", requestMessage.getUri().getHost(), HTTPCLIENT_RESPONSE_BEGIN, formattedResponse, formattedHeaders, formattedBody, HTTPCLIENT_RESPONSE_END);
    }

    private static String getFormattedRequest(StreamRequestMessage requestMessage) {
        StringBuilder request = new StringBuilder();
        request.append(((UpnpRequest)requestMessage.getOperation()).getHttpMethodName()).append(" ").append(requestMessage.getUri().getPath());
        request.append(" HTTP/1.").append(((UpnpRequest)requestMessage.getOperation()).getHttpMinorVersion()).append("\n");
        return request.toString();
    }

    private static String getFormattedResponse(StreamResponseMessage responseMessage) {
        StringBuilder response = new StringBuilder();
        response.append("HTTP/1.").append(((UpnpResponse)responseMessage.getOperation()).getHttpMinorVersion());
        response.append(" ").append(((UpnpResponse)responseMessage.getOperation()).getResponseDetails()).append("\n");
        return response.toString();
    }

    private static String getFormattedHeaders(UpnpMessage message) {
        StringBuilder headers = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : message.getHeaders().entrySet()) {
            if (!StringUtils.isNotBlank(entry.getKey())) continue;
            for (String value : entry.getValue()) {
                headers.append("  ").append(entry.getKey()).append(": ").append(value).append("\n");
            }
        }
        if (headers.length() > 0) {
            headers.insert(0, "\nHEADER:\n");
        }
        return headers.toString();
    }

    private static String getFormattedBody(UpnpMessage message) {
        Object formattedBody = "";
        try {
            boolean bodyNonEmpty;
            boolean bl = bodyNonEmpty = message.getBody() != null && (message.getBody() instanceof String && ((String)message.getBody()).length() > 0 || message.getBody() instanceof byte[] && ((byte[])message.getBody()).length > 0);
            if (bodyNonEmpty && message.isBodyNonEmptyString()) {
                if (message.getContentTypeHeader().isText()) {
                    try {
                        formattedBody = StringUtil.prettifyXML(message.getBodyString(), StandardCharsets.UTF_8, 4);
                    }
                    catch (ParserConfigurationException | TransformerException | XPathExpressionException | SAXException e) {
                        formattedBody = "  Content isn't valid XML, using text formatting: " + e.getMessage() + "\n";
                        formattedBody = (String)formattedBody + "    " + message.getBodyString().replace("\n", "\n    ");
                    }
                } else {
                    formattedBody = message.getBodyString();
                }
            }
        }
        catch (Exception e) {
            formattedBody = "";
        }
        formattedBody = StringUtils.isNotEmpty((CharSequence)formattedBody) ? "\nCONTENT:\n" + (String)formattedBody : "";
        return formattedBody;
    }
}

