/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.transport.impl;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import net.pms.network.HttpServletHelper;
import net.pms.network.mediaserver.MediaServer;
import org.jupnp.model.message.Connection;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.UpnpMessage;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.transport.spi.UpnpStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JakartaServletUpnpStream
extends UpnpStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(JakartaServletUpnpStream.class);
    protected StreamResponseMessage responseMessage;

    protected JakartaServletUpnpStream(ProtocolFactory protocolFactory) {
        super(protocolFactory);
    }

    @Override
    public void run() {
        try {
            StreamRequestMessage requestMessage = this.readRequestMessage();
            LOGGER.trace("Processing new request message: {}", (Object)requestMessage);
            if (LOGGER.isTraceEnabled()) {
                if (requestMessage.isBodyNonEmptyString()) {
                    HttpServletHelper.logHttpServletRequest(this.getRequest(), requestMessage.getBodyString());
                } else {
                    HttpServletHelper.logHttpServletRequest(this.getRequest(), "");
                }
            }
            this.responseMessage = this.process(requestMessage);
            if (this.responseMessage != null) {
                LOGGER.trace("Preparing HTTP response message: {}", (Object)this.responseMessage);
                this.writeResponseMessage(this.responseMessage);
            } else {
                LOGGER.trace("Sending HTTP response status: {}", (Object)404);
                this.getResponse().setStatus(404);
                if (LOGGER.isTraceEnabled()) {
                    HttpServletHelper.logHttpServletResponse(this.getRequest(), this.getResponse(), null, false);
                }
            }
        }
        catch (IOException e) {
            LOGGER.info("Exception occurred during UPnP stream processing", e);
            if (!this.getResponse().isCommitted()) {
                LOGGER.trace("Response hasn't been committed, returning INTERNAL SERVER ERROR to client");
                this.getResponse().setStatus(500);
                if (LOGGER.isTraceEnabled()) {
                    HttpServletHelper.logHttpServletResponse(this.getRequest(), this.getResponse(), null, false);
                }
            } else {
                LOGGER.info("Could not return INTERNAL SERVER ERROR to client, response was already committed");
            }
            this.responseException(e);
        }
        finally {
            this.complete();
        }
    }

    protected StreamRequestMessage readRequestMessage() throws IOException {
        byte[] bodyBytes;
        StreamRequestMessage requestMessage;
        String requestMethod = this.getRequest().getMethod();
        String requestURI = this.getRequest().getRequestURI();
        LOGGER.trace("Processing HTTP request: {} {} ", (Object)requestMethod, (Object)requestURI);
        try {
            requestMessage = new StreamRequestMessage(UpnpRequest.Method.getByHttpName(requestMethod), URI.create(requestURI));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid request URI: " + requestURI, e);
        }
        if (((UpnpRequest)requestMessage.getOperation()).getMethod().equals((Object)UpnpRequest.Method.UNKNOWN)) {
            throw new RuntimeException("Method not supported: " + requestMethod);
        }
        requestMessage.setConnection(this.createConnection());
        UpnpHeaders headers = new UpnpHeaders();
        Enumeration<String> headerNames = this.getRequest().getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement();
            Enumeration<String> headerValues = this.getRequest().getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = headerValues.nextElement();
                headers.add(headerName, headerValue);
            }
        }
        requestMessage.setHeaders(headers);
        try (ServletInputStream is = this.getRequest().getInputStream();){
            bodyBytes = UpnpRequest.Method.GET.getHttpName().equals(requestMethod) ? new byte[]{} : is.readAllBytes();
        }
        LOGGER.trace("Reading request body bytes: {}", (Object)bodyBytes.length);
        if (bodyBytes.length > 0 && requestMessage.isContentTypeMissingOrText()) {
            LOGGER.trace("Request contains textual entity body, converting then setting string on message");
            requestMessage.setBodyCharacters(bodyBytes);
        } else if (bodyBytes.length > 0) {
            LOGGER.trace("Request contains binary entity body, setting bytes on message");
            requestMessage.setBody(UpnpMessage.BodyType.BYTES, bodyBytes);
        } else {
            LOGGER.trace("Request did not contain entity body");
        }
        return requestMessage;
    }

    protected void writeResponseMessage(StreamResponseMessage responseMessage) throws IOException {
        int contentLength;
        LOGGER.trace("Sending HTTP response status: {}", (Object)((UpnpResponse)responseMessage.getOperation()).getStatusCode());
        this.getResponse().setStatus(((UpnpResponse)responseMessage.getOperation()).getStatusCode());
        for (Map.Entry<String, List<String>> entry : responseMessage.getHeaders().entrySet()) {
            for (String value : entry.getValue()) {
                this.getResponse().addHeader(entry.getKey(), value);
            }
        }
        this.getResponse().setHeader("Server", MediaServer.getServerName());
        this.getResponse().setDateHeader("Date", System.currentTimeMillis());
        byte[] responseBodyBytes = responseMessage.hasBody() ? responseMessage.getBodyBytes() : null;
        int n = contentLength = responseBodyBytes != null ? responseBodyBytes.length : -1;
        if (contentLength > 0) {
            this.getResponse().setContentLength(contentLength);
            if (LOGGER.isTraceEnabled()) {
                if (responseMessage.isBodyNonEmptyString()) {
                    HttpServletHelper.logHttpServletResponse(this.getRequest(), this.getResponse(), responseMessage.getBodyString(), false);
                } else {
                    HttpServletHelper.logHttpServletResponse(this.getRequest(), this.getResponse(), null, true);
                }
            }
            this.getResponse().getOutputStream().write(responseBodyBytes);
        } else if (LOGGER.isTraceEnabled()) {
            HttpServletHelper.logHttpServletResponse(this.getRequest(), this.getResponse(), null, false);
        }
    }

    protected abstract Connection createConnection();

    protected abstract HttpServletRequest getRequest();

    protected abstract HttpServletResponse getResponse();

    protected abstract void complete();
}

