/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.support.contentdirectory.updateobject;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import net.pms.PMS;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTableAudioMetadata;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.updateobject.BaseUpdateObjectHandler;
import net.pms.store.StoreResource;
import org.apache.commons.lang3.StringUtils;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.flac.FlacTag;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.ID3v11Tag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;
import org.jupnp.support.contentdirectory.ContentDirectoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NodeList;

public class UpnpRatingHandler
extends BaseUpdateObjectHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpnpRatingHandler.class.getName());

    public UpnpRatingHandler(StoreResource objectResource, NodeList currentTagValue, NodeList newTagValue) {
        super(objectResource, currentTagValue, newTagValue);
    }

    @Override
    public void handle() throws ContentDirectoryException {
        try {
            Integer newValue;
            Integer currentValue = this.getNodeTextValue(this.getCurrentTagValue(), 0) != null ? Integer.valueOf(Integer.parseInt(this.getNodeTextValue(this.getCurrentTagValue(), 0))) : null;
            Integer n = newValue = this.getNodeTextValue(this.getNewTagValue(), 0) != null ? Integer.valueOf(Integer.parseInt(this.getNodeTextValue(this.getNewTagValue(), 0))) : null;
            if (!this.isModelValueEqual(currentValue)) {
                throw new ContentDirectoryException(702, "UpdateObject() failed because upnp:rating value listed in the CurrentTagValue argument do not match the current state of the ContentDirectory service. The specified data is likely out of date.");
            }
            if (newValue > 5 || newValue < 0) {
                throw new ContentDirectoryException(703, "UpdateObject() failed because new upnp:rating value is out of bounds. Value must be between 0 and 5 which is equavalent of a rating from 0 to 5 stars.");
            }
            this.getObjectResource().getMediaInfo().getAudioMetadata().setRating(newValue);
            this.updateDatabase();
            if (PMS.getConfiguration().isAudioUpdateTag()) {
                String filename = this.getObjectResource().getFileName();
                this.setRatingInFile(newValue, filename);
            }
        }
        catch (NullPointerException e) {
            LOGGER.error("cannot handle update object request", e);
            throw new ContentDirectoryException(712, "UpdateObject() failed because some TextContent cannot be parsed.");
        }
    }

    private boolean isModelValueEqual(Integer oldValue) {
        if (oldValue == null && this.getObjectResource().getMediaInfo().getAudioMetadata().getRating() == null) {
            return true;
        }
        return this.getObjectResource().getMediaInfo().getAudioMetadata().getRating().equals(oldValue);
    }

    private void setRatingInFile(Integer ratingInStars, String filename) {
        if (StringUtils.isEmpty(filename)) {
            LOGGER.warn("cannot update rating in file. Filename is empty or NULL");
            return;
        }
        try {
            AudioFile audioFile = AudioFileIO.read(new File(filename));
            Tag tag = audioFile.getTag();
            if (ratingInStars == null) {
                tag.deleteField(FieldKey.RATING);
            } else {
                tag.setField(FieldKey.RATING, this.getRatingValue(tag, ratingInStars));
            }
            audioFile.commit();
        }
        catch (IOException | CannotReadException | CannotWriteException | InvalidAudioFrameException | ReadOnlyFileException | TagException e) {
            LOGGER.warn("Error writing Tag info.", e);
        }
    }

    private String getRatingValue(Tag tag, Integer stars) {
        if (stars == null) {
            return null;
        }
        int num = tag instanceof FlacTag || tag instanceof VorbisCommentTag ? this.convertStarsToVorbis(stars) : (tag instanceof AbstractID3v2Tag || tag instanceof ID3v11Tag ? this.convertStarsToID3(stars) : this.convertStarsToVorbis(stars));
        return "" + num;
    }

    private int convertStarsToID3(int rating) {
        return switch (rating) {
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 64;
            case 3 -> 128;
            case 4 -> 196;
            default -> 255;
        };
    }

    private int convertStarsToVorbis(int rating) {
        return rating * 20;
    }

    private void updateDatabase() throws ContentDirectoryException {
        try {
            MediaTableAudioMetadata.updateRatingByAudiotrackId(MediaDatabase.getConnectionIfAvailable(), this.getObjectResource().getMediaInfo().getAudioMetadata().getRating(), this.getObjectResource().getMediaInfo().getAudioMetadata().getAudiotrackId());
        }
        catch (SQLException e) {
            throw new ContentDirectoryException(712, "UpdateObject() failed because of SQL exception.");
        }
    }
}

