/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.support.contentdirectory.result;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.Property;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.Result;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.dc.DC;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.BaseObject;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.DIDL_LITE;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.Container;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.Item;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.sec.SEC;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.upnp.UPNP;
import org.jupnp.model.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Generator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Generator.class);
    private static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";

    public String generate(Result content) {
        try {
            return this.documentToString(this.buildDOM(content), true);
        }
        catch (ParserConfigurationException | TransformerException ex) {
            LOGGER.trace("\n" + ex);
            return "";
        }
    }

    protected String documentToString(Document document, boolean omitProlog) throws TransformerException {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        if (omitProlog) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        StringWriter out = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(out));
        return out.toString();
    }

    protected Document buildDOM(Result content) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document d = factory.newDocumentBuilder().newDocument();
        this.generateRoot(content, d);
        return d;
    }

    protected void generateRoot(Result content, Document descriptor) {
        Element rootElement = descriptor.createElementNS("urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/", "DIDL-Lite");
        descriptor.appendChild(rootElement);
        rootElement.setAttributeNS(XMLNS_NAMESPACE_URI, "xmlns:upnp", "urn:schemas-upnp-org:metadata-1-0/upnp/");
        rootElement.setAttributeNS(XMLNS_NAMESPACE_URI, "xmlns:dc", "http://purl.org/dc/elements/1.1/");
        rootElement.setAttributeNS(XMLNS_NAMESPACE_URI, "xmlns:dlna", "urn:schemas-dlna-org:metadata-1-0/");
        rootElement.setAttributeNS(XMLNS_NAMESPACE_URI, "xmlns:sec", "http://www.sec.co.kr/");
        rootElement.setAttributeNS(XMLNS_NAMESPACE_URI, "xmlns:pv", "http://www.pv.com/pvns/");
        for (Container container : content.getContainers()) {
            if (container == null) continue;
            this.generateContainer(descriptor, rootElement, container);
        }
        for (Item item : content.getItems()) {
            if (item == null) continue;
            this.generateItem(descriptor, rootElement, item);
        }
        this.generateDescriptions(descriptor, rootElement, content);
    }

    protected void generateContainer(Document descriptor, Element parent, Container container) {
        if (container.getUpnpClassName() == null) {
            throw new RuntimeException("Missing 'upnp:class' element for container: " + container.getId());
        }
        Element containerElement = XMLUtil.appendNewElement(descriptor, parent, "container");
        this.appendAttributes(descriptor, containerElement, container);
        this.appendProperties(descriptor, containerElement, container, DC.NAMESPACE.class, "http://purl.org/dc/elements/1.1/");
        this.appendProperties(descriptor, containerElement, container, UPNP.NAMESPACE.class, "urn:schemas-upnp-org:metadata-1-0/upnp/");
        this.appendProperties(descriptor, containerElement, container, DIDL_LITE.NAMESPACE.class, "urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/");
    }

    protected void generateItem(Document descriptor, Element parent, Item item) {
        Element itemElement = XMLUtil.appendNewElement(descriptor, parent, "item");
        this.appendAttributes(descriptor, itemElement, item);
        this.appendProperties(descriptor, itemElement, item, DC.NAMESPACE.class, "http://purl.org/dc/elements/1.1/");
        this.appendProperties(descriptor, itemElement, item, UPNP.NAMESPACE.class, "urn:schemas-upnp-org:metadata-1-0/upnp/");
        this.appendProperties(descriptor, itemElement, item, SEC.NAMESPACE.class, "http://www.sec.co.kr/");
        this.appendProperties(descriptor, itemElement, item, DIDL_LITE.NAMESPACE.class, "urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/");
    }

    protected void generateDescriptions(Document descriptor, Element parent, Result content) {
        for (Property property : content.getDescriptions()) {
            Element element = descriptor.createElementNS("urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/", property.getQualifiedName());
            this.appendAttributes(descriptor, element, property);
            element.setTextContent(property.toString());
            parent.appendChild(element);
        }
    }

    protected void appendAttributes(Document descriptor, Element parent, Property property) {
        for (Property<?> attributeProperty : property.getDependentProperties().get()) {
            String namespaceURI = attributeProperty.getNamespaceURI();
            Attr attr = namespaceURI != null ? descriptor.createAttributeNS(namespaceURI, attributeProperty.getQualifiedName()) : descriptor.createAttribute(attributeProperty.getQualifiedName());
            attr.setTextContent(attributeProperty.toString());
            if (namespaceURI != null) {
                String pre = descriptor.lookupPrefix(namespaceURI);
                attr.setPrefix(pre);
                parent.setAttributeNodeNS(attr);
                continue;
            }
            parent.setAttributeNode(attr);
        }
    }

    protected void appendProperties(Document descriptor, Element parent, BaseObject object, Class<?> namespace, String namespaceURI) {
        for (Property property : object.getProperties().getPropertiesInstanceOf(namespace)) {
            String qualifiedName = property.getQualifiedName();
            try {
                Element element = descriptor.createElementNS(namespaceURI, qualifiedName);
                String pre = descriptor.lookupPrefix(namespaceURI);
                element.setPrefix(pre);
                this.appendAttributes(descriptor, element, property);
                element.setTextContent(property.toString());
                parent.appendChild(element);
            }
            catch (DOMException e) {
                LOGGER.warn("Property '{}' throw an exception: {}", (Object)qualifiedName, (Object)e.getMessage());
                LOGGER.trace("", e);
            }
        }
    }
}

