/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.support.contentdirectory.result;

import net.pms.dlna.DLNAImageProfile;
import net.pms.encoders.AviSynthFFmpeg;
import net.pms.encoders.AviSynthMEncoder;
import net.pms.encoders.EncodingFormat;
import net.pms.encoders.Engine;
import net.pms.encoders.EngineId;
import net.pms.encoders.FFMpegVideo;
import net.pms.encoders.MEncoderVideo;
import net.pms.encoders.TranscodingSettings;
import net.pms.encoders.VLCVideo;
import net.pms.encoders.VideoLanVideoStreaming;
import net.pms.image.ImageInfo;
import net.pms.media.MediaInfo;
import net.pms.media.audio.MediaAudio;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.media.video.MediaVideo;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.dlna.ORG_CI;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.dlna.ORG_FLAGS;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.dlna.ORG_OP;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.dlna.ORG_PN;
import net.pms.renderers.Renderer;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlnaHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DlnaHelper.class);
    private static final String[] DLNA_LOCALES = new String[]{"NA", "JP", "EU"};

    protected DlnaHelper() {
    }

    public static String getDlnaContentFeatures(StoreItem item) {
        int localizationValue = 1;
        StringBuilder sb = new StringBuilder();
        sb.append(DlnaHelper.getDlnaOrgPn(item, localizationValue));
        ORG_OP op = DlnaHelper.getDlnaOrgOp(item);
        if (sb.length() > 0) {
            sb.append(op.getParam());
        } else {
            sb.append(op);
        }
        ORG_CI ci = new ORG_CI();
        ci.setConverted(item.isTranscoded());
        sb.append(ci.getParam());
        ORG_FLAGS flags = new ORG_FLAGS();
        flags.setDLNAv15(true);
        flags.setHttpConnectionStalling(true);
        flags.setBackgroundMode(true);
        flags.setStreamingMode(true);
        sb.append(flags.getParam());
        return sb.toString();
    }

    public static String getDlnaImageContentFeatures(StoreResource resource, DLNAImageProfile profile, boolean thumbnailRequest) {
        StringBuilder sb = new StringBuilder();
        if (profile != null) {
            sb.append("DLNA.ORG_PN=").append(profile);
        }
        MediaInfo mediaInfo = resource.getMediaInfo();
        ImageInfo thumbnailImageInf = null;
        if (resource.getThumbnailImageInfo() != null) {
            thumbnailImageInf = resource.getThumbnailImageInfo();
        } else if (mediaInfo != null && mediaInfo.getThumbnail() != null && mediaInfo.getThumbnail().getImageInfo() != null) {
            thumbnailImageInf = mediaInfo.getThumbnail().getImageInfo();
        }
        ImageInfo imageInfo = null;
        if (thumbnailRequest) {
            imageInfo = thumbnailImageInf;
        } else if (mediaInfo != null) {
            imageInfo = mediaInfo.getImageInfo();
        }
        if (profile != null && !thumbnailRequest && thumbnailImageInf != null && profile.useThumbnailSource(imageInfo, thumbnailImageInf)) {
            imageInfo = thumbnailImageInf;
        }
        if (profile != null && imageInfo != null) {
            DLNAImageProfile.HypotheticalResult hypotheticalResult = profile.calculateHypotheticalProperties(imageInfo);
            ORG_CI ci = new ORG_CI();
            ci.setConverted(hypotheticalResult.conversionNeeded);
            if (sb.length() > 0) {
                sb.append(ci.getParam());
            } else {
                sb.append(ci);
            }
        }
        ORG_FLAGS flags = new ORG_FLAGS();
        flags.setDLNAv15(true);
        flags.setInteractiveMode(true);
        if (sb.length() > 0) {
            sb.append(flags.getParam());
        } else {
            sb.append(flags);
        }
        return sb.toString();
    }

    protected static String getDlnaAdditionalInfo(StoreItem item, int localizationValue) {
        StringBuilder sb = new StringBuilder();
        sb.append(DlnaHelper.getDlnaOrgPn(item, localizationValue));
        ORG_OP op = DlnaHelper.getDlnaOrgOp(item);
        if (sb.length() > 0) {
            sb.append(op.getParam());
        } else {
            sb.append(op);
        }
        return sb.toString();
    }

    protected static int getDlnaLocalesCount() {
        return DLNA_LOCALES.length;
    }

    private static ORG_OP getDlnaOrgOp(StoreItem item) {
        ORG_OP dlnaOrgOp = new ORG_OP();
        dlnaOrgOp.setHttpRangeHeaderAccepted(true);
        Renderer renderer = item.getDefaultRenderer();
        if (renderer.isTranscodeSeekByTime() && item.isTranscoded() && item.isTimeSeekable()) {
            dlnaOrgOp.setHttpTimeSeekRangeHeaderAccepted(true);
            if (renderer.isTranscodeSeekByTimeExclusive()) {
                dlnaOrgOp.setHttpRangeHeaderAccepted(false);
            }
        }
        return dlnaOrgOp;
    }

    private static ORG_PN getDlnaOrgPn(StoreItem item, int localizationValue) {
        String profileId;
        Renderer renderer = item.getDefaultRenderer();
        if ((renderer.isDLNAOrgPNUsed() || renderer.isAccurateDLNAOrgPN()) && (profileId = DlnaHelper.getDlnaProfileId(item, localizationValue)) != null) {
            ORG_PN pn = new ORG_PN();
            pn.setProfileId(renderer.getDlnaProfileId(profileId));
            return pn;
        }
        return null;
    }

    private static String getDlnaProfileId(StoreItem item, int localizationValue) {
        String mime = item.getRendererMimeType();
        Renderer renderer = item.getDefaultRenderer();
        TranscodingSettings transcodingSettings = item.getTranscodingSettings();
        EncodingFormat encodingFormat = transcodingSettings != null ? transcodingSettings.getEncodingFormat() : null;
        EngineId engineId = transcodingSettings != null ? transcodingSettings.getEngine().getEngineId() : null;
        MediaInfo mediaInfo = item.getMediaInfo();
        MediaSubtitle mediaSubtitle = item.getMediaSubtitle();
        MediaVideo defaultVideoTrack = mediaInfo != null ? mediaInfo.getDefaultVideoTrack() : null;
        MediaAudio defaultAudioTrack = mediaInfo != null ? mediaInfo.getDefaultAudioTrack() : null;
        MediaAudio mediaAudio = item.getMediaAudio();
        MediaSubtitle resolvedSubtitle = mediaSubtitle;
        String profileId = null;
        if (renderer.isPS3()) {
            if (mime.equals("video/x-divx")) {
                profileId = "AVI";
            } else if (mime.equals("video/x-ms-wmv") && defaultVideoTrack != null && defaultVideoTrack.isHDVideo()) {
                profileId = DlnaHelper.getWmvProfileId(mediaInfo, encodingFormat);
            }
        } else if (mime.equals("video/x-divx")) {
            profileId = "AVI";
        } else if (mime.equals("video/x-ms-wmv") && defaultVideoTrack != null && defaultVideoTrack.isHDVideo()) {
            profileId = DlnaHelper.getWmvProfileId(mediaInfo, encodingFormat);
        } else if (mime.equals("video/mpeg") || mime.equals("application/x-mpegURL") || mime.equals("application/vnd.apple.mpegURL")) {
            profileId = DlnaHelper.getMpegPsProfileId(localizationValue);
            if (encodingFormat != null) {
                boolean isOutputtingMPEGTS = encodingFormat.isTranscodeToMPEGTS();
                if (!isOutputtingMPEGTS && encodingFormat.isTranscodeToMPEGTS() && (MEncoderVideo.ID.equals(engineId) || FFMpegVideo.ID.equals(engineId) || VLCVideo.ID.equals(engineId) || AviSynthFFmpeg.ID.equals(engineId) || AviSynthMEncoder.ID.equals(engineId))) {
                    isOutputtingMPEGTS = true;
                }
                if (!isOutputtingMPEGTS && (renderer.getUmsConfiguration().isMencoderMuxWhenCompatible() && MEncoderVideo.ID.equals(engineId) || renderer.getUmsConfiguration().isFFmpegMuxWithTsMuxerWhenCompatible() && FFMpegVideo.ID.equals(engineId))) {
                    if (renderer.isAccurateDLNAOrgPN()) {
                        if (resolvedSubtitle == null) {
                            MediaAudio audio = mediaAudio != null ? mediaAudio : item.resolveAudioStream();
                            resolvedSubtitle = item.resolveSubtitlesStream(audio == null ? null : audio.getLang(), false);
                        }
                        if (resolvedSubtitle == null) {
                            LOGGER.trace("We do not want a subtitle for {}", (Object)item.getName());
                        } else {
                            LOGGER.trace("We do want a subtitle for {}", (Object)item.getName());
                        }
                    }
                    if (resolvedSubtitle == null && !item.hasExternalSubtitles() && mediaInfo != null && mediaInfo.getDvdtrack() == null && Engine.isMuxable(mediaInfo.getDefaultVideoTrack(), renderer) && renderer.isVideoStreamTypeSupportedInTranscodingContainer(mediaInfo, encodingFormat, "mpegts")) {
                        isOutputtingMPEGTS = true;
                    }
                }
                if (isOutputtingMPEGTS) {
                    if (encodingFormat.isTranscodeToH264() && !VideoLanVideoStreaming.ID.equals(engineId)) {
                        profileId = DlnaHelper.getMpegTsH264ProfileId(localizationValue, false);
                    } else if (encodingFormat.isTranscodeToMPEG2()) {
                        profileId = DlnaHelper.getMpegTsMpeg2ProfileId(localizationValue, mediaInfo, false);
                    }
                }
            } else if (mediaInfo != null && mediaInfo.isMpegTS() && defaultVideoTrack != null) {
                if (defaultVideoTrack.isH264()) {
                    profileId = DlnaHelper.getMpegTsH264ProfileId(localizationValue, encodingFormat == null);
                } else if (defaultVideoTrack.isMpeg2()) {
                    profileId = DlnaHelper.getMpegTsMpeg2ProfileId(localizationValue, mediaInfo, encodingFormat == null);
                }
            }
        } else if (mediaInfo != null && mime.equals("video/vnd.dlna.mpeg-tts")) {
            if (encodingFormat == null && defaultVideoTrack != null && defaultVideoTrack.isH264() || encodingFormat != null && encodingFormat.isTranscodeToH264()) {
                profileId = DlnaHelper.getMpegTsH264ProfileId(localizationValue, encodingFormat == null);
            } else if (encodingFormat == null && defaultVideoTrack != null && defaultVideoTrack.isMpeg2() || encodingFormat != null && encodingFormat.isTranscodeToMPEG2()) {
                profileId = DlnaHelper.getMpegTsMpeg2ProfileId(localizationValue, mediaInfo, encodingFormat == null);
            }
        } else if (mediaInfo != null && mime.equals("video/mp4")) {
            if (encodingFormat == null && defaultVideoTrack != null && defaultVideoTrack.isH265() && defaultAudioTrack != null && (defaultAudioTrack.isAC3() || defaultAudioTrack.isEAC3() || defaultAudioTrack.isHEAAC())) {
                profileId = "DASH_HEVC_MP4_UHD_NA";
            } else if (encodingFormat == null && defaultVideoTrack != null && defaultVideoTrack.isH264()) {
                profileId = DlnaHelper.getMp4H264OrgPN(mediaInfo, encodingFormat);
            }
        } else if (mediaInfo != null && mime.equals("video/x-matroska")) {
            if (encodingFormat == null && defaultVideoTrack != null && defaultVideoTrack.isH264()) {
                profileId = DlnaHelper.getMkvH264ProfileId(mediaInfo, encodingFormat);
            }
        } else if (mediaInfo != null && mime.equals("video/x-ms-asf")) {
            if (encodingFormat == null && defaultVideoTrack != null && defaultVideoTrack.getCodec().equals("vc1") && defaultAudioTrack != null && defaultAudioTrack.isWMA()) {
                profileId = mediaInfo.getDefaultVideoTrack() != null && mediaInfo.getDefaultVideoTrack().isHDVideo() ? "VC1_ASF_AP_L2_WMA" : "VC1_ASF_AP_L1_WMA";
            }
        } else if (mediaInfo != null && mime.equals("image/jpeg")) {
            int width = mediaInfo.getWidth();
            int height = mediaInfo.getHeight();
            profileId = width > 1024 || height > 768 ? "JPEG_LRG" : (width > 640 || height > 480 ? "JPEG_MED" : (width > 160 || height > 160 ? "JPEG_SM" : "JPEG_TN"));
        } else if (mime.equals("audio/mpeg")) {
            profileId = "MP3";
        } else if (mime.substring(0, 9).equals("audio/L16") || mime.equals("audio/wav")) {
            profileId = "LPCM";
        }
        return profileId;
    }

    private static String getMpegPsProfileId(int index) {
        if (index == 1 || index == 2) {
            return "MPEG_PS_NTSC";
        }
        return "MPEG_PS_PAL";
    }

    private static String getMpegTsMpeg2ProfileId(int index, MediaInfo media, boolean isStreaming) {
        Object orgPN = "MPEG_TS_";
        orgPN = media != null && media.getDefaultVideoTrack() == null && media.getDefaultVideoTrack().isHDVideo() ? (String)orgPN + "HD" : (String)orgPN + "SD";
        orgPN = (String)orgPN + (switch (index) {
            case 1 -> "_NA";
            case 2 -> "_JP";
            default -> "_EU";
        });
        if (!isStreaming) {
            orgPN = (String)orgPN + "_ISO";
        }
        return orgPN;
    }

    private static String getMpegTsH264ProfileId(int index, boolean isStreaming) {
        Object orgPN = "AVC_TS";
        orgPN = (String)orgPN + (switch (index) {
            case 1 -> "_NA";
            case 2 -> "_JP";
            default -> "_EU";
        });
        if (!isStreaming) {
            orgPN = (String)orgPN + "_ISO";
        }
        return orgPN;
    }

    private static String getMkvH264ProfileId(MediaInfo media, EncodingFormat encodingFormat) {
        Object orgPN = "AVC_MKV";
        orgPN = media == null || media.getDefaultVideoTrack() == null || media.getDefaultVideoTrack().getFormatProfile() == null || media.getDefaultVideoTrack().getFormatProfile().contains("high") ? (String)orgPN + "_HP" : (String)orgPN + "_MP";
        orgPN = (String)orgPN + "_HD";
        if (media != null && media.getDefaultAudioTrack() != null) {
            if (encodingFormat == null && media.getDefaultAudioTrack().isAACLC() || encodingFormat != null && encodingFormat.isTranscodeToAAC()) {
                orgPN = (String)orgPN + "_AAC_MULT5";
            } else if (encodingFormat == null && media.getDefaultAudioTrack().isAC3() || encodingFormat != null && encodingFormat.isTranscodeToAC3()) {
                orgPN = (String)orgPN + "_AC3";
            } else if (encodingFormat == null && media.getDefaultAudioTrack().isDTS()) {
                orgPN = (String)orgPN + "_DTS";
            } else if (encodingFormat == null && media.getDefaultAudioTrack().isEAC3()) {
                orgPN = (String)orgPN + "_EAC3";
            } else if (encodingFormat == null && media.getDefaultAudioTrack().isHEAAC()) {
                orgPN = (String)orgPN + "_HEAAC_L4";
            }
        }
        return orgPN;
    }

    private static String getMp4H264OrgPN(MediaInfo media, EncodingFormat encodingFormat) {
        Object orgPN = "AVC_MP4";
        orgPN = media != null && media.getDefaultVideoTrack() != null && media.getDefaultVideoTrack().getFormatProfile() != null ? (media.getDefaultVideoTrack().getFormatProfile().contains("high") ? (encodingFormat == null && media.getDefaultAudioTrack() != null && media.getDefaultAudioTrack().isHEAAC() ? (String)orgPN + "_HD_HEAACv2_L6" : (String)orgPN + "_HP_HD") : (media.getDefaultVideoTrack().getFormatProfile().contains("baseline") ? (String)orgPN + "_BL" : (String)orgPN + "_MP_SD")) : (String)orgPN + "_MP_SD";
        if (media != null && media.getDefaultAudioTrack() != null) {
            if (encodingFormat == null && (media.getDefaultAudioTrack().isAC3() || media.getDefaultAudioTrack().isEAC3()) || encodingFormat != null && encodingFormat.isTranscodeToAC3()) {
                orgPN = (String)orgPN + "_EAC3";
            } else if (encodingFormat == null && media.getDefaultAudioTrack().isDTS()) {
                orgPN = (String)orgPN + "_DTS";
            } else if (encodingFormat == null && media.getDefaultAudioTrack().isDTSHD()) {
                orgPN = (String)orgPN + "_DTSHD";
            }
        }
        return orgPN;
    }

    private static String getWmvProfileId(MediaInfo media, EncodingFormat encodingFormat) {
        Object orgPN = "WMV";
        orgPN = media != null && media.getDefaultVideoTrack() != null && media.getDefaultVideoTrack().isHDVideo() ? (String)orgPN + "HIGH" : (String)orgPN + "MED";
        if (media != null && media.getDefaultAudioTrack() != null) {
            if (encodingFormat == null && media.getDefaultAudioTrack().isWMA() || encodingFormat != null && encodingFormat.isTranscodeToWMV()) {
                orgPN = (String)orgPN + "_FULL";
            } else if (encodingFormat == null && (media.getDefaultAudioTrack().isWMAPro() || media.getDefaultAudioTrack().isWMA10())) {
                orgPN = (String)orgPN + "_PRO";
            }
        }
        return orgPN;
    }
}

