/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.network.mediaserver.jupnp.transport.impl.UmsDatagramIO;
import net.pms.network.mediaserver.jupnp.transport.impl.UmsDatagramProcessor;
import net.pms.network.mediaserver.jupnp.transport.impl.UmsMulticastReceiver;
import net.pms.network.mediaserver.jupnp.transport.impl.UmsNetworkAddressFactory;
import net.pms.network.mediaserver.jupnp.transport.impl.jetty.JettyTransportConfiguration;
import net.pms.util.SimpleThreadFactory;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.binding.xml.DeviceDescriptorBinder;
import org.jupnp.binding.xml.RecoveringUDA10DeviceDescriptorBinderImpl;
import org.jupnp.binding.xml.RecoveringUDA10ServiceDescriptorBinderImpl;
import org.jupnp.binding.xml.ServiceDescriptorBinder;
import org.jupnp.model.Namespace;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.types.ServiceType;
import org.jupnp.transport.impl.DatagramIOConfigurationImpl;
import org.jupnp.transport.impl.GENAEventProcessorImpl;
import org.jupnp.transport.impl.MulticastReceiverConfigurationImpl;
import org.jupnp.transport.impl.SOAPActionProcessorImpl;
import org.jupnp.transport.impl.jetty.StreamClientConfigurationImpl;
import org.jupnp.transport.spi.DatagramIO;
import org.jupnp.transport.spi.DatagramProcessor;
import org.jupnp.transport.spi.GENAEventProcessor;
import org.jupnp.transport.spi.MulticastReceiver;
import org.jupnp.transport.spi.NetworkAddressFactory;
import org.jupnp.transport.spi.SOAPActionProcessor;
import org.jupnp.transport.spi.StreamClient;
import org.jupnp.transport.spi.StreamServer;
import org.jupnp.util.Exceptions;
import org.jupnp.util.SpecificationViolationReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmsUpnpServiceConfiguration
implements UpnpServiceConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmsUpnpServiceConfiguration.class);
    private static final List<String> LOG_LEVEL_MEDIASERVER = List.of("org.jupnp");
    private static final List<String> LOG_LEVEL_BASIC = List.of("net.pms.network.mediaserver.jupnp.transport.impl.UmsDatagramProcessor", "org.jupnp.protocol");
    private static final List<String> LOG_LEVEL_FULL = List.of("org.jupnp.binding", "org.jupnp.model", "org.jupnp.registry", "org.jupnp.transport");
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final int CORE_THREAD_POOL_SIZE = 16;
    private static final int THREAD_POOL_SIZE = 200;
    private static final int THREAD_QUEUE_SIZE = 1000;
    private static final boolean THREAD_POOL_CORE_TIMEOUT = true;
    private static final String STREAM_CLIENT_THREAD_NAME = "jupnp-stream-client";
    private static final String STREAM_SERVER_THREAD_NAME = "jupnp-stream-server";
    private static final String REGISTRY_MAINTAINER_THREAD_NAME = "jupnp-registry-maintainer";
    private static final String MULTICAST_RECEIVER_THREAD_NAME = "jupnp-multicast-receiver";
    private static final String DATAGRAM_IO_THREAD_NAME = "jupnp-datagram-io";
    private static final String SYNC_PROTOCOL_THREAD_NAME = "jupnp-sync-protocol";
    private static final String ASYNC_PROTOCOL_THREAD_NAME = "jupnp-async-protocol";
    private static final String REMOTE_LISTENER_THREAD_NAME = "jupnp-remote-listener";
    private static final String REGISTRY_LISTENER_THREAD_NAME = "jupnp-registry-listener";
    private final UpnpHeaders umsHeaders = new UpnpHeaders();
    private final DatagramProcessor datagramProcessor;
    private final SOAPActionProcessor soapActionProcessor;
    private final GENAEventProcessor genaEventProcessor;
    private final DeviceDescriptorBinder deviceDescriptorBinderUDA10;
    private final ServiceDescriptorBinder serviceDescriptorBinderUDA10;
    private final Namespace namespace;
    private boolean useThreadPool = false;
    private boolean multicastReceiverThreadPool = true;
    private boolean datagramIOThreadPool = true;
    private boolean streamClientThreadPool = true;
    private boolean streamServerThreadPool = true;
    private boolean syncProtocolThreadPool = true;
    private boolean asyncProtocolThreadPool = true;
    private boolean remoteListenerThreadPool = true;
    private boolean registryListenerThreadPool = true;
    private boolean registryMaintainerThreadPool = true;
    private ExecutorService multicastReceiverExecutorService;
    private ExecutorService datagramIOExecutorService;
    private ExecutorService streamClientExecutorService;
    private ExecutorService streamServerExecutorService;
    private ExecutorService syncProtocolExecutorService;
    private ExecutorService asyncProtocolExecutorService;
    private ExecutorService remoteListenerExecutorService;
    private ExecutorService registryListenerExecutorService;
    private ExecutorService registryMaintainerExecutorService;

    public UmsUpnpServiceConfiguration() {
        UmsUpnpServiceConfiguration.resetLoggingMode();
        this.umsHeaders.add(UpnpHeader.Type.USER_AGENT.getHttpName(), "UMS/" + PMS.getVersion() + " UPnP/1.0 DLNADOC/1.50 (" + System.getProperty("os.name").replace(" ", "_") + ")");
        this.datagramProcessor = new UmsDatagramProcessor();
        this.soapActionProcessor = new SOAPActionProcessorImpl();
        this.genaEventProcessor = new GENAEventProcessorImpl();
        this.deviceDescriptorBinderUDA10 = new RecoveringUDA10DeviceDescriptorBinderImpl();
        this.serviceDescriptorBinderUDA10 = new RecoveringUDA10ServiceDescriptorBinderImpl();
        this.namespace = new Namespace();
        this.createExecutorServices();
    }

    private void createExecutorServices() {
        if (this.useThreadPool) {
            if (this.multicastReceiverThreadPool) {
                LOGGER.trace("Creating multicast receiver executor service");
                this.multicastReceiverExecutorService = this.createDefaultExecutorService(MULTICAST_RECEIVER_THREAD_NAME);
            } else {
                LOGGER.trace("Skipping multicast receiver executor service creation.");
            }
            if (this.datagramIOThreadPool) {
                LOGGER.debug("Creating datagram IO executor service");
                this.datagramIOExecutorService = this.createDefaultExecutorService(DATAGRAM_IO_THREAD_NAME);
            } else {
                LOGGER.trace("Skipping datagram IO executor service creation.");
            }
            if (this.streamClientThreadPool) {
                LOGGER.debug("Creating stream client executor service");
                this.streamClientExecutorService = this.createDefaultExecutorService(STREAM_CLIENT_THREAD_NAME);
            } else {
                LOGGER.trace("Skipping stream client executor service creation.");
            }
            if (this.streamServerThreadPool) {
                LOGGER.debug("Creating stream server executor service");
                this.streamServerExecutorService = this.createDefaultExecutorService(STREAM_SERVER_THREAD_NAME);
            } else {
                LOGGER.trace("Skipping stream server executor service creation.");
            }
            if (this.syncProtocolThreadPool) {
                LOGGER.debug("Creating sync protocol executor service");
                this.syncProtocolExecutorService = this.createDefaultExecutorService(SYNC_PROTOCOL_THREAD_NAME);
            } else {
                LOGGER.trace("Skipping sync protocol executor service creation.");
            }
            if (this.asyncProtocolThreadPool) {
                LOGGER.debug("Creating async protocol executor service");
                this.asyncProtocolExecutorService = this.createDefaultExecutorService(ASYNC_PROTOCOL_THREAD_NAME);
            } else {
                LOGGER.debug("Skipping async protocol executor service creation.");
            }
            if (this.remoteListenerThreadPool) {
                LOGGER.debug("Creating remote listener executor service");
                this.remoteListenerExecutorService = this.createDefaultExecutorService(REMOTE_LISTENER_THREAD_NAME);
            } else {
                LOGGER.debug("Skipping remote listener executor service creation.");
            }
            if (this.registryListenerThreadPool) {
                LOGGER.debug("Creating registry listener executor service");
                this.registryListenerExecutorService = this.createDefaultExecutorService(REGISTRY_LISTENER_THREAD_NAME);
            } else {
                LOGGER.debug("Skipping registry listener executor service creation.");
            }
            if (this.registryMaintainerThreadPool) {
                LOGGER.debug("Creating registry maintainer executor service");
                this.registryMaintainerExecutorService = this.createDefaultExecutorService(REGISTRY_MAINTAINER_THREAD_NAME);
            } else {
                LOGGER.debug("Skipping registry maintainer executor service creation.");
            }
        } else {
            LOGGER.debug("Skipping thread pooled executor services creation.");
        }
    }

    protected void shutdownExecutorServices() {
        if (this.multicastReceiverExecutorService != null) {
            LOGGER.trace("Shutting down multicast receiver executor service");
            this.multicastReceiverExecutorService.shutdownNow();
        }
        if (this.datagramIOExecutorService != null) {
            LOGGER.trace("Shutting down datagram IO executor service");
            this.datagramIOExecutorService.shutdownNow();
        }
        if (this.streamServerExecutorService != null) {
            LOGGER.trace("Shutting down stream server executor service");
            this.streamServerExecutorService.shutdownNow();
        }
        if (this.syncProtocolExecutorService != null) {
            LOGGER.trace("Shutting down sync protocol executor service");
            this.syncProtocolExecutorService.shutdownNow();
        }
        if (this.registryListenerExecutorService != null) {
            LOGGER.trace("Shutting down registry listener executor service");
            this.registryListenerExecutorService.shutdownNow();
        }
        if (this.registryMaintainerExecutorService != null) {
            LOGGER.trace("Shutting down registry maintainer executor service");
            this.registryMaintainerExecutorService.shutdownNow();
        }
        if (this.streamClientExecutorService != null) {
            LOGGER.trace("Shutting down stream client executor service");
            this.streamClientExecutorService.shutdownNow();
        }
        if (this.asyncProtocolExecutorService != null) {
            LOGGER.trace("Shutting down async protocol executor service");
            this.asyncProtocolExecutorService.shutdownNow();
        }
        if (this.remoteListenerExecutorService != null) {
            LOGGER.trace("Shutting down remote listener executor service");
            this.remoteListenerExecutorService.shutdownNow();
        }
    }

    private ExecutorService createDefaultExecutorService(String name) {
        return new JUPnPExecutor(name);
    }

    @Override
    public UpnpHeaders getDescriptorRetrievalHeaders(RemoteDeviceIdentity identity) {
        return this.umsHeaders;
    }

    @Override
    public int getRegistryMaintenanceIntervalMillis() {
        return 15000;
    }

    @Override
    public int getAliveIntervalMillis() {
        return CONFIGURATION.getUpnpSendAliveDelay() != 0 ? CONFIGURATION.getUpnpSendAliveDelay() : 30000;
    }

    @Override
    public StreamClient createStreamClient() {
        ExecutorService executorService = this.getStreamClientExecutorService();
        return JettyTransportConfiguration.INSTANCE.createStreamClient(executorService, new StreamClientConfigurationImpl(executorService));
    }

    @Override
    public StreamServer createStreamServer(NetworkAddressFactory networkAddressFactory) {
        return JettyTransportConfiguration.INSTANCE.createStreamServer(networkAddressFactory.getStreamListenPort());
    }

    @Override
    public NetworkAddressFactory createNetworkAddressFactory() {
        return new UmsNetworkAddressFactory();
    }

    @Override
    public MulticastReceiver createMulticastReceiver(NetworkAddressFactory networkAddressFactory) {
        return new UmsMulticastReceiver(new MulticastReceiverConfigurationImpl(networkAddressFactory.getMulticastGroup(), networkAddressFactory.getMulticastPort()));
    }

    @Override
    public DatagramIO createDatagramIO(NetworkAddressFactory networkAddressFactory) {
        return new UmsDatagramIO(new DatagramIOConfigurationImpl());
    }

    @Override
    public ExecutorService getMulticastReceiverExecutor() {
        if (this.useThreadPool && this.multicastReceiverThreadPool) {
            return this.multicastReceiverExecutorService;
        }
        return Executors.newCachedThreadPool(new SimpleThreadFactory(MULTICAST_RECEIVER_THREAD_NAME, true));
    }

    @Override
    public ExecutorService getDatagramIOExecutor() {
        if (this.useThreadPool && this.datagramIOThreadPool) {
            return this.datagramIOExecutorService;
        }
        return Executors.newCachedThreadPool(new SimpleThreadFactory(DATAGRAM_IO_THREAD_NAME, true));
    }

    @Override
    public ExecutorService getAsyncProtocolExecutor() {
        if (this.useThreadPool && this.asyncProtocolThreadPool) {
            return this.asyncProtocolExecutorService;
        }
        return Executors.newCachedThreadPool(new SimpleThreadFactory(ASYNC_PROTOCOL_THREAD_NAME, true));
    }

    @Override
    public ExecutorService getSyncProtocolExecutorService() {
        if (this.useThreadPool && this.syncProtocolThreadPool) {
            return this.syncProtocolExecutorService;
        }
        return Executors.newCachedThreadPool(new SimpleThreadFactory(SYNC_PROTOCOL_THREAD_NAME, true));
    }

    public ExecutorService getStreamClientExecutorService() {
        if (this.useThreadPool && this.streamClientThreadPool) {
            return this.streamClientExecutorService;
        }
        return Executors.newCachedThreadPool(new SimpleThreadFactory(STREAM_CLIENT_THREAD_NAME, true));
    }

    @Override
    public ExecutorService getStreamServerExecutorService() {
        if (this.useThreadPool && this.streamServerThreadPool) {
            return this.streamServerExecutorService;
        }
        return Executors.newCachedThreadPool(new SimpleThreadFactory(STREAM_SERVER_THREAD_NAME, true));
    }

    @Override
    public Executor getRegistryMaintainerExecutor() {
        if (this.useThreadPool && this.registryMaintainerThreadPool) {
            return this.registryMaintainerExecutorService;
        }
        return Executors.newCachedThreadPool(new SimpleThreadFactory(REGISTRY_MAINTAINER_THREAD_NAME, true));
    }

    @Override
    public Executor getRegistryListenerExecutor() {
        if (this.useThreadPool && this.registryListenerThreadPool) {
            return this.registryListenerExecutorService;
        }
        return Executors.newCachedThreadPool(new SimpleThreadFactory(REGISTRY_LISTENER_THREAD_NAME, true));
    }

    @Override
    public Executor getRemoteListenerExecutor() {
        if (this.useThreadPool && this.remoteListenerThreadPool) {
            return this.remoteListenerExecutorService;
        }
        return Executors.newCachedThreadPool(new SimpleThreadFactory(REMOTE_LISTENER_THREAD_NAME, true));
    }

    @Override
    public void shutdown() {
        LOGGER.trace("Shutting down executor services");
        this.shutdownExecutorServices();
        this.createExecutorServices();
    }

    @Override
    public DatagramProcessor getDatagramProcessor() {
        return this.datagramProcessor;
    }

    @Override
    public SOAPActionProcessor getSoapActionProcessor() {
        return this.soapActionProcessor;
    }

    @Override
    public GENAEventProcessor getGenaEventProcessor() {
        return this.genaEventProcessor;
    }

    @Override
    public DeviceDescriptorBinder getDeviceDescriptorBinderUDA10() {
        return this.deviceDescriptorBinderUDA10;
    }

    @Override
    public ServiceDescriptorBinder getServiceDescriptorBinderUDA10() {
        return this.serviceDescriptorBinderUDA10;
    }

    @Override
    public ServiceType[] getExclusiveServiceTypes() {
        return new ServiceType[0];
    }

    @Override
    public boolean isReceivedSubscriptionTimeoutIgnored() {
        return false;
    }

    @Override
    public Integer getRemoteDeviceMaxAgeSeconds() {
        return null;
    }

    @Override
    public UpnpHeaders getEventSubscriptionHeaders(RemoteService service) {
        return null;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    private static void resetLoggingMode() {
        ch.qos.logback.classic.Logger rootLogger;
        Level fullLevel;
        Level mediaServerLevel = CONFIGURATION.isUpnpDebugMediaServer() ? Level.TRACE : Level.INFO;
        Level basicLevel = CONFIGURATION.isUpnpDebugBasic() ? Level.TRACE : Level.INFO;
        Level level = fullLevel = CONFIGURATION.isUpnpDebugFull() ? Level.TRACE : Level.ERROR;
        if (fullLevel == Level.TRACE) {
            LOGGER.debug("Upnp log mode: full");
            SpecificationViolationReporter.enableReporting();
        } else {
            if (basicLevel == Level.TRACE) {
                LOGGER.debug("Upnp log mode: basic");
            } else if (mediaServerLevel == Level.TRACE) {
                LOGGER.debug("Upnp log mode: MediaServer only");
            } else {
                LOGGER.debug("Upnp log mode: silent");
            }
            SpecificationViolationReporter.disableReporting();
        }
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (String name : LOG_LEVEL_MEDIASERVER) {
            rootLogger = loggerContext.getLogger(name);
            rootLogger.setLevel(mediaServerLevel);
        }
        for (String name : LOG_LEVEL_BASIC) {
            rootLogger = loggerContext.getLogger(name);
            rootLogger.setLevel(basicLevel);
        }
        for (String name : LOG_LEVEL_FULL) {
            rootLogger = loggerContext.getLogger(name);
            rootLogger.setLevel(fullLevel);
        }
    }

    static {
        CONFIGURATION.addConfigurationListener(event -> {
            if (!event.isBeforeUpdate() && "upnp_log_level".equals(event.getPropertyName())) {
                UmsUpnpServiceConfiguration.resetLoggingMode();
            }
        });
    }

    public static class JUPnPExecutor
    extends ThreadPoolExecutor {
        public JUPnPExecutor(String name) {
            this(new SimpleThreadFactory(name), new ThreadPoolExecutor.DiscardPolicy(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    LOGGER.warn("Thread pool rejected execution of " + runnable.getClass());
                    super.rejectedExecution(runnable, threadPoolExecutor);
                }
            });
        }

        public JUPnPExecutor(ThreadFactory threadFactory, RejectedExecutionHandler rejectedHandler) {
            super(16, 200, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000), threadFactory, rejectedHandler);
            this.allowCoreThreadTimeOut();
        }

        private void allowCoreThreadTimeOut() {
            this.allowCoreThreadTimeOut(true);
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            super.afterExecute(runnable, throwable);
            if (throwable != null) {
                Throwable cause = Exceptions.unwrap(throwable);
                if (cause instanceof InterruptedException) {
                    return;
                }
                LOGGER.warn("Thread terminated " + runnable + " abruptly with exception: " + throwable);
                LOGGER.warn("Root cause: " + cause);
            }
        }
    }
}

