/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.handlers.nextcpapi;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.database.MediaDatabase;
import net.pms.network.mediaserver.handlers.nextcpapi.NextcpApiResponse;
import net.pms.network.mediaserver.handlers.nextcpapi.NextcpApiResponseHandler;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.h2.tools.RunScript;
import org.h2.tools.Script;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LikeMusic
implements NextcpApiResponseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LikeMusic.class.getName());
    public static final String PATH_MATCH = "like";
    private final String backupFilename;

    public LikeMusic() {
        PMS.getConfiguration();
        String dir2 = FilenameUtils.concat(UmsConfiguration.getProfileDirectory(), "database_backup");
        this.backupFilename = FilenameUtils.concat(dir2, "MUSIC_BRAINZ_RELEASE_LIKE");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public NextcpApiResponse handleRequest(String uri, String content) {
        try (Connection connection = MediaDatabase.getConnectionIfAvailable();){
            if (connection == null) {
                NextcpApiResponse nextcpApiResponse = null;
                return nextcpApiResponse;
            }
            NextcpApiResponse response = new NextcpApiResponse();
            response.setStatusCode(200);
            response.setContentType("text/plain; charset=UTF-8");
            response.setConnection("keep-alive");
            switch (uri) {
                case "likealbum": {
                    String sql = "MERGE INTO MUSIC_BRAINZ_RELEASE_LIKE KEY (MBID_RELEASE) values (?)";
                    try (PreparedStatement ps = connection.prepareStatement(sql);){
                        ps.setString(1, content);
                        ps.executeUpdate();
                        break;
                    }
                    catch (SQLException e) {
                        LOG.warn("error preparing statement", e);
                        response.setResponse("ERROR:" + e.getMessage());
                        NextcpApiResponse nextcpApiResponse = response;
                        if (connection != null) {
                            connection.close();
                        }
                        return nextcpApiResponse;
                    }
                }
                case "dislikealbum": {
                    String sql = "DELETE FROM MUSIC_BRAINZ_RELEASE_LIKE WHERE MUSIC_BRAINZ_RELEASE_LIKE.MBID_RELEASE = ?";
                    try (PreparedStatement ps = connection.prepareStatement(sql);){
                        ps.setString(1, content);
                        ps.executeUpdate();
                        break;
                    }
                    catch (SQLException e) {
                        LOG.warn("error preparing statement", e);
                        response.setResponse("ERROR:" + e.getMessage());
                        NextcpApiResponse nextcpApiResponse = response;
                        if (connection != null) {
                            connection.close();
                        }
                        return nextcpApiResponse;
                    }
                }
                case "isalbumliked": {
                    String sql = "SELECT COUNT(*) FROM MUSIC_BRAINZ_RELEASE_LIKE WHERE MUSIC_BRAINZ_RELEASE_LIKE.MBID_RELEASE = ?";
                    response.setResponse(Boolean.toString(this.isCountGreaterZero(sql, connection, content)));
                    NextcpApiResponse nextcpApiResponse = response;
                    return nextcpApiResponse;
                }
                case "issongliked": {
                    String sql = "SELECT COUNT(*) FROM AUDIO_METADATA WHERE AUDIO_METADATA.MBID_TRACK = ?";
                    response.setResponse(Boolean.toString(this.isCountGreaterZero(sql, connection, content)));
                    NextcpApiResponse nextcpApiResponse = response;
                    return nextcpApiResponse;
                }
                case "backupLikedAlbums": {
                    this.backupLikedAlbums();
                    response.setResponse("OK");
                    NextcpApiResponse nextcpApiResponse = response;
                    return nextcpApiResponse;
                }
                case "restoreLikedAlbums": {
                    this.restoreLikedAlbums();
                    response.setResponse("OK");
                    NextcpApiResponse nextcpApiResponse = response;
                    return nextcpApiResponse;
                }
                default: {
                    response.setStatusCode(404);
                    response.setResponse("ERROR");
                    NextcpApiResponse nextcpApiResponse = response;
                    return nextcpApiResponse;
                }
            }
            response.setResponse("ERROR");
            Object object = response;
            return object;
        }
        catch (SQLException e) {
            throw new RuntimeException("cannot handle request", e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("backup file not found.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isCountGreaterZero(String sql, Connection connection, String key) {
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            ps.setString(1, key);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return false;
            boolean bl = rs.getLong(1) > 0L;
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException("cannot handle request", e);
        }
    }

    private void backupLikedAlbums() throws SQLException {
        try (Connection connection = MediaDatabase.getConnectionIfAvailable();){
            Script.process(connection, this.backupFilename, "", "TABLE MUSIC_BRAINZ_RELEASE_LIKE");
        }
    }

    private void restoreLikedAlbums() throws SQLException, FileNotFoundException {
        block16: {
            File backupFile = new File(this.backupFilename);
            if (backupFile.exists() && backupFile.isFile()) {
                try (Connection connection = MediaDatabase.getConnectionIfAvailable();
                     Statement stmt = connection.createStatement();){
                    String sql = "DROP TABLE MUSIC_BRAINZ_RELEASE_LIKE";
                    stmt.execute(sql);
                    try {
                        RunScript.execute(connection, new FileReader(this.backupFilename));
                    }
                    catch (FileNotFoundException | SQLException e) {
                        LOG.error("restoring MUSIC_BRAINZ_RELEASE_LIKE table : failed");
                        throw new RuntimeException("restoring MUSIC_BRAINZ_RELEASE_LIKE table failed", e);
                    }
                    connection.commit();
                    LOG.trace("restoring MUSIC_BRAINZ_RELEASE_LIKE table : success");
                    break block16;
                }
            }
            if (!StringUtils.isEmpty(this.backupFilename)) {
                LOG.trace("Backup file doesn't exist : " + this.backupFilename);
                throw new RuntimeException("Backup file doesn't exist : " + this.backupFilename);
            }
            throw new RuntimeException("Backup filename not set !");
        }
    }
}

