/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.configuration;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;

public class NetworkInterfaceAssociation {
    String parentName;
    InetAddress addr;
    NetworkInterface iface;
    boolean wasUp;

    public NetworkInterfaceAssociation(InetAddress addr, NetworkInterface iface, String parentName) {
        this.addr = addr;
        this.iface = iface;
        this.parentName = parentName;
        this.wasUp = this.isUp();
    }

    public InetAddress getAddr() {
        return this.addr;
    }

    public NetworkInterface getIface() {
        return this.iface;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getShortName() {
        return this.iface.getName();
    }

    public String getDisplayNameWithAddress() {
        Object displayName = this.iface.getDisplayName();
        displayName = displayName != null ? ((String)displayName).trim() : this.iface.getName();
        if (this.addr != null) {
            displayName = (String)displayName + " (" + this.addr.getHostAddress() + ")";
        }
        return displayName;
    }

    public String getDisplayName() {
        String displayName = this.iface.getDisplayName();
        displayName = displayName != null ? displayName.trim() : this.iface.getName();
        return displayName;
    }

    public final boolean wasUp() {
        return this.wasUp;
    }

    public final boolean statusChanged() {
        return this.wasUp != this.isUp();
    }

    public final void updateStatus() {
        this.wasUp = this.isUp();
    }

    public final boolean isUp() {
        try {
            return this.iface.isUp();
        }
        catch (SocketException ex) {
            return false;
        }
    }

    public String toString() {
        return "InterfaceAssociation(addr=" + this.addr + ", iface=" + this.iface + ", parent=" + this.parentName + ")";
    }
}

